/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTree;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public String findURIFromDoc(int n) {
        int n2 = this.m_sourceTree.size();
        for (int i = 0; i < n2; ++i) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i);
            if (n != sourceTree.m_root) continue;
            return sourceTree.m_url;
        }
        return null;
    }

    public Source resolveURI(String string, String string2, SourceLocator sourceLocator) throws TransformerException, IOException {
        Source source = null;
        if (null != this.m_uriResolver) {
            source = this.m_uriResolver.resolve(string2, string);
        }
        if (null == source) {
            String string3 = SystemIDResolver.getAbsoluteURI(string2, string);
            source = new StreamSource(string3);
        }
        return source;
    }

    public void removeDocumentFromCache(int n) {
        if (-1 == n) {
            return;
        }
        for (int i = this.m_sourceTree.size() - 1; i >= 0; --i) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i);
            if (sourceTree == null || sourceTree.m_root != n) continue;
            this.m_sourceTree.removeElementAt(i);
            return;
        }
    }

    public void putDocumentInCache(int n, Source source) {
        int n2 = this.getNode(source);
        if (-1 != n2) {
            if (n2 != n) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (null != source.getSystemId()) {
            this.m_sourceTree.addElement(new SourceTree(n, source.getSystemId()));
        }
    }

    public int getNode(Source source) {
        String string = source.getSystemId();
        if (null == string) {
            return -1;
        }
        int n = this.m_sourceTree.size();
        for (int i = 0; i < n; ++i) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i);
            if (!string.equals(sourceTree.m_url)) continue;
            return sourceTree.m_root;
        }
        return -1;
    }

    public int getSourceTree(String string, String string2, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        try {
            Source source = this.resolveURI(string, string2, sourceLocator);
            return this.getSourceTree(source, sourceLocator, xPathContext);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException.getMessage(), sourceLocator, iOException);
        }
    }

    public int getSourceTree(Source source, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        int n;
        String string = source.getSystemId();
        if (string != null) {
            String string2 = SystemIDResolver.getAbsoluteURI(string);
            source.setSystemId(string2);
            int n2 = this.getNode(source);
            if (-1 != n2) {
                return n2;
            }
            source.setSystemId(string);
        }
        if (-1 != (n = this.getNode(source))) {
            return n;
        }
        n = this.parseToNode(source, sourceLocator, xPathContext);
        if (-1 != n) {
            this.putDocumentInCache(n, source);
        }
        return n;
    }

    public int parseToNode(Source source, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        try {
            Object object = xPathContext.getOwnerObject();
            DTM dTM = null != object && object instanceof DTMWSFilter ? xPathContext.getDTM(source, false, (DTMWSFilter)object, false, true) : xPathContext.getDTM(source, false, null, false, true);
            return dTM.getDocument();
        }
        catch (Exception exception) {
            throw new TransformerException(exception.getMessage(), sourceLocator, exception);
        }
    }

    public static XMLReader getXMLReader(Source source, SourceLocator sourceLocator) throws TransformerException {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException.getMessage(), sourceLocator, sAXException);
        }
    }
}

