/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.SAXException;

public class ToXMLStream
extends ToStream {
    private static final CharInfo m_xmlcharInfo = CharInfo.getCharInfo(null, "xml");

    public ToXMLStream() {
        EncodingInfo encodingInfo;
        this.m_charInfo = m_xmlcharInfo;
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
        this.m_OutputPropsDefault = new HashMap();
        this.m_OutputPropsDefault.put("method", "xml");
        this.m_OutputPropsDefault.put("version", "1.0");
        this.m_version = "1.0";
        this.m_OutputPropsDefault.put("mime-name", "UTF-8");
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.m_OutputPropsDefault.put("encoding", "UTF-8");
        this.m_doIndent = false;
        this.m_OutputPropsDefault.put("indent", "no");
        this.m_OutputPropsDefault.put("omit-xml-declaration", "no");
        this.m_standalone = "no";
        this.m_OutputPropsDefault.put("standalone", "no");
        this.m_mediatype = "text/xml";
        this.m_OutputPropsDefault.put("media-type", "text/xml");
        this.m_wasJustReset = true;
    }

    public void CopyFrom(ToXMLStream toXMLStream) {
        this.setWriter(toXMLStream.m_writer);
        String string = toXMLStream.getEncoding();
        this.setEncoding(string);
        this.setOmitXMLDeclaration(toXMLStream.getOmitXMLDeclaration());
        this.m_ispreserve = toXMLStream.m_ispreserve;
        this.m_isprevtext = toXMLStream.m_isprevtext;
        this.m_doIndent = toXMLStream.m_doIndent;
        this.setIndentAmount(toXMLStream.getIndentAmount());
        this.m_startNewLine = toXMLStream.m_startNewLine;
        this.m_needToOutputDocTypeDecl = toXMLStream.m_needToOutputDocTypeDecl;
        this.setDoctypeSystem(toXMLStream.getDoctypeSystem());
        this.setDoctypePublic(toXMLStream.getDoctypePublic());
        this.setStandalone(toXMLStream.getStandalone());
        this.setMediaType(toXMLStream.getMediaType());
        this.m_encodingInfo = toXMLStream.m_encodingInfo;
        this.m_spaceBeforeClose = toXMLStream.m_spaceBeforeClose;
        this.m_cdataStartCalled = toXMLStream.m_cdataStartCalled;
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            String string = this.getXMLVersion();
            if (!this.getOmitXMLDeclaration()) {
                String string2 = Encodings.getMimeEncoding(this.getEncoding());
                String string3 = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    Writer writer = this.m_writer;
                    writer.write("<?xml version=\"");
                    writer.write(string);
                    writer.write("\" encoding=\"");
                    writer.write(string2);
                    writer.write(34);
                    writer.write(string3);
                    writer.write("?>");
                    if (this.m_doIndent && (this.m_standaloneWasSpecified || this.getDoctypePublic() != null || this.getDoctypeSystem() != null)) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    }
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
            if (this.m_undeclareNamespaces && "1.0".equals(string)) {
                this.m_undeclareNamespaces = false;
            }
        }
    }

    public void endDocument() throws SAXException {
        this.flushInternal();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void flushPending() throws SAXException {
        this.flushInternal();
        this.flushWriter();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushInternal();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n;
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.m_docIsEmpty = false;
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                if ((n = string2.indexOf("?>")) >= 0) {
                    if (n > 0) {
                        writer.write(string2.substring(0, n));
                    }
                    writer.write("? >");
                    if (n + 2 < string2.length()) {
                        writer.write(string2.substring(n + 2));
                    }
                } else {
                    writer.write(string2);
                }
                writer.write(63);
                writer.write(62);
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            String string6;
            boolean bl2 = this.addAttributeAlways(string, string2, string3, string4, string5, bl);
            if (bl2 && !bl && !string3.startsWith("xmlns") && (string6 = this.ensureAttributesNamespaceIsDeclared(string, string2, string3)) != null && string3 != null && !string3.startsWith(string6)) {
                string3 = string6 + ":" + string2;
            }
            this.addAttributeAlways(string, string2, string3, string4, string5, bl);
        } else {
            this.reportWarning("ER_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{string2});
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToXMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    protected boolean pushNamespace(String string, String string2) {
        try {
            if (this.m_prefixMap.pushNamespace(string, string2, this.m_elemContext.m_currentElemDepth)) {
                this.startPrefixMapping(string, string2);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public boolean reset() {
        super.reset();
        return true;
    }

    private String getXMLVersion() {
        String string = this.getVersion();
        if (string == null || string.equals("1.0")) {
            string = "1.0";
        } else if (string.equals("1.1")) {
            string = "1.1";
        } else {
            String string2 = Utils.messages.createMessage("ER_XML_VERSION_NOT_SUPPORTED", new Object[]{string});
            try {
                Transformer transformer = super.getTransformer();
                ErrorListener errorListener = null;
                if (transformer != null) {
                    errorListener = transformer.getErrorListener();
                }
                if (null != errorListener && this.m_sourceLocator != null) {
                    errorListener.warning(new TransformerException(string2, this.m_sourceLocator));
                } else {
                    System.out.println(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = "1.0";
        }
        return string;
    }

    final void processAttributes(Writer writer, int n) throws IOException, SAXException {
        WriterOptimized writerOptimized = writer == this.m_writerOptimized ? this.m_writerOptimized : null;
        for (int i = 0; i < n; ++i) {
            this.processAttribute(writer, writerOptimized, this.m_attributes.getAttribute(i), this.m_optLevel);
        }
    }

    void processAttribute(Writer writer, WriterOptimized writerOptimized, AttributesImplSerializer.AttributeImpl attributeImpl, int n) throws IOException {
        writer.write(32);
        String string = attributeImpl.m_qName;
        String string2 = attributeImpl.m_value;
        writer.write(string);
        writer.write("=\"");
        switch (n) {
            case 0: {
                if ((attributeImpl.m_flags & 1) != 0) {
                    if (writer == writerOptimized) {
                        writerOptimized.writeASCII(string2);
                        break;
                    }
                    writer.write(string2);
                    break;
                }
                this.writeXMLAttrOpt(writer, writerOptimized, string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeXMLAttr(writer, writerOptimized, string2);
            }
        }
        writer.write(34);
    }

    public void undeclareAllPrefixMappings() {
        int n = this.m_elemContext.m_currentElemDepth;
        this.m_prefixMap.undeclareAllPrefixMappings(n);
    }

    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        if ((n3 & 1) > 0 && this.m_optLevel == 0) {
            Writer writer;
            if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
                return;
            }
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            } else if (this.m_needToCallStartDocument) {
                this.m_docIsEmpty = false;
                this.startDocumentInternal();
            }
            if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
                this.cdata(cArray, n, n2);
                return;
            }
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
                this.charactersRaw(cArray, n, n2);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            if ((n3 & 8) == 0) {
                this.m_ispreserve = true;
            }
            WriterOptimized writerOptimized = (writer = this.m_writer) == this.m_writerOptimized ? this.m_writerOptimized : null;
            try {
                if (writerOptimized != null) {
                    writerOptimized.writeASCII(cArray, n, n2);
                } else {
                    writer.write(cArray, n, n2);
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.m_isprevtext = true;
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
        } else {
            this.characters(cArray, n, n2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.m_optLevel) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                super.characters(cArray, n, n2);
                return;
            }
        }
        if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.m_docIsEmpty = false;
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            int n3;
            int n4;
            Writer writer = this.m_writer;
            WriterOptimized writerOptimized = writer == this.m_writerOptimized ? this.m_writerOptimized : null;
            int n5 = n + n2;
            int n6 = n;
            boolean bl = true;
            int n7 = n;
            block27: while (n7 < n5) {
                n4 = cArray[n7];
                switch (n4) {
                    case 9: 
                    case 32: {
                        ++n7;
                        continue block27;
                    }
                    case 10: {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n7;
                            continue block27;
                        }
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            writer.write(cArray, n6, n3);
                            n3 = 0;
                        }
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n6 = ++n7;
                        continue block27;
                    }
                    case 13: {
                        n3 = n7 - n6;
                        this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                        n6 = ++n7;
                        continue block27;
                    }
                }
                bl = false;
                if (bl) continue;
            }
            if (n7 < n5 || !bl) {
                this.m_ispreserve = true;
            }
            block28: while (n7 < n5) {
                int n8;
                int n9;
                n4 = cArray[n7];
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n3 = n7 - n6;
                        this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                        n6 = ++n7;
                        continue block28;
                    }
                    case 9: {
                        ++n7;
                        continue block28;
                    }
                    case 10: {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n7;
                            continue block28;
                        }
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n6, n3);
                            } else {
                                writer.write(cArray, n6, n3);
                            }
                        }
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n6 = ++n7;
                        continue block28;
                    }
                    case 11: 
                    case 12: {
                        n3 = n7 - n6;
                        this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                        n6 = ++n7;
                        continue block28;
                    }
                    case 13: {
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n6, n3);
                            } else {
                                writer.write(cArray, n6, n3);
                            }
                        }
                        writer.write("&#13;");
                        n6 = ++n7;
                        continue block28;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        n3 = n7 - n6;
                        this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                        n6 = ++n7;
                        continue block28;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        ++n7;
                        continue block28;
                    }
                    case 38: {
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n6, n3);
                            } else {
                                writer.write(cArray, n6, n3);
                            }
                        }
                        writer.write("&amp;");
                        n6 = ++n7;
                        continue block28;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: {
                        ++n7;
                        continue block28;
                    }
                    case 60: {
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n6, n3);
                            } else {
                                writer.write(cArray, n6, n3);
                            }
                        }
                        writer.write("&lt;");
                        n6 = ++n7;
                        continue block28;
                    }
                    case 61: {
                        ++n7;
                        continue block28;
                    }
                    case 62: {
                        n3 = n7 - n6;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n6, n3);
                            } else {
                                writer.write(cArray, n6, n3);
                            }
                        }
                        writer.write("&gt;");
                        n6 = ++n7;
                        continue block28;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        ++n7;
                        continue block28;
                    }
                    case 127: {
                        n3 = n7 - n6;
                        this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                        n6 = ++n7;
                        continue block28;
                    }
                }
                if (Encodings.isHighUTF16Surrogate((char)n4) && n7 + 1 < n5) {
                    char c = cArray[n7 + 1];
                    n9 = Encodings.toCodePoint((char)n4, c);
                    n8 = 2;
                } else {
                    n9 = n4;
                    n8 = 1;
                }
                if (n9 <= 159) {
                    n3 = n7 - n6;
                    this.writeNumericEntity(writer, writerOptimized, n4, cArray, n3, n6);
                    n6 = n7 += n8;
                    continue;
                }
                if (n9 == 8232) {
                    n3 = n7 - n6;
                    if (n3 > 0) {
                        if (writerOptimized == writer) {
                            writerOptimized.writeASCII(cArray, n6, n3);
                        } else {
                            writer.write(cArray, n6, n3);
                        }
                    }
                    writer.write("&#8232;");
                    n6 = n7 += n8;
                    continue;
                }
                byte[] byArray = this.m_encodingInfo.getEncodedBytes(n9);
                if (byArray != null) {
                    if (writerOptimized == writer) {
                        n3 = n7 - n6;
                        writerOptimized.writeASCII(cArray, n6, n3);
                        writerOptimized.writeBytes(byArray, 0, byArray.length);
                        n6 = n7 += n8;
                        continue;
                    }
                    n7 += n8;
                    continue;
                }
                n3 = n7 - n6;
                if (n3 > 0) {
                    if (writerOptimized == writer) {
                        writerOptimized.writeASCII(cArray, n6, n3);
                    } else {
                        writer.write(cArray, n6, n3);
                    }
                }
                String string = this.m_charInfo.getOutputStringForChar(n9, this.m_charKey);
                if (this.shouldMapTextChar(n9) && string != null) {
                    writer.write(string);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(n9));
                    writer.write(59);
                }
                n6 = n7 += n8;
            }
            n3 = n7 - n6;
            if (n3 > 0) {
                if (writerOptimized == writer) {
                    writerOptimized.writeASCII(cArray, n6, n3);
                } else {
                    writer.write(cArray, n6, n3);
                }
            }
            this.m_isprevtext = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
    }
}

