/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.utils.WrappedRuntimeException;

public final class Encodings {
    private static final String ENCODINGS_FILE = SerializerBase.PKG_PATH + "/Encodings.properties";
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string)) continue;
            try {
                String string2 = Encodings._encodings[i].javaName;
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
                return outputStreamWriter;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new OutputStreamWriter(outputStream, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    static EncodingInfo getEncodingInfo(String string) {
        String string2 = Encodings.toUpperCaseFast(string);
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        if (encodingInfo == null) {
            encodingInfo = new EncodingInfo(null, null, '\u0000', true);
        }
        return encodingInfo;
    }

    public static boolean isRecognizedEncoding(String string) {
        String string2 = string.toUpperCase();
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        return encodingInfo != null;
    }

    private static String toUpperCaseFast(String string) {
        boolean bl = false;
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c + -32);
                bl = true;
            }
            cArray[i] = c;
        }
        String string2 = bl ? String.valueOf(cArray) : string;
        return string2;
    }

    static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = System.getProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    private static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(Encodings.toUpperCaseFast(string));
        if (null != encodingInfo) {
            return encodingInfo.name;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(string)) continue;
            return Encodings._encodings[i].javaName;
        }
        return string;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        try {
            SecuritySupport securitySupport = SecuritySupport.getInstance();
            InputStream inputStream = securitySupport.getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            Properties properties = new Properties();
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            }
            int n = properties.size();
            ArrayList<EncodingInfo> arrayList = new ArrayList<EncodingInfo>();
            Enumeration<Object> enumeration = properties.keys();
            for (int i = 0; i < n; ++i) {
                char c;
                String string;
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t");
                int n2 = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (n2 == 1) {
                        string4 = string;
                    } else if (n2 == 2) {
                        string5 = string;
                    } else if (n2 == 3) {
                        string6 = string;
                    }
                    ++n2;
                }
                if (string4 == null) {
                    string = string2;
                    c = '\u0000';
                    continue;
                }
                try {
                    String string7 = string5;
                    c = string5 == null ? (char)'\u0000' : (char)Integer.decode(string7).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    c = '\u0000';
                }
                boolean bl = "STATELESS".equals(string6);
                String string8 = string4;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string8, ",");
                boolean bl2 = true;
                while (stringTokenizer2.hasMoreTokens()) {
                    string = stringTokenizer2.nextToken();
                    EncodingInfo encodingInfo = new EncodingInfo(string, string2, c, bl);
                    arrayList.add(encodingInfo);
                    _encodingTableKeyMime.put(string.toUpperCase(), encodingInfo);
                    if (bl2) {
                        _encodingTableKeyJava.put(string2.toUpperCase(), encodingInfo);
                    }
                    bl2 = false;
                }
            }
            EncodingInfo[] encodingInfoArray = new EncodingInfo[arrayList.size()];
            arrayList.toArray(encodingInfoArray);
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }

    static boolean isHighUTF16Surrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    static int toCodePoint(char c, char c2) {
        int n = (c - 55296 << 10) + (c2 - 56320) + 65536;
        return n;
    }

    static int toCodePoint(char c) {
        char c2 = c;
        return c2;
    }

    public static char getHighChar(String string) {
        String string2 = Encodings.toUpperCaseFast(string);
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        char c = encodingInfo != null ? encodingInfo.getHighChar() : (char)'\u0000';
        return c;
    }
}

