/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import org.apache.xml.serializer.EntitiesTable;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.utils.Utils;

final class CharInfo {
    private HashMap m_charToString;
    static final char S_HORIZONAL_TAB = '\t';
    static final char S_LINEFEED = '\n';
    static final char S_CARRIAGERETURN = '\r';
    static final char S_SPACE = ' ';
    static final char S_QUOTE = '\"';
    static final char S_LT = '<';
    static final char S_GT = '>';
    static final char S_NEL = '\u0085';
    static final char S_LINE_SEPARATOR = '\u2028';
    static final char S_NBSP = '\u00a0';
    private static final int ASCII_MAX = 128;
    private final boolean[] shouldMapAttrChar_ASCII;
    private final boolean[] shouldMapTextChar_ASCII;
    private final int[] array_of_bits;
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed;
    private boolean onlyStandardEntities;

    private CharInfo() {
        this.array_of_bits = this.createEmptySetOfIntegers(65535);
        this.firstWordNotUsed = 0;
        this.shouldMapAttrChar_ASCII = new boolean[128];
        this.shouldMapTextChar_ASCII = new boolean[128];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CharInfo(String string, String string2) {
        block26: {
            this();
            if (string == null) {
                this.m_charToString = new HashMap();
                int[] nArray = null;
                String[] stringArray = null;
                this.setOnlyStandardEntities(true);
                if ("html".equals(string2)) {
                    nArray = EntitiesTable.getHTMLCodePoints();
                    stringArray = EntitiesTable.getHTMLEntities();
                } else if ("xml".equals(string2) || "xhtml".equals(string2)) {
                    nArray = EntitiesTable.getXMLCodePoints();
                    stringArray = EntitiesTable.getXMLEntities();
                }
                if (nArray != null && stringArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        String string3 = stringArray[i];
                        int n = nArray[i];
                        this.defineChar2StringMapping(string3, (char)n);
                    }
                }
            } else {
                InputStream inputStream = null;
                try {
                    try {
                        Object object;
                        ClassLoader classLoader = ObjectFactory.findClassLoader();
                        inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
                        if (inputStream == null) {
                            try {
                                object = new URL(string);
                                inputStream = ((URL)object).openStream();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (inputStream == null) {
                            throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{string, string}));
                        }
                        try {
                            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            object = new BufferedReader(new InputStreamReader(inputStream));
                        }
                        this.setOnlyStandardEntities(false);
                        this.m_charToString = new HashMap();
                        String string4 = ((BufferedReader)object).readLine();
                        while (string4 != null) {
                            if (string4.length() == 0 || string4.charAt(0) == '#') {
                                string4 = ((BufferedReader)object).readLine();
                                continue;
                            }
                            int n = string4.indexOf(32);
                            if (n > 1) {
                                String string5 = string4.substring(0, n);
                                if (++n < string4.length()) {
                                    String string6 = string4.substring(n);
                                    if ((n = string6.indexOf(32)) > 0) {
                                        string6 = string6.substring(0, n);
                                    }
                                    int n2 = Integer.parseInt(string6);
                                    this.defineEntity(string5, (char)n2);
                                }
                            }
                            string4 = ((BufferedReader)object).readLine();
                        }
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{string, exception.toString(), string, exception.toString()}));
                    }
                    Object var12_19 = null;
                    if (inputStream == null) break block26;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                inputStream.close();
            }
        }
        if ("xml".equals(string2) || "xhtml".equals(string2)) {
            this.shouldMapTextChar_ASCII[34] = false;
        }
        if (!"html".equals(string2)) return;
        this.shouldMapAttrChar_ASCII[60] = false;
        this.shouldMapTextChar_ASCII[34] = false;
    }

    private void setOnlyStandardEntities(boolean bl) {
        this.onlyStandardEntities = bl;
    }

    boolean getOnlyStandardEntities() {
        return this.onlyStandardEntities;
    }

    private void defineEntity(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer("&");
        stringBuffer.append(string);
        stringBuffer.append(';');
        String string2 = stringBuffer.toString();
        this.defineChar2StringMapping(string2, c);
    }

    String getOutputStringForChar(int n, CharKey charKey) {
        charKey.setChar(n);
        return (String)this.m_charToString.get(charKey);
    }

    final boolean shouldMapAttrChar(int n) {
        if (n < 128) {
            return this.shouldMapAttrChar_ASCII[n];
        }
        return this.get(n);
    }

    final boolean shouldMapTextChar(int n) {
        return this.get(n);
    }

    static CharInfo getCharInfo(String string, String string2) {
        return new CharInfo(string, string2);
    }

    private static int arrayIndex(int n) {
        return n >> 5;
    }

    private int[] createEmptySetOfIntegers(int n) {
        this.firstWordNotUsed = 0;
        int[] nArray = new int[CharInfo.arrayIndex(n - 1) + 1];
        return nArray;
    }

    private final void set(int n) {
        this.setASCIItextDirty(n);
        this.setASCIIattrDirty(n);
        int n2 = n >> 5;
        int n3 = n2 + 1;
        if (this.firstWordNotUsed < n3) {
            this.firstWordNotUsed = n3;
        }
        int n4 = n2;
        this.array_of_bits[n4] = this.array_of_bits[n4] | 1 << (n & 0x1F);
    }

    private final boolean get(int n) {
        boolean bl = false;
        int n2 = n >> 5;
        if (n2 < this.firstWordNotUsed) {
            bl = (this.array_of_bits[n2] & 1 << (n & 0x1F)) != 0;
        }
        return bl;
    }

    private void setASCIItextDirty(int n) {
        if (0 <= n && n < 128) {
            this.shouldMapTextChar_ASCII[n] = true;
        }
    }

    private void setASCIIattrDirty(int n) {
        if (0 <= n && n < 128) {
            this.shouldMapAttrChar_ASCII[n] = true;
        }
    }

    private void defineChar2StringMapping(String string, int n) {
        CharKey charKey = new CharKey(n);
        this.m_charToString.put(charKey, string);
        this.set(n);
    }

    static class CharKey {
        private int m_char;

        public CharKey(int n) {
            this.m_char = n;
        }

        public CharKey() {
        }

        public final void setChar(int n) {
            this.m_char = n;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object object) {
            return ((CharKey)object).m_char == this.m_char;
        }
    }
}

