/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.PromiseType;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;

public class DelayInstruction
extends Instruction
implements ISpecialForm {
    protected Instruction m_operand;

    public DelayInstruction() {
    }

    public DelayInstruction(Instruction instruction) {
        this.m_operand = instruction;
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_operand = ((ReductionHelper)reductionHelper.clone()).reduce(this.m_operand, bindingEnvironment);
        instructionArray[0] = this;
    }

    public Instruction getOperand() {
        return this.m_operand;
    }

    public void setOperand(Instruction instruction) {
        this.m_operand = instruction;
    }

    public Instruction getChildInstruction(int n) {
        return n == 0 ? this.m_operand : null;
    }

    public int getChildInstructionCount() {
        return 1;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        if (n == 0) {
            this.m_operand = instruction;
        }
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public boolean isChildInstructionBody(int n) {
        return true;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        return ISpecialForm.NO_BINDINGS;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(new PromiseType(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList)));
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return new PromiseType(this.m_operand.getType(typeEnvironment, bindingEnvironment));
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        PromiseType promiseType = (PromiseType)this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        Type type = promiseType.getBodyType();
        String string3 = promiseType.getImplementationName(dataFlowCodeGenerationHelper);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        dataFlowCodeGenerationHelper.append("final " + string3 + " " + string2 + " = new " + string3 + "() {\n" + "public final " + type.getImplementationName(dataFlowCodeGenerationHelper) + " memoize() {\n");
        HashSet hashSet = new HashSet();
        this.m_operand.accumulateNonLiteralFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
        String string4 = this.m_operand.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
        dataFlowCodeGenerationHelper.append("return " + string4 + ";\n}\n");
        ClosureGenerationUtilities.generateClosureInitSuffix(string3, hashSet, codeGenerationTracker, dataFlowCodeGenerationHelper, true);
        return string2;
    }

    public Instruction cloneWithoutTypeInformation() {
        return new DelayInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    public Instruction cloneShallow() {
        return new DelayInstruction(this.m_operand);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_operand = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_operand);
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new DelayInstruction(instruction);
    }

    public String innerToString() {
        return "delay";
    }
}

