/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IMatchDestructable;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.interpreter.AbstractDataObject;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.AbstractDataTypeLambda;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ConstructorInstantiationInstruction
extends NaryPrimopInstruction
implements IStreamInADTOptimizationInstruction,
IMatchDestructable {
    protected String m_constructorName;
    protected AbstractDataType.Constructor m_constructor;
    protected NamedType m_namedType;

    public int byteCodeSize() {
        return 2 + 2 * this.m_parameters.length;
    }

    public ConstructorInstantiationInstruction() {
    }

    public ConstructorInstantiationInstruction(String string, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_constructorName = string;
    }

    public ConstructorInstantiationInstruction(AbstractDataType.Constructor constructor, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_constructorName = constructor.getName();
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_namedType;
    }

    public AbstractDataType.Constructor getConstructor() {
        return this.m_constructor;
    }

    public String getConstructorName() {
        return this.m_constructorName;
    }

    public void setConstructor(AbstractDataType.Constructor constructor) {
        this.m_constructor = constructor;
        this.m_constructorName = constructor.getName();
        this.setCachedType(this.m_constructor.getAbstractDataType().getNamedType());
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_constructor = typeEnvironment.getModule().getConstructor(this.m_constructorName);
        if (this.m_constructor == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this);
        }
        if (this.m_parameters.length != this.m_constructor.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Invalid number of parameters to constructor " + this.m_constructorName + "\n  expected " + this.m_constructor.m_parameters.length + ", found " + this.m_parameters.length), this);
        }
        AbstractDataType abstractDataType = this.m_constructor.getAbstractDataType();
        if (abstractDataType instanceof AbstractDataTypeLambda) {
            AbstractDataTypeLambda abstractDataTypeLambda = (AbstractDataTypeLambda)abstractDataType;
            HashMap hashMap = new HashMap();
            NamedType namedType = (NamedType)abstractDataType.getNamedType().duplicateType(hashMap);
            TypeVariable[] typeVariableArray = abstractDataTypeLambda.getTypeParameters();
            Type[] typeArray = this.m_constructor.getParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (type instanceof TypeVariable) {
                    for (int j = 0; j < typeVariableArray.length; ++j) {
                        if (typeVariableArray[j] != type) continue;
                        typeEnvironment.unify(namedType.getChildType(j), this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
                    }
                    continue;
                }
                typeEnvironment.unify(this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this.m_constructor.m_parameters[i].getBindingType().duplicateType(hashMap), this);
            }
            this.m_namedType = namedType;
            return this.setCachedType(this.m_namedType);
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeEnvironment.unify(this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this.m_constructor.m_parameters[i].getBindingType(), this);
        }
        this.m_namedType = abstractDataType.getNamedType();
        return this.setCachedType(this.m_namedType);
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.m_constructor = typeEnvironment.getModule().getConstructor(this.m_constructorName);
        AbstractDataType abstractDataType = this.m_constructor.getAbstractDataType();
        if (abstractDataType instanceof AbstractDataTypeLambda) {
            AbstractDataTypeLambda abstractDataTypeLambda = (AbstractDataTypeLambda)abstractDataType;
            if (this.m_namedType == null) {
                this.m_namedType = abstractDataType.instantiateNamedType();
            }
            TypeVariable[] typeVariableArray = abstractDataTypeLambda.getTypeParameters();
            Type[] typeArray = this.m_constructor.getParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (!(type instanceof TypeVariable)) continue;
                for (int j = 0; j < typeVariableArray.length; ++j) {
                    if (typeVariableArray[j] != type) continue;
                    try {
                        typeEnvironment.unify(this.m_namedType.getChildType(j), this.m_parameters[i].getType(typeEnvironment, bindingEnvironment), this);
                        continue;
                    }
                    catch (TypeCheckException typeCheckException) {
                        typeCheckException.printStackTrace();
                    }
                }
            }
        } else {
            this.m_namedType = abstractDataType.getNamedType();
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ConstructorInstantiationInstruction constructorInstantiationInstruction = new ConstructorInstantiationInstruction(this.m_constructorName, instructionArray);
        constructorInstantiationInstruction.m_namedType = this.m_namedType;
        return constructorInstantiationInstruction;
    }

    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        ConstructorInstantiationInstruction constructorInstantiationInstruction = new ConstructorInstantiationInstruction(this.m_constructorName, instructionArray);
        constructorInstantiationInstruction.m_namedType = this.m_namedType;
        return constructorInstantiationInstruction;
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return this.m_constructor.getAbstractDataType().generateConstructorConstructionCode(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_constructor, this.m_parameters, this.m_constructor.getAbstractDataType().getNamedType());
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        this.m_constructor.getAbstractDataType().generateConstructorConstructionCode(bCELCodeGenerationHelper, codeGenerationTracker, this.m_constructor, this.m_parameters, this.m_constructor.getAbstractDataType().getNamedType(), instructionListBuilder);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        if (!(this.m_constructor.getAbstractDataType() instanceof ConstructorDataType)) {
            throw new UnsupportedOperationException("stream in adt optimization only supported for CDTs");
        }
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        if (bl) {
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (this.m_constructor.m_parameters[i] == binding && string != null) {
                    codeGenerationTracker.generateAddToStream(this.m_parameters[i], string, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), dataFlowCodeGenerationHelper, false);
                    continue;
                }
                String string3 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.appendAssignment(string2 + "_" + this.m_constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper), this.m_constructor.m_parameters[i].getBindingType(), string3, codeGenerationTracker);
            }
        } else {
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "new " + this.m_constructor.getAbstractDataType().getImplementationName(dataFlowCodeGenerationHelper) + "(" + this.m_constructor.getIndex() + ")", codeGenerationTracker);
            } else {
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "new " + this.m_constructor.getAbstractDataType().getName() + "_", codeGenerationTracker);
                dataFlowCodeGenerationHelper.append(string2 + dataFlowCodeGenerationHelper.m_dot + "m_type = " + this.m_constructor.getIndex() + ";\n");
            }
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (this.m_constructor.m_parameters[i] == binding && string != null) {
                    codeGenerationTracker.generateAddToStream(this.m_parameters[i], string, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), dataFlowCodeGenerationHelper, false);
                    dataFlowCodeGenerationHelper.append(string2 + dataFlowCodeGenerationHelper.m_dot + this.m_constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper) + " = " + string + "_stream;\n");
                    continue;
                }
                String string4 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.append(string2 + dataFlowCodeGenerationHelper.m_dot + this.m_constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper) + " = " + string4 + ";\n");
            }
        }
        return string2;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (!(this.m_constructor.getAbstractDataType() instanceof ConstructorDataType)) {
            throw new UnsupportedOperationException("stream in adt optimization only supported for CDTs");
        }
        if (bl) {
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (this.m_constructor.m_parameters[i] == binding && nArray != null) {
                    codeGenerationTracker.generateAddToStream(this.m_parameters[i], nArray, instructionListBuilder, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), bCELCodeGenerationHelper, null);
                    continue;
                }
                codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            }
        } else {
            String string = this.m_constructor.getAbstractDataType().getImplementationName(bCELCodeGenerationHelper);
            instructionListBuilder.appendNew(string);
            instructionListBuilder.appendDUP();
            instructionListBuilder.appendConstant(this.m_constructor.getIndex());
            instructionListBuilder.appendInvokeConstructor(string, BasicType.INT);
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (this.m_constructor.m_parameters[i] == binding && nArray != null) {
                    codeGenerationTracker.generateAddToStream(this.m_parameters[i], nArray, instructionListBuilder, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), bCELCodeGenerationHelper, null);
                    instructionListBuilder.appendDUP();
                    instructionListBuilder.appendALoad(nArray[0]);
                    instructionListBuilder.appendPutField(this.m_constructor, i, bCELCodeGenerationHelper);
                    continue;
                }
                instructionListBuilder.appendDUP();
                codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
                instructionListBuilder.appendPutField(this.m_constructor, i, bCELCodeGenerationHelper);
            }
        }
    }

    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (this.m_parameters[i].isStatic(bindingEnvironment)) continue;
            return false;
        }
        return true;
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle) {
            return this.m_constructor.getAbstractDataType() instanceof ConstructorDataType;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        return true;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object[] objectArray = new Object[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object;
            objectArray[i] = object = this.m_parameters[i].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        AbstractDataObject abstractDataObject = new AbstractDataObject(this.m_constructor, objectArray);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, abstractDataObject);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("construct", n);
        prettyPrinter.printToken(this.m_constructorName, n + 1);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].toString(prettyPrinter, n + 1);
        }
        prettyPrinter.print(")");
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)object;
        if (this.m_constructor == null || constructorInstantiationInstruction.m_constructor == null) {
            return this.m_constructorName.equals(constructorInstantiationInstruction.m_constructorName);
        }
        return constructorInstantiationInstruction.m_constructor == this.m_constructor;
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_constructorName = readObjectFileHelper.readString();
        this.m_namedType = (NamedType)readObjectFileHelper.readType();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_constructorName);
        writeObjectFileHelper.writeType(this.m_namedType);
    }

    public void desugarADTLambdas(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, PolymorphicADTDesugarer polymorphicADTDesugarer) {
        AbstractDataType abstractDataType = this.m_constructor.getAbstractDataType();
        if (abstractDataType instanceof AbstractDataTypeLambda) {
            NamedType namedType = (NamedType)polymorphicADTDesugarer.convertType(this.getType(typeEnvironment, bindingEnvironment));
            AbstractDataType abstractDataType2 = namedType.resolveNameToADT(typeEnvironment);
            this.m_constructor = abstractDataType2.m_constructors[this.m_constructor.getIndex()];
            this.m_constructorName = this.m_constructor.getName();
            this.m_namedType = abstractDataType2.getNamedType();
        }
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_namedType = (NamedType)this.getCachedType().resolveTypeAsMuchAsPossible(reductionHelper.m_typeEnvironment, new HashSet());
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    public int getTypeParameterCount() {
        return 1;
    }

    public Type getTypeParameter(int n) {
        if (n == 0) {
            return this.m_namedType;
        }
        return null;
    }

    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_namedType = (NamedType)type;
        }
    }

    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        this.m_constructor = typeEnvironment.getModule().getConstructor(this.m_constructorName);
        if (this.m_constructor == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this);
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Instruction instruction = this.m_parameters[i];
            if (!(instruction instanceof IMatchDestructable)) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", instruction + " not supported in match2 pattern"), this);
            }
            typeEnvironment.unify(((IMatchDestructable)((Object)instruction)).typeCheckDestruction(typeEnvironment, bindingEnvironment), this.m_constructor.m_parameters[i].getBindingType(), this);
        }
        return this.m_constructor.getAbstractDataType().getNamedType();
    }

    public Instruction desugarDestruction(Instruction instruction, final ReductionHelper reductionHelper, IMatchDestructable.Generator generator, final IMatchDestructable.Generator generator2, final BindingEnvironment bindingEnvironment) {
        Object[] objectArray = new Object[this.m_constructor.m_parameters.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = reductionHelper.generateReducedIdentifier("");
        }
        MatchInstruction.DeconstructionMatch deconstructionMatch = new MatchInstruction.DeconstructionMatch(this.m_constructor, objectArray, null);
        final Binding[] bindingArray = deconstructionMatch.getBindings();
        for (int i = bindingArray.length - 1; i >= 0; --i) {
            final IMatchDestructable iMatchDestructable = (IMatchDestructable)((Object)this.m_parameters[i]);
            final int n = i;
            final IMatchDestructable.Generator generator3 = generator;
            bindingEnvironment.setVariableBinding(bindingArray[i]);
            generator = new IMatchDestructable.Generator(){

                public Instruction generate() {
                    return iMatchDestructable.desugarDestruction(new IdentifierInstruction(bindingArray[n].getName()), reductionHelper, generator3, generator2, bindingEnvironment).assignNewNames(new HashMap());
                }
            };
        }
        deconstructionMatch.m_handler = generator.generate();
        return new MatchInstruction(instruction, new MatchInstruction.Match[]{deconstructionMatch}, generator2.generate());
    }
}

