/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.instructions.DebugInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;

public abstract class FunctionGenerationStyle {
    protected Function m_function;
    private String m_signature = null;

    protected FunctionGenerationStyle(Function function) {
        this.m_function = function;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((FunctionGenerationStyle)object).m_function == this.m_function;
    }

    public Function getFunction() {
        return this.m_function;
    }

    public int hashCode() {
        return this.m_function.getName().hashCode() + this.getClass().hashCode();
    }

    public abstract void generateFunctionBasedOnDataFlow(DataFlowCodeGenerationHelper var1, CodeGenerationTracker var2);

    public abstract void generateFunction(BCELCodeGenerationHelper var1, CodeGenerationTracker var2, InstructionList var3);

    protected final void generateFunctionHeader(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        Function function = this.m_function;
        String string = function.getComment();
        dataFlowCodeGenerationHelper.append("// " + function.getName() + "\n");
        if (string != null) {
            dataFlowCodeGenerationHelper.append("// ");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("\n");
        }
    }

    protected final void generateFunctionFooter(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        Function function = this.m_function;
        String string = function.getComment();
        if (string != null) {
            dataFlowCodeGenerationHelper.append("// ");
            dataFlowCodeGenerationHelper.append(string);
            dataFlowCodeGenerationHelper.append("\n");
        }
        dataFlowCodeGenerationHelper.append("// end\n\n");
    }

    protected final void generateProfileHitCode(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Function function = this.m_function;
        if (dataFlowCodeGenerationHelper.getSettings().isFunctionCallTracing()) {
            dataFlowCodeGenerationHelper.append("if (" + dataFlowCodeGenerationHelper.generateThisVar() + " != null) {\n");
            dataFlowCodeGenerationHelper.append("StringBuffer sb = new StringBuffer();");
            dataFlowCodeGenerationHelper.append("for (int __stackcounterspace__ = 0; __stackcounterspace__ < " + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__; __stackcounterspace__++) sb.append(\"   \");\n");
            dataFlowCodeGenerationHelper.append("sb.append(\">> " + LiteralInstruction.escape(function.generateFunctionName(dataFlowCodeGenerationHelper)) + ": " + LiteralInstruction.escape(function.getComment() == null ? "" : function.getComment()) + "\");\n");
            dataFlowCodeGenerationHelper.append("sb.append('\\n');\n");
            for (int i = 0; i < function.m_parameters.length; ++i) {
                Object object = function.m_parameters[i].getName();
                String string = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[i], dataFlowCodeGenerationHelper, false);
                dataFlowCodeGenerationHelper.append("for (int __stackcounterspace__ = 0; __stackcounterspace__ < " + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__; __stackcounterspace__++) sb.append(\"   \");\n");
                dataFlowCodeGenerationHelper.append("sb.append(\"   " + LiteralInstruction.escape(object.toString()) + " = \");\n");
                Type type = function.m_parameters[i].getBindingType();
                DebugInstruction.generateStringValue(type, string, "sb", dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.append("sb.append('\\n');\n");
            }
            dataFlowCodeGenerationHelper.append("System.err.println(sb.toString());\n");
            dataFlowCodeGenerationHelper.append("++" + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__;\n");
            dataFlowCodeGenerationHelper.append("}\n");
            String string = (String)dataFlowCodeGenerationHelper.generationMemosGet("stackCounter");
            if (string == null) {
                dataFlowCodeGenerationHelper.generationMemosPut("stackCounter", "__stackcounter__");
                dataFlowCodeGenerationHelper.appendConstantStatement("protected int __stackcounter__ = 0;\n");
            }
        }
    }

    public final void generateProfileExitCode(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl, Type type, String string2) {
        Function function = this.m_function;
        if (dataFlowCodeGenerationHelper.getSettings().isFunctionCallTracing()) {
            dataFlowCodeGenerationHelper.append("if (" + dataFlowCodeGenerationHelper.generateThisVar() + " != null) {\n");
            dataFlowCodeGenerationHelper.append("--" + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__;\n");
            dataFlowCodeGenerationHelper.append("StringBuffer sb = new StringBuffer();");
            dataFlowCodeGenerationHelper.append("for (int __stackcounterspace__ = 0; __stackcounterspace__ < " + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__; __stackcounterspace__++) sb.append(\"   \");\n");
            dataFlowCodeGenerationHelper.append("sb.append(\"<< " + LiteralInstruction.escape(function.generateFunctionName(dataFlowCodeGenerationHelper)) + ": " + LiteralInstruction.escape(function.getComment() == null ? "" : function.getComment()) + "\");\n");
            dataFlowCodeGenerationHelper.append("sb.append('\\n');\n");
            dataFlowCodeGenerationHelper.append("for (int __stackcounterspace__ = 0; __stackcounterspace__ < " + dataFlowCodeGenerationHelper.generateThisVar() + dataFlowCodeGenerationHelper.m_dot + "__stackcounter__; __stackcounterspace__++) sb.append(\"   \");\n");
            dataFlowCodeGenerationHelper.append("sb.append(\"   return = \");\n");
            if (string != null) {
                Type type2 = type;
                if (type2 == null) {
                    type2 = function.getReturnType();
                }
                if (bl) {
                    if (!(type2 instanceof StreamType)) {
                        throw new XylemError("ERR_SYSTEM", "" + type2 + " " + this.getClass().getName());
                    }
                    DebugInstruction.generateStreamStringValue((StreamType)type2, string, "sb", dataFlowCodeGenerationHelper, string2);
                } else {
                    DebugInstruction.generateStringValue(type2, string, "sb", dataFlowCodeGenerationHelper);
                }
            } else {
                dataFlowCodeGenerationHelper.append("sb.append(\"tailrecurse\");\n");
            }
            dataFlowCodeGenerationHelper.append("sb.append('\\n');\n");
            dataFlowCodeGenerationHelper.append("System.err.println(sb.toString());\n");
            dataFlowCodeGenerationHelper.append("}\n");
        }
    }

    protected String computeSignature() {
        return this.m_function.getName() + "___" + this.getClass().toString();
    }

    public String getSignature() {
        if (this.m_signature == null) {
            this.m_signature = this.computeSignature();
        }
        return this.m_signature;
    }

    protected TypeEnvironment prepareTypeEnvironment() {
        TypeEnvironment typeEnvironment = this.m_function.getTypeEnvironment();
        return typeEnvironment;
    }

    protected static final String generateStaticThisIfNeeded(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer) {
        if (dataFlowCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(dataFlowCodeGenerationHelper.getClassName());
            stringBuffer2.append(" __this__");
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(", ");
            }
            return stringBuffer2.toString();
        }
        return "";
    }

    protected static final void generateStaticThisIfNeeded(BCELCodeGenerationHelper bCELCodeGenerationHelper, ArrayList arrayList, ArrayList arrayList2) {
        if (bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            arrayList.add(" __this__");
            arrayList2.add(new ObjectType(bCELCodeGenerationHelper.getClassName()));
        }
    }

    protected void generateParamSpecs(BCELCodeGenerationHelper bCELCodeGenerationHelper, ArrayList arrayList, ArrayList arrayList2, CodeGenerationTracker codeGenerationTracker) {
        Binding[] bindingArray = this.m_function.m_parameters;
        String[] stringArray = new String[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            Type type = bindingArray[i].getBindingType();
            com.ibm.xtq.bcel.generic.Type type2 = type.getImplementationType(bCELCodeGenerationHelper);
            stringArray[i] = Binding.generateVariableName(bindingArray[i], bCELCodeGenerationHelper);
            int n = codeGenerationTracker.allocateRegister(type2);
            codeGenerationTracker.registerExtantBinding(bindingArray[i], n, type2);
            arrayList2.add(type2);
            arrayList.add(stringArray[i]);
        }
    }

    protected void generateParamSpecs(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer, CodeGenerationTracker codeGenerationTracker) {
        Binding[] bindingArray = this.m_function.m_parameters;
        String[] stringArray = new String[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            stringArray[i] = dataFlowCodeGenerationHelper.generateNewLocalVariableName(Binding.generateVariableName(bindingArray[i], dataFlowCodeGenerationHelper));
            codeGenerationTracker.registerExtantBinding(bindingArray[i], stringArray[i]);
            Type type = bindingArray[i].getBindingType();
            type.generateParamSpec(stringBuffer, dataFlowCodeGenerationHelper, stringArray[i], codeGenerationTracker.getCurrentModule());
            if (i == bindingArray.length - 1) continue;
            stringBuffer.append(", ");
        }
    }
}

