/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.FunctionInstantiation;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.IContext;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LUBConstraint;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.TypeSpecializationDerivative;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class Function
implements Serializable,
IContext {
    private static final long serialVersionUID = -7216470938089112997L;
    private static final char ESCAPE_DELIM_CHAR = '$';
    protected String m_name;
    protected Instruction m_body;
    public Binding[] m_parameters;
    public String[] m_defaultValues;
    private TypeEnvironment m_typeEnvironment;
    public BindingEnvironment m_bindingEnvironment;
    protected Type m_returnType;
    private HashSet m_constraints;
    public String m_comment;
    public HashMap m_resolvedConstraintTypes = new HashMap();
    protected HashMap m_derivatives = new HashMap();
    protected Function m_original = null;
    protected Object m_derivationKey = null;
    protected boolean m_memoizeResult = false;
    protected boolean m_inlineHint = false;
    protected boolean m_impure = false;
    protected TypeEnvironment m_inProgressTypeEnvironment;
    public boolean m_supportsStreamOptimization = false;
    public boolean m_checkedStreamOptimization = false;
    public boolean m_inSupportsStreamCall = false;
    public boolean m_supportsStreamInADTOptimization = false;
    public boolean m_supportsStreamInObjectlessADT = false;
    public boolean m_checkedStreamInADTOptimization = false;
    public boolean m_inSupportsStreamInADTCall = false;
    public int m_definitionLineNumber;
    public URL m_definitionURL;
    public boolean m_isClassMethod = false;
    private boolean hasTryCatchInstruction = false;
    private InstructionHandle exceptionHandle = null;
    static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$Function == null ? (class$com$ibm$xylem$Function = Function.class$("com.ibm.xylem.Function")) : class$com$ibm$xylem$Function);
    private boolean m_checkedRecursiveness = false;
    private boolean m_isRecursiveF = false;
    private static int s_fixups = 0;
    protected String m_memoizedVarName;
    protected String m_memoizedCheckVarName;
    protected Object m_interpreterStoredMemoizedValue;
    static /* synthetic */ Class class$com$ibm$xylem$Function;

    public Function() {
    }

    public boolean getTryFlag() {
        return this.hasTryCatchInstruction;
    }

    public void setTryFlag(boolean bl) {
        this.hasTryCatchInstruction = bl;
    }

    public InstructionHandle getExceptionHandle() {
        return this.exceptionHandle;
    }

    public void setExceptionHandle(InstructionHandle instructionHandle) {
        this.exceptionHandle = instructionHandle;
    }

    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    public static void pushFunction(Function function, LinkedList linkedList) {
        linkedList.add(function);
    }

    public static LinkedList isInCycle(Function function, LinkedList linkedList) {
        LinkedList<Function> linkedList2 = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Function function2 = (Function)iterator.next();
            if (function2 == function) {
                linkedList2 = new LinkedList<Function>();
                continue;
            }
            if (linkedList2 == null) continue;
            linkedList2.add(function2);
        }
        return linkedList2;
    }

    public boolean isRecursive() {
        if (this.m_checkedRecursiveness) {
            return this.m_isRecursiveF;
        }
        HashSet hashSet = new HashSet();
        this.getBody().accumulateFunctionsCalled(hashSet);
        this.m_isRecursiveF = hashSet.contains(this.getName());
        this.m_checkedRecursiveness = true;
        return this.m_isRecursiveF;
    }

    public static Function getCurrentFunction(LinkedList linkedList) {
        if (linkedList.isEmpty()) {
            return null;
        }
        return (Function)linkedList.getLast();
    }

    public static void popFunction(Function function, LinkedList linkedList) {
        if (linkedList.removeLast() != function) {
            throw new RuntimeException("Error: function stack is inconsistent");
        }
    }

    private void init(String string, Binding[] bindingArray, Instruction instruction, URL uRL, int n) {
        this.m_name = string;
        this.m_parameters = bindingArray;
        this.m_body = instruction;
        this.m_returnType = new TypeVariable();
        this.m_constraints = new HashSet();
        this.m_definitionURL = uRL;
        this.m_definitionLineNumber = n;
    }

    public Function(String string, Binding[] bindingArray, Instruction instruction) {
        this.init(string, bindingArray, instruction, null, 0);
    }

    public Function(String string, Binding[] bindingArray, Instruction instruction, URL uRL, int n) {
        this.init(string, bindingArray, instruction, uRL, n);
    }

    public void setMemoizeResult(boolean bl) {
        this.m_memoizeResult = bl;
    }

    public boolean getMemoizeResult() {
        return this.m_memoizeResult;
    }

    public void setImpurity(boolean bl) {
        this.m_impure = bl;
    }

    public boolean isImpure() {
        return this.m_impure;
    }

    public void setInlineHint(boolean bl) {
        this.m_inlineHint = bl;
    }

    public boolean getInlineHint() {
        return this.m_inlineHint;
    }

    public Function cloneFunctionForFixup(Object object) {
        return this.cloneFunctionForFixup(object, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateNewFixupName() {
        int n;
        Class clazz = class$com$ibm$xylem$Function == null ? (class$com$ibm$xylem$Function = Function.class$("com.ibm.xylem.Function")) : class$com$ibm$xylem$Function;
        synchronized (clazz) {
            n = s_fixups++;
        }
        return "$fixup$" + n + "$" + this.m_name;
    }

    public Function cloneFunctionForFixup(Object object, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        Iterator<Object> iterator;
        Serializable serializable2;
        String string = this.generateNewFixupName();
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            serializable2 = this.m_parameters[i];
            bindingArray[i] = new Binding(((Binding)serializable2).m_name, ((Binding)serializable2).m_type, ((Binding)serializable2).m_typeEnvironment);
        }
        Instruction instruction = this.m_body;
        if (bl2) {
            instruction = bl3 ? instruction.cloneReduced() : instruction.cloneWithoutTypeInformation();
        }
        serializable2 = new Function(string, bindingArray, instruction);
        ((Function)serializable2).m_comment = this.m_comment;
        this.registerDerivative(object, (Function)serializable2);
        ((Function)serializable2).setImpurity(this.isImpure());
        ((Function)serializable2).m_constraints = new HashSet();
        HashMap hashMap = new HashMap();
        if (this.m_constraints != null && !this.m_constraints.isEmpty()) {
            iterator = this.m_constraints.iterator();
            while (iterator.hasNext()) {
                serializable = (LUBConstraint)iterator.next();
                Iterator iterator2 = ((LUBConstraint)serializable).m_set.iterator();
                HashSet<Type> hashSet = new HashSet<Type>();
                while (iterator2.hasNext()) {
                    Type type = (Type)iterator2.next();
                    hashSet.add(bl ? type.duplicateType(hashMap) : type);
                }
                ((Function)serializable2).m_constraints.add(new LUBConstraint(bl ? ((LUBConstraint)serializable).m_t.duplicateType(hashMap) : ((LUBConstraint)serializable).m_t, hashSet));
            }
        }
        if (!this.m_resolvedConstraintTypes.isEmpty()) {
            iterator = this.m_resolvedConstraintTypes.keySet().iterator();
            while (iterator.hasNext()) {
                serializable = (Type)iterator.next();
                ((Function)serializable2).m_resolvedConstraintTypes.put(bl ? ((Type)serializable).duplicateType(hashMap) : serializable, this.m_resolvedConstraintTypes.get(serializable));
            }
        }
        if (!hashMap.isEmpty() && bl) {
            if (!bl2) {
                throw new XylemError("ERR_SYSTEM", "not compatible renameTypeVars && !cloneBody");
            }
            ((Function)serializable2).m_body.replaceTypeVariables(hashMap);
        }
        return serializable2;
    }

    public void setComment(String string) {
        this.m_comment = string;
    }

    public String getComment() {
        return this.m_comment;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    public boolean hasBeenTypeChecked() {
        return this.m_typeEnvironment != null;
    }

    public void typeCheck(final Module module, Instruction instruction, LinkedList linkedList) throws TypeCheckException {
        if (this.m_typeEnvironment != null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_name + " has already been type checked"), instruction);
        }
        LinkedList linkedList2 = Function.isInCycle(this, linkedList);
        if (linkedList2 != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                Function function = (Function)iterator.next();
                this.m_inProgressTypeEnvironment.incorporate(function.m_inProgressTypeEnvironment);
                function.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            if (!this.m_body.typeAliasesExpanded) {
                this.m_body.expandTypeAliases(module);
            }
            s_logger.debug("type checking function " + this.m_name);
            s_logger.debug(this.m_name + " has " + this.m_parameters.length + " parameters.");
            FunctionSignature functionSignature = module.getFunctionSignature(this.m_name);
            if (functionSignature != null) {
                functionSignature.m_parameterTypes = Type.map(new Type.Mapping(){

                    public Type apply(Type type) {
                        return type.expandTypeAliases(module);
                    }
                }, functionSignature.m_parameterTypes);
                functionSignature.m_returnType = functionSignature.m_returnType.expandTypeAliases(module);
            }
            BindingEnvironment bindingEnvironment = new BindingEnvironment();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(module);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_type = this.m_parameters[i].m_type.expandTypeAliases(module);
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                if (bindingEnvironment.getVariableBinding(this.m_parameters[i].getName()) != null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter name " + this.m_parameters[i].getName() + " is used more than once"), instruction);
                }
                bindingEnvironment.setVariableBinding(this.m_parameters[i]);
                if (functionSignature == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), functionSignature.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter " + this.m_parameters[i].getName() + "@" + this.m_parameters[i].getBindingType() + " of function " + this.m_name + " does not match the type@" + functionSignature.getParameterTypes()[i] + " given in the module signature " + functionSignature.getFunctionName()), null);
                }
            }
            Function.pushFunction(this, linkedList);
            try {
                this.m_body.typeCheck(this.m_inProgressTypeEnvironment, bindingEnvironment, linkedList);
            }
            catch (Exception exception) {
                s_logger.error("exception in typecheck of " + this.getName() + " dumping program to errors.xylem.", exception);
                Program.dumpXylemFile(module, null, "errors");
                if (exception instanceof TypeCheckException) {
                    throw (TypeCheckException)exception;
                }
                throw new Error("TCE");
            }
            if (this.m_returnType != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, this.m_body.getCachedType(), null);
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_body.getCachedType().resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature"), null);
                }
            } else {
                this.m_returnType = this.m_body.getCachedType();
            }
            if (functionSignature != null && functionSignature.getReturnType() != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, functionSignature.getReturnType(), null);
                }
                catch (TypeCheckException typeCheckException) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_returnType + " of function " + this.m_name + " does not match the type " + functionSignature.getReturnType() + " given in the module signature"), null);
                }
            }
            Function.popFunction(this, linkedList);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = bindingEnvironment;
            Iterator iterator = this.m_resolvedConstraintTypes.keySet().iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                Type type2 = (Type)this.m_resolvedConstraintTypes.get(type);
                this.m_typeEnvironment.unify(type, type2, null);
            }
            if (this.m_constraints != null) {
                this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, module.m_lubResolver, true);
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                this.m_constraints = null;
            }
            this.standardizeTypes(false);
        }
    }

    public void standardizeTypes(boolean bl) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type type = this.m_parameters[i].getBindingType().resolveTypeAsMuchAsPossible(this.m_typeEnvironment, hashSet);
            this.m_parameters[i].setType(type);
        }
        this.m_returnType = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, hashSet);
        if (bl) {
            this.m_body.standardizeTypes(hashSet, this.m_typeEnvironment);
        }
    }

    public void typeCheckReduced(Module module, LinkedList linkedList) throws TypeCheckException {
        LinkedList linkedList2 = Function.isInCycle(this, linkedList);
        if (linkedList2 != null) {
            if (this.m_returnType == null) {
                this.m_returnType = new TypeVariable();
            }
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                Function function = (Function)iterator.next();
                this.m_inProgressTypeEnvironment.incorporate(function.m_inProgressTypeEnvironment);
                function.m_inProgressTypeEnvironment.redirectFrom(this.m_inProgressTypeEnvironment);
            }
        } else {
            FunctionSignature functionSignature = module.getFunctionSignature(this.m_name);
            BindingEnvironment bindingEnvironment = new BindingEnvironment();
            bindingEnvironment.prepareHashMap();
            this.m_inProgressTypeEnvironment = new TypeEnvironment(module);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].m_typeEnvironment = this.m_inProgressTypeEnvironment;
                bindingEnvironment.setVariableBinding(this.m_parameters[i]);
                if (functionSignature == null) continue;
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_parameters[i].getBindingType(), functionSignature.getParameterTypes()[i], null);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    s_logger.error(typeCheckException);
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Parameter '" + this.m_parameters[i].getName() + "' of function '" + this.m_name + "' does not match the type given in the module signature (" + typeCheckException + ")"), null);
                }
            }
            Function.pushFunction(this, linkedList);
            try {
                this.m_body.typeCheckReduced(this.m_inProgressTypeEnvironment, bindingEnvironment, linkedList);
            }
            catch (Exception exception) {
                s_logger.error("Error type-checking body of " + this.getName(), exception);
                s_logger.error(this);
                throw new Error("TCE");
            }
            TypeEnvironment typeEnvironment = this.m_inProgressTypeEnvironment;
            if (this.m_returnType != null) {
                try {
                    this.m_inProgressTypeEnvironment.unify(this.m_returnType, this.m_body.getType(typeEnvironment, bindingEnvironment), null);
                }
                catch (TypeCheckException typeCheckException) {
                    String string = XylemMsg.createXylemMessage("ERR_SYSTEM", "The return type " + this.m_body.getType(typeEnvironment, bindingEnvironment).resolveType(this.m_inProgressTypeEnvironment) + " of function " + this.m_name + " does not match the type " + this.m_returnType + " given in the module signature");
                    s_logger.error(string, typeCheckException);
                    throw new TypeCheckException(string, null);
                }
            } else {
                this.m_returnType = this.m_body.getType(typeEnvironment, bindingEnvironment);
            }
            if (functionSignature != null && functionSignature.getReturnType() != null) {
                this.m_inProgressTypeEnvironment.unify(this.m_returnType, functionSignature.getReturnType(), null);
            }
            Function.popFunction(this, linkedList);
            this.m_typeEnvironment = this.m_inProgressTypeEnvironment;
            this.m_bindingEnvironment = bindingEnvironment;
            this.standardizeTypes(false);
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Type type) {
        this.m_returnType = type;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    public void unifyParameter(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Type type, Instruction[] instructionArray, int n, FunctionCallInstruction functionCallInstruction, boolean bl) throws TypeCheckException {
        Type type2 = this.m_parameters[n].getBindingType();
        this.unifyParameter(typeEnvironment, bindingEnvironment, type, type2, instructionArray, n, functionCallInstruction, bl);
    }

    public void unifyParameter(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Type type, Type type2, Instruction[] instructionArray, int n, FunctionCallInstruction functionCallInstruction, boolean bl) throws TypeCheckException {
        if (type == null) {
            throw new RuntimeException();
        }
        Type[] typeArray = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            Type type3 = (bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType()).resolveType(typeEnvironment);
            if (type3 == null) continue;
            typeArray[i] = type3;
        }
        typeEnvironment.unify(type, type2, functionCallInstruction);
    }

    public FunctionInstantiation instantiate(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Instruction[] instructionArray, FunctionCallInstruction functionCallInstruction, LinkedList linkedList, boolean bl) throws TypeCheckException {
        Type type;
        Object object;
        Object object2;
        Type type2;
        Type type3;
        if (instructionArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_name + "\n  expected " + this.m_parameters.length + ", found " + instructionArray.length), functionCallInstruction);
        }
        Function function = this;
        Type[] typeArray = new HashMap();
        Object object3 = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            Type type4 = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            type3 = function.m_parameters[i].m_type;
            Type type5 = type2 = function.m_parameters[i].m_typeEnvironment == null ? null : type3.resolveType(function.m_parameters[i].m_typeEnvironment);
            if (type2 != null) {
                type3 = type2;
            }
            if (bl) continue;
            type3 = type3.duplicateType((Map)typeArray);
            this.unifyParameter(typeEnvironment, bindingEnvironment, type4, type3, instructionArray, i, functionCallInstruction, bl);
            object3[i] = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            object2 = function.m_resolvedConstraintTypes.keySet().iterator();
            while (object2.hasNext()) {
                object = (Type)object2.next();
                type = (Type)function.m_resolvedConstraintTypes.get(object);
                typeEnvironment.unify(((Type)object).duplicateType((Map)typeArray), type, null);
            }
        }
        if (this.isPolymorphic()) {
            typeArray = new Type[instructionArray.length];
            for (int i = 0; i < instructionArray.length; ++i) {
                Type type6;
                typeArray[i] = type6 = (bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType()).resolveType(typeEnvironment);
            }
            object3 = new TypeSpecializationDerivative(typeArray);
            if (!((TypeSpecializationDerivative)object3).equals(this.m_derivationKey)) {
                Function function2 = TypeSpecializationDerivative.specializeTypes(this, typeArray);
                functionCallInstruction.setFunction(function2.getName());
                function = function2;
                typeEnvironment.getModule().addFunction(function);
            }
        }
        object3 = Function.getCurrentFunction(linkedList);
        if (function.isPolymorphic()) {
            if (object3 == null) {
                typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
            } else if (!((Function)object3).isPolymorphic()) {
                typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
            }
        }
        if (!function.hasBeenTypeChecked()) {
            if (bl) {
                function.typeCheckReduced(typeEnvironment.getModule(), linkedList);
            } else {
                function.typeCheck(typeEnvironment.getModule(), functionCallInstruction, linkedList);
            }
        }
        HashMap hashMap = new HashMap();
        typeArray = new Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            type3 = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            type2 = function.m_parameters[i].m_type;
            Object object4 = object2 = function.m_parameters[i].m_typeEnvironment == null ? null : type2.resolveType(function.m_parameters[i].m_typeEnvironment);
            if (object2 != null) {
                type2 = object2;
            }
            if (bl) continue;
            type2 = type2.duplicateType(hashMap);
            this.unifyParameter(typeEnvironment, bindingEnvironment, type3, type2, instructionArray, i, functionCallInstruction, bl);
            typeArray[i] = bl ? instructionArray[i].getType(typeEnvironment, bindingEnvironment) : instructionArray[i].getCachedType();
            object = function.m_resolvedConstraintTypes.keySet().iterator();
            while (object.hasNext()) {
                type = (Type)object.next();
                Type type7 = (Type)function.m_resolvedConstraintTypes.get(type);
                typeEnvironment.unify(type.duplicateType(hashMap), type7, null);
            }
        }
        Type type8 = function.m_returnType;
        if (function.m_typeEnvironment != null && (type3 = type8.resolveType(function.m_typeEnvironment)) != null) {
            type8 = type3;
        }
        if (!bl) {
            type8 = type8.duplicateType(hashMap);
        }
        if (!type8.isFullySpecified()) {
            typeEnvironment.getModule().addToFixupList(functionCallInstruction, (Function)object3);
        }
        return new FunctionInstantiation(function, typeArray, type8, hashMap, typeEnvironment, functionCallInstruction, bindingEnvironment);
    }

    public Type instantiateReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, FunctionCallInstruction functionCallInstruction, LinkedList linkedList) throws TypeCheckException {
        Function function = this;
        if (!function.hasBeenTypeChecked()) {
            function.typeCheckReduced(typeEnvironment.getModule(), linkedList);
        }
        if (function.isPolymorphic()) {
            HashMap hashMap = new HashMap();
            Instruction[] instructionArray = functionCallInstruction.m_parameters;
            for (int i = 0; i < function.m_parameters.length; ++i) {
                Binding binding = function.m_parameters[i];
                Type type = binding.getBindingType();
                Type type2 = type.duplicateType(hashMap);
                typeEnvironment.unify(instructionArray[i].getType(typeEnvironment, bindingEnvironment), type2, functionCallInstruction);
            }
            return function.m_returnType.duplicateType(hashMap);
        }
        return function.m_returnType;
    }

    public Type instantiateReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Instruction[] instructionArray, FunctionCallInstruction functionCallInstruction, Set set, Set set2, Set set3) {
        Function function = this;
        if (this.isPolymorphic()) {
            Type type;
            Type type2;
            int n;
            Type[] typeArray = new Type[instructionArray.length];
            TypeEnvironment typeEnvironment2 = (TypeEnvironment)this.m_typeEnvironment.clone();
            for (n = 0; n < instructionArray.length; ++n) {
                Type type3 = instructionArray[n].getType(typeEnvironment, bindingEnvironment).resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet());
                try {
                    type2 = this.m_parameters[n].getBindingType();
                    typeEnvironment2.unify(type3, type2, functionCallInstruction);
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                    throw new RuntimeException();
                }
                typeArray[n] = type3;
            }
            for (n = 0; n < instructionArray.length; ++n) {
                typeArray[n] = typeArray[n].resolveType(typeEnvironment2);
                if (typeArray[n] == null) {
                    throw new XylemError("ERR_SYSTEM", "Some type could not be inferred in " + this);
                }
                try {
                    typeEnvironment.unify(typeArray[n], instructionArray[n].getType(typeEnvironment, bindingEnvironment), functionCallInstruction);
                    continue;
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                    throw new RuntimeException();
                }
            }
            Function function2 = TypeSpecializationDerivative.specializeTypes(this, typeArray);
            functionCallInstruction.setFunction(function2.getName());
            typeEnvironment.getModule().addFunction(function2);
            if (!function2.hasBeenTypeChecked()) {
                try {
                    s_logger.debug("Function:instantiateReduced() type-checking new function '" + function2.getName() + "'");
                    function2.typeCheckReduced(typeEnvironment.getModule(), new LinkedList());
                    set.add(function2);
                    for (int i = 0; i < instructionArray.length; ++i) {
                        type2 = this.m_parameters[i].getBindingType();
                        function2.m_typeEnvironment.unify(type2, typeArray[i], functionCallInstruction);
                    }
                    function2.standardizeTypes(true);
                    function2.instantiateReducedPolymorphicFunctions(set, set2, set3);
                }
                catch (Exception exception) {
                    s_logger.error("" + exception, exception);
                    throw new RuntimeException("" + exception);
                }
            }
            if ((type2 = (type = function2.m_returnType).resolveType(typeEnvironment2)) == null) {
                throw new XylemError("ERR_SYSTEM", "An error occurred trying to process function " + function2.getName());
            }
            return type2;
        }
        if (!set2.contains(function)) {
            function.instantiateReducedPolymorphicFunctions(set, set2, set3);
        }
        Type type = function.m_returnType;
        return type.resolveType(function.m_typeEnvironment);
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.m_bindingEnvironment;
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printComment("============================================", n);
        if (null != this.m_comment) {
            prettyPrinter.printComment(this.m_comment, n);
        }
        prettyPrinter.printFormOpen("function", n);
        if (this.m_memoizeResult) {
            prettyPrinter.printToken("memoize", n);
        }
        if (this.m_impure) {
            prettyPrinter.printToken("impure", n);
        }
        if (this.m_inlineHint) {
            prettyPrinter.printToken("inline", n);
        }
        prettyPrinter.printToken("(" + this.m_name, n + 1);
        if (!(this.m_returnType == null || this.m_typeEnvironment == null && this.m_returnType instanceof TypeVariable)) {
            Type type = this.m_returnType;
            if (this.m_typeEnvironment != null) {
                type = this.m_returnType.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            prettyPrinter.print("@");
            prettyPrinter.print(type.prettyPrint());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.println("");
            prettyPrinter.print("      ");
            prettyPrinter.printIdentifier(this.m_parameters[i].getName(), n + 2);
            Type type = this.m_parameters[i].getBindingType();
            if (type == null) continue;
            if (this.m_typeEnvironment != null) {
                type = type.resolveTypeAsMuchAsPossible(this.m_typeEnvironment, new HashSet());
            }
            prettyPrinter.print("@");
            prettyPrinter.print(type.prettyPrint());
        }
        prettyPrinter.printFormClose(n + 1);
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    public String generateFunctionName(CodeGeneration codeGeneration) {
        return Function.generateFunctionName(codeGeneration, this.getName());
    }

    public static final String generateFunctionName(CodeGeneration codeGeneration, String string) {
        if (codeGeneration.getSettings().isObfuscateFunctionNames()) {
            String string2 = codeGeneration.getObfuscatedFunctionName(string);
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 != '$' && (Character.isJavaIdentifierStart(c2) || Character.isJavaIdentifierPart(c2))) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('$').append("0x").append(Integer.toHexString(c2)).append('$');
        }
        return stringBuffer.toString();
    }

    public void clearTypeInformation() {
        this.clearTypeInformation(true);
    }

    public void clearTypeInformation(boolean bl) {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        this.m_body.clearTypeInformation();
        if (bl && this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void clearReducedTypeInformation() {
        this.m_bindingEnvironment = null;
        this.m_typeEnvironment = null;
        if (this.m_returnType != null && this.m_returnType instanceof TypeVariable) {
            this.m_returnType = null;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
        }
        this.m_inProgressTypeEnvironment = null;
    }

    public void reduce() {
        if (this.m_typeEnvironment == null) {
            return;
        }
        this.m_bindingEnvironment = new BindingEnvironment();
        this.m_bindingEnvironment.prepareHashMap();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].m_typeEnvironment = null;
            this.m_bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        ReductionHelper reductionHelper = new ReductionHelper(this.m_typeEnvironment);
        this.m_body = reductionHelper.reduce(this.m_body, this.m_bindingEnvironment);
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap) {
        this.determineDataDependencies(bindingArray, hashMap, this.getBindingEnvironment());
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, BindingEnvironment bindingEnvironment) {
        try {
            this.m_body.determineDataDependencies(bindingArray, hashMap, null, -1, bindingEnvironment);
        }
        catch (RuntimeException runtimeException) {
            s_logger.error("error encountering getting data dependancies for " + this.getName(), runtimeException);
            throw runtimeException;
        }
    }

    public void recordLUBConstraintResults(TypeEnvironment typeEnvironment) {
        Iterator iterator = this.m_constraints.iterator();
        while (iterator.hasNext()) {
            LUBConstraint lUBConstraint = (LUBConstraint)iterator.next();
            Type type = lUBConstraint.m_t.resolveType(typeEnvironment);
            if (type == null) continue;
            this.m_resolvedConstraintTypes.put(lUBConstraint.m_t, type);
            iterator.remove();
        }
    }

    public Function lookupDerivative(Object object) {
        return (Function)this.m_derivatives.get(object);
    }

    public void registerDerivative(Object object, Function function) {
        function.m_derivationKey = object;
        function.m_original = this;
        this.m_derivatives.put(object, function);
    }

    public boolean isDerivative() {
        return this.m_derivationKey != null;
    }

    public Object getDerivationKey() {
        return this.m_derivationKey;
    }

    public Function getOriginalFunction() {
        return this.m_original;
    }

    public boolean isPolymorphic() {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (this.m_parameters[i].m_type.isFullySpecified()) continue;
            return true;
        }
        return false;
    }

    public void setConstraints(HashSet hashSet) {
        this.m_constraints = hashSet;
    }

    public HashSet getConstraints() {
        return this.m_constraints;
    }

    public boolean resolveConstraints(boolean bl) throws TypeCheckException {
        if (!this.isPolymorphic() && this.m_constraints != null) {
            if (this.m_typeEnvironment.resolveLUBConstraints(this.m_constraints, this.m_typeEnvironment.getModule().m_lubResolver, bl)) {
                this.recordLUBConstraintResults(this.m_typeEnvironment);
                return true;
            }
            return false;
        }
        return true;
    }

    public String getMemoVarName(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        if (this.m_memoizedVarName == null) {
            Type type = this.m_returnType.resolveType(this.m_typeEnvironment);
            this.m_memoizedVarName = dataFlowCodeGenerationHelper.generateNewMemberVariableName();
            dataFlowCodeGenerationHelper.appendConstantStatement((dataFlowCodeGenerationHelper.isTargetJava() ? "protected " : "") + type.getImplementationName(dataFlowCodeGenerationHelper) + " " + this.m_memoizedVarName + ";\n");
            if (type.getDefaultValue().equals("null")) {
                dataFlowCodeGenerationHelper.appendRecycleStatement(this.m_memoizedVarName + " = null;\n");
            }
        }
        return this.m_memoizedVarName;
    }

    public String getMemoCheckVarName(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        if (this.m_memoizedCheckVarName == null) {
            this.m_memoizedCheckVarName = dataFlowCodeGenerationHelper.generateNewMemberVariableName();
            dataFlowCodeGenerationHelper.appendConstantStatement((dataFlowCodeGenerationHelper.isTargetJava() ? "protected " : "") + "boolean " + this.m_memoizedCheckVarName + " = false;\n");
            dataFlowCodeGenerationHelper.appendRecycleStatement(this.m_memoizedCheckVarName + " = false;\n");
        }
        return this.m_memoizedCheckVarName;
    }

    public String getMemoVarName(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        if (this.m_memoizedVarName == null) {
            Type type = this.m_returnType.resolveType(this.m_typeEnvironment);
            this.m_memoizedVarName = bCELCodeGenerationHelper.generateNewMemberVariableName();
            bCELCodeGenerationHelper.allocateThreadLocalVariable(this.m_memoizedVarName, type.getImplementationType(bCELCodeGenerationHelper), true);
        }
        return this.m_memoizedVarName;
    }

    public String getMemoCheckVarName(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        if (this.m_memoizedCheckVarName == null) {
            this.m_memoizedCheckVarName = bCELCodeGenerationHelper.generateNewMemberVariableName();
            bCELCodeGenerationHelper.allocateThreadLocalVariable(this.m_memoizedCheckVarName, BasicType.BOOLEAN, true);
        }
        return this.m_memoizedCheckVarName;
    }

    public void switchOverTypeEnvironment(TypeEnvironment typeEnvironment) {
        this.m_typeEnvironment = typeEnvironment;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_name);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
        writeObjectFileHelper.writeBoolean(this.m_memoizeResult);
        writeObjectFileHelper.writeBoolean(this.m_impure);
        writeObjectFileHelper.writeBoolean(this.m_inlineHint);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeType(this.m_returnType);
        writeObjectFileHelper.writeBoolean(this.m_isClassMethod);
        writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
        if (this.m_defaultValues != null) {
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                if (this.m_defaultValues[i] == null) continue;
                writeObjectFileHelper.writeString(this.m_defaultValues[i]);
            }
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_name = readObjectFileHelper.readString();
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet();
        this.m_memoizeResult = readObjectFileHelper.readBoolean();
        this.m_impure = readObjectFileHelper.readBoolean();
        this.m_inlineHint = readObjectFileHelper.readBoolean();
        this.m_body = readObjectFileHelper.readInstruction(null);
        this.m_returnType = readObjectFileHelper.readType();
        this.m_isClassMethod = readObjectFileHelper.readBoolean();
        int n = readObjectFileHelper.readInt();
        if (n > 0) {
            this.m_defaultValues = new String[n];
            for (int i = 0; i < this.m_defaultValues.length; ++i) {
                if (!readObjectFileHelper.readBoolean()) continue;
                this.m_defaultValues[i] = readObjectFileHelper.readString();
            }
        }
    }

    public void instantiateReducedPolymorphicFunctions(Set set, Set set2, Set set3) {
        if (set3.contains(this)) {
            return;
        }
        set3.add(this);
        set2.add(this);
        this.m_body.instantiateReducedPolymorphicFunctions(set, this.m_typeEnvironment, this.m_bindingEnvironment, set2, set3);
        set2.remove(this);
    }

    public void removeDerivativeInformation() {
        this.m_derivationKey = null;
        this.m_original = null;
        this.m_derivatives = new HashMap();
    }

    public Object getInterpreterStoredMemoizedValue() {
        return this.m_interpreterStoredMemoizedValue;
    }

    public void setInterpreterStoredMemoizedValue(Object object) {
        this.m_interpreterStoredMemoizedValue = object;
    }

    public Function cloneFunction() {
        Function function = new Function();
        function.setName(this.m_name);
        function.setBody(this.m_body.cloneWithoutTypeInformation());
        function.setReturnType(this.m_returnType);
        function.m_parameters = Binding.cloneBindings(this.m_parameters);
        function.m_memoizeResult = this.m_memoizeResult;
        function.m_impure = this.m_impure;
        function.m_inlineHint = this.m_inlineHint;
        function.m_isClassMethod = this.m_isClassMethod;
        function.m_defaultValues = this.m_defaultValues;
        return function;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

