/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime;

import com.ibm.xtq.xml.dtm.ref.DTMCursorExtensions;
import com.ibm.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xtq.xml.xcollator.XCollator;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMCursor_SAXBuildable;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapter;
import com.ibm.xtq.xml.xdm.ref.XDMConcatenationCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCursorNodeList;
import com.ibm.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xtq.xslt.runtime.Converter;
import com.ibm.xtq.xslt.runtime.ConverterFactory;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.ToXMLSAXHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;

public class RuntimeLibrary {
    public static final String VERSION = "Gustav-Mon-Jan-22-06:03:25-EST-2007";
    public static final char[] s_emptyCharStream = new char[0];
    private static final DecimalFormat DEC_NOTATION = new DecimalFormat("0.0################");
    private static final DecimalFormat DOUBLE_FORMATER = new DecimalFormat("0.0#################E0");
    public static final int[] EMPTY_NAMESPACE_TABLE = new int[0];
    public static final int EMPTY_ID = 13;
    static /* synthetic */ Class class$com$ibm$xtq$xml$xdm$dtm$XDMManagerDTM;

    public static String verboseVersionWithCopyright() {
        return "Xylem RuntimeLibrary version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\" (C) Copyright IBM Corp. 2004, 2005, 2006";
    }

    public static String verboseVersion() {
        return "Xylem runtime version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\"";
    }

    public static void checkVersion(String string) {
        if (!string.equals(VERSION)) {
            throw new Error("version '" + string + "' does not match RuntimeLibrary version '" + VERSION + "'");
        }
    }

    public static final boolean contains(char[] cArray, char[] cArray2) {
        if (cArray2.length == 0) {
            return true;
        }
        if (cArray2.length > cArray.length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[n]) {
                if (++n != cArray2.length) continue;
                return true;
            }
            while (n != 0) {
                --n;
                --i;
            }
        }
        return false;
    }

    public static char[] doubleToCharArray10(double d) {
        return RuntimeLibrary.doubleToString10(d).toCharArray();
    }

    public static String doubleToString10(double d) {
        return BasisLibrary.realToString(d);
    }

    public static char[] floatToCharArray10(float f) {
        return RuntimeLibrary.floatToString10(f).toCharArray();
    }

    public static String floatToString10(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == 0.0f) {
            return "0";
        }
        if ((double)StrictMath.abs(f) < 1.0E-6 || StrictMath.abs(f) >= 1000000.0f) {
            return DOUBLE_FORMATER.format(f);
        }
        return RuntimeLibrary.removeTrailingZeros(Float.toString(f));
    }

    public static char[] doubleToCharArray(double d) {
        return RuntimeLibrary.doubleToString(d).toCharArray();
    }

    public static String doubleToString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        Double d2 = new Double(d);
        if (d == 0.0) {
            String string = d2.toString();
            return string.substring(0, string.indexOf("."));
        }
        if (StrictMath.abs(d) >= 1.0E-6 && StrictMath.abs(d) < 1000000.0) {
            return RuntimeLibrary.removeTrailingZeros(DEC_NOTATION.format(d));
        }
        return Double.toString(d);
    }

    public static char[] floatToCharArray(float f) {
        return RuntimeLibrary.floatToString(f).toCharArray();
    }

    public static String floatToString(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f)) {
            return "NaN";
        }
        Float f2 = new Float(f);
        if (f == 0.0f) {
            String string = f2.toString();
            return string.substring(0, string.indexOf("."));
        }
        if ((double)StrictMath.abs(f) >= 1.0E-6 && StrictMath.abs(f) < 1000000.0f) {
            Double d = new Double(f2.toString());
            return RuntimeLibrary.removeTrailingZeros(DEC_NOTATION.format(d));
        }
        return f2.toString();
    }

    public static String removeTrailingZeros(String string) {
        int n = string.length();
        if (string.charAt(n - 1) != '0') {
            return string;
        }
        if (string.indexOf(46) >= 0) {
            while (string.charAt(n - 1) == '0') {
                --n;
            }
            if (string.charAt(n - 1) == '.') {
                --n;
            }
            return string.substring(0, n);
        }
        return string;
    }

    public static char[] decimalToCharArray(BigDecimal bigDecimal) {
        return RuntimeLibrary.decimalToString(bigDecimal).toCharArray();
    }

    public static String decimalToString(BigDecimal bigDecimal) {
        return RuntimeLibrary.removeTrailingZeros(bigDecimal.toString());
    }

    public static char[] normalizeSpace(char[] cArray) {
        char[] cArray2;
        int n;
        int n2 = cArray.length;
        char[] cArray3 = new char[cArray.length];
        int n3 = 0;
        for (n = 0; n < n2 && RuntimeLibrary.isWhiteSpace(cArray[n]); ++n) {
        }
        while (true) {
            if (n < n2 && !RuntimeLibrary.isWhiteSpace(cArray[n])) {
                if (n3 == cArray3.length) {
                    cArray2 = new char[cArray3.length * 2];
                    System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                    cArray3 = cArray2;
                }
                cArray3[n3++] = cArray[n++];
                continue;
            }
            if (n == n2) break;
            while (n < n2 && RuntimeLibrary.isWhiteSpace(cArray[n])) {
                ++n;
            }
            if (n >= n2) continue;
            if (n3 == cArray3.length) {
                cArray2 = new char[cArray3.length * 2];
                System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                cArray3 = cArray2;
            }
            cArray3[n3++] = 32;
        }
        if (n3 == cArray3.length) {
            return cArray3;
        }
        cArray2 = new char[n3];
        System.arraycopy(cArray3, 0, cArray2, 0, n3);
        return cArray2;
    }

    private static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static final boolean startsWith(char[] cArray, char[] cArray2) {
        if (cArray2.length == 0) {
            return true;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) {
                if (i != cArray2.length - 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void addToElement(XDMCursor xDMCursor, Node node, boolean bl) {
        RuntimeLibrary.addToElement(xDMCursor, node, node.getOwnerDocument(), bl);
    }

    public static void addToElement(XDMCursor xDMCursor, Node node, Document document, boolean bl) {
        if (xDMCursor instanceof XDMNodeAdapter) {
            int n = xDMCursor.getNodeType();
            if (n == 2) {
                String string = xDMCursor.getNamespaceURI();
                if (string.equals("")) {
                    string = null;
                }
                String string2 = xDMCursor.getNodeName();
                ((Element)node).setAttributeNS(string, string2, xDMCursor.getNodeValue());
                if (bl) {
                    Attr attr = ((Element)node).getAttributeNodeNS(string, string2);
                    Attr attr2 = (Attr)xDMCursor.getNode();
                    if (attr2 instanceof AttributePSVI) {
                        ((PSVIAttrNSImpl)attr).setPSVI((AttributePSVI)((Object)attr2));
                    }
                }
            } else if (n == 13) {
                ((Element)node).setAttributeNS(xDMCursor.getNode().getNamespaceURI(), xDMCursor.getNodeName(), xDMCursor.getNodeValue());
            } else {
                Node node2 = ((XDMNodeAdapter)xDMCursor).getNode();
                Node node3 = node.appendChild(document.importNode(node2, !bl));
                if (bl) {
                    RuntimeLibrary.copySubtreeWithTypeAnnotations(node2, node3, document);
                }
            }
            return;
        }
        switch (xDMCursor.getNodeType()) {
            case 3: {
                node.appendChild(document.createTextNode(xDMCursor.getNodeValue()));
                return;
            }
            case 2: {
                ((Element)node).setAttribute(xDMCursor.getNodeName(), xDMCursor.getNodeValue());
                return;
            }
            case 1: {
                Element element = document.createElement(xDMCursor.getNodeName());
                XDMCursor xDMCursor2 = xDMCursor.getAxisCursor(3);
                if (!xDMCursor2.isEmpty()) {
                    do {
                        RuntimeLibrary.addToElement(xDMCursor2, element, document, bl);
                    } while (xDMCursor2.nextNode());
                }
                node.appendChild(element);
                return;
            }
            case 11: {
                DocumentFragment documentFragment = document.createDocumentFragment();
                XDMCursor xDMCursor3 = xDMCursor.getAxisCursor(3);
                if (!xDMCursor3.isEmpty()) {
                    do {
                        RuntimeLibrary.addToElement(xDMCursor3, documentFragment, document, bl);
                    } while (xDMCursor3.nextNode());
                }
                node.appendChild(documentFragment);
                return;
            }
        }
    }

    private static void copySubtreeWithTypeAnnotations(Node node, Node node2, Document document) {
        Node node3;
        Object object;
        if (node2 instanceof Element) {
            if (node instanceof ElementPSVI && node2 instanceof PSVIElementNSImpl) {
                ((PSVIElementNSImpl)node2).setPSVI((ElementPSVI)((Object)node));
            }
            object = node.getAttributes();
            Element element = (Element)node2;
            for (int i = 0; i < object.getLength(); ++i) {
                node3 = (Attr)object.item(i);
                Attr attr = (Attr)document.importNode(node3, false);
                element.setAttributeNodeNS(attr);
                if (!(node3 instanceof AttributePSVI) || !(attr instanceof PSVIAttrNSImpl)) continue;
                ((PSVIAttrNSImpl)attr).setPSVI((AttributePSVI)((Object)node3));
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node4 = object.item(i);
            node3 = document.importNode(node4, false);
            node2.appendChild(node3);
            RuntimeLibrary.copySubtreeWithTypeAnnotations(node4, node3, document);
        }
    }

    public static int compare(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return 0;
        }
        if (Double.isNaN(d2) || d > d2) {
            return 1;
        }
        if (Double.isNaN(d) || d < d2) {
            return -1;
        }
        return 0;
    }

    public static int compare(String string, String string2) {
        int n = string.compareToIgnoreCase(string2);
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static double cursorToDouble(XDMCursor xDMCursor) {
        if (xDMCursor.isEmpty()) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(xDMCursor.getStringValueX());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static float cursorToFloat(XDMCursor xDMCursor) {
        if (xDMCursor.isEmpty()) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(xDMCursor.getStringValueX());
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static BigDecimal cursorToDecimal(XDMCursor xDMCursor) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(String.valueOf(xDMCursor));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException();
        }
        return bigDecimal;
    }

    public static int cursorToInt(XDMCursor xDMCursor) {
        if (xDMCursor.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(xDMCursor.getStringValueX());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double stringToDouble(char[] cArray) {
        try {
            return Double.parseDouble(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static float stringToFloat(char[] cArray) {
        try {
            return Float.parseFloat(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static int stringToInt(char[] cArray) {
        try {
            return Integer.parseInt(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static BigDecimal stringToDecimal(char[] cArray) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(String.valueOf(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException();
        }
        return bigDecimal;
    }

    public static Object evaluateXPathFunction10(XPathFunction xPathFunction, XDMManagerFactory xDMManagerFactory, Object[] objectArray) {
        Object object;
        XDMCursor[] xDMCursorArray;
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof char[]) {
                arrayList.add(new String((char[])objectArray[i]));
                continue;
            }
            if (objectArray[i] instanceof XDMCursor) {
                xDMCursorArray = ((XDMCursor)objectArray[i]).cloneXDMCursor();
                arrayList.add(new XDMCursorNodeList((XDMCursor)xDMCursorArray));
                continue;
            }
            arrayList.add(objectArray[i]);
        }
        try {
            object = xPathFunction.evaluate(arrayList);
        }
        catch (XPathFunctionException xPathFunctionException) {
            throw new RuntimeException(xPathFunctionException.toString());
        }
        if (object instanceof Node) {
            object = RuntimeLibrary.getCursor(xDMManagerFactory, (Node)object);
        } else if (object instanceof NodeList) {
            xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeList)object);
            object = new XDMConcatenationCursor(xDMCursorArray, false);
        } else if (object instanceof NodeIterator) {
            xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeIterator)object);
            object = new XDMConcatenationCursor(xDMCursorArray, false);
        }
        return object;
    }

    public static Object evaluateXPathFunction20(XPathFunction xPathFunction, XDMManagerFactory xDMManagerFactory, Object[] objectArray) {
        XDMCursor[] xDMCursorArray;
        int n;
        Object[] objectArray2;
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[i];
                for (n = 0; n < objectArray2.length; ++n) {
                    if (!(objectArray2[n] instanceof XDMCursor)) continue;
                    objectArray2[n] = ((XDMCursor)objectArray2[n]).getNode();
                }
            }
            arrayList.add(objectArray[i]);
        }
        try {
            xDMCursorArray = xPathFunction.evaluate(arrayList);
        }
        catch (XPathFunctionException xPathFunctionException) {
            throw new RuntimeException(xPathFunctionException.toString());
        }
        if (xDMCursorArray instanceof Node) {
            xDMCursorArray = RuntimeLibrary.getCursor(xDMManagerFactory, (Node)xDMCursorArray);
        } else if (xDMCursorArray instanceof NodeList) {
            xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeList)xDMCursorArray);
        } else if (xDMCursorArray instanceof NodeIterator) {
            xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeIterator)xDMCursorArray);
        } else if (xDMCursorArray instanceof Object[]) {
            objectArray2 = xDMCursorArray;
            for (n = 0; n < objectArray2.length; ++n) {
                if (!(objectArray2[n] instanceof Node)) continue;
                objectArray2[n] = RuntimeLibrary.getCursor(xDMManagerFactory, (Node)objectArray2[n]);
            }
        }
        return xDMCursorArray;
    }

    public static final XDMCursor getCursor(XDMManagerFactory xDMManagerFactory, Node node) {
        DOMSource dOMSource = new DOMSource(node);
        return xDMManagerFactory.getXDM(dOMSource, false, null, true, false, false, false);
    }

    public static final XDMCursor[] getCursors(XDMManagerFactory xDMManagerFactory, NodeList nodeList) {
        int n = nodeList.getLength();
        XDMCursor[] xDMCursorArray = new XDMCursor[n];
        for (int i = 0; i < n; ++i) {
            DOMSource dOMSource = new DOMSource(nodeList.item(i));
            xDMCursorArray[i] = xDMManagerFactory.getXDM(dOMSource, false, null, true, false, false, false);
        }
        return xDMCursorArray;
    }

    public static final XDMCursor[] getCursors(XDMManagerFactory xDMManagerFactory, NodeIterator nodeIterator) {
        Vector<XDMCursor> vector = new Vector<XDMCursor>(10);
        Node node = nodeIterator.nextNode();
        while (node != null) {
            DOMSource dOMSource = new DOMSource(node);
            vector.add(xDMManagerFactory.getXDM(dOMSource, false, null, true, false, false, false));
            node = nodeIterator.nextNode();
        }
        return vector.toArray(new XDMCursor[vector.size()]);
    }

    public static final XDMCursor getCursor(XDMManagerFactory xDMManagerFactory, DocumentFragment documentFragment) {
        DOMSource dOMSource = null;
        Document document = documentFragment.getOwnerDocument();
        dOMSource = document != null ? new DOMSource(document) : new DOMSource(documentFragment);
        XDMCursor xDMCursor = xDMManagerFactory.getXDM(dOMSource, false, null, true, false, false, false);
        return xDMCursor.getXDMCursorFromNode(documentFragment);
    }

    public static final Object convertJavaObject(XDMManagerFactory xDMManagerFactory, Object object) {
        if (object instanceof Node) {
            return RuntimeLibrary.getCursor(xDMManagerFactory, (Node)object);
        }
        if (object instanceof NodeList) {
            XDMCursor[] xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeList)object);
            return new XDMConcatenationCursor(xDMCursorArray, false);
        }
        if (object instanceof NodeIterator) {
            XDMCursor[] xDMCursorArray = RuntimeLibrary.getCursors(xDMManagerFactory, (NodeIterator)object);
            return new XDMConcatenationCursor(xDMCursorArray, false);
        }
        if (object instanceof DocumentFragment) {
            return RuntimeLibrary.getCursor(xDMManagerFactory, (DocumentFragment)object);
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        return object;
    }

    public static SerializationHandler getOutputDomBuilder(XDMCursor_SAXBuildable xDMCursor_SAXBuildable) {
        Converter converter = ConverterFactory.getConverter();
        ContentHandler contentHandler = xDMCursor_SAXBuildable.getContentHandler();
        converter.setOutputContentHandler(contentHandler);
        return converter.getInputSerializationHandler(null);
    }

    public static XCollator getCollator(String string, String string2) {
        CollatorDeclaration collatorDeclaration = CollatorFactory.getCollatorDeclaration(null, string, null, null, null, string2, null);
        XCollator xCollator = CollatorFactory.createCollatorFromDeclaration(collatorDeclaration);
        return xCollator;
    }

    public static Collator getCollator(String string) {
        if (string == null || string.length() == 0) {
            return Collator.getInstance();
        }
        Locale locale = new Locale(string.toLowerCase(), Locale.getDefault().getCountry());
        return Collator.getInstance(locale);
    }

    public static final int[] getNamespaceTable(XDMCursor xDMCursor) {
        Object object;
        if (xDMCursor instanceof DTMCursorExtensions) {
            return ((DTMCursorExtensions)((Object)xDMCursor)).getNamespaceTable();
        }
        XDMCursor xDMCursor2 = xDMCursor.getAxisCursor(9);
        int n = xDMCursor2.getLength();
        if (n <= 0) {
            return EMPTY_NAMESPACE_TABLE;
        }
        boolean bl = xDMCursor.getPrefix() == null || xDMCursor.getPrefix().length() == 0;
        Object object2 = new int[(n - 1) * 2];
        boolean bl2 = false;
        int n2 = 0;
        do {
            if ((object = xDMCursor2.getLocalName()) == null || ((String)object).length() == 0) {
                bl2 = true;
            } else if (((String)object).equals("xml")) continue;
            object2[n2++] = xDMCursor2.getExpandedTypeID();
            object2[n2++] = xDMCursor2.getNamespaceURIID();
        } while (xDMCursor2.nextNode());
        if (bl && !bl2) {
            object = new int[n2 + 2];
            System.arraycopy(object2, 0, object, 0, n2);
            object[n2] = 13;
            object[n2 + 1] = 13;
            object2 = object;
        }
        return object2;
    }

    public static final SerializationHandler makeNodesetSerializationHandler(XDMManagerFactory xDMManagerFactory) {
        XDMCursor_SAXBuildable xDMCursor_SAXBuildable = xDMManagerFactory.get(class$com$ibm$xtq$xml$xdm$dtm$XDMManagerDTM == null ? (class$com$ibm$xtq$xml$xdm$dtm$XDMManagerDTM = RuntimeLibrary.class$("com.ibm.xtq.xml.xdm.dtm.XDMManagerDTM")) : class$com$ibm$xtq$xml$xdm$dtm$XDMManagerDTM).getGlobalRTFXDMCursor();
        ToXMLSAXHandler toXMLSAXHandler = new ToXMLSAXHandler();
        toXMLSAXHandler.setContentHandler(xDMCursor_SAXBuildable.getContentHandler());
        return toXMLSAXHandler;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

