/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.YearMonthDV;

public class XGYearMonth
extends XItemBase {
    private static TypeValidator m_validator = new YearMonthDV();
    private int m_year;
    private int m_month;

    public XGYearMonth(int n, int n2) {
        this(n, n2, TypeConstants.GYEARMONTH);
    }

    public XGYearMonth(int n, int n2, ItemType itemType) {
        this.m_year = n;
        this.m_month = n2;
        this.m_type = itemType;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getPrimitiveId() {
        return 12;
    }

    public static XGYearMonth parse(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XGYearMonth(dateTimeBase.getYear(), dateTimeBase.getMonth());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XGYearMonth toGYearMonth() {
        return this;
    }

    public String toString() {
        return CastLibrary.convertYearToString(this.m_year) + "-" + CastLibrary.convertTo2CharString(this.m_month);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 12: {
                return this.equals(xItem.toGYearMonth());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XGYearMonth xGYearMonth) {
        return this.m_year == xGYearMonth.getYear() && this.m_month == xGYearMonth.getMonth();
    }

    public final boolean notEquals(XGYearMonth xGYearMonth) throws TypeError {
        return !this.equals(xGYearMonth);
    }
}

