/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.XDouble;
import com.ibm.xtq.xml.datamodel.XFloat;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XDecimal
extends XItemBase {
    public static final int ROUND_MODE = 6;
    public static final int PRECISION = 20;
    private final BigDecimal m_value;

    public XDecimal(BigDecimal bigDecimal) {
        this.m_value = bigDecimal;
        this.m_type = TypeConstants.DECIMAL;
    }

    public XDecimal(BigDecimal bigDecimal, ItemType itemType) {
        this.m_value = bigDecimal;
        this.m_type = itemType;
    }

    public final int getPrimitiveId() {
        return 4;
    }

    public static final XDecimal valueOf(BigDecimal bigDecimal) {
        return new XDecimal(bigDecimal);
    }

    public static final XDecimal valueOf(String string) {
        return new XDecimal(new BigDecimal(string));
    }

    public final BigDecimal getCurrentItemAsDecimal() throws TypeError {
        return this.m_value;
    }

    public final float getCurrentItemAsFloat() throws TypeError {
        return this.m_value.floatValue();
    }

    public final double getCurrentItemAsDouble() throws TypeError {
        return this.m_value.doubleValue();
    }

    public final boolean toBoolean() {
        return CastLibrary.toBoolean(this.m_value);
    }

    public final BigDecimal toDecimal() {
        return this.m_value;
    }

    public final double toDouble() {
        return this.m_value.doubleValue();
    }

    public final BigInteger toInteger() {
        return this.m_value.toBigInteger();
    }

    public final float toFloat() {
        return this.m_value.floatValue();
    }

    public final String toString() {
        return CastLibrary.toString(this.m_value);
    }

    public final XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public final XItem add(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return new XDecimal(this.m_value.add(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() + xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() + xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigDecimal add(BigDecimal bigDecimal) {
        return this.m_value.add(bigDecimal);
    }

    public final XItem subtract(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return new XDecimal(this.m_value.subtract(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() - xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() - xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigDecimal subtract(BigDecimal bigDecimal) {
        return this.m_value.subtract(bigDecimal);
    }

    public final XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return new XDecimal(this.m_value.multiply(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() * xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() * xItem.toDouble());
            }
            case 8: {
                return xItem.toDayTimeDuration().multiply(this.toDouble());
            }
            case 7: {
                return xItem.toYearMonthDuration().multiply(this.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigDecimal multiply(BigDecimal bigDecimal) {
        return this.m_value.multiply(bigDecimal);
    }

    public final XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return new XDecimal(this.divide(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() / xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() / xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigDecimal divide(BigDecimal bigDecimal) {
        int n = this.m_value.scale() + bigDecimal.scale() + 20;
        return this.m_value.divide(bigDecimal, n, 6);
    }

    public final XItem mod(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return new XDecimal(this.mod(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() % xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() % xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigDecimal mod(BigDecimal bigDecimal) throws TypeError {
        int n = this.m_value.scale() + bigDecimal.scale() + 20;
        BigDecimal bigDecimal2 = this.m_value.divide(bigDecimal, n, 6);
        long l = bigDecimal2.longValue();
        return bigDecimal2.subtract(BigDecimal.valueOf(l)).multiply(bigDecimal);
    }

    public final XItem negate() throws TypeError {
        return new XDecimal(this.m_value.negate());
    }

    public final BigDecimal _negate() throws TypeError {
        return this.m_value.negate();
    }

    public final boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return this.equals(xItem.toDecimal());
            }
            case 2: {
                float f = XFloat.compare(this.m_value.floatValue(), xItem.toFloat());
                if (Float.isNaN(f)) {
                    return false;
                }
                return f == 0.0f;
            }
            case 3: {
                double d = XDouble.compare(this.m_value.doubleValue(), xItem.toDouble());
                if (Double.isNaN(d)) {
                    return false;
                }
                return d == 0.0;
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final boolean equals(BigDecimal bigDecimal) throws TypeError {
        return this.m_value.compareTo(bigDecimal) == 0;
    }

    public final boolean notEquals(BigDecimal bigDecimal) throws TypeError {
        return !this.equals(bigDecimal);
    }

    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 4: 
            case 5: {
                return this.m_value.compareTo(xItem.toDecimal());
            }
            case 2: {
                return (int)XFloat.compare(this.toFloat(), xItem.toFloat());
            }
            case 3: {
                return (int)XDouble.compare(this.toDouble(), xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final int compareTo(BigDecimal bigDecimal) throws TypeError {
        return this.m_value.compareTo(bigDecimal);
    }

    public final boolean greaterThan(BigDecimal bigDecimal) throws TypeError {
        return this.compareTo(bigDecimal) > 0;
    }

    public final boolean greaterOrEquals(BigDecimal bigDecimal) throws TypeError {
        return this.compareTo(bigDecimal) >= 0;
    }

    public final boolean lessThan(BigDecimal bigDecimal) throws TypeError {
        return this.compareTo(bigDecimal) < 0;
    }

    public final boolean lessOrEquals(BigDecimal bigDecimal) throws TypeError {
        return this.compareTo(bigDecimal) <= 0;
    }
}

