/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.classfile.AccessFlags;
import com.ibm.xtq.bcel.classfile.Attribute;
import com.ibm.xtq.bcel.classfile.ConstantPool;
import com.ibm.xtq.bcel.classfile.Field;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.bcel.classfile.Method;
import com.ibm.xtq.bcel.classfile.SourceFile;
import com.ibm.xtq.bcel.generic.ClassGenException;
import com.ibm.xtq.bcel.generic.ClassObserver;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private ArrayList field_vec = new ArrayList();
    private ArrayList method_vec = new ArrayList();
    private ArrayList attribute_vec = new ArrayList();
    private ArrayList interface_vec = new ArrayList();
    private ArrayList observers;

    public ClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces, ConstantPoolGen cp) {
        this.class_name = class_name;
        this.super_class_name = super_class_name;
        this.file_name = file_name;
        this.access_flags = access_flags;
        this.cp = cp;
        if (file_name != null) {
            this.addAttribute(new SourceFile(cp.addUtf8("SourceFile"), 2, cp.addUtf8(file_name), cp.getConstantPool()));
        }
        this.class_name_index = cp.addClass(class_name);
        this.superclass_name_index = cp.addClass(super_class_name);
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                this.addInterface(interfaces[i]);
                ++i;
            }
        }
    }

    public ClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces) {
        this(class_name, super_class_name, file_name, access_flags, interfaces, new ConstantPoolGen());
    }

    public ClassGen(JavaClass clazz) {
        this.class_name_index = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.class_name = clazz.getClassName();
        this.super_class_name = clazz.getSuperclassName();
        this.file_name = clazz.getSourceFileName();
        this.access_flags = clazz.getAccessFlags();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Attribute[] attributes = clazz.getAttributes();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        int i = 0;
        while (i < interfaces.length) {
            this.addInterface(interfaces[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < attributes.length) {
            this.addAttribute(attributes[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < methods.length) {
            this.addMethod(methods[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < fields.length) {
            this.addField(fields[i4]);
            ++i4;
        }
    }

    public JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        Attribute[] attributes = this.getAttributes();
        ConstantPool cp = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, cp, interfaces, fields, methods, attributes);
    }

    public void addInterface(String name) {
        this.interface_vec.add(name);
    }

    public void removeInterface(String name) {
        ((AbstractCollection)this.interface_vec).remove(name);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute a) {
        this.attribute_vec.add(a);
    }

    public void addMethod(Method m) {
        this.method_vec.add(m);
    }

    public void addEmptyConstructor(int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConstants.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        il.append(InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(Field f) {
        this.field_vec.add(f);
    }

    public boolean containsField(Field f) {
        return this.field_vec.contains(f);
    }

    public Field containsField(String name) {
        Iterator e = ((AbstractList)this.field_vec).iterator();
        while (e.hasNext()) {
            Field f = (Field)e.next();
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Method containsMethod(String name, String signature) {
        Iterator e = ((AbstractList)this.method_vec).iterator();
        while (e.hasNext()) {
            Method m = (Method)e.next();
            if (!m.getName().equals(name) || !m.getSignature().equals(signature)) continue;
            return m;
        }
        return null;
    }

    public void removeAttribute(Attribute a) {
        ((AbstractCollection)this.attribute_vec).remove(a);
    }

    public void removeMethod(Method m) {
        ((AbstractCollection)this.method_vec).remove(m);
    }

    public void replaceMethod(Method old, Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.method_vec.indexOf(old);
        if (i < 0) {
            this.method_vec.add(new_);
        } else {
            this.method_vec.set(i, new_);
        }
    }

    public void replaceField(Field old, Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.field_vec.indexOf(old);
        if (i < 0) {
            this.field_vec.add(new_);
        } else {
            this.field_vec.set(i, new_);
        }
    }

    public void removeField(Field f) {
        ((AbstractCollection)this.field_vec).remove(f);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String name) {
        this.class_name = name.replace('/', '.');
        this.class_name_index = this.cp.addClass(name);
    }

    public void setSuperclassName(String name) {
        this.super_class_name = name.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(name);
    }

    public Method[] getMethods() {
        Method[] methods = new Method[this.method_vec.size()];
        this.method_vec.toArray(methods);
        return methods;
    }

    public void setMethods(Method[] methods) {
        this.method_vec.clear();
        int m = 0;
        while (m < methods.length) {
            this.addMethod(methods[m]);
            ++m;
        }
    }

    public void setMethodAt(Method method, int pos) {
        this.method_vec.set(pos, method);
    }

    public Method getMethodAt(int pos) {
        return (Method)this.method_vec.get(pos);
    }

    public String[] getInterfaceNames() {
        int size = this.interface_vec.size();
        String[] interfaces = new String[size];
        this.interface_vec.toArray(interfaces);
        return interfaces;
    }

    public int[] getInterfaces() {
        int size = this.interface_vec.size();
        int[] interfaces = new int[size];
        int i = 0;
        while (i < size) {
            interfaces[i] = this.cp.addClass((String)this.interface_vec.get(i));
            ++i;
        }
        return interfaces;
    }

    public Field[] getFields() {
        Field[] fields = new Field[this.field_vec.size()];
        this.field_vec.toArray(fields);
        return fields;
    }

    public Attribute[] getAttributes() {
        Attribute[] attributes = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.toArray(attributes);
        return attributes;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setClassNameIndex(int class_name_index) {
        this.class_name_index = class_name_index;
        this.class_name = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.super_class_name = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o);
    }

    public void removeObserver(ClassObserver o) {
        if (this.observers != null) {
            ((AbstractCollection)this.observers).remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e = ((AbstractList)this.observers).iterator();
            while (e.hasNext()) {
                ((ClassObserver)e.next()).notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            return null;
        }
    }
}

