/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.parsers.xpath;

import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.utils.XPathError;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class XQueryToXQueryX
implements XPathTreeConstants {
    Stack _openElemStack = new Stack();
    Stack _outputStack = new Stack();
    Stack _stackChecks = new Stack();
    PrintWriter _xqout1;
    PrintWriter _xqout2;
    static final int BSP_STRIP = 0;
    static final int BSP_PRESERVE = 1;
    int _boundarySpacePolicy = 0;
    private static int MAXCHAR = 65535;

    public XQueryToXQueryX() throws UnsupportedEncodingException {
        try {
            this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
            }
        }
    }

    public XQueryToXQueryX(PrintWriter printWriter) throws UnsupportedEncodingException {
        this._xqout1 = printWriter;
    }

    public XQueryToXQueryX(PrintStream printStream) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
    }

    public XQueryToXQueryX(PrintStream printStream, PrintStream printStream2) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
    }

    private void xqprintln() {
        if (null != this._xqout1) {
            this._xqout1.println();
        }
        if (null != this._xqout2) {
            this._xqout2.println();
        }
    }

    private void xqprintln(String string) {
        if (null != this._xqout1) {
            this._xqout1.println(string);
        }
        if (null != this._xqout2) {
            this._xqout2.println(string);
        }
    }

    private void xqprint(String string) {
        if (null != this._xqout1) {
            this._xqout1.print(string);
        }
        if (null != this._xqout2) {
            this._xqout2.print(string);
        }
    }

    private static void writeUTF16Surrogate(PrintWriter printWriter, char c, char[] cArray, int n, int n2) {
        int n3 = XQueryToXQueryX.getURF16SurrogateValue(c, cArray, n, n2);
        printWriter.print('&');
        printWriter.print('#');
        printWriter.print(Integer.toString(n3));
        printWriter.print(';');
    }

    private static int getURF16SurrogateValue(char c, char[] cArray, int n, int n2) {
        int n3;
        if (n + 1 >= n2) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (n3 = cArray[++n]) || n3 >= 57344) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
        return n3;
    }

    private static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static boolean canConvert(char c) {
        boolean bl;
        boolean bl2 = bl = c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
        if (!bl) {
            throw new XPathError("ERR_INVALID_CHAR");
        }
        return c <= MAXCHAR;
    }

    private void xqprintEscaped(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                this.xqprint("&lt;");
                continue;
            }
            if (c == '>') {
                this.xqprint("&gt;");
                continue;
            }
            if (c == '&') {
                this.xqprint("&amp;");
                continue;
            }
            if (XQueryToXQueryX.isUTF16Surrogate(c)) {
                char[] cArray = string.toCharArray();
                int n = string.length();
                if (null != this._xqout1) {
                    XQueryToXQueryX.writeUTF16Surrogate(this._xqout1, c, cArray, i, n - 1);
                }
                if (null == this._xqout2) continue;
                XQueryToXQueryX.writeUTF16Surrogate(this._xqout2, c, cArray, i, n - 1);
                continue;
            }
            if (!XQueryToXQueryX.canConvert(c)) {
                this.xqprint("&#");
                this.xqprint(Integer.toString(c));
                this.xqprint(";");
                continue;
            }
            if (null != this._xqout1) {
                this._xqout1.print(c);
            }
            if (null == this._xqout2) continue;
            this._xqout2.print(c);
        }
    }

    private void indent() {
        int n = this._openElemStack.size();
        for (int i = 0; i < n; ++i) {
            this.xqprint(" ");
        }
    }

    private void pd(String string, int n) {
        this.indent();
        for (int i = 0; i < n; ++i) {
            this.xqprint(" ");
        }
        this.xqprint("<!-- ");
        this.xqprint(string);
        this.xqprintln(" -->");
    }

    private void pd(String string) {
        this.pd(string, 0);
    }

    private void pd(int n) {
        this.pd(XPathTreeConstants.jjtNodeName[n], 0);
    }

    private void pushElem(int n, SimpleNode simpleNode) {
        this.indent();
        this._outputStack.push("<");
        String string = XPathTreeConstants.jjtNodeName[n];
        String string2 = "xqx:" + string.substring(0, 1).toLowerCase() + string.substring(1);
        this._outputStack.push(string2);
        this._openElemStack.push(string2);
        this._openElemStack.push(simpleNode);
    }

    private void pushElem(String string, SimpleNode simpleNode) {
        this.indent();
        this._outputStack.push("<");
        this._outputStack.push(string);
        this._openElemStack.push(string);
        this._openElemStack.push(simpleNode);
    }

    private void pushAttr(String string, String string2) {
        this._outputStack.push(" ");
        this._outputStack.push(string);
        this._outputStack.push("=\"");
        this._outputStack.push(string2);
        this._outputStack.push("\"");
    }

    private void flushOpen(SimpleNode simpleNode, boolean bl) {
        if (this._outputStack.size() > 0) {
            if (simpleNode != this._openElemStack.peek()) {
                return;
            }
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String string = (String)this._outputStack.elementAt(i);
                this.xqprint(string);
            }
            this.xqprint(">");
            if (bl) {
                this.xqprintln();
            }
            this._outputStack.removeAllElements();
        }
    }

    private void flushOpen(SimpleNode simpleNode) {
        this.flushOpen(simpleNode, true);
    }

    private void flushEmpty(SimpleNode simpleNode) {
        if (this._outputStack.size() > 0) {
            if (simpleNode != this._openElemStack.peek()) {
                return;
            }
            this._openElemStack.pop();
            this._openElemStack.pop();
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String string = (String)this._outputStack.elementAt(i);
                this.xqprint(string);
            }
            this.xqprintln("/>");
            this._outputStack.removeAllElements();
        }
    }

    private void flushClose(SimpleNode simpleNode, boolean bl) {
        if (this._openElemStack.size() == 0) {
            return;
        }
        if (simpleNode != this._openElemStack.peek()) {
            return;
        }
        this._openElemStack.pop();
        String string = (String)this._openElemStack.pop();
        if (bl) {
            this.indent();
        }
        this.xqprint("</");
        this.xqprint(string);
        this.xqprintln(">");
    }

    private void flushClose(SimpleNode simpleNode) {
        this.flushClose(simpleNode, true);
    }

    private boolean isJustWhitespace(SimpleNode simpleNode) {
        if (simpleNode.getId() == 127 || simpleNode.getId() == 116) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (this.isJustWhitespace(simpleNode2)) continue;
                return false;
            }
            return true;
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            return Util.trimWhitespace(simpleNode.getValue()).length() == 0;
        }
        return false;
    }

    private boolean isPreviousSiblingBoundaryWhitespaceChar(SimpleNode simpleNode) {
        if ((simpleNode = this.getPreviousSibling(this.sn(simpleNode.jjtGetParent()))) == null) {
            return true;
        }
        if (simpleNode.jjtGetNumChildren() > 0) {
            simpleNode = this.sn(simpleNode.jjtGetChild(0));
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            if (Util.trimWhitespace(simpleNode.getValue()).length() == 0) {
                return this.isPreviousSiblingBoundaryWhitespaceChar(simpleNode);
            }
        } else {
            return simpleNode.getId() != 129 || (simpleNode = this.sn(simpleNode.jjtGetChild(0))).getId() != 132 && simpleNode.getId() != 131 && simpleNode.getId() != 130;
        }
        return false;
    }

    private boolean isNextSiblingBoundaryWhitespaceChar(SimpleNode simpleNode) {
        if ((simpleNode = this.getNextSibling(this.sn(simpleNode.jjtGetParent()))) == null) {
            return true;
        }
        if (simpleNode.jjtGetNumChildren() > 0) {
            simpleNode = this.sn(simpleNode.jjtGetChild(0));
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            if (Util.trimWhitespace(simpleNode.getValue()).length() == 0) {
                return this.isNextSiblingBoundaryWhitespaceChar(simpleNode);
            }
        } else {
            return simpleNode.getId() != 129 || (simpleNode = this.sn(simpleNode.jjtGetChild(0))).getId() != 132 && simpleNode.getId() != 131 && simpleNode.getId() != 130;
        }
        return false;
    }

    private boolean isBoundaryWhitespaceChar(SimpleNode simpleNode) {
        return (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) && Util.trimWhitespace(simpleNode.getValue()).length() == 0 && this.isPreviousSiblingBoundaryWhitespaceChar(simpleNode) && this.isNextSiblingBoundaryWhitespaceChar(simpleNode);
    }

    private boolean shouldStripChar(SimpleNode simpleNode) {
        return this._boundarySpacePolicy == 0 && this.isBoundaryWhitespaceChar(simpleNode);
    }

    private boolean shouldVoidPathExpr(SimpleNode simpleNode) {
        if (this.getNumExprChildren(simpleNode) > 1) {
            return false;
        }
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.getId() != 85) continue;
            return false;
        }
        return true;
    }

    private void markCheck() {
        this._stackChecks.push(new Integer(this._openElemStack.size()));
    }

    private boolean check(SimpleNode simpleNode) {
        int n;
        int n2 = (Integer)this._stackChecks.pop();
        if (n2 != (n = this._openElemStack.size())) {
            System.err.println("Stack not flushed properly!!! " + XPathTreeConstants.jjtNodeName[simpleNode.getId()]);
        }
        return n2 == n;
    }

    private void xqflush() {
        if (null != this._xqout1) {
            this._xqout1.flush();
        }
        if (null != this._xqout2) {
            this._xqout2.flush();
        }
    }

    public boolean transform(SimpleNode simpleNode, PrintStream printStream) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transform(SimpleNode simpleNode, PrintStream printStream, PrintStream printStream2) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transformNoEncodingException(SimpleNode simpleNode, PrintStream printStream, PrintStream printStream2) {
        try {
            this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
            this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._xqout1 = printStream != null ? new PrintWriter(printStream) : null;
            this._xqout2 = printStream2 != null ? new PrintWriter(printStream2) : null;
        }
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transform(SimpleNode simpleNode) {
        this.markCheck();
        int n = simpleNode.getId();
        switch (n) {
            case 0: {
                this.xqprintln("<?xml version=\"1.0\"?>");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.pushElem("xqx:module", simpleNode);
                this.pushAttr("xmlns:xqx", "http://www.w3.org/2005/XQueryX");
                this._outputStack.push("\n           ");
                this.pushAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this._outputStack.push("\n           ");
                this.pushAttr("xsi:schemaLocation", "http://www.w3.org/2005/XQueryX\n                                http://www.w3.org/2005/XQueryX/xqueryx.xsd");
                break;
            }
            case 4: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                    if (i == 0) {
                        this.pushElem("xqx:version", simpleNode2);
                        this.flushOpen(simpleNode2, false);
                        this.xqprint(simpleNode2.getValue().substring(1, simpleNode2.getValue().length() - 1));
                        this.flushClose(simpleNode2, false);
                        continue;
                    }
                    if (i != 1) continue;
                    this.pd("encoding: " + simpleNode2.getValue());
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 5: 
            case 97: 
            case 98: 
            case 99: {
                String string;
                boolean bl = true;
                switch (n) {
                    case 97: {
                        string = "xqx:integerConstantExpr";
                        break;
                    }
                    case 98: {
                        string = "xqx:decimalConstantExpr";
                        break;
                    }
                    case 99: {
                        string = "xqx:doubleConstantExpr";
                        break;
                    }
                    case 5: {
                        if (this.getParentID(simpleNode) == 16) {
                            string = "xqx:optionContents";
                            bl = false;
                            break;
                        }
                        string = "xqx:stringConstantExpr";
                        break;
                    }
                    default: {
                        string = "UNKNOWN!";
                    }
                }
                this.pushElem(string, simpleNode);
                this.flushOpen(simpleNode, bl);
                if (bl) {
                    this.pushElem("xqx:value", simpleNode);
                    this.flushOpen(simpleNode, false);
                }
                String string2 = simpleNode.getValue();
                if (n == 5) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                this.xqprintEscaped(string2);
                if (bl) {
                    this.flushClose(simpleNode, false);
                }
                this.flushClose(simpleNode, bl);
                return this.check(simpleNode);
            }
            case 25: {
                break;
            }
            case 185: {
                if (this.getParentID(simpleNode) == 25) {
                    this.pushElem("xqx:baseUriDecl", simpleNode);
                } else if (this.getParentID(simpleNode) == 50) {
                    this.pushElem("xqx:collation", simpleNode);
                } else if (this.getParentID(simpleNode) == 24) {
                    this.pushElem("xqx:defaultCollationDecl", simpleNode);
                } else {
                    this.pushElem("xqx:uri", simpleNode);
                }
                this.flushOpen(simpleNode, false);
                SimpleNode simpleNode3 = this.sn(simpleNode.jjtGetChild(0));
                String string = simpleNode3.getValue();
                string = string.substring(1, string.length() - 1);
                this.xqprint(string);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 9: {
                if (simpleNode.jjtGetNumChildren() <= 0) break;
                this.pushElem("xqx:prolog", simpleNode);
                break;
            }
            case 93: 
            case 94: {
                String string = simpleNode.getValue();
                int n2 = string.indexOf(58);
                if (n2 > 0) {
                    String string3 = string.substring(0, n2);
                    string = string.substring(n2 + 1);
                    if (string3.equals("*")) {
                        this.pushElem("xqx:star", simpleNode);
                        this.flushEmpty(simpleNode);
                    } else {
                        this.pushElem("xqx:NCName", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint(string3);
                        this.flushClose(simpleNode, false);
                    }
                }
                if (string.equals("*")) {
                    this.pushElem("xqx:star", simpleNode);
                    this.flushEmpty(simpleNode);
                } else {
                    this.pushElem("xqx:NCName", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint(string);
                    this.flushClose(simpleNode, false);
                }
                return this.check(simpleNode);
            }
            case 163: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                if (this.sn(simpleNode.jjtGetChild(0)).getValue() != null) {
                    this.pushElem("xqx:optional", simpleNode);
                    this.flushEmpty(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 168: {
                break;
            }
            case 175: 
            case 179: {
                if (simpleNode.getValue() == null || !simpleNode.getValue().equals("*")) break;
                this.pushElem(n == 175 ? 182 : 183, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:star", simpleNode);
                this.flushEmpty(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 182: 
            case 183: {
                this.pushElem(n, simpleNode);
                break;
            }
            case 78: 
            case 190: 
            case 191: {
                int n3 = this.getParentID(simpleNode);
                if (n3 == 157 || n3 == 159) {
                    this.pushElem("xqx:tagName", simpleNode);
                } else if (n3 == 184) {
                    this.pushElem("xqx:typeName", simpleNode);
                } else if (n3 == 162) {
                    this.pushElem("xqx:piTarget", simpleNode);
                } else if (n3 == 168) {
                    this.pushElem(168, simpleNode);
                } else if (n3 == 13) {
                    this.pushElem("xqx:prefix", simpleNode);
                } else if (n3 == 29 || n3 == 34) {
                    this.pushElem("xqx:varName", simpleNode);
                } else if (n3 == 32) {
                    this.pushElem("xqx:functionName", simpleNode);
                } else if (n3 == 16) {
                    this.pushElem("xqx:optionName", simpleNode);
                } else {
                    this.pushElem("xqx:QName", simpleNode);
                }
                String string = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 111: {
                if (this.getParentID(simpleNode) == 114 && simpleNode.getValue().startsWith("xmlns:")) {
                    this.pushElem("xqx:prefix", simpleNode);
                    this.flushOpen(simpleNode, false);
                    int n4 = simpleNode.getValue().indexOf(58);
                    String string = simpleNode.getValue().substring(n4 + 1);
                    this.xqprint(string);
                    this.flushClose(simpleNode, false);
                    return this.check(simpleNode);
                }
                if (this.getParentID(simpleNode) == 114) {
                    this.pushElem("xqx:attributeName", simpleNode);
                } else {
                    this.pushElem("xqx:tagName", simpleNode);
                }
                String string = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 192: {
                this.pushElem("xqx:functionName", simpleNode);
                String string = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 92: {
                this.pushElem("xqx:Wildcard", simpleNode);
                break;
            }
            case 91: {
                if (this.getChildID(simpleNode, 0) == 92) break;
            }
            case 100: {
                int n5 = this.getParentID(simpleNode);
                if (n5 == 43 || n5 == 45 || n5 == 53) {
                    this.pushElem("xqx:typedVariableBinding", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem(n, simpleNode);
                } else if (n5 == 55 || n5 == 54) {
                    this.pushElem("xqx:variableBinding", simpleNode);
                } else if (n == 100) {
                    this.pushElem("xqx:varRef", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem("xqx:name", simpleNode);
                } else {
                    this.pushElem(n, simpleNode);
                }
                String string = ((SimpleNode)simpleNode.jjtGetChild(0)).getValue();
                if (null != string) {
                    string = this.processPrefix(string);
                }
                this.flushOpen(simpleNode, false);
                this.xqprint(string);
                this.flushClose(simpleNode, false);
                SimpleNode simpleNode4 = this.getNextSibling(simpleNode);
                if (null != simpleNode4 && simpleNode4.getId() == 164) {
                    this.transform(simpleNode4);
                }
                if (n5 == 43 || n5 == 45 || n5 == 53) {
                    this.flushClose(simpleNode, true);
                } else if (n == 100) {
                    this.flushClose(simpleNode, true);
                }
                return this.check(simpleNode);
            }
            case 44: {
                this.pushElem("xqx:positionalVariableBinding", simpleNode);
                String string = this.sn(this.sn(simpleNode.jjtGetChild(0)).jjtGetChild(0)).getValue();
                String string4 = this.processPrefix(string);
                this.flushOpen(simpleNode, false);
                this.xqprint(string4);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 167: {
                if (simpleNode.getValue() == null || !simpleNode.getValue().equals("item")) break;
                this.pushElem("xqx:anyItemType", simpleNode);
                this.flushEmpty(simpleNode);
                return this.check(simpleNode);
            }
            case 165: {
                int n6 = this.getParentID(simpleNode);
                if (n6 == 55 || n6 == 32) {
                    this.pushElem("xqx:typeDeclaration", simpleNode);
                    this.flushOpen(simpleNode);
                }
                if (simpleNode.getValue() != null && simpleNode.getValue().equals("empty-sequence")) {
                    this.pushElem("xqx:voidSequenceType", simpleNode);
                    this.flushEmpty(simpleNode);
                } else {
                    this.transformChildren(simpleNode);
                }
                if (n6 == 55 || n6 == 32) {
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 40: {
                if (this.getNumExprChildren(simpleNode) <= 1) break;
                this.pushElem("xqx:sequenceExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 82: {
                int n7;
                if (this.shouldVoidPathExpr(simpleNode)) break;
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode, true);
                int n8 = 0;
                SimpleNode simpleNode5 = this.sn(simpleNode.jjtGetChild(0));
                if (simpleNode5.getId() != 85) {
                    this.pushElem("xqx:argExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.transform(simpleNode5);
                    this.flushClose(simpleNode);
                    ++n8;
                } else {
                    n7 = this.getChildID(simpleNode5, 0);
                    if (n7 != 86 && n7 != 88 && n7 != 87 && n7 != 87 && n7 != 89) {
                        ++n8;
                        this.pushElem("xqx:argExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                        int n9 = simpleNode5.jjtGetNumChildren();
                        SimpleNode simpleNode6 = null;
                        for (int i = 0; i < n9; ++i) {
                            SimpleNode simpleNode7 = (SimpleNode)simpleNode5.jjtGetChild(i);
                            if (simpleNode7.getId() == 95) {
                                simpleNode6 = simpleNode7;
                                continue;
                            }
                            this.transform(simpleNode7);
                        }
                        this.flushClose(simpleNode);
                        if (null != simpleNode6) {
                            this.transform(simpleNode6);
                        }
                    }
                }
                for (n7 = n8; n7 < simpleNode.jjtGetNumChildren(); ++n7) {
                    SimpleNode simpleNode8 = this.sn(simpleNode.jjtGetChild(n7));
                    if (simpleNode8.getId() == 85 || simpleNode8.getId() == 84 || simpleNode8.getId() == 83) {
                        this.transform(simpleNode8);
                        continue;
                    }
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem("xqx:filterExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    if (simpleNode8.getId() == 101) {
                        this.pushElem("xqx:parenthesizedExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    }
                    this.transform(simpleNode8);
                    if (simpleNode8.getId() == 101) {
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 95: {
                this.pushElem("xqx:predicates", simpleNode);
                break;
            }
            case 105: {
                this.pushElem("xqx:functionCallExpr", simpleNode);
                this.flushOpen(simpleNode, true);
                SimpleNode simpleNode9 = (SimpleNode)simpleNode.jjtGetChild(0);
                this.transform(simpleNode9);
                this.pushElem("xqx:arguments", simpleNode);
                this.flushOpen(simpleNode, true);
                int n10 = 1;
                this.transformChildren(simpleNode, n10);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 85: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode, true);
                int n11 = 0;
                int n12 = this.getChildID(simpleNode, n11);
                if (n12 == 102 || n12 == 101) {
                    if (n12 == 101) {
                        this.pushElem("xqx:filterExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                        this.pushElem("xqx:parenthesizedExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    } else if (n12 == 102) {
                        this.pushElem("xqx:filterExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    }
                    SimpleNode simpleNode10 = null;
                    for (int i = n11; i < simpleNode.jjtGetNumChildren(); ++i) {
                        SimpleNode simpleNode11 = (SimpleNode)simpleNode.jjtGetChild(i);
                        if (simpleNode11.getId() == 95) {
                            simpleNode10 = simpleNode11;
                            continue;
                        }
                        this.transform(simpleNode11);
                    }
                    this.flushClose(simpleNode, true);
                    if (n12 == 101) {
                        this.flushClose(simpleNode, true);
                    }
                    if (null != simpleNode10) {
                        this.transform(simpleNode10);
                    }
                    this.flushClose(simpleNode);
                    return this.check(simpleNode);
                }
                if (n12 == 86 || n12 == 88) {
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    String string = this.sn(simpleNode.jjtGetChild(0)).getValue();
                    this.xqprint(string);
                    ++n11;
                    this.flushClose(simpleNode, false);
                } else if (n12 == 89) {
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("parent");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    ++n11;
                } else if (n12 == 87) {
                    String string = this.sn(simpleNode.jjtGetChild(0)).getValue();
                    if (string != null && string.equals("@")) {
                        this.pushElem("xqx:xpathAxis", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint("attribute");
                        this.flushClose(simpleNode, false);
                    } else {
                        SimpleNode simpleNode12 = this.getPreviousSibling(simpleNode);
                        if (simpleNode12 != null) {
                            if (simpleNode12.getId() != 84) {
                                // empty if block
                            }
                            this.pushElem("xqx:xpathAxis", simpleNode);
                            this.flushOpen(simpleNode, false);
                            this.xqprint("child");
                            this.flushClose(simpleNode, false);
                        }
                    }
                    this.transformChildren(this.sn(simpleNode.jjtGetChild(0)), n11);
                    ++n11;
                } else {
                    SimpleNode simpleNode13 = this.getPreviousSibling(simpleNode);
                    if (simpleNode13 != null) {
                        if (simpleNode13.getId() != 84) {
                            // empty if block
                        }
                        this.pushElem("xqx:xpathAxis", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint("child");
                        this.flushClose(simpleNode, false);
                    }
                }
                this.transformChildren(simpleNode, n11);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 53: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:quantifier", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                int n13 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n13 - 1; i += 2) {
                    SimpleNode simpleNode14 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:quantifiedExprInClause", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transform(simpleNode14);
                    this.pushElem("xqx:sourceExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    SimpleNode simpleNode15 = this.sn(simpleNode.jjtGetChild(i + 1));
                    this.transform(simpleNode15);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.pushElem("xqx:predicateExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n13 - 1, n13 - 1);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 56: {
                this.pushElem("xqx:ifThenElseExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:ifClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                this.pushElem("xqx:thenClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 1, 1);
                this.flushClose(simpleNode);
                this.pushElem("xqx:elseClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 2, 2);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 42: {
                this.pushElem("xqx:flworExpr", simpleNode);
                this.flushOpen(simpleNode);
                int n14 = simpleNode.jjtGetNumChildren();
                this.transformChildren(simpleNode, 0, n14 - 2);
                this.pushElem("xqx:returnClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n14 - 1, n14 - 1);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 60: {
                this.pushElem("xqx:rangeSequenceExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:startExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(0)));
                this.flushClose(simpleNode);
                this.pushElem("xqx:endExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(1)));
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 69: {
                int n15 = 0;
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode16 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode16.getId() == 71) {
                        this.pushElem("xqx:unaryPlusOp", simpleNode);
                        this.flushOpen(simpleNode);
                        this.pushElem("xqx:operand", simpleNode);
                        this.flushOpen(simpleNode);
                        ++n15;
                        continue;
                    }
                    if (simpleNode16.getId() == 70) {
                        this.pushElem("xqx:unaryMinusOp", simpleNode);
                        this.flushOpen(simpleNode);
                        this.pushElem("xqx:operand", simpleNode);
                        this.flushOpen(simpleNode);
                        ++n15;
                        continue;
                    }
                    this.transform(simpleNode16);
                    for (int j = 0; j < n15; ++j) {
                        this.flushClose(simpleNode);
                        this.flushClose(simpleNode);
                    }
                    break;
                }
                return this.check(simpleNode);
            }
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                switch (n) {
                    case 61: {
                        String string = simpleNode.getValue();
                        String string5 = string.equals("+") ? "xqx:addOp" : (string.equals("-") ? "xqx:subtractOp" : "JJTADDITIVEEXPR UNKNOWN EXPR!");
                        this.pushElem(string5, simpleNode);
                        break;
                    }
                    case 62: {
                        String string = simpleNode.getValue();
                        String string6 = string.equals("*") ? "xqx:multiplyOp" : (string.equals("div") ? "xqx:divOp" : (string.equals("idiv") ? "xqx:idivOp" : (string.equals("mod") ? "xqx:modOp" : "JJTMULTIPLICATIVEEXPR UNKNOWN EXPR: " + string)));
                        this.pushElem(string6, simpleNode);
                        break;
                    }
                    case 63: {
                        this.pushElem("xqx:unionOp", simpleNode);
                        break;
                    }
                    case 64: {
                        String string = simpleNode.getValue();
                        String string7 = string.equals("intersect") ? "xqx:intersectOp" : (string.equals("except") ? "xqx:exceptOp" : "JJTINTERSECTEXCEPTEXPR UNKNOWN EXPR: " + string);
                        this.pushElem(string7, simpleNode);
                        break;
                    }
                    case 58: {
                        this.pushElem("xqx:andOp", simpleNode);
                        break;
                    }
                    case 57: {
                        this.pushElem("xqx:orOp", simpleNode);
                        break;
                    }
                    case 59: {
                        String string = simpleNode.getValue();
                        String string8 = string.equals("eq") ? "xqx:eqOp" : (string.equals("ne") ? "xqx:neOp" : (string.equals("lt") ? "xqx:ltOp" : (string.equals("le") ? "xqx:leOp" : (string.equals("gt") ? "xqx:gtOp" : (string.equals("ge") ? "xqx:geOp" : (string.equals("=") ? "xqx:equalOp" : (string.equals("!=") ? "xqx:notEqualOp" : (string.equals("<") ? "xqx:lessThanOp" : (string.equals("<=") ? "xqx:lessThanOrEqualOp" : (string.equals(">") ? "xqx:greaterThanOp" : (string.equals(">=") ? "xqx:greaterThanOrEqualOp" : (string.equals("is") ? "xqx:isOp" : (string.equals("<<") ? "xqx:nodeBeforeOp" : (string.equals(">>") ? "xqx:nodeAfterOp" : "JJTCOMPARISONEXPR UNKNOWN: " + string))))))))))))));
                        this.pushElem(string8, simpleNode);
                        break;
                    }
                    default: {
                        this.pushElem("???", simpleNode);
                    }
                }
                this.flushOpen(simpleNode);
                this.pushElem("xqx:firstOperand", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(0)));
                this.flushClose(simpleNode);
                this.pushElem("xqx:secondOperand", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(1)));
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 83: {
                this.pushElem("xqx:rootExpr", simpleNode);
                break;
            }
            case 84: {
                if (this.sn(simpleNode.jjtGetParent()).jjtGetChild(0) == simpleNode) {
                    this.pushElem("xqx:pathExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:argExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:rootExpr", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                } else {
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 43: 
            case 45: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                int n16 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i <= n16; ++i) {
                    SimpleNode simpleNode17 = (SimpleNode)simpleNode.jjtGetChild(i);
                    if (simpleNode17.getId() != 100) continue;
                    this.pushElem(n == 43 ? "xqx:forClauseItem" : "xqx:letClauseItem", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.transform(simpleNode17);
                    SimpleNode simpleNode18 = (SimpleNode)simpleNode.jjtGetChild(i + 1);
                    if (simpleNode18.getId() == 164) {
                        simpleNode18 = (SimpleNode)simpleNode.jjtGetChild(++i + 1);
                    }
                    if (simpleNode18.getId() == 44) {
                        this.transformChildren(simpleNode, ++i, i);
                    }
                    this.pushElem(n == 43 ? "xqx:forExpr" : "xqx:letExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    ++i;
                    while (i < n16) {
                        simpleNode17 = (SimpleNode)simpleNode.jjtGetChild(i);
                        if (simpleNode17.getId() == 100) {
                            --i;
                            break;
                        }
                        this.transform(simpleNode17);
                        ++i;
                    }
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 48: {
                int n17 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n17; ++i) {
                    SimpleNode simpleNode19 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:orderBySpec", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transform(simpleNode19);
                    if (simpleNode19.getId() == 49) {
                        int n18 = simpleNode19.jjtGetNumChildren();
                        for (int j = 0; j < n18; ++j) {
                            SimpleNode simpleNode20 = this.sn(simpleNode19.jjtGetChild(j));
                            if (simpleNode20.getId() != 50 || simpleNode20.jjtGetNumChildren() <= 0) continue;
                            this.transform(simpleNode20);
                        }
                    }
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 49: {
                this.pushElem("xqx:orderByExpr", simpleNode);
                this.flushOpen(simpleNode);
                int n19 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n19; ++i) {
                    SimpleNode simpleNode21 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode21.getId() == 50) continue;
                    this.transform(simpleNode21);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 50: {
                if (simpleNode.jjtGetNumChildren() == 0) {
                    return this.check(simpleNode);
                }
                this.pushElem(n, simpleNode);
                break;
            }
            case 173: {
                this.pushElem("xqx:piTest", simpleNode);
                if (simpleNode.jjtGetNumChildren() > 0) {
                    this.flushOpen(simpleNode);
                    SimpleNode simpleNode22 = this.sn(simpleNode.jjtGetChild(0));
                    this.markCheck();
                    this.pushElem("xqx:piTarget", simpleNode22);
                    this.flushOpen(simpleNode22, false);
                    String string = simpleNode22.getValue();
                    if (simpleNode22.getId() == 5) {
                        string = string.substring(1, string.length() - 1);
                    }
                    this.xqprint(string);
                    this.flushClose(simpleNode22, false);
                    this.check(simpleNode22);
                    this.flushClose(simpleNode);
                } else {
                    this.flushEmpty(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 26: {
                SimpleNode simpleNode23;
                this.pushElem("xqx:schemaImport", simpleNode);
                this.flushOpen(simpleNode);
                SimpleNode simpleNode24 = this.sn(simpleNode.jjtGetChild(0));
                int n20 = 0;
                if (simpleNode24.getId() == 27 && simpleNode24.jjtGetNumChildren() > 0) {
                    this.pushElem("xqx:namespacePrefix", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint(this.sn(simpleNode24.jjtGetChild(0)).getValue());
                    ++n20;
                    this.flushClose(simpleNode, false);
                    simpleNode23 = this.sn(simpleNode.jjtGetChild(1));
                    ++n20;
                } else if (simpleNode24.getId() == 27) {
                    this.pushElem("xqx:defaultElementNamespace", simpleNode);
                    this.flushEmpty(simpleNode);
                    ++n20;
                    simpleNode23 = this.sn(simpleNode.jjtGetChild(1));
                    ++n20;
                } else {
                    simpleNode23 = simpleNode24;
                    ++n20;
                }
                this.pushElem("xqx:targetNamespace", simpleNode23);
                this.flushOpen(simpleNode23, false);
                String string = this.sn(simpleNode23.jjtGetChild(0)).getValue();
                string = string.substring(1, string.length() - 1);
                this.xqprint(string);
                this.flushClose(simpleNode23, false);
                for (int i = n20; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode25 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:targetLocation", simpleNode25);
                    this.flushOpen(simpleNode25, false);
                    string = this.sn(simpleNode23.jjtGetChild(0)).getValue();
                    string = string.substring(1, string.length() - 1);
                    this.xqprint(string);
                    this.flushClose(simpleNode25, false);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 51: 
            case 52: {
                this.pushElem("xqx:orderingKind", simpleNode);
                this.flushOpen(simpleNode, false);
                if (n == 51) {
                    this.xqprint("ascending");
                } else {
                    this.xqprint("descending");
                }
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 19: 
            case 20: {
                if (this.getParentID(simpleNode) == 18) {
                    this.pushElem("xqx:emptyOrderingDecl", simpleNode);
                } else {
                    this.pushElem("xqx:emptyOrderingMode", simpleNode);
                }
                this.flushOpen(simpleNode, false);
                if (n == 51) {
                    this.xqprint("empty greatest");
                } else {
                    this.xqprint("empty least");
                }
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 101: {
                if (simpleNode.jjtGetNumChildren() != 0) break;
                this.pushElem("xqx:sequenceExpr", simpleNode);
                break;
            }
            case 15: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:defaultNamespaceCategory", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 14: {
                this._boundarySpacePolicy = simpleNode.getValue().equals("preserve") ? 1 : 0;
                return this.check(simpleNode);
            }
            case 17: 
            case 22: 
            case 23: 
            case 31: 
            case 166: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                if (n == 65) {
                    this.pushElem("xqx:instanceOfExpr", simpleNode);
                } else {
                    this.pushElem(n, simpleNode);
                }
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                if (n != 68 && n != 67) {
                    this.pushElem("xqx:sequenceType", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, 1, 1);
                    this.flushClose(simpleNode);
                } else {
                    this.transformChildren(simpleNode, 1, 1);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 103: 
            case 104: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 54: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                int n21 = simpleNode.jjtGetNumChildren();
                int n22 = n21 - 2;
                this.transformChildren(simpleNode, 1, n22 - 1);
                if (this.getChildID(simpleNode, n22) != 100) {
                    this.transformChildren(simpleNode, n22, n22);
                    ++n22;
                }
                this.pushElem("xqx:typeswitchExprDefaultClause", simpleNode);
                this.flushOpen(simpleNode);
                if (n22 == n21 - 2) {
                    this.transformChildren(simpleNode, n22, n22);
                    ++n22;
                }
                this.pushElem("xqx:resultExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n22, n22);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 55: {
                this.pushElem("xqx:typeswitchExprCaseClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 1);
                this.pushElem("xqx:resultExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 2);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 32: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                int n23 = 0;
                this.transformChildren(simpleNode, n23, n23);
                if (this.getChildID(simpleNode, ++n23) == 33) {
                    this.transformChildren(simpleNode, n23, n23);
                    ++n23;
                } else {
                    this.pushElem("xqx:paramList", simpleNode);
                    this.flushEmpty(simpleNode);
                }
                int n24 = simpleNode.jjtGetNumChildren() - 1;
                this.transformChildren(simpleNode, n23, n24 - 1);
                n23 = n24;
                if (this.getChildID(simpleNode, n24) == 30) {
                    this.transformChildren(simpleNode, n23, n24);
                } else {
                    this.pushElem("xqx:functionBody", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, n23, n24);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 29: {
                this.pushElem(n, simpleNode);
                this.flushOpen(simpleNode);
                int n25 = 0;
                int n26 = simpleNode.jjtGetNumChildren() - 1;
                this.transformChildren(simpleNode, n25, n26 - 1);
                n25 = n26;
                if (this.getChildID(simpleNode, n26) == 30) {
                    this.transformChildren(simpleNode, n25, n26);
                } else {
                    this.pushElem("xqx:varValue", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, n25, n26);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 46: 
            case 47: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 102: 
            case 164: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 178: 
            case 180: {
                this.pushElem(n, simpleNode);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 70: 
            case 71: 
            case 77: 
            case 90: 
            case 96: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 129: 
            case 145: 
            case 184: {
                break;
            }
            case 130: {
                this.xqprint(simpleNode.getValue());
                break;
            }
            case 131: {
                String string = simpleNode.getValue();
                this.xqprint(string);
                break;
            }
            case 132: {
                this.xqprint("{{");
                break;
            }
            case 133: {
                this.xqprint("}}");
                break;
            }
            case 134: {
                this.pushElem("xqx:computedCommentConstructor", simpleNode);
                break;
            }
            case 138: {
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:stringConstantExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:value", simpleNode);
                this.flushOpen(simpleNode, false);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode, false);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 139: 
            case 140: 
            case 148: 
            case 154: {
                this.xqprintEscaped(simpleNode.getValue());
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 142: 
            case 143: 
            case 146: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                break;
            }
            case 149: {
                this.pushElem("xqx:computedTextConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:stringConstantExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:value", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint("<![CDATA[");
                this.transformChildren(simpleNode);
                this.xqprint("]]>");
                this.flushClose(simpleNode, false);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 147: {
                break;
            }
            case 141: {
                this.pushElem("xqx:computedPIConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:piTarget", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(this.sn(simpleNode.jjtGetChild(1)).getValue());
                this.flushClose(simpleNode, false);
                if (this.hasChildID(simpleNode, 147)) {
                    this.pushElem("xqx:piValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:stringConstantExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:value", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.transformChildren(simpleNode, 2);
                    this.flushClose(simpleNode, false);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 156: 
            case 160: 
            case 161: {
                switch (n) {
                    case 156: {
                        String string = "xqx:computedDocumentConstructor";
                        break;
                    }
                    case 160: {
                        String string = "xqx:computedTextConstructor";
                        break;
                    }
                    case 161: {
                        String string = "xqx:computedCommentConstructor";
                        break;
                    }
                    default: {
                        String string = "UNKNOWN-" + XPathTreeConstants.jjtNodeName[n];
                    }
                }
                this.pushElem("xqx:computedTextConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 155: {
                break;
            }
            case 157: 
            case 159: 
            case 162: {
                this.pushElem(n == 159 ? "xqx:computedAttributeConstructor" : (n == 162 ? "xqx:computedPIConstructor" : "xqx:computedElementConstructor"), simpleNode);
                this.flushOpen(simpleNode);
                int n27 = 0;
                if (this.getChildID(simpleNode, 0) == 37) {
                    if (n == 162) {
                        this.pushElem("xqx:piTargetExpr", simpleNode);
                    } else {
                        this.pushElem("xqx:tagNameExpr", simpleNode);
                    }
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, 1, 1);
                    this.flushClose(simpleNode);
                    n27 += 3;
                } else {
                    this.transformChildren(simpleNode, 0, 0);
                    ++n27;
                }
                if (n == 159 || n == 162) {
                    this.pushElem(n == 159 ? "xqx:valueExpr" : "xqx:piValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    if (this.getNumExprChildren(simpleNode, n27) == 0) {
                        this.pushElem("xqx:sequenceExpr", simpleNode);
                        this.flushEmpty(simpleNode);
                    } else {
                        this.transformChildren(simpleNode, n27);
                    }
                    this.flushClose(simpleNode);
                } else {
                    this.transformChildren(simpleNode, n27);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 158: {
                this.pushElem(n, simpleNode);
                break;
            }
            case 114: {
                if (this.getNumRealChildren(simpleNode) > 0) {
                    this.pushElem("xqx:attributeList", simpleNode);
                    this.flushOpen(simpleNode);
                    int n28 = simpleNode.jjtGetNumChildren();
                    for (int i = 0; i < n28; ++i) {
                        SimpleNode simpleNode26 = this.sn(simpleNode.jjtGetChild(i));
                        if (simpleNode26.getId() == 111) {
                            if (simpleNode26.getValue().startsWith("xmlns:")) {
                                this.pushElem("xqx:namespaceDeclaration", simpleNode);
                            } else {
                                this.pushElem("xqx:attributeConstructor", simpleNode);
                            }
                            this.flushOpen(simpleNode);
                        }
                        this.transform(simpleNode26);
                        if (simpleNode26.getId() != 116) continue;
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 127: {
                if (this.getChildID(simpleNode, 0) != 128) break;
                String string = this.sn(simpleNode.jjtGetChild(0)).getValue();
                this.xqprintEscaped(string);
                return this.check(simpleNode);
            }
            case 108: {
                this.pushElem("xqx:elementConstructor", simpleNode);
                this.flushOpen(simpleNode);
                int n29 = simpleNode.jjtGetNumChildren();
                boolean bl = false;
                SimpleNode simpleNode27 = null;
                int n30 = 0;
                for (int i = 0; i < n29; ++i) {
                    SimpleNode simpleNode28 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode28.getId() == 127) {
                        if (!bl) {
                            this.pushElem("xqx:elementContent", simpleNode);
                            this.flushOpen(simpleNode);
                            bl = true;
                        }
                        if (this.isEncloseExpr(simpleNode28)) {
                            if (n30 == 2) {
                                this.flushClose(simpleNode, !this.isElemContentChar(simpleNode27));
                                this.flushClose(simpleNode);
                            }
                            simpleNode27 = this.sn(this.sn(simpleNode28.jjtGetChild(0)).jjtGetChild(0));
                            simpleNode28 = this.sn(this.sn(simpleNode28.jjtGetChild(0)).jjtGetChild(0));
                            n30 = 0;
                        } else if (this.isElemContentChar(simpleNode28)) {
                            if (simpleNode28.getId() == 127 && this.shouldStripChar(this.sn(simpleNode28.jjtGetChild(0)))) continue;
                            if (!this.isElemContentChar(simpleNode27)) {
                                this.pushElem("xqx:stringConstantExpr", simpleNode);
                                this.flushOpen(simpleNode);
                                this.pushElem("xqx:value", simpleNode);
                                this.flushOpen(simpleNode, false);
                                n30 = 2;
                            }
                            simpleNode27 = simpleNode28;
                        } else {
                            if (n30 == 2) {
                                this.flushClose(simpleNode, !this.isElemContentChar(simpleNode27));
                                this.flushClose(simpleNode);
                            }
                            simpleNode27 = simpleNode28;
                            n30 = 0;
                        }
                    }
                    this.transform(simpleNode28);
                }
                if (n30 == 2) {
                    this.flushClose(simpleNode, false);
                    this.flushClose(simpleNode);
                }
                if (bl) {
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 116: {
                SimpleNode simpleNode29;
                int n31;
                if (this.isJustWhitespace(simpleNode)) {
                    return this.check(simpleNode);
                }
                int n32 = simpleNode.jjtGetNumChildren();
                int n33 = -1;
                boolean bl = false;
                for (n31 = 0; n31 < n32; ++n31) {
                    simpleNode29 = this.sn(simpleNode.jjtGetChild(n31));
                    if (!this.isEncloseExpr(simpleNode29)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.pushElem("xqx:attributeValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    n31 = 0;
                    for (int i = 0; i < n32; ++i) {
                        SimpleNode simpleNode30 = this.sn(simpleNode.jjtGetChild(i));
                        if (this.isEncloseExpr(simpleNode30)) {
                            if (n31 == 2) {
                                this.flushClose(simpleNode, !this.isAttrContentChar(n33));
                                this.flushClose(simpleNode);
                            }
                            n33 = this.sn(this.sn(simpleNode30.jjtGetChild(0)).jjtGetChild(0)).getId();
                            simpleNode30 = this.sn(this.sn(simpleNode30.jjtGetChild(0)).jjtGetChild(0));
                            n31 = 0;
                        } else if (this.isAttrContentChar(simpleNode30.getId())) {
                            if (!this.isAttrContentChar(n33)) {
                                this.pushElem("xqx:stringConstantExpr", simpleNode);
                                this.flushOpen(simpleNode);
                                this.pushElem("xqx:value", simpleNode);
                                this.flushOpen(simpleNode, false);
                                n31 = 2;
                            }
                            n33 = simpleNode30.getId();
                        } else {
                            if (simpleNode30.getId() == 117 || simpleNode30.getId() == 119 || simpleNode30.getId() == 120 || simpleNode30.getId() == 122) continue;
                            if (n31 == 2) {
                                this.flushClose(simpleNode, !this.isAttrContentChar(n33));
                                this.flushClose(simpleNode);
                            }
                            n33 = simpleNode30.getId();
                            n31 = 0;
                        }
                        this.transform(simpleNode30);
                    }
                    if (n31 == 2) {
                        this.flushClose(simpleNode, false);
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                } else {
                    if (this.getPreviousSibling(this.getPreviousSibling(simpleNode)).getValue().startsWith("xmlns:")) {
                        this.pushElem("xqx:uri", simpleNode);
                    } else {
                        this.pushElem("xqx:attributeValue", simpleNode);
                    }
                    this.flushOpen(simpleNode, false);
                    for (n31 = 0; n31 < n32; ++n31) {
                        simpleNode29 = this.sn(simpleNode.jjtGetChild(n31));
                        if (simpleNode29.getId() == 117 || simpleNode29.getId() == 119 || simpleNode29.getId() == 120 || simpleNode29.getId() == 122) continue;
                        this.transform(simpleNode29);
                    }
                    this.flushClose(simpleNode, false);
                }
                return this.check(simpleNode);
            }
            case 118: {
                this.xqprint("\"\"");
                return this.check(simpleNode);
            }
            case 121: {
                this.xqprint("''");
                return this.check(simpleNode);
            }
            case 124: 
            case 126: 
            case 128: {
                if (simpleNode.getValue() != null) {
                    this.xqprintEscaped(simpleNode.getValue());
                }
                return this.check(simpleNode);
            }
            default: {
                System.err.println("Unknown ID: " + XPathTreeConstants.jjtNodeName[n]);
            }
        }
        int n34 = simpleNode.jjtGetNumChildren();
        if (n34 == 0) {
            this.flushEmpty(simpleNode);
        } else {
            this.flushOpen(simpleNode);
            this.transformChildren(simpleNode);
            this.flushClose(simpleNode);
        }
        return this.check(simpleNode);
    }

    private SimpleNode getNextSibling(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetParent().jjtGetChild(i));
            if (simpleNode2 != simpleNode) continue;
            if (i + 1 >= n) break;
            return this.sn(simpleNode.jjtGetParent().jjtGetChild(i + 1));
        }
        return null;
    }

    private SimpleNode getPreviousSibling(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetParent().jjtGetChild(i));
            if (simpleNode2 != simpleNode) continue;
            if (i <= 0) break;
            return this.sn(simpleNode.jjtGetParent().jjtGetChild(i - 1));
        }
        return null;
    }

    private boolean hasChildID(SimpleNode simpleNode, int n) {
        int n2 = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() != n) continue;
            return true;
        }
        return false;
    }

    private int getNumExprChildren(SimpleNode simpleNode) {
        return this.getNumExprChildren(simpleNode, 0);
    }

    private int getNumExprChildren(SimpleNode simpleNode, int n) {
        int n2 = 0;
        int n3 = simpleNode.jjtGetNumChildren();
        for (int i = n; i < n3; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77 || simpleNode2.getId() == 37 || simpleNode2.getId() == 38) continue;
            ++n2;
        }
        return n2;
    }

    private int getNumRealChildren(SimpleNode simpleNode) {
        int n = 0;
        int n2 = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77) continue;
            ++n;
        }
        return n;
    }

    private boolean isEncloseExpr(SimpleNode simpleNode) {
        return (simpleNode.getId() == 123 || simpleNode.getId() == 125 || simpleNode.getId() == 127) && this.sn(simpleNode.jjtGetChild(0)).getId() == 129 && this.sn(this.sn(simpleNode.jjtGetChild(0)).jjtGetChild(0)).getId() == 35;
    }

    private boolean isAttrContentChar(int n) {
        switch (n) {
            case 118: 
            case 121: 
            case 123: 
            case 125: {
                return true;
            }
            case 129: {
                return true;
            }
        }
        return false;
    }

    private boolean isElemContentChar(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return false;
        }
        if (simpleNode.getId() == 127) {
            switch (this.getChildID(simpleNode, 0)) {
                case 128: {
                    return true;
                }
                case 129: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String processPrefix(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            this.pushAttr("xqx:prefix", string2);
        }
        return string;
    }

    private SimpleNode sn(Node node) {
        return (SimpleNode)node;
    }

    private void transformChildren(SimpleNode simpleNode, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            this.transform(simpleNode2);
        }
    }

    private void transformChildren(SimpleNode simpleNode, int n) {
        this.transformChildren(simpleNode, n, simpleNode.jjtGetNumChildren() - 1);
    }

    private void transformChildren(SimpleNode simpleNode) {
        this.transformChildren(simpleNode, 0, simpleNode.jjtGetNumChildren() - 1);
    }

    private int getParentID(SimpleNode simpleNode) {
        return ((SimpleNode)simpleNode.jjtGetParent()).getId();
    }

    private int getChildID(SimpleNode simpleNode, int n) {
        return ((SimpleNode)simpleNode.jjtGetChild(n)).getId();
    }

    private SimpleNode getFirstChildIgnoreS(SimpleNode simpleNode) {
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77) continue;
            return this.sn(simpleNode2);
        }
        return null;
    }
}

