/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

final class Latin1EncodingSupport
implements EncodingSupport {
    private static EncodingSupport fgSingleton = new Latin1EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = byteStreamDataSource.byteBuffer;
        int n = byteStreamDataSource.byteOffset;
        byte[] byArray2 = dataBuffer.bytes;
        int n2 = byteStreamDataSource.bufferLength;
        int n3 = 0;
        try {
            while (byteStreamDataSource.stream != null || n > 0) {
                int n4;
                byte by;
                int n5;
                if (byteStreamDataSource.stream != null && n < byteStreamDataSource.bufferLength) {
                    n5 = byteStreamDataSource.stream.read(byArray, n, byteStreamDataSource.bufferLength - n);
                    if (n5 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n == 0) {
                            byteStreamDataSource.byteOffset = n;
                            dataBuffer.endOffset = n3;
                            return null;
                        }
                        n5 = 0;
                    }
                } else {
                    n5 = 0;
                }
                n5 += n;
                n = 0;
                if (n5 <= n2 - n3) {
                    while (n < n5 && (byArray2[n3] = byArray[n]) >= 0) {
                        ++n;
                        ++n3;
                    }
                    if (n == n5) {
                        if (!(n3 >= n2 || byteStreamDataSource.checkAvailable && byteStreamDataSource.stream.available() <= 0)) {
                            n = 0;
                            continue;
                        }
                        byteStreamDataSource.byteOffset = 0;
                        dataBuffer.endOffset = n3;
                        return null;
                    }
                    if (n3 + 1 < n2) {
                        by = byArray2[n3];
                        ++n;
                        byArray2[n3] = (byte)(0xC0 | by >> 6 & 3);
                        byArray2[n3 + 1] = (byte)(0x80 | by & 0x3F);
                        n3 += 2;
                    }
                    n4 = n5 - n <= n2 - n3 ? n5 : n + (n2 - n3);
                } else {
                    n4 = n2 - n3;
                }
                while (n < n4) {
                    byArray2[n3] = byArray[n];
                    if (byArray2[n3] >= 0) {
                        ++n;
                        ++n3;
                        continue;
                    }
                    if (n3 + 1 < n2) {
                        by = byArray2[n3];
                        byArray2[n3] = (byte)(0xC0 | by >> 6 & 3);
                        byArray2[n3 + 1] = (byte)(0x80 | by & 0x3F);
                        if (n4 - ++n <= n2 - (n3 += 2)) continue;
                        n4 = n + (n2 - n3);
                        continue;
                    }
                    if (n < n5) {
                        System.arraycopy(byArray, n, byArray, 0, n5 -= n);
                        n = n5;
                    } else {
                        n = 0;
                    }
                    byteStreamDataSource.byteOffset = n;
                    dataBuffer.endOffset = n3;
                    return null;
                }
                if (n < n5) {
                    System.arraycopy(byArray, n, byArray, 0, n5 -= n);
                    n = n5;
                } else {
                    n = 0;
                }
                if (!(n3 == n2 || byteStreamDataSource.checkAvailable && byteStreamDataSource.stream.available() == 0)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
        byteStreamDataSource.byteOffset = n;
        dataBuffer.endOffset = n3;
        return null;
    }

    private Latin1EncodingSupport() {
    }
}

