/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.openjpa.event.AbstractRemoteCommitProvider;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.Serialization;
import serp.util.Strings;

public class TCPRemoteCommitProvider
extends AbstractRemoteCommitProvider
implements Configurable {
    private static final int DEFAULT_PORT = 5636;
    private static final Localizer s_loc = Localizer.forPackage(TCPRemoteCommitProvider.class);
    private static long s_idSequence = System.currentTimeMillis();
    private static final Map s_portListenerMap = new HashMap();
    private long _id;
    private byte[] _localhost;
    private int _port = 5636;
    private int _maxActive = 2;
    private int _maxIdle = 2;
    private int _recoveryTimeMillis = 15000;
    private TCPPortListener _listener;
    private BroadcastQueue _broadcastQueue = new BroadcastQueue();
    private final List _broadcastThreads = Collections.synchronizedList(new LinkedList());
    private ArrayList _addresses = new ArrayList();
    private ReentrantLock _addressesLock;
    private static final long PROTOCOL_VERSION = 338210047L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPRemoteCommitProvider() throws UnknownHostException {
        Class<TCPRemoteCommitProvider> clazz = TCPRemoteCommitProvider.class;
        synchronized (TCPRemoteCommitProvider.class) {
            this._id = s_idSequence++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._localhost = InetAddress.getLocalHost().getAddress();
            this._addressesLock = new ReentrantLock();
            this.setNumBroadcastThreads(2);
            return;
        }
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setRecoveryTimeMillis(int recoverytime) {
        this._recoveryTimeMillis = recoverytime;
    }

    public int getRecoveryTimeMillis() {
        return this._recoveryTimeMillis;
    }

    public void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
    }

    public int getMaxActive() {
        return this._maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumBroadcastThreads(int numBroadcastThreads) {
        List list = this._broadcastThreads;
        synchronized (list) {
            int cur = this._broadcastThreads.size();
            if (cur > numBroadcastThreads) {
                for (int i = numBroadcastThreads; i < cur; ++i) {
                    BroadcastWorkerThread worker = (BroadcastWorkerThread)this._broadcastThreads.remove(0);
                    worker.setRunning(false);
                }
            } else if (cur < numBroadcastThreads) {
                for (int i = cur; i < numBroadcastThreads; ++i) {
                    BroadcastWorkerThread wt = new BroadcastWorkerThread();
                    wt.setDaemon(true);
                    wt.start();
                    this._broadcastThreads.add(wt);
                }
            }
        }
    }

    public int getNumBroadcastThreads() {
        return this._broadcastThreads.size();
    }

    public void setAddresses(String names) throws UnknownHostException {
        this._addressesLock.lock();
        try {
            Iterator iter = this._addresses.iterator();
            while (iter.hasNext()) {
                ((HostAddress)iter.next()).close();
            }
            String[] toks = Strings.split(names, ";", 0);
            this._addresses = new ArrayList(toks.length);
            InetAddress localhost = InetAddress.getLocalHost();
            String localhostName = localhost.getHostName();
            for (int i = 0; i < toks.length; ++i) {
                int tmpPort;
                String hostname;
                String host = toks[i];
                int colon = host.indexOf(58);
                if (colon != -1) {
                    hostname = host.substring(0, colon);
                    tmpPort = Integer.parseInt(host.substring(colon + 1));
                } else {
                    hostname = host;
                    tmpPort = 5636;
                }
                InetAddress tmpAddress = (InetAddress)AccessController.doPrivileged(J2DoPrivHelper.getByNameAction(hostname));
                if (localhostName.equals(hostname)) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace(s_loc.get("tcp-address-asself", tmpAddress.getHostName() + ":" + tmpPort));
                    continue;
                }
                HostAddress newAddress = new HostAddress(host);
                this._addresses.add(newAddress);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace(s_loc.get("tcp-address-set", newAddress._address.getHostName() + ":" + newAddress._port));
            }
        }
        catch (PrivilegedActionException pae) {
            throw (UnknownHostException)pae.getException();
        }
        finally {
            this._addressesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endConfiguration() {
        super.endConfiguration();
        Map map = s_portListenerMap;
        synchronized (map) {
            this._listener = (TCPPortListener)s_portListenerMap.get(String.valueOf(this._port));
            if (this._listener == null || !this._listener.isRunning() && this._listener._port == this._port) {
                try {
                    this._listener = new TCPPortListener(this._port, this.log);
                    this._listener.listen();
                    s_portListenerMap.put(String.valueOf(this._port), this._listener);
                }
                catch (Exception e) {
                    throw new GeneralException(s_loc.get("tcp-init-exception", String.valueOf(this._port)), (Throwable)e).setFatal(true);
                }
            } else if (this._listener.isRunning()) {
                if (this._listener._port != this._port) {
                    throw new GeneralException(s_loc.get("tcp-not-equal", String.valueOf(this._port))).setFatal(true);
                }
            } else {
                throw new InternalException(s_loc.get("tcp-listener-broken"));
            }
            this._listener.addProvider(this);
        }
        this._addressesLock.lock();
        try {
            for (HostAddress curAddress : this._addresses) {
                curAddress.setMaxActive(this._maxActive);
                curAddress.setMaxIdle(this._maxIdle);
            }
        }
        finally {
            this._addressesLock.unlock();
        }
    }

    public void broadcast(RemoteCommitEvent event) {
        block4: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeLong(338210047L);
                oos.writeLong(this._id);
                oos.writeInt(this._port);
                oos.writeObject(this._localhost);
                oos.writeObject(event);
                oos.flush();
                byte[] bytes = baos.toByteArray();
                baos.close();
                if (this._broadcastThreads.isEmpty()) {
                    this.sendUpdatePacket(bytes);
                } else {
                    this._broadcastQueue.addPacket(bytes);
                }
            }
            catch (IOException ioe) {
                if (!this.log.isWarnEnabled()) break block4;
                this.log.warn(s_loc.get("tcp-payload-create-error"), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdatePacket(byte[] bytes) {
        this._addressesLock.lock();
        try {
            Iterator iter = this._addresses.iterator();
            while (iter.hasNext()) {
                ((HostAddress)iter.next()).sendUpdatePacket(bytes);
            }
        }
        finally {
            this._addressesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._listener != null) {
            this._listener.removeProvider(this);
        }
        this._broadcastQueue.close();
        while (!this._broadcastThreads.isEmpty()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {}
        }
        this._addressesLock.lock();
        try {
            Iterator iter = this._addresses.iterator();
            while (iter.hasNext()) {
                ((HostAddress)iter.next()).close();
            }
        }
        finally {
            this._addressesLock.unlock();
        }
    }

    private class HostAddress {
        private InetAddress _address;
        private int _port;
        private long _timeLastError;
        private boolean _isAvailable;
        private int _infosIssued = 0;
        private GenericObjectPool _socketPool;

        private HostAddress(String host) throws UnknownHostException {
            int colon = host.indexOf(58);
            try {
                if (colon != -1) {
                    this._address = (InetAddress)AccessController.doPrivileged(J2DoPrivHelper.getByNameAction(host.substring(0, colon)));
                    this._port = Integer.parseInt(host.substring(colon + 1));
                } else {
                    this._address = (InetAddress)AccessController.doPrivileged(J2DoPrivHelper.getByNameAction(host));
                    this._port = 5636;
                }
            }
            catch (PrivilegedActionException pae) {
                throw (UnknownHostException)pae.getException();
            }
            this._socketPool = new GenericObjectPool(new SocketPoolableObjectFactory(), TCPRemoteCommitProvider.this._maxActive, 1, -1L);
            this._isAvailable = true;
        }

        private void setMaxActive(int maxActive) {
            this._socketPool.setMaxActive(maxActive);
        }

        private void setMaxIdle(int maxIdle) {
            this._socketPool.setMaxIdle(maxIdle);
        }

        public void close() {
            block2: {
                try {
                    this._socketPool.close();
                }
                catch (Exception e) {
                    if (!TCPRemoteCommitProvider.this.log.isWarnEnabled()) break block2;
                    TCPRemoteCommitProvider.this.log.warn(s_loc.get("tcp-close-pool-error"), e);
                }
            }
        }

        private void sendUpdatePacket(byte[] bytes) {
            block8: {
                long now;
                if (!this._isAvailable && (now = System.currentTimeMillis()) - this._timeLastError < (long)TCPRemoteCommitProvider.this._recoveryTimeMillis) {
                    return;
                }
                Socket s = null;
                try {
                    s = this.getSocket();
                    OutputStream os = s.getOutputStream();
                    os.write(bytes);
                    os.flush();
                    if (TCPRemoteCommitProvider.this.log.isTraceEnabled()) {
                        TCPRemoteCommitProvider.this.log.trace(s_loc.get("tcp-sent-update", this._address.getHostAddress() + ":" + this._port, String.valueOf(s.getLocalPort())));
                    }
                    this._isAvailable = true;
                    this._infosIssued = 0;
                    this.returnSocket(s);
                }
                catch (Exception e) {
                    if (s != null) {
                        this.closeSocket(s);
                    }
                    this.clearAllSockets();
                    if (this._isAvailable) {
                        if (TCPRemoteCommitProvider.this.log.isWarnEnabled()) {
                            TCPRemoteCommitProvider.this.log.warn(s_loc.get("tcp-send-error", this._address.getHostAddress() + ":" + this._port), e);
                        }
                        this._isAvailable = false;
                        this._timeLastError = System.currentTimeMillis();
                    }
                    long now2 = System.currentTimeMillis();
                    if (now2 - this._timeLastError <= (long)TCPRemoteCommitProvider.this._recoveryTimeMillis || this._infosIssued >= 5) break block8;
                    this._timeLastError = System.currentTimeMillis();
                    if (TCPRemoteCommitProvider.this.log.isInfoEnabled()) {
                        TCPRemoteCommitProvider.this.log.info(s_loc.get("tcp-send-still-error", this._address.getHostAddress() + ":" + this._port), e);
                    }
                    ++this._infosIssued;
                }
            }
        }

        private Socket getSocket() throws Exception {
            return (Socket)this._socketPool.borrowObject();
        }

        private void returnSocket(Socket s) throws Exception {
            this._socketPool.returnObject(s);
        }

        private void clearAllSockets() {
            this._socketPool.clear();
        }

        private void closeSocket(Socket s) {
            try {
                this._socketPool.invalidateObject(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class SocketPoolableObjectFactory
        implements PoolableObjectFactory {
            private SocketPoolableObjectFactory() {
            }

            public Object makeObject() throws IOException {
                try {
                    Socket s = (Socket)AccessController.doPrivileged(J2DoPrivHelper.newSocketAction(HostAddress.this._address, HostAddress.this._port));
                    if (TCPRemoteCommitProvider.this.log.isTraceEnabled()) {
                        TCPRemoteCommitProvider.this.log.trace(s_loc.get("tcp-open-connection", HostAddress.this._address + ":" + HostAddress.this._port, "" + s.getLocalPort()));
                    }
                    return s;
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
            }

            public void destroyObject(Object obj) {
                try {
                    Socket s = (Socket)obj;
                    if (TCPRemoteCommitProvider.this.log.isTraceEnabled()) {
                        TCPRemoteCommitProvider.this.log.trace(s_loc.get("tcp-close-sending-socket", HostAddress.this._address + ":" + HostAddress.this._port, "" + s.getLocalPort()));
                    }
                    s.close();
                }
                catch (Exception e) {
                    TCPRemoteCommitProvider.this.log.warn(s_loc.get("tcp-close-socket-error", HostAddress.this._address.getHostAddress() + ":" + HostAddress.this._port), e);
                }
            }

            public boolean validateObject(Object obj) {
                return true;
            }

            public void activateObject(Object value) {
            }

            public void passivateObject(Object value) {
            }
        }
    }

    private static class TCPPortListener
    implements Runnable {
        private final Log _log;
        private ServerSocket _receiveSocket;
        private Thread _acceptThread;
        private Set _receiverThreads = new HashSet();
        private final Set _providers = new HashSet();
        private byte[] _localhost;
        private int _port;
        private boolean _isRunning = false;

        private TCPPortListener(int port, Log log) throws IOException {
            this._port = port;
            this._log = log;
            try {
                this._receiveSocket = (ServerSocket)AccessController.doPrivileged(J2DoPrivHelper.newServerSocketAction(this._port));
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
            this._localhost = InetAddress.getLocalHost().getAddress();
            if (this._log.isTraceEnabled()) {
                this._log.info(s_loc.get("tcp-start-listener", String.valueOf(this._port)));
            }
        }

        private void listen() {
            this._acceptThread = new Thread(this);
            this._acceptThread.setDaemon(true);
            this._acceptThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addProvider(TCPRemoteCommitProvider provider) {
            Set set = this._providers;
            synchronized (set) {
                this._providers.add(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void removeProvider(TCPRemoteCommitProvider provider) {
            Set set = this._providers;
            synchronized (set) {
                this._providers.remove(provider);
                if (this._providers.size() == 0) {
                    block6: {
                        this._isRunning = false;
                        try {
                            this._receiveSocket.close();
                        }
                        catch (IOException ioe) {
                            if (!this._log.isWarnEnabled()) break block6;
                            this._log.warn(s_loc.get("tcp-close-error"), ioe);
                        }
                    }
                    this._acceptThread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRunning() {
            Set set = this._providers;
            synchronized (set) {
                return this._isRunning;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = this._providers;
            synchronized (set) {
                this._isRunning = true;
            }
            Socket s = null;
            while (this._isRunning) {
                try {
                    s = null;
                    s = (Socket)AccessController.doPrivileged(J2DoPrivHelper.acceptAction(this._receiveSocket));
                    if (this._log.isTraceEnabled()) {
                        this._log.trace(s_loc.get("tcp-received-connection", s.getInetAddress().getHostAddress() + ":" + s.getPort()));
                    }
                    ReceiveSocketHandler sh = new ReceiveSocketHandler(s);
                    Thread receiverThread = new Thread(sh);
                    receiverThread.setDaemon(true);
                    receiverThread.start();
                    this._receiverThreads.add(receiverThread);
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        e = ((PrivilegedActionException)e).getException();
                    }
                    if ((!(e instanceof SocketException) || this._isRunning) && this._log.isWarnEnabled()) {
                        this._log.warn(s_loc.get("tcp-accept-error"), e);
                    }
                    try {
                        if (s == null) continue;
                        s.close();
                    }
                    catch (Exception ee) {
                        if (!this._log.isWarnEnabled()) continue;
                        this._log.warn(s_loc.get("tcp-close-error"), e);
                    }
                }
            }
            for (Thread worker : this._receiverThreads) {
                worker.interrupt();
            }
            Set set2 = this._providers;
            synchronized (set2) {
                block19: {
                    try {
                        if (this._isRunning) {
                            this._receiveSocket.close();
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block19;
                        this._log.warn(s_loc.get("tcp-close-error"), e);
                    }
                }
                this._isRunning = false;
                if (this._log.isTraceEnabled()) {
                    this._log.trace(s_loc.get("tcp-close-listener", this._port + ""));
                }
            }
        }

        private class ReceiveSocketHandler
        implements Runnable {
            private InputStream _in;
            private Socket _s;

            private ReceiveSocketHandler(Socket s) {
                this._s = s;
                try {
                    this._s.setTcpNoDelay(true);
                    this._in = new BufferedInputStream(s.getInputStream());
                }
                catch (IOException ioe) {
                    if (TCPPortListener.this._log.isInfoEnabled()) {
                        TCPPortListener.this._log.info(s_loc.get("tcp-socket-option-error"), ioe);
                    }
                    this._s = null;
                }
                catch (Exception e) {
                    if (TCPPortListener.this._log.isWarnEnabled()) {
                        TCPPortListener.this._log.warn(s_loc.get("tcp-receive-error"), e);
                    }
                    this._s = null;
                }
            }

            public void run() {
                if (this._s == null) {
                    return;
                }
                while (TCPPortListener.this._isRunning && this._s != null) {
                    try {
                        this.handle(this._in);
                    }
                    catch (EOFException eof) {
                        if (!TCPPortListener.this._log.isTraceEnabled()) break;
                        TCPPortListener.this._log.trace(s_loc.get("tcp-close-socket", this._s.getInetAddress().getHostAddress() + ":" + this._s.getPort()));
                        break;
                    }
                    catch (Throwable e) {
                        if (!TCPPortListener.this._log.isWarnEnabled()) break;
                        TCPPortListener.this._log.warn(s_loc.get("tcp-receive-error"), e);
                        break;
                    }
                }
                try {
                    this._in.close();
                    if (this._s != null) {
                        this._s.close();
                    }
                }
                catch (IOException e) {
                    TCPPortListener.this._log.warn(s_loc.get("tcp-close-socket-error", this._s.getInetAddress().getHostAddress() + ":" + this._s.getPort()), e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handle(InputStream in) throws IOException, ClassNotFoundException {
                Serialization.ClassResolvingObjectInputStream ois = new Serialization.ClassResolvingObjectInputStream(in);
                long protocolVersion = ois.readLong();
                if (protocolVersion != 338210047L && TCPPortListener.this._log.isWarnEnabled()) {
                    TCPPortListener.this._log.warn(s_loc.get("tcp-wrong-version-error", this._s.getInetAddress().getHostAddress() + ":" + this._s.getPort()));
                    return;
                }
                long senderId = ois.readLong();
                int senderPort = ois.readInt();
                byte[] senderAddress = (byte[])ois.readObject();
                RemoteCommitEvent rce = (RemoteCommitEvent)ois.readObject();
                if (TCPPortListener.this._log.isTraceEnabled()) {
                    TCPPortListener.this._log.trace(s_loc.get("tcp-received-event", this._s.getInetAddress().getHostAddress() + ":" + this._s.getPort()));
                }
                boolean fromSelf = senderPort == TCPPortListener.this._port && Arrays.equals(senderAddress, TCPPortListener.this._localhost);
                Set set = TCPPortListener.this._providers;
                synchronized (set) {
                    for (TCPRemoteCommitProvider provider : TCPPortListener.this._providers) {
                        if (senderId == provider._id && fromSelf) continue;
                        provider.eventManager.fireEvent(rce);
                    }
                }
            }
        }
    }

    private class BroadcastWorkerThread
    extends Thread {
        private boolean _keepRunning = true;

        private BroadcastWorkerThread() {
        }

        public void run() {
            while (this._keepRunning) {
                try {
                    byte[] bytes = TCPRemoteCommitProvider.this._broadcastQueue.removePacket();
                    if (bytes != null) {
                        TCPRemoteCommitProvider.this.sendUpdatePacket(bytes);
                        continue;
                    }
                    if (!TCPRemoteCommitProvider.this._broadcastQueue.isClosed()) continue;
                    this._keepRunning = false;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.remove();
        }

        public void setRunning(boolean keepRunning) {
            this._keepRunning = keepRunning;
        }

        private void remove() {
            TCPRemoteCommitProvider.this._broadcastThreads.remove(this);
        }
    }

    private static class BroadcastQueue {
        private LinkedList _packetQueue = new LinkedList();
        private boolean _closed = false;

        private BroadcastQueue() {
        }

        public synchronized void close() {
            this._closed = true;
            this.notifyAll();
        }

        public synchronized boolean isClosed() {
            return this._closed;
        }

        public synchronized void addPacket(byte[] bytes) {
            this._packetQueue.addLast(bytes);
            this.notify();
        }

        public synchronized byte[] removePacket() throws InterruptedException {
            while (!this._closed && this._packetQueue.isEmpty()) {
                this.wait();
            }
            if (this._packetQueue.isEmpty()) {
                return null;
            }
            return (byte[])this._packetQueue.removeFirst();
        }
    }
}

