/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.conf;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCBrokerFactory;
import com.ibm.ws.persistence.pdq.kernel.PDQConstraintUpdateManager;
import com.ibm.ws.persistence.pdq.kernel.PDQPessimisticLockManager;
import com.ibm.ws.persistence.pdq.kernel.PDQStoreManager;
import com.ibm.ws.persistence.pdq.kernel.PDQTableJDBCSeq;
import com.ibm.ws.persistence.pdq.meta.PDQMappingRepository;
import com.ibm.ws.persistence.pdq.sql.DB2Dictionary;
import com.ibm.ws.persistence.pdq.sql.PDQSQLFactoryImpl;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public final class PDQConfigurationHelper {
    static final String pdqExecutionMode = "pdq.executionMode";
    static final String defaultExecutionMode = "STATIC";
    static final String RSRC_PDQ = "META-INF/pdq.properties";
    private static final Localizer _loc = Localizer.forPackage(PDQConfigurationHelper.class);

    private static boolean foundPDQXml(WsJpaJDBCBrokerFactory factory) {
        String puNameXml = "META-INF/" + factory.getConfiguration().getId() + ".pdqxml";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration urls = null;
        try {
            urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, puNameXml));
            return urls.hasMoreElements();
        }
        catch (Exception pae) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configurePdqPlugins(WsJpaJDBCBrokerFactory factory) {
        Log log;
        WsJpaJDBCConfigurationImpl config = (WsJpaJDBCConfigurationImpl)factory.getConfiguration();
        boolean runPDQ = PDQConfigurationHelper.foundPDQXml(factory);
        if (runPDQ) {
            Properties props;
            block10: {
                PluginValue dbdictionaryPlugin = config.dbdictionaryPlugin;
                dbdictionaryPlugin.setAlias("db2", DB2Dictionary.class.getCanonicalName());
                dbdictionaryPlugin.setClassName(DB2Dictionary.class.getCanonicalName());
                config.setUpdateManager(PDQConstraintUpdateManager.class.getCanonicalName());
                config.setSQLFactory(PDQSQLFactoryImpl.class.getCanonicalName());
                ObjectValue metaRepositoryPlugin = config.metaRepositoryPlugin;
                metaRepositoryPlugin.setAlias("default", PDQMappingRepository.class.getCanonicalName());
                config.setMetaDataRepository(PDQMappingRepository.class.getCanonicalName());
                ObjectValue seqPlugin = config.seqPlugin;
                seqPlugin.setAlias("default", PDQTableJDBCSeq.class.getCanonicalName());
                config.setSequence(PDQTableJDBCSeq.class.getCanonicalName());
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                props = new Properties();
                try {
                    InputStream in;
                    Enumeration urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, RSRC_PDQ));
                    if (!urls.hasMoreElements() || (in = ((URL)urls.nextElement()).openStream()) == null) break block10;
                    try {
                        props.load(in);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Exception ioe) {
                    // empty catch block
                }
            }
            String executionMode = props.getProperty(pdqExecutionMode);
            if (executionMode == null) {
                props.setProperty(pdqExecutionMode, defaultExecutionMode);
            }
            config.setPdqProperties(props);
        }
        if ((log = config.getLog("openjpa.Runtime")).isTraceEnabled()) {
            String puNameXml = "META-INF/" + config.getId() + ".pdqxml";
            if (runPDQ) {
                log.trace(_loc.get("found-pdq-xml", new Object[]{puNameXml}));
            } else {
                log.trace(_loc.get("no-pdq-xml", new Object[]{puNameXml}));
            }
        }
        return runPDQ;
    }

    public static StoreManager newPdqStoreManager(JDBCConfiguration jdbcConfig) {
        PDQStoreManager mgr = null;
        if (((PDQMappingRepository)jdbcConfig.getMetaDataRepositoryInstance()).getDBDictionary().platform.indexOf("DB2") != -1) {
            mgr = new PDQStoreManager();
        }
        return mgr;
    }

    public static LockManager newPdqPessimisticLockManager() {
        return new PDQPessimisticLockManager();
    }
}

