/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence;

import com.ibm.websphere.persistence.WsJpaEntityManagerFactory;
import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.QueryImpl;
import com.ibm.ws.persistence.WsJpaEntityManager;
import com.ibm.ws.persistence.WsJpaQuery;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class EntityManagerImpl
extends org.apache.openjpa.persistence.EntityManagerImpl
implements com.ibm.websphere.persistence.WsJpaEntityManager,
WsJpaEntityManager {
    private static final Localizer _loc = Localizer.forPackage(org.apache.openjpa.persistence.EntityManagerImpl.class);
    private RuntimeExceptionTranslator ret = PersistenceExceptions.getRollbackTranslator(this);

    public EntityManagerImpl() {
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Broker broker) {
        super(factory, broker);
    }

    void assertNotCloseInvoked() {
        if (!this.getBroker().isClosed() && this.getBroker().isCloseInvoked()) {
            throw new InvalidStateException(_loc.get("close-invoked"), null, null, true);
        }
    }

    public WsJpaQuery createNamedQuery(String name) {
        this.assertNotCloseInvoked();
        this.getBroker().assertOpen();
        try {
            QueryMetaData meta = this.getBroker().getConfiguration().getMetaDataRepositoryInstance().getQueryMetaData(null, name, this.getBroker().getClassLoader(), true);
            org.apache.openjpa.kernel.Query del = this.getBroker().newQuery(meta.getLanguage(), null);
            meta.setInto(del);
            del.compile();
            QueryImpl q = new QueryImpl(this, this.ret, del);
            String[] hints = meta.getHintKeys();
            Object[] values = meta.getHintValues();
            for (int i = 0; i < hints.length; ++i) {
                q.setHint(hints[i], values[i]);
            }
            return q;
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    public WsJpaQuery createQuery(String query) {
        return this.createQuery("javax.persistence.JPQL", query);
    }

    public WsJpaQuery createQuery(String language, String query) {
        this.assertNotCloseInvoked();
        return new QueryImpl(this, this.ret, this.getBroker().newQuery(language, query));
    }

    public WsJpaQuery createQuery(Query query) {
        if (query == null) {
            return this.createQuery((String)null);
        }
        this.assertNotCloseInvoked();
        if (query instanceof QueryImpl) {
            org.apache.openjpa.kernel.Query q = ((QueryImpl)query).getDelegate();
            return new QueryImpl(this, this.ret, this.getBroker().newQuery(q.getLanguage(), q));
        }
        return null;
    }

    public WsJpaQuery createNativeQuery(String query, String mappingName) {
        this.assertNotCloseInvoked();
        EntityManagerImpl.validateSQL(query);
        org.apache.openjpa.kernel.Query kernelQuery = this.getBroker().newQuery("openjpa.SQL", query);
        kernelQuery.setResultMapping(null, mappingName);
        return new QueryImpl(this, this.ret, kernelQuery);
    }

    public WsJpaQuery createNativeQuery(String query) {
        EntityManagerImpl.validateSQL(query);
        return this.createQuery("openjpa.SQL", query);
    }

    public WsJpaQuery createNativeQuery(String query, Class cls) {
        WsJpaQuery q = this.createNativeQuery(query);
        q.setResultClass(cls);
        return q;
    }

    private static void validateSQL(String query) {
        if (StringUtils.trimToNull(query) == null) {
            throw new ArgumentException(_loc.get("no-sql"), null, null, false);
        }
    }

    public WsJpaEntityManagerFactory getEntityManagerFactory() {
        return (WsJpaEntityManagerFactory)super.getEntityManagerFactory();
    }
}

