/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import com.ibm.security.sasl.CramMD5Base;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class CramMD5Server
extends CramMD5Base
implements SaslServer {
    private String fqdn;
    private byte[] challengeData = null;
    private String authzid;
    private CallbackHandler cbh;

    CramMD5Server(String protocol, String serverFqdn, Map props, CallbackHandler cbh) throws SaslException {
        if (serverFqdn == null) {
            throw new SaslException("CRAM-MD5: fully qualified server name must be specified");
        }
        this.fqdn = serverFqdn;
        this.cbh = cbh;
    }

    @Override
    public byte[] evaluateResponse(byte[] responseData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 authentication already completed");
        }
        if (this.aborted) {
            throw new IllegalStateException("CRAM-MD5 authentication previously aborted due to error");
        }
        try {
            if (this.challengeData == null) {
                if (responseData.length != 0) {
                    this.aborted = true;
                    throw new SaslException("CRAM-MD5 does not expect any initial response");
                }
                Random random = new Random();
                long rand = random.nextLong();
                long timestamp = System.currentTimeMillis();
                StringBuffer buf = new StringBuffer();
                buf.append('<');
                buf.append(rand);
                buf.append('.');
                buf.append(timestamp);
                buf.append('@');
                buf.append(this.fqdn);
                buf.append('>');
                String challengeStr = buf.toString();
                logger.log(Level.FINE, "CRAMSRV01:Generated challenge: {0}", challengeStr);
                this.challengeData = challengeStr.getBytes("UTF8");
                return (byte[])this.challengeData.clone();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "CRAMSRV02:Received response: {0}", new String(responseData, "UTF8"));
            }
            int ulen = 0;
            for (int i = 0; i < responseData.length; ++i) {
                if (responseData[i] != 32) continue;
                ulen = i;
                break;
            }
            if (ulen == 0) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: Invalid response; space missing");
            }
            String username = new String(responseData, 0, ulen, "UTF8");
            logger.log(Level.FINE, "CRAMSRV03:Extracted username: {0}", username);
            NameCallback ncb = new NameCallback("CRAM-MD5 authentication ID: ", username);
            PasswordCallback pcb = new PasswordCallback("CRAM-MD5 password: ", false);
            this.cbh.handle(new Callback[]{ncb, pcb});
            char[] pwChars = pcb.getPassword();
            if (pwChars == null || pwChars.length == 0) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: username not found: " + username);
            }
            pcb.clearPassword();
            String pwStr = new String(pwChars);
            for (int i = 0; i < pwChars.length; ++i) {
                pwChars[i] = '\u0000';
            }
            this.pw = pwStr.getBytes("UTF8");
            String digest = CramMD5Server.HMAC_MD5(this.pw, this.challengeData);
            logger.log(Level.FINE, "CRAMSRV04:Expecting digest: {0}", digest);
            this.clearPassword();
            byte[] expectedDigest = digest.getBytes("UTF8");
            int digestLen = responseData.length - ulen - 1;
            if (expectedDigest.length != digestLen) {
                this.aborted = true;
                throw new SaslException("Invalid response");
            }
            int j = 0;
            for (int i = ulen + 1; i < responseData.length; ++i) {
                if (expectedDigest[j++] == responseData[i]) continue;
                this.aborted = true;
                throw new SaslException("Invalid response");
            }
            AuthorizeCallback acb = new AuthorizeCallback(username, username);
            this.cbh.handle(new Callback[]{acb});
            if (!acb.isAuthorized()) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: user not authorized: " + username);
            }
            this.authzid = acb.getAuthorizedID();
            logger.log(Level.FINE, "CRAMSRV05:Authorization id: {0}", this.authzid);
            this.completed = true;
            return null;
        }
        catch (UnsupportedEncodingException e) {
            this.aborted = true;
            throw new SaslException("UTF8 not available on platform", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.aborted = true;
            throw new SaslException("MD5 algorithm not available on platform", e);
        }
        catch (UnsupportedCallbackException e) {
            this.aborted = true;
            throw new SaslException("CRAM-MD5 authentication failed", e);
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            this.aborted = true;
            throw new SaslException("CRAM-MD5 authentication failed", e);
        }
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }
}

