/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X400Address;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPathHelperInitializer;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509CertSelector
implements CertSelector {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private BigInteger serialNumber;
    private X500Principal issuer;
    private boolean issuerAsString;
    private X500Principal subject;
    private boolean subjectAsString;
    private byte[] subjectKeyIdentifier;
    private byte[] authorityKeyIdentifier;
    private Date certificateValid;
    private Date privateKeyValid;
    private AlgorithmId subjectPublicKeyAlgID;
    private PublicKey subjectPublicKey;
    private boolean[] keyUsage;
    private ArrayList<List> subjectAlternativeNames;
    private ArrayList<List> subjectAlternativeNamesFromApp;
    private GeneralSubtrees[] nameConstraints;
    private byte[] baNameConstraints;
    private int basicConstraints;
    private Set<String> policy;
    private Set<String> keyPurposeSet;
    private X509Certificate certificate;
    private boolean matchAllNames;
    private ArrayList<List> pathToNames;
    private ArrayList<List> pathToNamesFromApp;

    public X509CertSelector() {
        try {
            this.setCertificate(null);
            this.setExtendedKeyUsage(null);
            this.setSerialNumber(null);
            this.setIssuer((byte[])null);
            this.setSubject((byte[])null);
            this.setSubjectKeyIdentifier(null);
            this.setAuthorityKeyIdentifier(null);
            this.setCertificateValid(null);
            this.setPrivateKeyValid(null);
            this.setSubjectPublicKeyAlgID(null);
            this.setSubjectPublicKey((PublicKey)null);
            this.setKeyUsage(null);
            this.setSubjectAlternativeNames(null);
            this.setNameConstraints(null);
            this.setBasicConstraints(-1);
            this.setPolicy(null);
            this.setPathToNames(null);
            this.setMatchAllSubjectAltNames(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSerialNumber(BigInteger serial) {
        this.serialNumber = serial != null ? new BigInteger(serial.toByteArray()) : null;
    }

    public void setIssuer(String issuerDN) throws IOException {
        this.issuerAsString = true;
        if (issuerDN == null) {
            this.issuer = null;
        } else {
            try {
                this.issuer = new X500Principal(issuerDN);
            }
            catch (IllegalArgumentException ex) {
                throw (IOException)new IOException("Invalid name").initCause(ex);
            }
        }
    }

    public void setIssuer(byte[] issuerDN) throws IOException {
        this.issuerAsString = false;
        if (issuerDN != null) {
            try {
                this.issuer = new X500Principal(issuerDN);
            }
            catch (IllegalArgumentException ex) {
                throw (IOException)new IOException("Invalid name").initCause(ex);
            }
        } else {
            this.issuer = null;
        }
    }

    public void setIssuer(X500Principal issuer) {
        this.issuer = issuer;
        this.issuerAsString = false;
    }

    public void setSubject(String subjectDN) throws IOException {
        try {
            this.subject = subjectDN != null ? new X500Principal(subjectDN) : null;
            this.subjectAsString = true;
        }
        catch (IllegalArgumentException ex) {
            throw (IOException)new IOException("invalid subject").initCause(ex);
        }
    }

    public void setSubject(byte[] subjectDN) throws IOException {
        try {
            this.subject = subjectDN == null ? null : new X500Principal(subjectDN);
            this.subjectAsString = false;
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException("Invalid name").initCause(e);
        }
    }

    public void setSubject(X500Principal subject) {
        this.subject = subject;
        this.subjectAsString = false;
    }

    public void setSubjectKeyIdentifier(byte[] subjectKeyID) {
        this.subjectKeyIdentifier = subjectKeyID != null ? (byte[])subjectKeyID.clone() : null;
    }

    public void setAuthorityKeyIdentifier(byte[] authorityKeyID) {
        this.authorityKeyIdentifier = authorityKeyID != null ? (byte[])authorityKeyID.clone() : null;
    }

    public void setCertificate(X509Certificate cert) {
        this.certificate = cert;
    }

    public void setCertificateValid(Date certValid) {
        this.certificateValid = certValid != null ? new Date(certValid.getTime()) : null;
    }

    public void setExtendedKeyUsage(Set<String> keyPurposeSet) throws IOException {
        if (keyPurposeSet != null) {
            HashSet<String> newKeyPurposeSet = new HashSet<String>();
            for (String o : keyPurposeSet) {
                if (!(o instanceof String)) {
                    throw new IOException("all elements in the keyPurposeSet must be String");
                }
                try {
                    ObjectIdentifier oi = new ObjectIdentifier(o);
                }
                catch (Exception ex) {
                    throw new IOException("invalid OID " + o.toString());
                }
                newKeyPurposeSet.add(o);
            }
            this.keyPurposeSet = newKeyPurposeSet;
        } else {
            this.keyPurposeSet = null;
        }
    }

    public void setPrivateKeyValid(Date privateKeyValid) {
        this.privateKeyValid = privateKeyValid != null ? (Date)privateKeyValid.clone() : null;
    }

    public void setSubjectPublicKeyAlgID(String oid) throws IOException {
        if (oid != null) {
            try {
                this.subjectPublicKeyAlgID = new AlgorithmId(new ObjectIdentifier(oid));
            }
            catch (Exception ex) {
                throw new IOException("invalid OID: " + oid);
            }
        } else {
            this.subjectPublicKeyAlgID = null;
        }
    }

    public void setSubjectPublicKey(PublicKey key) {
        this.subjectPublicKey = key;
    }

    public void setSubjectPublicKey(byte[] key) throws IOException {
        if (key == null) {
            this.subjectPublicKey = null;
        } else {
            X509Key publicKey = new X509Key();
            try {
                publicKey.decode((InputStream)new ByteArrayInputStream((byte[])key.clone()));
            }
            catch (InvalidKeyException e) {
                throw new IOException(e.getMessage());
            }
            this.subjectPublicKey = publicKey;
        }
    }

    public void setKeyUsage(boolean[] keyUsage) {
        this.keyUsage = (boolean[])(keyUsage == null ? null : (boolean[])keyUsage.clone());
    }

    public void setMatchAllSubjectAltNames(boolean matchAll) {
        this.matchAllNames = matchAll;
    }

    public void setSubjectAlternativeNames(Collection<List<?>> names) throws IOException {
        if (names != null && names.size() > 0) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
            for (List<?> aName : names) {
                if (!(aName instanceof List)) {
                    throw new IOException("each entry of names should be instance of List");
                }
                List<?> entry = aName;
                if (entry.size() < 2) {
                    throw new IOException("each entry of names should contain two elements");
                }
                Object first = entry.get(0);
                if (!(first instanceof Integer)) {
                    throw new IOException("first element in each entry of names should be an Integer");
                }
                int type = (Integer)first;
                if (type < 0 || type > 8) {
                    throw new IOException("name type not 0-8");
                }
                Object second = entry.get(1);
                if (second instanceof byte[]) {
                    this.addSubjectAlternativeName(type, (byte[])second);
                    continue;
                }
                if (second instanceof String) {
                    this.addSubjectAlternativeName(type, (String)second);
                    continue;
                }
                throw new IOException("second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.subjectAlternativeNamesFromApp = null;
            this.subjectAlternativeNames = null;
        }
    }

    public void addSubjectAlternativeName(int type, String name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNamesFromApp = new ArrayList();
            this.subjectAlternativeNames = new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(type));
        list.add(name);
        this.subjectAlternativeNamesFromApp.add(list);
        this.subjectAlternativeNames.add(this.processGeneralName(type, name));
    }

    public void addSubjectAlternativeName(int type, byte[] name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(type));
        list.add(name.clone());
        this.subjectAlternativeNamesFromApp.add(list);
        this.subjectAlternativeNames.add(this.processGeneralName(type, (byte[])name.clone()));
    }

    public void setNameConstraints(byte[] bytes) throws IOException {
        if (bytes != null) {
            this.baNameConstraints = (byte[])bytes.clone();
            if (this.nameConstraints == null) {
                this.nameConstraints = new GeneralSubtrees[2];
            }
            NameConstraintsExtension ext = new NameConstraintsExtension(Boolean.TRUE, (Object)bytes);
            GeneralSubtrees perm = (GeneralSubtrees)ext.get("permitted_subtrees");
            GeneralSubtrees excl = (GeneralSubtrees)ext.get("excluded_subtrees");
            this.nameConstraints[0] = perm;
            this.nameConstraints[1] = excl;
        } else {
            this.baNameConstraints = null;
            this.nameConstraints = null;
        }
    }

    public void setBasicConstraints(int minMaxPathLen) {
        if (minMaxPathLen < -2) {
            throw new IllegalArgumentException("Max path length less than -2");
        }
        this.basicConstraints = minMaxPathLen;
    }

    public void setPolicy(Set<String> certPolicySet) throws IOException {
        if (certPolicySet != null) {
            HashSet<String> newPolicy = new HashSet<String>();
            for (String o : certPolicySet) {
                if (!(o instanceof String)) {
                    throw new IOException("all elements in the Set must be String");
                }
                try {
                    ObjectIdentifier oi = new ObjectIdentifier(o);
                }
                catch (Exception ex) {
                    throw new IOException("invalid OID: " + o.toString());
                }
                newPolicy.add(o);
            }
            this.policy = newPolicy;
        } else {
            this.policy = null;
        }
    }

    public void setPathToNames(Collection<List<?>> names) throws IOException {
        if (names != null && names.size() > 0) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
            for (List<?> aName : names) {
                if (!(aName instanceof List)) {
                    throw new IOException("each entry of names should be instance of List");
                }
                List<?> entry = aName;
                if (entry.size() < 2) {
                    throw new IOException("each entry of names should contain two elements");
                }
                Object first = entry.get(0);
                if (!(first instanceof Integer)) {
                    throw new IOException("first element in each entry of names should be an Integer");
                }
                int type = (Integer)first;
                if (type < 0 || type > 8) {
                    throw new IOException("name type not 0-8");
                }
                Object second = entry.get(1);
                if (second instanceof byte[]) {
                    this.addPathToName(type, (byte[])second);
                    continue;
                }
                if (second instanceof String) {
                    this.addPathToName(type, (String)second);
                    continue;
                }
                throw new IOException("second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.pathToNames = null;
            this.pathToNamesFromApp = null;
        }
    }

    void setPathToNamesInternal(Set names) {
        Class<?> cl = null;
        try {
            cl = Class.forName("sun.security.x509.GeneralNameInterface");
        }
        catch (ClassNotFoundException ex) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.x509.GeneralNameInterface not found");
            }
            return;
        }
        Class<?> cl2 = null;
        try {
            cl2 = Class.forName("sun.security.util.DerOutputStream");
        }
        catch (ClassNotFoundException ex) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.util.DerOutputStream not found");
            }
            return;
        }
        Method md = this.getMethod(cl, "getType", null);
        if (md == null) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: cannot find getType() method");
            }
            return;
        }
        Method md2 = this.getMethod(cl, "encode", new Class[]{cl2});
        if (md2 == null && debug != null) {
            System.out.println("X509CertSelector.setPathToNamesInternal: cannot find encode() method");
        }
        this.pathToNames = new ArrayList();
        this.pathToNamesFromApp = new ArrayList();
        for (Object obj : names) {
            if (!cl.isInstance(obj)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: objects in the set are not GeneralNameInterface");
                }
                return;
            }
            Object typeO = null;
            Object dos = null;
            try {
                dos = cl2.newInstance();
            }
            catch (InstantiationException istex) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + istex.toString());
                }
                return;
            }
            catch (IllegalAccessException iaex) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal:" + iaex.toString());
                }
                return;
            }
            try {
                typeO = md.invoke(obj, (Object[])null);
                md2.invoke(obj, dos);
            }
            catch (IllegalAccessException iaex) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + iaex.toString());
                }
                return;
            }
            catch (InvocationTargetException itex) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + itex.toString());
                }
                return;
            }
            int type = 0;
            byte[] data = null;
            if (!(typeO instanceof Integer)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: fail to getType");
                }
                return;
            }
            type = (Integer)typeO;
            if (!(dos instanceof ByteArrayOutputStream)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.util.DerOutputStream not a ByteArrayOutputStream");
                }
                return;
            }
            data = ((ByteArrayOutputStream)dos).toByteArray();
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add((Integer)typeO);
            temp.add(data);
            this.pathToNamesFromApp.add(temp);
            temp = new ArrayList();
            temp.add((Integer)typeO);
            temp.add(this.getGNS(type, data));
            this.pathToNames.add(temp);
        }
    }

    private GeneralNameInterface getGNS(int type, byte[] data) {
        DerValue der = null;
        try {
            der = new DerValue(data);
        }
        catch (IOException ex) {
            if (debug != null) {
                System.out.println("X509CertSelector.getGNS: fail to construct DerValue");
            }
            return null;
        }
        OtherName gn = null;
        switch (type) {
            case 0: {
                try {
                    gn = new OtherName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct othername");
                }
                break;
            }
            case 1: {
                try {
                    gn = new RFC822Name(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct RFC822name");
                }
                break;
            }
            case 2: {
                try {
                    gn = new DNSName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct dnsname");
                }
                break;
            }
            case 3: {
                try {
                    gn = new X400Address(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct x400address");
                }
                break;
            }
            case 4: {
                try {
                    gn = new X500Name(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct x500name");
                }
                break;
            }
            case 5: {
                try {
                    gn = new EDIPartyName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct ediparty name");
                }
                break;
            }
            case 6: {
                try {
                    gn = new URIName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct uri name");
                }
                break;
            }
            case 7: {
                try {
                    gn = new IPAddressName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct ip address name");
                }
                break;
            }
            case 8: {
                try {
                    gn = new OIDName(der);
                }
                catch (IOException ex) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct oid name");
                }
                break;
            }
            default: {
                if (debug == null) break;
                System.out.println("X509CertSelector.getGNS: illegal type");
            }
        }
        return gn;
    }

    private Method getMethod(Class cl, String method, Class[] parameters) {
        final String methodf = method;
        final Class clf = cl;
        final Class[] params = parameters;
        Method md = (Method)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Method m;
                block3: {
                    m = null;
                    try {
                        m = clf.getMethod(methodf, params);
                        if (m != null) {
                            m.setAccessible(true);
                        }
                    }
                    catch (NoSuchMethodException nsme) {
                        if (debug == null) break block3;
                        System.out.println("X509CertSelector.getMethod: can not find " + methodf);
                    }
                }
                return m;
            }
        });
        return md;
    }

    public void addPathToName(int type, String name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        this.pathToNames.add(this.processGeneralName(type, name));
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(new Integer(type));
        list.add(name);
        this.pathToNamesFromApp.add(list);
    }

    public void addPathToName(int type, byte[] name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(type));
        list.add(name.clone());
        this.pathToNames.add(this.processGeneralName(type, (byte[])name.clone()));
        this.pathToNamesFromApp.add(list);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getIssuerAsString() {
        return this.issuer != null ? this.issuer.getName("RFC2253") : null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.issuer != null ? this.issuer.getEncoded() : null;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public String getSubjectAsString() {
        return this.subject != null ? this.subject.getName("RFC2253") : null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.subject != null ? this.subject.getEncoded() : null;
    }

    public X500Principal getSubject() {
        return this.subject;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier != null ? (byte[])this.subjectKeyIdentifier.clone() : null;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier != null ? (byte[])this.authorityKeyIdentifier.clone() : null;
    }

    public Date getCertificateValid() {
        return this.certificateValid != null ? new Date(this.certificateValid.getTime()) : null;
    }

    public Set<String> getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            return Collections.unmodifiableSet(this.keyPurposeSet);
        }
        return null;
    }

    public Date getPrivateKeyValid() {
        return this.privateKeyValid != null ? (Date)this.privateKeyValid.clone() : null;
    }

    public String getSubjectPublicKeyAlgID() {
        return this.subjectPublicKeyAlgID != null ? this.subjectPublicKeyAlgID.getOID().toString() : null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public Collection<List<?>> getSubjectAlternativeNames() {
        if (this.subjectAlternativeNamesFromApp != null) {
            ArrayList retList = new ArrayList();
            for (ArrayList arrayList : this.subjectAlternativeNamesFromApp) {
                ArrayList<Object> entry = new ArrayList<Object>(2);
                entry.add(arrayList.get(0));
                if (arrayList.get(1) instanceof byte[]) {
                    entry.add(((byte[])arrayList.get(1)).clone());
                } else {
                    entry.add(arrayList.get(1));
                }
                retList.add(entry);
            }
            return retList;
        }
        return null;
    }

    public byte[] getNameConstraints() {
        return this.baNameConstraints != null ? (byte[])this.baNameConstraints.clone() : null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public Set<String> getPolicy() {
        if (this.policy != null) {
            return Collections.unmodifiableSet(this.policy);
        }
        return null;
    }

    public Collection<List<?>> getPathToNames() {
        if (this.pathToNamesFromApp != null) {
            ArrayList retList = new ArrayList();
            for (ArrayList arrayList : this.pathToNamesFromApp) {
                ArrayList<Object> entry = new ArrayList<Object>(2);
                entry.add(arrayList.get(0));
                if (arrayList.get(1) instanceof byte[]) {
                    entry.add(((byte[])arrayList.get(1)).clone());
                } else {
                    entry.add(arrayList.get(1));
                }
                retList.add(entry);
            }
            return retList;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X509CertSelector: [");
        sb.append("\n    AuthorityKeyIdentifier:");
        this.dumpBA(this.getAuthorityKeyIdentifier(), sb);
        sb.append("\n    BasicConstraints:");
        sb.append(this.getBasicConstraints());
        sb.append("\n    CertificateEquals:");
        sb.append(this.getCertificate());
        sb.append("\n    CertificateValid:");
        sb.append(this.getCertificateValid());
        sb.append("\n    ExtendedKeyUsage:");
        sb.append(this.getExtendedKeyUsage());
        sb.append("\n    IssuerAsString:");
        sb.append(this.getIssuerAsString());
        sb.append("\n    KeyUsage:");
        boolean[] b = this.getKeyUsage();
        if (b == null || b.length == 0) {
            sb.append("null");
        } else {
            sb.append(b[0]);
            for (int i = 1; i < b.length; ++i) {
                sb.append(", ");
                sb.append(b[i]);
            }
        }
        sb.append("\n    MatchAllSubjectAltNames:");
        sb.append(this.getMatchAllSubjectAltNames());
        sb.append("\n    NameConstraints:");
        this.dumpBA(this.getNameConstraints(), sb);
        sb.append("\n    PathToNames:");
        sb.append(this.getPathToNames());
        sb.append("\n    Policy:");
        sb.append(this.getPolicy());
        sb.append("\n    PrivateKeyValid:");
        sb.append(this.getPrivateKeyValid());
        sb.append("\n    SerialNumber:");
        sb.append(this.getSerialNumber());
        sb.append("\n    SubjectAlternativeNames:");
        sb.append(this.getSubjectAlternativeNames());
        sb.append("\n    SubjectAsString:");
        sb.append(this.getSubjectAsString());
        sb.append("\n    SubjectKeyIdentifier:");
        this.dumpBA(this.getSubjectKeyIdentifier(), sb);
        sb.append("\n    SubjectPublicKey:");
        sb.append(this.getSubjectPublicKey());
        sb.append("\n    SubjectPublicKeyAlgID:");
        sb.append(this.getSubjectPublicKeyAlgID());
        sb.append("\n]");
        return sb.toString();
    }

    private void dumpBA(byte[] ba, StringBuffer sb) {
        if (ba == null) {
            sb.append("null");
        } else {
            HexDumpEncoder encoder = new HexDumpEncoder();
            sb.append("\n");
            sb.append(encoder.encodeBuffer(ba));
        }
    }

    @Override
    public boolean match(Certificate cert) {
        boolean[] certKeyUsage;
        SubjectKeyIdentifierExtension ext;
        X509CertImpl c;
        block142: {
            KeyIdentifier kid;
            if (cert == null) {
                return false;
            }
            if (!(cert instanceof X509Certificate)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match not X509Certificate");
                }
                return false;
            }
            if (cert instanceof X509CertImpl) {
                c = (X509CertImpl)cert;
            } else {
                try {
                    c = new X509CertImpl(((X509Certificate)cert).getEncoded());
                }
                catch (CertificateException cex) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match exception");
                        cex.printStackTrace();
                    }
                    return false;
                }
            }
            if (debug != null) {
                System.out.println("X509CertSelector.match(SN: " + c.getSerialNumber().toString(16) + "\n  Issuer: " + c.getIssuerDN() + "\n  Subject: " + c.getSubjectDN() + ")");
            }
            if (this.certificate != null && !this.certificate.equals(cert)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: certs don't match");
                }
                return false;
            }
            if (this.serialNumber != null && this.serialNumber.compareTo(c.getSerialNumber()) != 0) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: serial numbers don't match");
                }
                return false;
            }
            if (this.issuer != null && !this.issuer.equals(c.getIssuerX500Principal())) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: issuer DNs don't match");
                }
                if (this.issuerAsString) {
                    if (!this.issuer.getName("RFC2253").equalsIgnoreCase(((X500Name)c.getIssuerDN()).getRFC2253Name())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.subject != null && !this.subject.equals(c.getSubjectX500Principal())) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: subject DNs don't match");
                }
                if (this.subjectAsString) {
                    if (!this.subject.getName("RFC2253").equalsIgnoreCase(((X500Name)c.getSubjectDN()).getRFC2253Name())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.subjectKeyIdentifier != null) {
                try {
                    ext = (SubjectKeyIdentifierExtension)c.get("x509.info.extensions.SubjectKeyIdentifier");
                    kid = (KeyIdentifier)ext.get("key_id");
                    DerOutputStream dos = new DerOutputStream();
                    kid.encode(dos);
                    byte[] ba = dos.toByteArray();
                    if (!Arrays.equals(this.subjectKeyIdentifier, ba)) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: subject key IDs don't match");
                        }
                        return false;
                    }
                }
                catch (IOException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception in subject key ID check");
                    }
                    return false;
                }
                catch (NullPointerException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: no subject key ID extension");
                    }
                    return false;
                }
                catch (CertificateParsingException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: subjectKeyIdentifier extension parsing exception");
                    }
                    return false;
                }
            }
            if (this.authorityKeyIdentifier != null) {
                try {
                    ext = (AuthorityKeyIdentifierExtension)c.get("x509.info.extensions.AuthorityKeyIdentifier");
                    kid = (KeyIdentifier)ext.get("key_id");
                    byte[] ba = kid.getIdentifier();
                    if (!Arrays.equals(this.authorityKeyIdentifier, ba)) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: authority key IDs don't match");
                        }
                        return false;
                    }
                }
                catch (IOException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception in authority key ID check");
                    }
                    return false;
                }
                catch (NullPointerException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: no authority key ID extension");
                    }
                    return false;
                }
                catch (CertificateParsingException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: authorityKeyIdentifier extension parsing exception");
                    }
                    return false;
                }
            }
            if (this.certificateValid != null && (this.certificateValid.before(c.getNotBefore()) || this.certificateValid.after(c.getNotAfter()))) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: certificate not within validity date");
                }
                return false;
            }
            if (this.privateKeyValid != null) {
                try {
                    Date notAfter;
                    Date notBefore;
                    PrivateKeyUsageExtension ext2 = (PrivateKeyUsageExtension)c.get("x509.info.extensions.PrivateKeyUsage");
                    if (ext2 == null) break block142;
                    try {
                        notBefore = (Date)ext2.get("not_before");
                    }
                    catch (CertificateException e) {
                        notBefore = null;
                    }
                    try {
                        notAfter = (Date)ext2.get("not_after");
                    }
                    catch (CertificateException e) {
                        notAfter = null;
                    }
                    if (notBefore != null && this.privateKeyValid.before(notBefore)) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: the private key valid date is before the notBefore in private key usage extension");
                        }
                        return false;
                    }
                    if (notAfter != null && this.privateKeyValid.after(notAfter)) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: the private key valid date is after the notAfter in private key usage extension");
                        }
                        return false;
                    }
                }
                catch (CertificateParsingException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: CertificateParsingException in private key usage check; X509CertSelector: ");
                        e.printStackTrace();
                    }
                    return false;
                }
            }
        }
        if (this.subjectPublicKeyAlgID != null && !this.subjectPublicKeyAlgID.equals(((X509Key)c.getPublicKey()).getAlgorithmId())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: subjectPublicKey algorithm IDs do not match ");
            }
            return false;
        }
        if (this.subjectPublicKey != null && !Arrays.equals(this.subjectPublicKey.getEncoded(), c.getPublicKey().getEncoded())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: subjectPublicKeys do not match ");
            }
            return false;
        }
        if (this.keyUsage != null && (certKeyUsage = c.getKeyUsage()) != null) {
            for (int keyBit = 0; keyBit < this.keyUsage.length; ++keyBit) {
                if (!this.keyUsage[keyBit] || keyBit < certKeyUsage.length && certKeyUsage[keyBit]) continue;
                if (debug != null) {
                    System.out.println("X509CertSelector.match: key usage bits don't match");
                }
                return false;
            }
        }
        if (this.keyPurposeSet != null && !this.keyPurposeSet.isEmpty()) {
            try {
                ext = (ExtKeyUsageExtension)c.get("x509.info.extensions.ExtKeyUsage");
                Vector v = (Vector)ext.get("extkeyusage");
                boolean found = true;
                Iterator<String> i = this.keyPurposeSet.iterator();
                while (i.hasNext()) {
                    ObjectIdentifier keyPurpose = new ObjectIdentifier(i.next());
                    if (v.contains(keyPurpose)) continue;
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: key purpose sets do not match");
                    }
                    found = false;
                    return found;
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: failed on matching key purpose set");
                    e.printStackTrace();
                }
                return false;
            }
            catch (NullPointerException e) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: failed on matching key purpose set");
                    e.printStackTrace();
                }
                return false;
            }
            catch (CertificateParsingException e) {
                if (debug != null) {
                    System.out.println("X509CertSeledctor.match:");
                    e.printStackTrace();
                }
                return false;
            }
        }
        if (this.subjectAlternativeNames != null || this.nameConstraints != null) {
            GeneralNames gns = null;
            ArrayList<List> GNScollection = new ArrayList<List>();
            SubjectAlternativeNameExtension subjectAltNameExt = (SubjectAlternativeNameExtension)c.getExtension(OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName"));
            if (subjectAltNameExt != null) {
                try {
                    gns = (GeneralNames)subjectAltNameExt.get("subject_name");
                }
                catch (IOException ex) {
                    gns = null;
                }
            } else {
                gns = null;
            }
            if (this.subjectAlternativeNames != null) {
                if (gns == null) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: none of subject alternative names match");
                    }
                    return false;
                }
                try {
                    Object name_in_listSAN;
                    Object name_in_listGNS;
                    Iterator iterGNS;
                    List listGNS;
                    for (GeneralName gn : gns) {
                        try {
                            listGNS = this.processGeneralName(gn);
                            GNScollection.add(listGNS);
                        }
                        catch (IOException e) {
                            if (debug == null) continue;
                            e.printStackTrace();
                        }
                    }
                    boolean found = false;
                    if (this.getMatchAllSubjectAltNames()) {
                        for (List listSAN : this.subjectAlternativeNames) {
                            iterGNS = GNScollection.iterator();
                            found = false;
                            while (iterGNS.hasNext()) {
                                listGNS = (List)iterGNS.next();
                                if (!listGNS.get(0).equals(listSAN.get(0))) continue;
                                name_in_listGNS = listGNS.get(1);
                                name_in_listSAN = listSAN.get(1);
                                if (name_in_listGNS instanceof byte[] && name_in_listSAN instanceof byte[]) {
                                    if (!Arrays.equals((byte[])name_in_listGNS, (byte[])name_in_listSAN)) continue;
                                    found = true;
                                    break;
                                }
                                if (!name_in_listGNS.equals(name_in_listSAN)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            if (debug != null) {
                                System.out.println("X509CertSelector.match: at least one subject alternative name does not match");
                            }
                            return false;
                        }
                    } else {
                        for (List listSAN : this.subjectAlternativeNames) {
                            iterGNS = GNScollection.iterator();
                            found = false;
                            while (iterGNS.hasNext()) {
                                listGNS = (List)iterGNS.next();
                                if (!listGNS.get(0).equals(listSAN.get(0))) continue;
                                name_in_listGNS = listGNS.get(1);
                                name_in_listSAN = listSAN.get(1);
                                if (name_in_listGNS instanceof byte[] && name_in_listSAN instanceof byte[]) {
                                    if (!Arrays.equals((byte[])name_in_listGNS, (byte[])name_in_listSAN)) continue;
                                    found = true;
                                    break;
                                }
                                if (!name_in_listGNS.equals(name_in_listSAN)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        if (!found) {
                            if (debug != null) {
                                System.out.println("X509CertSelector.match: no matched subject alternative name found");
                            }
                            return false;
                        }
                    }
                }
                catch (NullPointerException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: failed on checking subject alternative name");
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            if (this.nameConstraints != null && !((Object)c.getIssuerDN()).equals(c.getSubjectDN())) {
                X500Name xn = (X500Name)c.getSubjectDN();
                if (debug != null) {
                    System.out.println("X509CertSelector.match: check subjectname and name constraints");
                }
                if (!this.nameMatchesConstraints((GeneralNameInterface)xn)) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: cert subject name does not comply to name constraints");
                    }
                    return false;
                }
                if (gns == null) {
                    for (int i = 0; i < xn.size(); ++i) {
                        RDN rdn = xn.getRDN(i);
                        for (int j = 0; j < rdn.size(); ++j) {
                            AVA ava = rdn.getAVA(j);
                            if (!ava.getOID().equals(X500Name.emailAddress_oid)) continue;
                            try {
                                RFC822Name email = new RFC822Name(ava.getValue());
                                if (this.nameMatchesConstraints((GeneralNameInterface)email)) continue;
                                if (debug != null) {
                                    System.out.println("X509CertSelector.match: cert email address does not comply to name constraints");
                                }
                                return false;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < gns.size(); ++i) {
                        GeneralNameInterface gni = ((GeneralName)gns.get(i)).getName();
                        if (this.nameMatchesConstraints(gni)) continue;
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: cert alternative name extension does not comply to name constraints");
                        }
                        return false;
                    }
                }
            }
        }
        if (this.basicConstraints >= 0 && this.basicConstraints > c.getBasicConstraints()) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: failed to verify basic constraints");
            }
            return false;
        }
        if (this.basicConstraints == -2 && ((Object)c.getIssuerDN()).equals(c.getSubjectDN())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: not an EE cert");
            }
            return false;
        }
        if (this.policy != null) {
            try {
                ext = (CertificatePoliciesExtension)c.get("x509.info.extensions.CertificatePolicies");
                Vector v = (Vector)ext.get("cert_policies");
                if (!this.policy.isEmpty() || v.isEmpty()) {
                    boolean found = false;
                    for (int i = 0; i < v.size(); ++i) {
                        ObjectIdentifier oid = ((PolicyInformation)v.get(i)).getPolicyIdentifier();
                        if (!this.policy.contains(oid.toString())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: failed on policy criterion");
                        }
                        return false;
                    }
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception when checking cert policies");
                    e.printStackTrace();
                }
                return false;
            }
            catch (NullPointerException e) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception when checking cert policies");
                    e.printStackTrace();
                }
                return false;
            }
            catch (CertificateParsingException e) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match:");
                    e.printStackTrace();
                }
                return false;
            }
        }
        if (this.pathToNames != null) {
            ext = null;
            try {
                ext = (NameConstraintsExtension)c.get("x509.info.extensions.NameConstraints");
            }
            catch (CertificateParsingException cpex) {
                ext = null;
            }
            if (ext != null) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match pathToNames:\n");
                    Iterator<List> i = this.pathToNames.iterator();
                    while (i.hasNext()) {
                        System.out.println("   " + i.next() + "\n");
                    }
                }
                try {
                    GeneralSubtrees permitted = (GeneralSubtrees)ext.get("permitted_subtrees");
                    GeneralSubtrees excluded = (GeneralSubtrees)ext.get("excluded_subtrees");
                    if (excluded != null && !this.matchExcluded(excluded)) {
                        return false;
                    }
                    if (permitted != null && !this.matchPermitted(permitted)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception when checking pathToNames");
                        e.printStackTrace();
                    }
                    return false;
                }
                catch (NullPointerException e) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception when checking pathToNames");
                        e.printStackTrace();
                    }
                    return false;
                }
            }
        }
        if (debug != null) {
            System.out.println("X509CertSelector.match: returning true");
        }
        return true;
    }

    private boolean matchExcluded(GeneralSubtrees excluded) {
        for (GeneralSubtree tree : excluded) {
            GeneralNameInterface excludedName = tree.getBase().getName();
            Iterator<List> i = this.pathToNames.iterator();
            while (i.hasNext()) {
                GeneralNameInterface pathToName = (GeneralNameInterface)i.next().get(1);
                if (excludedName.getType() != pathToName.getType()) continue;
                switch (pathToName.constrains(excludedName)) {
                    case 0: 
                    case 2: {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: name constraints inhibit path to specified name");
                            System.out.println("X509CertSelector.match: excluded name: " + pathToName);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean matchPermitted(GeneralSubtrees permitted) {
        Iterator<List> i = this.pathToNames.iterator();
        while (i.hasNext()) {
            GeneralNameInterface pathToName = (GeneralNameInterface)i.next().get(1);
            Iterator t = permitted.iterator();
            boolean permittedNameFound = false;
            boolean nameTypeFound = false;
            String names = "";
            while (t.hasNext() && !permittedNameFound) {
                GeneralSubtree tree = (GeneralSubtree)t.next();
                GeneralNameInterface permittedName = tree.getBase().getName();
                if (permittedName.getType() != pathToName.getType()) continue;
                nameTypeFound = true;
                names = names + "  " + permittedName;
                switch (pathToName.constrains(permittedName)) {
                    case 0: 
                    case 2: {
                        permittedNameFound = true;
                        break;
                    }
                }
            }
            if (permittedNameFound || !nameTypeFound) continue;
            if (debug != null) {
                System.out.println("X509CertSelector.match: name constraints inhibit path to specified name; permitted names of type " + pathToName.getType() + ": " + names);
            }
            return false;
        }
        return true;
    }

    private boolean nameMatchesConstraints(GeneralNameInterface name) {
        GeneralSubtrees permitted = this.nameConstraints[0];
        GeneralSubtrees excluded = this.nameConstraints[1];
        if (excluded != null && excluded.size() > 0) {
            if (debug != null) {
                System.out.println("CertPath: excluded tree present");
            }
            for (int i = 0; i < excluded.size(); ++i) {
                GeneralSubtree gs = excluded.get(i);
                if (gs == null) {
                    if (debug == null) continue;
                    System.out.println("CertPath: subtree null");
                    continue;
                }
                GeneralName gn = gs.getBase();
                if (gn == null) {
                    if (debug == null) continue;
                    System.out.println("CertPath: base null");
                    continue;
                }
                GeneralNameInterface gni = gn.getName();
                if (gni == null) {
                    if (debug == null) continue;
                    System.out.println("CertPath: name null");
                    continue;
                }
                try {
                    switch (gni.constrains(name)) {
                        case -1: 
                        case 2: 
                        case 3: {
                            if (debug == null) break;
                            System.out.println("CertPath: name widens excluded tree");
                            break;
                        }
                        case 0: 
                        case 1: {
                            if (debug != null) {
                                System.out.println("CertPath: name match or narrow excluded tree");
                            }
                            return false;
                        }
                    }
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    if (debug != null) {
                        System.out.print("CertPath: ");
                        ex.printStackTrace();
                    }
                    if (!gni.equals(name)) continue;
                    if (debug != null) {
                        System.out.println("CertPath: name equals");
                    }
                    return false;
                }
            }
        }
        if (permitted != null && permitted.size() > 0) {
            boolean sameType = false;
            for (int i = 0; i < permitted.size(); ++i) {
                GeneralNameInterface gni;
                GeneralName gn;
                GeneralSubtree gs = permitted.get(i);
                if (gs == null || (gn = gs.getBase()) == null || (gni = gn.getName()) == null) continue;
                try {
                    switch (gni.constrains(name)) {
                        case -1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            sameType = true;
                            break;
                        }
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    if (!gni.equals(name)) continue;
                    return true;
                }
            }
            if (sameType) {
                return false;
            }
        }
        return true;
    }

    private boolean nameMatchesConstraint(List name, List pattern) {
        int patternType;
        int nameType = (Integer)name.get(0);
        if (nameType != (patternType = ((Integer)pattern.get(0)).intValue())) {
            return false;
        }
        switch (nameType) {
            case 0: 
            case 3: 
            case 5: 
            case 8: {
                String nameString = (String)name.get(1);
                String patternString = (String)pattern.get(1);
                return nameString.equals(patternString);
            }
            case 1: {
                String nameString = (String)name.get(1);
                String patternString = (String)pattern.get(1);
                return nameString.equals(patternString) || nameString.endsWith("@" + patternString) || patternString.startsWith(".") && nameString.endsWith(patternString);
            }
            case 2: {
                String nameString = (String)name.get(1);
                String patternString = (String)pattern.get(1);
                return nameString.equals(patternString) || nameString.endsWith(patternString);
            }
            case 4: {
                X500Name object = (X500Name)name.get(1);
                X500Name constraint = (X500Name)pattern.get(1);
                if (constraint.size() > object.size()) {
                    return false;
                }
                boolean matchSoFar = true;
                for (int i = 0; i < constraint.size(); ++i) {
                    if (constraint.getRDN(i).equals((Object)object.getRDN(i))) continue;
                    matchSoFar = false;
                    break;
                }
                return matchSoFar;
            }
            case 6: {
                String nameString = (String)name.get(1);
                String patternString = (String)pattern.get(1);
                try {
                    nameString = new URL(nameString).getHost().toLowerCase();
                    patternString = new URL(patternString).getHost().toLowerCase();
                }
                catch (MalformedURLException e) {
                    return false;
                }
                return nameString.equals(patternString) || nameString.endsWith("." + patternString);
            }
            case 7: {
                String nameString = (String)name.get(1);
                String patternString = (String)pattern.get(1);
                return nameString.equals(patternString);
            }
        }
        return false;
    }

    private List processGeneralName(GeneralName name) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        GeneralNameInterface gni = name.getName();
        int type = gni.getType();
        result.add(0, new Integer(type));
        switch (type) {
            case 0: {
                result.add(1, (Integer)((OtherName)gni));
                break;
            }
            case 5: {
                result.add(1, (Integer)((EDIPartyName)gni));
                break;
            }
            case 8: {
                result.add(1, (Integer)((OIDName)gni));
                break;
            }
            case 1: {
                result.add(1, (Integer)((RFC822Name)gni));
                break;
            }
            case 2: {
                result.add(1, (Integer)((DNSName)gni));
                break;
            }
            case 6: {
                result.add(1, (Integer)((URIName)gni));
                break;
            }
            case 4: {
                result.add(1, (Integer)((X500Name)gni));
                break;
            }
            case 7: {
                result.add(1, (Integer)((IPAddressName)gni));
                break;
            }
            case 3: {
                result.add(1, (Integer)((X400Address)gni));
                break;
            }
            default: {
                result.add(1, (Integer)gni);
            }
        }
        return result;
    }

    private List processGeneralName(int type, String name) throws IOException {
        ArrayList<Integer> list = new ArrayList<Integer>(2);
        list.add(0, new Integer(type));
        switch (type) {
            case 8: {
                try {
                    list.add(1, (Integer)new OIDName(new ObjectIdentifier(name)));
                    break;
                }
                catch (Exception ex) {
                    throw new IOException("unable to parse name");
                }
            }
            case 1: {
                list.add(1, (Integer)new RFC822Name(name));
                break;
            }
            case 7: {
                list.add(1, (Integer)new IPAddressName(name));
                break;
            }
            case 2: {
                list.add(1, (Integer)new DNSName(name));
                break;
            }
            case 6: {
                list.add(1, (Integer)new URIName(name));
                break;
            }
            case 4: {
                list.add(1, (Integer)new X500Name(name));
                break;
            }
            default: {
                throw new IOException("unable to parse String of name type " + type);
            }
        }
        return list;
    }

    private List processGeneralName(int type, byte[] name) throws IOException {
        ArrayList<Integer> list = new ArrayList<Integer>(2);
        list.add(0, new Integer(type));
        switch (type) {
            case 0: {
                list.add(1, (Integer)new OtherName(new DerValue(name)));
                break;
            }
            case 5: {
                list.add(1, (Integer)new EDIPartyName(new DerValue(name)));
                break;
            }
            case 8: {
                list.add(1, (Integer)new OIDName(new DerValue(name)));
                break;
            }
            case 1: {
                list.add(1, (Integer)new RFC822Name(new DerValue(name)));
                break;
            }
            case 2: {
                list.add(1, (Integer)new DNSName(new DerValue(name)));
                break;
            }
            case 6: {
                list.add(1, (Integer)new URIName(new DerValue(name)));
                break;
            }
            case 4: {
                list.add(1, (Integer)new X500Name(new DerValue(name)));
                break;
            }
            case 7: {
                list.add(1, (Integer)new IPAddressName(new DerValue(name)));
                break;
            }
            case 3: {
                list.add(1, (Integer)new X400Address(new DerValue(name)));
                break;
            }
            default: {
                throw new IOException("unable to parse byte array of name type " + type);
            }
        }
        return list;
    }

    @Override
    public Object clone() {
        try {
            Object copy = super.clone();
            if (this.subjectAlternativeNames != null) {
                this.subjectAlternativeNames = new ArrayList<List>(this.subjectAlternativeNames);
                this.subjectAlternativeNamesFromApp = new ArrayList<List>(this.subjectAlternativeNamesFromApp);
            }
            if (this.pathToNames != null) {
                this.pathToNames = new ArrayList<List>(this.pathToNames);
                this.pathToNamesFromApp = new ArrayList<List>(this.pathToNamesFromApp);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    static {
        if (!CertPathHelperInitializer.isInitialized()) {
            CertPathHelperInitializer.init();
        }
    }
}

