/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    static final long serialVersionUID = 6068470306649138683L;
    private String type;

    protected CertPath(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator<String> getEncodings();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CertPath)) {
            return false;
        }
        CertPath otherCP = (CertPath)other;
        if (!otherCP.getType().equals(this.type)) {
            return false;
        }
        List<? extends Certificate> thisCertList = this.getCertificates();
        List<? extends Certificate> otherCertList = otherCP.getCertificates();
        return ((Object)thisCertList).equals(otherCertList);
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        hash = 31 * hash + ((Object)this.getCertificates()).hashCode();
        return hash;
    }

    public String toString() {
        StringBuffer certPathString = new StringBuffer();
        List<? extends Certificate> thisCertPathList = this.getCertificates();
        certPathString.append("\n" + this.type + " Cert Path: length = " + thisCertPathList.size() + ".\n[\n");
        Iterator<? extends Certificate> thisCertPathIterator = thisCertPathList.iterator();
        int count = 1;
        while (thisCertPathIterator.hasNext()) {
            Certificate thisCert = thisCertPathIterator.next();
            certPathString.append("=========================================================Certificate " + count + " start.\n" + thisCert.toString() + "\n=========================================================Certificate " + count + " end.\n\n\n");
            ++count;
        }
        certPathString.append("\n]");
        return certPathString.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List<? extends Certificate> getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException ce) {
            NotSerializableException nse = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            nse.initCause(ce);
            throw nse;
        }
    }

    protected static class CertPathRep
    implements Serializable {
        static final long serialVersionUID = 3015633072427920915L;
        private String type;
        private byte[] data;

        protected CertPathRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(this.type);
                return cf.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException ce) {
                NotSerializableException nse = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                nse.initCause(ce);
                throw nse;
            }
        }
    }
}

