/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    transient int size;
    transient Entry<K, V> root;
    Comparator<? super K> comparator;
    transient int modCount;
    transient Set<Map.Entry<K, V>> entrySet;
    transient NavigableMap<K, V> descendingMap;
    transient NavigableSet<K> navigableKeySet;

    public TreeMap() {
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this(sortedMap.comparator());
        Iterator iterator = sortedMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Entry entry2 = new Entry(entry.getKey(), entry.getValue());
            this.root = entry2;
            this.size = 1;
            while (iterator.hasNext()) {
                entry = iterator.next();
                Entry entry3 = new Entry(entry.getKey(), entry.getValue());
                entry3.parent = entry2;
                entry2.right = entry3;
                ++this.size;
                this.balance(entry3);
                entry2 = entry3;
            }
        }
    }

    void balance(Entry<K, V> entry) {
        entry.color = true;
        while (entry != this.root && entry.parent.color) {
            Entry entry2;
            if (entry.parent == entry.parent.parent.left) {
                entry2 = entry.parent.parent.right;
                if (entry2 != null && entry2.color) {
                    entry.parent.color = false;
                    entry2.color = false;
                    entry.parent.parent.color = true;
                    entry = entry.parent.parent;
                    continue;
                }
                if (entry == entry.parent.right) {
                    entry = entry.parent;
                    this.leftRotate(entry);
                }
                entry.parent.color = false;
                entry.parent.parent.color = true;
                this.rightRotate(entry.parent.parent);
                continue;
            }
            entry2 = entry.parent.parent.left;
            if (entry2 != null && entry2.color) {
                entry.parent.color = false;
                entry2.color = false;
                entry.parent.parent.color = true;
                entry = entry.parent.parent;
                continue;
            }
            if (entry == entry.parent.left) {
                entry = entry.parent;
                this.rightRotate(entry);
            }
            entry.parent.color = false;
            entry.parent.parent.color = true;
            this.leftRotate(entry.parent.parent);
        }
        this.root.color = false;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Object clone() {
        try {
            TreeMap treeMap = (TreeMap)super.clone();
            treeMap.entrySet = null;
            treeMap.navigableKeySet = null;
            treeMap.descendingMap = null;
            treeMap.valuesCollection = null;
            treeMap.keySet = null;
            if (this.root != null) {
                treeMap.root = this.root.clone(null);
            }
            return treeMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.root != null) {
            return this.containsValue(this.root, object);
        }
        return false;
    }

    private boolean containsValue(Entry<K, V> entry, Object object) {
        if (object == null ? entry.value == null : object.equals(entry.value)) {
            return true;
        }
        if (entry.left != null && this.containsValue(entry.left, object)) {
            return true;
        }
        return entry.right != null && this.containsValue(entry.right, object);
    }

    Entry<K, V> find(Object object) {
        Object object2 = object;
        Entry<K, V> entry = this.root;
        if (null != this.comparator) {
            while (entry != null) {
                int n = this.comparator.compare(object2, entry.key);
                if (n == 0) {
                    return entry;
                }
                entry = n < 0 ? entry.left : entry.right;
            }
            return null;
        }
        Comparable comparable = (Comparable)object2;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n == 0) {
                return entry;
            }
            entry = n < 0 ? entry.left : entry.right;
        }
        return null;
    }

    Entry<K, V> findSmallestEntry() {
        return null == this.root ? null : TreeMap.minimum(this.root);
    }

    Entry<K, V> findBiggestEntry() {
        return null == this.root ? null : TreeMap.maximum(this.root);
    }

    Entry<K, V> findCeilingEntry(K k) {
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        if (null != this.comparator) {
            while (entry != null) {
                int n = this.comparator.compare(k, entry.key);
                if (n == 0) {
                    return entry;
                }
                if (n < 0) {
                    entry2 = entry;
                    entry = entry.left;
                    continue;
                }
                entry = entry.right;
            }
            return entry2;
        }
        Comparable comparable = (Comparable)k;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n == 0) {
                return entry;
            }
            if (n < 0) {
                entry2 = entry;
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return entry2;
    }

    Entry<K, V> findFloorEntry(K k) {
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        if (this.comparator != null) {
            while (entry != null) {
                int n = this.comparator.compare(k, entry.key);
                if (0 == n) {
                    return entry;
                }
                if (0 < n) {
                    entry2 = entry;
                    entry = entry.right;
                    continue;
                }
                entry = entry.left;
            }
            return entry2;
        }
        Comparable comparable = (Comparable)k;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (0 == n) {
                return entry;
            }
            if (0 < n) {
                entry2 = entry;
                entry = entry.right;
                continue;
            }
            entry = entry.left;
        }
        return entry2;
    }

    Entry<K, V> findLowerEntry(K k) {
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        if (this.comparator != null) {
            while (entry != null) {
                int n = this.comparator.compare(k, entry.key);
                if (n <= 0) {
                    entry = entry.left;
                    continue;
                }
                entry2 = entry;
                entry = entry.right;
            }
            return entry2;
        }
        Comparable comparable = (Comparable)k;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n <= 0) {
                entry = entry.left;
                continue;
            }
            entry2 = entry;
            entry = entry.right;
        }
        return entry2;
    }

    Entry<K, V> findHigherEntry(K k) {
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        if (this.comparator != null) {
            while (entry != null) {
                int n = this.comparator.compare(k, entry.key);
                if (n < 0) {
                    entry2 = entry;
                    entry = entry.left;
                    continue;
                }
                entry = entry.right;
            }
            return entry2;
        }
        Comparable comparable = (Comparable)k;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n < 0) {
                entry2 = entry;
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return entry2;
    }

    @Override
    public K firstKey() {
        if (this.root != null) {
            return (K)TreeMap.minimum(this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void fixup(Entry<K, V> entry) {
        while (entry != this.root && !entry.color) {
            Entry entry2;
            if (entry == entry.parent.left) {
                entry2 = entry.parent.right;
                if (entry2 == null) {
                    entry = entry.parent;
                    continue;
                }
                if (entry2.color) {
                    entry2.color = false;
                    entry.parent.color = true;
                    this.leftRotate(entry.parent);
                    entry2 = entry.parent.right;
                    if (entry2 == null) {
                        entry = entry.parent;
                        continue;
                    }
                }
                if (!(entry2.left != null && entry2.left.color || entry2.right != null && entry2.right.color)) {
                    entry2.color = true;
                    entry = entry.parent;
                    continue;
                }
                if (entry2.right == null || !entry2.right.color) {
                    entry2.left.color = false;
                    entry2.color = true;
                    this.rightRotate(entry2);
                    entry2 = entry.parent.right;
                }
                entry2.color = entry.parent.color;
                entry.parent.color = false;
                entry2.right.color = false;
                this.leftRotate(entry.parent);
                entry = this.root;
                continue;
            }
            entry2 = entry.parent.left;
            if (entry2 == null) {
                entry = entry.parent;
                continue;
            }
            if (entry2.color) {
                entry2.color = false;
                entry.parent.color = true;
                this.rightRotate(entry.parent);
                entry2 = entry.parent.left;
                if (entry2 == null) {
                    entry = entry.parent;
                    continue;
                }
            }
            if (!(entry2.left != null && entry2.left.color || entry2.right != null && entry2.right.color)) {
                entry2.color = true;
                entry = entry.parent;
                continue;
            }
            if (entry2.left == null || !entry2.left.color) {
                entry2.right.color = false;
                entry2.color = true;
                this.leftRotate(entry2);
                entry2 = entry.parent.left;
            }
            entry2.color = entry.parent.color;
            entry.parent.color = false;
            entry2.left.color = false;
            this.rightRotate(entry.parent);
            entry = this.root;
        }
        entry.color = false;
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry = this.find(object);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public Iterator<K> iterator() {
                    return new UnboundedKeyIterator(TreeMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public K lastKey() {
        if (this.root != null) {
            return (K)TreeMap.maximum(this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void leftRotate(Entry<K, V> entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry == entry.parent.left) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    static <K, V> Entry<K, V> maximum(Entry<K, V> entry) {
        while (entry.right != null) {
            entry = entry.right;
        }
        return entry;
    }

    static <K, V> Entry<K, V> minimum(Entry<K, V> entry) {
        while (entry.left != null) {
            entry = entry.left;
        }
        return entry;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry.left != null) {
            return TreeMap.maximum(entry.left);
        }
        Entry entry2 = entry.parent;
        while (entry2 != null && entry == entry2.left) {
            entry = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry.right != null) {
            return TreeMap.minimum(entry.right);
        }
        Entry entry2 = entry.parent;
        while (entry2 != null && entry == entry2.right) {
            entry = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    @Override
    public V put(K k, V v) {
        Entry<K, V> entry = this.rbInsert(k);
        Object v2 = entry.value;
        entry.value = v;
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    void rbDelete(Entry<K, V> entry) {
        Entry entry2;
        Entry<K, V> entry3 = entry.left == null || entry.right == null ? entry : TreeMap.successor(entry);
        Entry entry4 = entry2 = entry3.left != null ? entry3.left : entry3.right;
        if (entry2 != null) {
            entry2.parent = entry3.parent;
        }
        if (entry3.parent == null) {
            this.root = entry2;
        } else if (entry3 == entry3.parent.left) {
            entry3.parent.left = entry2;
        } else {
            entry3.parent.right = entry2;
        }
        ++this.modCount;
        if (entry3 != entry) {
            entry.key = entry3.key;
            entry.value = entry3.value;
        }
        if (!entry3.color && entry2 != null) {
            this.fixup(entry2);
        }
        --this.size;
        entry3.right = null;
        entry3.left = null;
        entry3.parent = null;
    }

    private Entry<K, V> rbInsert(K k) {
        Entry<K, V> entry;
        int n = 0;
        Entry<K, V> entry2 = null;
        if (this.size != 0) {
            if (this.comparator == null) {
                entry = TreeMap.toComparable(k);
                Entry<K, V> entry3 = this.root;
                while (entry3 != null) {
                    entry2 = entry3;
                    n = entry.compareTo(entry3.key);
                    if (n == 0) {
                        return entry3;
                    }
                    entry3 = n < 0 ? entry3.left : entry3.right;
                }
            } else {
                entry = this.root;
                while (entry != null) {
                    entry2 = entry;
                    n = this.comparator.compare(k, entry.key);
                    if (n == 0) {
                        return entry;
                    }
                    entry = n < 0 ? entry.left : entry.right;
                }
            }
        }
        ++this.size;
        ++this.modCount;
        entry = new Entry(k);
        if (entry2 == null) {
            this.root = entry;
            return this.root;
        }
        entry.parent = entry2;
        if (n < 0) {
            entry2.left = entry;
        } else {
            entry2.right = entry;
        }
        this.balance(entry);
        return entry;
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.find(object);
        if (entry == null) {
            return null;
        }
        Object object2 = entry.value;
        this.rbDelete(entry);
        return (V)object2;
    }

    private void rightRotate(Entry<K, V> entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry == entry.parent.right) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new UnboundedValueIterator(TreeMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.newImmutableEntry(this.findSmallestEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.newImmutableEntry(this.findBiggestEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> entry = this.findSmallestEntry();
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry = this.newImmutableEntry(entry);
        if (null != entry) {
            this.rbDelete(entry);
        }
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> entry = this.findBiggestEntry();
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry = this.newImmutableEntry(entry);
        if (null != entry) {
            this.rbDelete(entry);
        }
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        return this.newImmutableEntry(this.findHigherEntry(k));
    }

    @Override
    public K higherKey(K k) {
        Map.Entry<K, V> entry = this.higherEntry(k);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        return this.newImmutableEntry(this.findLowerEntry(k));
    }

    @Override
    public K lowerKey(K k) {
        Map.Entry<K, V> entry = this.lowerEntry(k);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        return this.newImmutableEntry(this.findCeilingEntry(k));
    }

    @Override
    public K ceilingKey(K k) {
        Map.Entry<K, V> entry = this.ceilingEntry(k);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        return this.newImmutableEntry(this.findFloorEntry(k));
    }

    @Override
    public K floorKey(K k) {
        Map.Entry<K, V> entry = this.floorEntry(k);
        return null == entry ? null : (K)entry.getKey();
    }

    final AbstractMap.SimpleImmutableEntry<K, V> newImmutableEntry(Entry<K, V> entry) {
        return null == entry ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    private static <T> Comparable<T> toComparable(T t) {
        return (Comparable)t;
    }

    int keyCompare(K k, K k2) {
        return null != this.comparator ? this.comparator.compare(k, k2) : TreeMap.toComparable(k).compareTo(k2);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object k = entry.getKey();
                        Object v = TreeMap.this.get(k);
                        Object v2 = entry.getValue();
                        return v == null ? v2 == null && TreeMap.this.containsKey(k) : v.equals(v2);
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new UnboundedEntryIterator(TreeMap.this);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return null != this.navigableKeySet ? this.navigableKeySet : (this.navigableKeySet = new AscendingSubMap(this).navigableKeySet());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return null != this.descendingMap ? this.descendingMap : (this.descendingMap = new DescendingSubMap(this));
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        if (this.keyCompare(k, k2) <= 0) {
            return new AscendingSubMap(k, bl, this, k2, bl2);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        this.keyCompare(k, k);
        return new AscendingSubMap(this, k, bl);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        this.keyCompare(k, k);
        return new AscendingSubMap(k, bl, this);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return this.headMap(k, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return this.tailMap(k, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        if (this.size > 0) {
            Entry<K, V> entry = TreeMap.minimum(this.root);
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = TreeMap.successor(entry);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.size = objectInputStream.readInt();
        Entry entry = null;
        int n = this.size;
        while (--n >= 0) {
            Entry entry2 = new Entry(objectInputStream.readObject());
            entry2.value = objectInputStream.readObject();
            if (entry == null) {
                this.root = entry2;
            } else {
                entry2.parent = entry;
                entry.right = entry2;
                this.balance(entry2);
            }
            entry = entry2;
        }
    }

    static class SubMapValuesCollection<K, V>
    extends AbstractCollection<V> {
        NavigableSubMap<K, V> subMap;

        public SubMapValuesCollection(NavigableSubMap<K, V> navigableSubMap) {
            this.subMap = navigableSubMap;
        }

        @Override
        public boolean isEmpty() {
            return this.subMap.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new UnboundedValueIterator(this.subMap.m, this.subMap.theSmallestEntry());
        }

        @Override
        public int size() {
            return this.subMap.size();
        }
    }

    static class UnboundedKeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        public UnboundedKeyIterator(TreeMap<K, V> treeMap, Entry<K, V> entry) {
            super(treeMap, entry);
        }

        public UnboundedKeyIterator(TreeMap<K, V> treeMap) {
            super(treeMap, treeMap.root == null ? null : TreeMap.minimum(treeMap.root));
        }

        @Override
        public K next() {
            this.getNext();
            return (K)this.lastNode.key;
        }
    }

    private static class UnboundedValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        public UnboundedValueIterator(TreeMap<K, V> treeMap, Entry<K, V> entry) {
            super(treeMap, entry);
        }

        public UnboundedValueIterator(TreeMap<K, V> treeMap) {
            super(treeMap, treeMap.root == null ? null : TreeMap.minimum(treeMap.root));
        }

        @Override
        public V next() {
            this.getNext();
            return (V)this.lastNode.value;
        }
    }

    private static class UnboundedEntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        UnboundedEntryIterator(TreeMap<K, V> treeMap, Entry<K, V> entry) {
            super(treeMap, entry);
        }

        UnboundedEntryIterator(TreeMap<K, V> treeMap) {
            super(treeMap, treeMap.root == null ? null : TreeMap.minimum(treeMap.root));
        }

        @Override
        public Map.Entry<K, V> next() {
            this.getNext();
            return this.lastNode;
        }
    }

    private static class AbstractMapIterator<K, V> {
        TreeMap<K, V> backingMap;
        int expectedModCount;
        Entry<K, V> node;
        Entry<K, V> lastNode;

        AbstractMapIterator(TreeMap<K, V> treeMap, Entry<K, V> entry) {
            this.backingMap = treeMap;
            this.expectedModCount = treeMap.modCount;
            this.node = entry;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public final void remove() {
            if (this.lastNode == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            this.backingMap.rbDelete(this.lastNode);
            if (null != this.node && this.node.key == this.lastNode.key) {
                this.node = this.lastNode;
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }

        final void getNext() {
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.node = TreeMap.successor(this.node);
        }
    }

    static class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(K k, boolean bl, TreeMap<K, V> treeMap, K k2, boolean bl2) {
            super(k, bl, treeMap, k2, bl2);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(K k, boolean bl, TreeMap<K, V> treeMap) {
            super(k, bl, treeMap);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(TreeMap<K, V> treeMap, K k, boolean bl) {
            super(treeMap, k, bl);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(TreeMap<K, V> treeMap) {
            super(treeMap);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.m.newImmutableEntry(this.theBiggestEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.m.newImmutableEntry(this.theSmallestEntry());
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Entry entry = this.theBiggestEntry();
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = this.m.newImmutableEntry(entry);
            if (null != entry) {
                this.m.rbDelete(entry);
            }
            return simpleImmutableEntry;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Entry entry = this.theSmallestEntry();
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = this.m.newImmutableEntry(entry);
            if (null != entry) {
                this.m.rbDelete(entry);
            }
            return simpleImmutableEntry;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return this.m.newImmutableEntry(this.smallerEntry(k));
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return this.m.newImmutableEntry(this.biggerEntry(k));
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return this.m.newImmutableEntry(this.smallerOrEqualEntry(k));
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return this.m.newImmutableEntry(this.biggerOrEqualEntry(k));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new DescendingSubMapEntrySet(this);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new DescendingSubMapKeySet(this);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.fromStart && this.toEnd) {
                return new AscendingSubMap(this.lo, this.loInclusive, this.m, this.hi, this.hiInclusive);
            }
            if (this.fromStart) {
                return new AscendingSubMap(this.lo, this.loInclusive, this.m);
            }
            if (this.toEnd) {
                return new AscendingSubMap(this.m, this.hi, this.hiInclusive);
            }
            return new AscendingSubMap(this.m);
        }

        int keyCompare(K k, K k2) {
            return null != this.reverseComparator ? this.reverseComparator.compare(k, k2) : TreeMap.toComparable(k).compareTo(k2);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (this.keyCompare(k, k2) <= 0) {
                boolean bl3;
                K k3 = bl ? k : this.higherKey(k);
                K k4 = bl2 ? k2 : this.lowerKey(k2);
                boolean bl4 = null == k3 || this.checkLowerBound(k3);
                boolean bl5 = bl3 = null == k4 || this.checkUpperBound(k4);
                if (bl4 && bl3) {
                    return new DescendingSubMap<K, V>(k2, bl2, this.m, k, bl);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            K k2;
            this.keyCompare(k, k);
            K k3 = k2 = bl ? k : this.lowerKey(k);
            if (null == k2 || this.checkLowerBound(k2)) {
                if (this.toEnd) {
                    return new DescendingSubMap<Object, V>(k, bl, this.m, this.hi, this.hiInclusive);
                }
                return new DescendingSubMap<K, V>(k, bl, this.m);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            K k2;
            this.keyCompare(k, k);
            K k3 = k2 = bl ? k : this.higherKey(k);
            if (null == k2 || this.checkUpperBound(k2)) {
                if (this.fromStart) {
                    return new DescendingSubMap<Object, V>(this.lo, this.loInclusive, this.m, k, bl);
                }
                return new DescendingSubMap<K, V>(this.m, k, bl);
            }
            throw new IllegalArgumentException();
        }
    }

    static class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(K k, boolean bl, TreeMap<K, V> treeMap, K k2, boolean bl2) {
            super(k, bl, treeMap, k2, bl2);
        }

        AscendingSubMap(TreeMap<K, V> treeMap, K k, boolean bl) {
            super(treeMap, k, bl);
        }

        AscendingSubMap(K k, boolean bl, TreeMap<K, V> treeMap) {
            super(k, bl, treeMap);
        }

        AscendingSubMap(TreeMap<K, V> treeMap) {
            super(treeMap);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.m.newImmutableEntry(this.theSmallestEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.m.newImmutableEntry(this.theBiggestEntry());
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Entry entry = this.theSmallestEntry();
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = this.m.newImmutableEntry(entry);
            if (null != entry) {
                this.m.rbDelete(entry);
            }
            return simpleImmutableEntry;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Entry entry = this.theBiggestEntry();
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = this.m.newImmutableEntry(entry);
            if (null != entry) {
                this.m.rbDelete(entry);
            }
            return simpleImmutableEntry;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return this.m.newImmutableEntry(this.biggerEntry(k));
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return this.m.newImmutableEntry(this.smallerEntry(k));
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return this.m.newImmutableEntry(this.biggerOrEqualEntry(k));
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return this.m.newImmutableEntry(this.smallerOrEqualEntry(k));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AscendingSubMapEntrySet(this);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new AscendingSubMapKeySet(this);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.fromStart && this.toEnd) {
                return new DescendingSubMap(this.lo, this.loInclusive, this.m, this.hi, this.hiInclusive);
            }
            if (this.fromStart) {
                return new DescendingSubMap(this.lo, this.loInclusive, this.m);
            }
            if (this.toEnd) {
                return new AscendingSubMap<Object, V>(this.m, this.hi, this.hiInclusive);
            }
            return new DescendingSubMap(this.m);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (this.m.keyCompare(k, k2) <= 0) {
                boolean bl3;
                if (this.fromStart && this.m.keyCompare(k, this.lo) < 0 || this.toEnd && this.m.keyCompare(k2, this.hi) > 0) {
                    throw new IllegalArgumentException();
                }
                K k3 = bl ? k : this.higherKey(k);
                K k4 = bl2 ? k2 : this.lowerKey(k2);
                boolean bl4 = null == k3 || this.checkLowerBound(k3);
                boolean bl5 = bl3 = null == k4 || this.checkUpperBound(k4);
                if (bl4 && bl3) {
                    return new AscendingSubMap<K, V>(k, bl, this.m, k2, bl2);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            K k2;
            if (this.toEnd && this.m.keyCompare(k, this.hi) > 0) {
                throw new IllegalArgumentException();
            }
            K k3 = k2 = bl ? k : this.lowerKey(k);
            if (null == k2 || this.checkUpperBound(k2)) {
                if (this.fromStart) {
                    return new AscendingSubMap<Object, V>(this.lo, this.loInclusive, this.m, k, bl);
                }
                return new AscendingSubMap<K, V>(this.m, k, bl);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            K k2;
            if (this.fromStart && this.m.keyCompare(k, this.lo) < 0) {
                throw new IllegalArgumentException();
            }
            K k3 = k2 = bl ? k : this.higherKey(k);
            if (null == k2 || this.checkLowerBound(k2)) {
                if (this.toEnd) {
                    return new AscendingSubMap<Object, V>(k, bl, this.m, this.hi, this.hiInclusive);
                }
                return new AscendingSubMap<K, V>(k, bl, this.m);
            }
            throw new IllegalArgumentException();
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;

        NavigableSubMap(K k, boolean bl, TreeMap<K, V> treeMap, K k2, boolean bl2) {
            this.m = treeMap;
            this.toEnd = true;
            this.fromStart = true;
            this.lo = k;
            this.hi = k2;
            this.loInclusive = bl;
            this.hiInclusive = bl2;
        }

        NavigableSubMap(K k, boolean bl, TreeMap<K, V> treeMap) {
            this.m = treeMap;
            this.fromStart = true;
            this.toEnd = false;
            this.lo = k;
            this.hi = null;
            this.loInclusive = bl;
            this.hiInclusive = false;
        }

        NavigableSubMap(TreeMap<K, V> treeMap, K k, boolean bl) {
            this.m = treeMap;
            this.fromStart = false;
            this.toEnd = true;
            this.lo = null;
            this.hi = k;
            this.loInclusive = false;
            this.hiInclusive = bl;
        }

        NavigableSubMap(TreeMap<K, V> treeMap) {
            this.m = treeMap;
            this.toEnd = false;
            this.fromStart = false;
            this.hi = null;
            this.lo = null;
            this.hiInclusive = false;
            this.loInclusive = false;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public boolean containsKey(Object object) {
            this.checkNull(object);
            if (this.isInRange(object)) {
                return this.m.containsKey(object);
            }
            return false;
        }

        private void checkNull(Object object) {
            if (null == object && null == this.comparator()) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.firstEntry() == null;
        }

        @Override
        public int size() {
            return this.entrySet().size();
        }

        @Override
        public V put(K k, V v) {
            this.checkNull(k);
            if (this.isInRange(k)) {
                return this.m.put(k, v);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public V get(Object object) {
            this.checkNull(object);
            if (this.isInRange(object)) {
                return this.m.get(object);
            }
            return null;
        }

        @Override
        public V remove(Object object) {
            this.checkNull(object);
            if (this.isInRange(object)) {
                return this.m.remove(object);
            }
            return null;
        }

        @Override
        public abstract Map.Entry<K, V> firstEntry();

        @Override
        public abstract Map.Entry<K, V> lastEntry();

        @Override
        public abstract Map.Entry<K, V> pollFirstEntry();

        @Override
        public abstract Map.Entry<K, V> pollLastEntry();

        @Override
        public abstract Map.Entry<K, V> higherEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> lowerEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> ceilingEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> floorEntry(K var1);

        @Override
        public K firstKey() {
            Map.Entry<K, V> entry = this.firstEntry();
            if (entry != null) {
                return entry.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> entry = this.lastEntry();
            if (entry != null) {
                return entry.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public K higherKey(K k) {
            Map.Entry<K, V> entry = this.higherEntry(k);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K lowerKey(K k) {
            Map.Entry<K, V> entry = this.lowerEntry(k);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K ceilingKey(K k) {
            Map.Entry<K, V> entry = this.ceilingEntry(k);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K floorKey(K k) {
            Map.Entry<K, V> entry = this.floorEntry(k);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public abstract NavigableSet<K> navigableKeySet();

        @Override
        public abstract Set<Map.Entry<K, V>> entrySet();

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        @Override
        public abstract NavigableMap<K, V> subMap(K var1, boolean var2, K var3, boolean var4);

        @Override
        public abstract NavigableMap<K, V> headMap(K var1, boolean var2);

        @Override
        public abstract NavigableMap<K, V> tailMap(K var1, boolean var2);

        final boolean checkUpperBound(K k) {
            if (this.toEnd) {
                int n = this.m.keyCompare(k, this.hi);
                return this.hiInclusive ? n <= 0 : n < 0;
            }
            return true;
        }

        final boolean checkLowerBound(K k) {
            if (this.fromStart) {
                int n = -this.m.keyCompare(this.lo, k);
                return this.loInclusive ? n >= 0 : n > 0;
            }
            return true;
        }

        final boolean isInRange(K k) {
            return this.checkUpperBound(k) && this.checkLowerBound(k);
        }

        final Entry<K, V> theSmallestEntry() {
            Entry<K, V> entry = null;
            entry = !this.fromStart ? this.m.findSmallestEntry() : (this.loInclusive ? this.m.findCeilingEntry(this.lo) : this.m.findHigherEntry(this.lo));
            return null != entry && (!this.toEnd || this.checkUpperBound(entry.getKey())) ? entry : null;
        }

        final Entry<K, V> theBiggestEntry() {
            Entry<K, V> entry = null;
            entry = !this.toEnd ? this.m.findBiggestEntry() : (this.hiInclusive ? this.m.findFloorEntry(this.hi) : this.m.findLowerEntry(this.hi));
            return null != entry && (!this.fromStart || this.checkLowerBound(entry.getKey())) ? entry : null;
        }

        final Entry<K, V> smallerOrEqualEntry(K k) {
            Entry<K, V> entry = this.findFloorEntry(k);
            return null != entry && (!this.fromStart || this.checkLowerBound(entry.getKey())) ? entry : null;
        }

        private Entry<K, V> findFloorEntry(K k) {
            boolean bl = false;
            boolean bl2 = false;
            Entry entry = this.m.root;
            Entry entry2 = null;
            while (entry != null) {
                bl = this.checkUpperBound(entry.key);
                bl2 = this.checkLowerBound(entry.key);
                int n = this.m.keyCompare(k, entry.key);
                if (n == 0 && bl2 && bl) {
                    return entry;
                }
                if (0 < n && bl || n == 0 && !bl2) {
                    entry2 = entry;
                    entry = entry.right;
                    continue;
                }
                if (0 > n && bl2 || n == 0 && !bl) {
                    entry = entry.left;
                    continue;
                }
                entry = null;
            }
            return entry2;
        }

        final Entry<K, V> biggerOrEqualEntry(K k) {
            Entry<K, V> entry = this.findCeilingEntry(k);
            return null != entry && (!this.toEnd || this.checkUpperBound(entry.getKey())) ? entry : null;
        }

        private Entry<K, V> findStartNode() {
            Entry entry = this.m.root;
            Entry entry2 = null;
            while (entry != null) {
                int n = this.m.keyCompare(this.lo, entry.key);
                if (n == 0) {
                    if (this.loInclusive) {
                        entry2 = entry;
                        break;
                    }
                    entry2 = TreeMap.successor(entry);
                    break;
                }
                if (0 > n) {
                    entry2 = entry;
                    entry = entry.left;
                }
                if (0 >= n) continue;
                entry = entry.right;
            }
            if (entry2 != null && this.toEnd && !this.checkUpperBound(entry2.key)) {
                return null;
            }
            return entry2;
        }

        private Entry<K, V> findEndNode() {
            Entry entry = this.m.root;
            Entry entry2 = null;
            while (entry != null) {
                int n = this.m.keyCompare(this.hi, entry.key);
                if (n == 0) {
                    if (this.hiInclusive) {
                        entry2 = entry;
                        break;
                    }
                    entry2 = TreeMap.predecessor(entry);
                    break;
                }
                if (n > 0) {
                    entry2 = entry;
                    entry = entry.right;
                    continue;
                }
                entry = entry.left;
            }
            if (entry2 != null && this.fromStart && !this.checkLowerBound(entry2.key)) {
                return null;
            }
            return entry2;
        }

        private Entry<K, V> findCeilingEntry(K k) {
            Entry entry = this.m.root;
            Entry entry2 = null;
            if (this.fromStart && !this.checkLowerBound(k)) {
                return this.findStartNode();
            }
            if (this.toEnd && !this.checkUpperBound(k)) {
                return null;
            }
            if (this.m.comparator != null) {
                Comparator comparator = this.m.comparator;
                while (entry != null) {
                    int n = comparator.compare(k, entry.key);
                    if (n == 0) {
                        return entry;
                    }
                    if (0 > n) {
                        entry2 = entry;
                        entry = entry.left;
                    }
                    if (0 >= n) continue;
                    entry = entry.right;
                }
            } else {
                Comparable comparable = TreeMap.toComparable(k);
                while (entry != null) {
                    int n = comparable.compareTo(entry.key);
                    if (n == 0) {
                        return entry;
                    }
                    if (0 > n) {
                        entry2 = entry;
                        entry = entry.left;
                    }
                    if (0 >= n) continue;
                    entry = entry.right;
                }
            }
            return entry2;
        }

        final Entry<K, V> smallerEntry(K k) {
            Entry<K, V> entry = this.findLowerEntry(k);
            return null != entry && (!this.fromStart || this.checkLowerBound(entry.getKey())) ? entry : null;
        }

        private Entry<K, V> findLowerEntry(K k) {
            int n = -1;
            if (this.fromStart && !this.checkLowerBound(k)) {
                return null;
            }
            if (this.toEnd && !this.checkUpperBound(k)) {
                return this.findEndNode();
            }
            Entry entry = this.m.root;
            Entry entry2 = null;
            if (this.m.comparator != null) {
                Comparator comparator = this.m.comparator;
                while (entry != null) {
                    n = comparator.compare(k, entry.key);
                    if (n > 0) {
                        entry2 = entry;
                        entry = entry.right;
                        continue;
                    }
                    entry = entry.left;
                }
            } else {
                Comparable comparable = TreeMap.toComparable(k);
                while (entry != null) {
                    n = comparable.compareTo(entry.key);
                    if (n > 0) {
                        entry2 = entry;
                        entry = entry.right;
                        continue;
                    }
                    entry = entry.left;
                }
            }
            return entry2;
        }

        final Entry<K, V> biggerEntry(K k) {
            Entry<K, V> entry = this.findHigherEntry(k);
            return null != entry && (!this.toEnd || this.checkUpperBound(entry.getKey())) ? entry : null;
        }

        private Entry<K, V> findHigherEntry(K k) {
            int n = -1;
            boolean bl = true;
            Entry entry = this.m.root;
            Entry entry2 = null;
            while (entry != null) {
                bl = this.checkLowerBound(entry.key);
                n = this.m.keyCompare(k, entry.key);
                if (n < 0 && bl) {
                    entry2 = entry;
                    entry = entry.left;
                    continue;
                }
                entry = entry.right;
            }
            return entry2;
        }

        @Override
        public Collection<V> values() {
            if (this.valuesCollection == null) {
                this.valuesCollection = this.toEnd ? super.values() : new SubMapValuesCollection(this);
            }
            return this.valuesCollection;
        }
    }

    static class DescendingSubMapKeySet<K>
    extends SubMapKeySet<K> {
        DescendingSubMapKeySet(NavigableSubMap<K, K> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Iterator<K> iterator() {
            return new DescendingSubMapKeyIterator(this.subMap);
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return new AscendingSubMapKeyIterator(this.subMap);
        }
    }

    static class AscendingSubMapKeySet<K>
    extends SubMapKeySet<K> {
        AscendingSubMapKeySet(NavigableSubMap<K, K> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Iterator<K> iterator() {
            return new AscendingSubMapKeyIterator(this.subMap);
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return new DescendingSubMapKeyIterator(this.subMap);
        }
    }

    static abstract class SubMapKeySet<K>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        final NavigableSubMap<K, K> subMap;
        NavigableSet<K> descendingSet;

        SubMapKeySet(NavigableSubMap<K, K> navigableSubMap) {
            this.subMap = navigableSubMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.subMap.m.comparator();
        }

        @Override
        public boolean contains(Object object) {
            return this.subMap.m.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            Iterator<K> iterator = this.iterator();
            return !iterator.hasNext();
        }

        @Override
        public int size() {
            Iterator<K> iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        @Override
        public boolean remove(Object object) {
            return null != this.subMap.remove(object);
        }

        @Override
        public abstract Iterator<K> iterator();

        @Override
        public abstract Iterator<K> descendingIterator();

        @Override
        public K first() {
            return this.subMap.firstKey();
        }

        @Override
        public K last() {
            return this.subMap.lastKey();
        }

        @Override
        public K pollFirst() {
            Map.Entry<K, K> entry = this.subMap.pollFirstEntry();
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K pollLast() {
            Map.Entry<K, K> entry = this.subMap.pollLastEntry();
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K higher(K k) {
            return this.subMap.higherKey(k);
        }

        @Override
        public K lower(K k) {
            return this.subMap.lowerKey(k);
        }

        @Override
        public K ceiling(K k) {
            return this.subMap.ceilingKey(k);
        }

        @Override
        public K floor(K k) {
            return this.subMap.floorKey(k);
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return null != this.descendingSet ? this.descendingSet : (this.descendingSet = new TreeSet(this.subMap.descendingMap()));
        }

        @Override
        public SortedSet<K> subSet(K k, K k2) {
            return this.subSet(k, true, k2, false);
        }

        @Override
        public SortedSet<K> headSet(K k) {
            return this.headSet(k, false);
        }

        @Override
        public SortedSet<K> tailSet(K k) {
            return this.tailSet(k, true);
        }

        @Override
        public NavigableSet<K> subSet(K k, boolean bl, K k2, boolean bl2) {
            if (this.subMap.m.keyCompare(k, k2) <= 0) {
                return new TreeSet<K>(this.subMap.subMap(k, bl, k2, bl2));
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableSet<K> headSet(K k, boolean bl) {
            this.subMap.m.keyCompare(k, k);
            return new TreeSet<K>(this.subMap.headMap(k, bl));
        }

        @Override
        public NavigableSet<K> tailSet(K k, boolean bl) {
            this.subMap.m.keyCompare(k, k);
            return new TreeSet<K>(this.subMap.tailMap(k, bl));
        }
    }

    static class DescendingSubMapEntrySet<K, V>
    extends SubMapEntrySet<K, V> {
        DescendingSubMapEntrySet(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new DescendingSubMapEntryIterator(this.subMap);
        }
    }

    static class AscendingSubMapEntrySet<K, V>
    extends SubMapEntrySet<K, V> {
        AscendingSubMapEntrySet(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new AscendingSubMapEntryIterator(this.subMap);
        }
    }

    static abstract class SubMapEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final NavigableSubMap<K, V> subMap;

        SubMapEntrySet(NavigableSubMap<K, V> navigableSubMap) {
            this.subMap = navigableSubMap;
        }

        @Override
        public boolean isEmpty() {
            Iterator<Map.Entry<K, V>> iterator = this.iterator();
            return !iterator.hasNext();
        }

        @Override
        public int size() {
            int n = 0;
            Iterator<Map.Entry<K, V>> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object k;
            if (object instanceof Map.Entry && this.subMap.isInRange(k = (entry = (Map.Entry)object).getKey())) {
                V v = this.subMap.get(k);
                Object v2 = entry.getValue();
                return v == null ? v2 == null && this.subMap.containsKey(k) : v.equals(v2);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            Entry entry;
            Object k;
            if (object instanceof Map.Entry && this.subMap.isInRange(k = (entry = (Entry)object).getKey())) {
                Entry entry2 = this.subMap.m.find(k);
                if (entry2 == null) {
                    return false;
                }
                Object object2 = entry2.value;
                Object v = entry.getValue();
                if (object2 == null ? v == null : object2.equals(v)) {
                    this.subMap.m.rbDelete(entry2);
                    return true;
                }
            }
            return false;
        }

        @Override
        public abstract Iterator<Map.Entry<K, V>> iterator();
    }

    static class DescendingSubMapKeyIterator<K, V>
    extends DescendingSubMapIterator<K, V>
    implements Iterator<K> {
        DescendingSubMapKeyIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final K next() {
            return (K)this.getNext().key;
        }
    }

    static class DescendingSubMapEntryIterator<K, V>
    extends DescendingSubMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        DescendingSubMapEntryIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.getNext();
        }
    }

    private static abstract class DescendingSubMapIterator<K, V>
    extends AbstractSubMapIterator<K, V> {
        DescendingSubMapIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        final Entry<K, V> getStartNode() {
            if (this.subMap.toEnd) {
                return this.subMap.hiInclusive ? this.subMap.smallerOrEqualEntry(this.subMap.hi) : this.subMap.smallerEntry(this.subMap.hi);
            }
            return this.subMap.theBiggestEntry();
        }

        @Override
        final Entry<K, V> getBoundaryNode() {
            if (this.subMap.fromStart) {
                return this.subMap.loInclusive ? this.subMap.biggerOrEqualEntry(this.subMap.lo) : this.subMap.biggerEntry(this.subMap.lo);
            }
            return this.subMap.theSmallestEntry();
        }

        @Override
        Entry<K, V> getNext() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != this.subMap.m.modCount) {
                throw new ConcurrentModificationException();
            }
            this.lastNode = this.node;
            this.node = this.node.key == this.boundaryKey ? null : TreeMap.predecessor(this.node);
            return this.lastNode;
        }

        @Override
        final Entry<K, V> getRealNext(Entry<K, V> entry) {
            return TreeMap.predecessor(entry);
        }

        @Override
        public final boolean hasNext() {
            return this.node != null;
        }
    }

    static class AscendingSubMapKeyIterator<K, V>
    extends AscendingSubMapIterator<K, V>
    implements Iterator<K> {
        AscendingSubMapKeyIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final K next() {
            return (K)this.getNext().key;
        }
    }

    static class AscendingSubMapEntryIterator<K, V>
    extends AscendingSubMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        AscendingSubMapEntryIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.getNext();
        }
    }

    private static abstract class AscendingSubMapIterator<K, V>
    extends AbstractSubMapIterator<K, V> {
        AscendingSubMapIterator(NavigableSubMap<K, V> navigableSubMap) {
            super(navigableSubMap);
        }

        @Override
        final Entry<K, V> getBoundaryNode() {
            if (this.subMap.toEnd) {
                return this.subMap.hiInclusive ? this.subMap.smallerOrEqualEntry(this.subMap.hi) : this.subMap.smallerEntry(this.subMap.hi);
            }
            return this.subMap.theBiggestEntry();
        }

        @Override
        final Entry<K, V> getStartNode() {
            if (this.subMap.fromStart) {
                return this.subMap.loInclusive ? this.subMap.biggerOrEqualEntry(this.subMap.lo) : this.subMap.biggerEntry(this.subMap.lo);
            }
            return this.subMap.theSmallestEntry();
        }

        @Override
        Entry<K, V> getNext() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != this.subMap.m.modCount) {
                throw new ConcurrentModificationException();
            }
            this.lastNode = this.node;
            this.node = this.node.key == this.boundaryKey ? null : TreeMap.successor(this.node);
            return this.lastNode;
        }

        @Override
        final Entry<K, V> getRealNext(Entry<K, V> entry) {
            return TreeMap.successor(entry);
        }

        @Override
        public final boolean hasNext() {
            return null != this.node;
        }
    }

    private static abstract class AbstractSubMapIterator<K, V> {
        final NavigableSubMap<K, V> subMap;
        int expectedModCount;
        Entry<K, V> node;
        Entry<K, V> lastNode;
        K boundaryKey;
        boolean getToEnd = false;

        AbstractSubMapIterator(NavigableSubMap<K, V> navigableSubMap) {
            this.subMap = navigableSubMap;
            this.expectedModCount = this.subMap.m.modCount;
            this.node = this.getBoundaryNode();
            if (null != this.node) {
                this.boundaryKey = this.node.key;
                this.node = this.getStartNode();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void remove() {
            if (this.expectedModCount != this.subMap.m.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            if (this.boundaryKey == null) {
                this.subMap.m.rbDelete(this.lastNode);
            } else {
                if (this.lastNode.key == this.boundaryKey) {
                    this.node = null;
                }
                this.subMap.m.rbDelete(this.lastNode);
                if (null != this.node && this.node.key == this.lastNode.key) {
                    this.node = this.lastNode;
                }
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }

        Entry<K, V> getNext() {
            if (this.node != null) {
                if (this.expectedModCount == this.subMap.m.modCount) {
                    this.lastNode = this.node;
                    this.node = this.node.key == this.boundaryKey ? null : this.getRealNext(this.node);
                    return this.lastNode;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        abstract Entry<K, V> getStartNode();

        abstract Entry<K, V> getRealNext(Entry<K, V> var1);

        abstract boolean hasNext();

        abstract Entry<K, V> getBoundaryNode();
    }

    static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> parent;
        Entry<K, V> left;
        Entry<K, V> right;
        boolean color;

        Entry(K k) {
            super(k);
        }

        Entry(K k, V v) {
            super(k, v);
        }

        Entry<K, V> clone(Entry<K, V> entry) {
            Entry entry2 = (Entry)super.clone();
            entry2.parent = entry;
            if (this.left != null) {
                entry2.left = this.left.clone(entry2);
            }
            if (this.right != null) {
                entry2.right = this.right.clone(entry2);
            }
            return entry2;
        }
    }
}

