/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_CAPACITY = 11;
    private static final double DEFAULT_INIT_CAPACITY_RATIO = 1.1;
    private static final int DEFAULT_CAPACITY_RATIO = 2;
    private int size;
    private Comparator<? super E> comparator;
    private transient E[] elements;

    public PriorityQueue() {
        this(11);
    }

    public PriorityQueue(int n) {
        this(n, null);
    }

    public PriorityQueue(int n, Comparator<? super E> comparator) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.elements = this.newElementArray(n);
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> collection) {
        if (collection instanceof PriorityQueue) {
            this.getFromPriorityQueue((PriorityQueue)collection);
        } else if (collection instanceof SortedSet) {
            this.getFromSortedSet((SortedSet)collection);
        } else {
            this.initSize(collection);
            this.addAll(collection);
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        this.getFromPriorityQueue(priorityQueue);
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
        this.getFromSortedSet(sortedSet);
    }

    @Override
    public Iterator<E> iterator() {
        return new PriorityIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.size = 0;
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        this.growToSize(this.size + 1);
        this.elements[this.size] = e;
        this.siftUp(this.size++);
        return true;
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E e = this.elements[0];
        this.removeAt(0);
        return e;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[0];
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].equals(object)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean contains(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.newArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.newArray(TArray);
    }

    private <T> T[] newArray(T[] objectArray) {
        if (this.size > objectArray.length) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, this.size);
        }
        System.arraycopy(this.elements, 0, objectArray, 0, this.size);
        if (this.size < objectArray.length) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elements = this.newElementArray(n);
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
    }

    private E[] newElementArray(int n) {
        return new Object[n];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elements.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elements[i]);
        }
    }

    private void getFromPriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        this.initSize(priorityQueue);
        this.comparator = priorityQueue.comparator();
        System.arraycopy(priorityQueue.elements, 0, this.elements, 0, priorityQueue.size());
        this.size = priorityQueue.size();
    }

    private void getFromSortedSet(SortedSet<? extends E> sortedSet) {
        this.initSize(sortedSet);
        this.comparator = sortedSet.comparator();
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            this.elements[this.size++] = iterator.next();
        }
    }

    private void removeAt(int n) {
        --this.size;
        this.elements[n] = this.elements[this.size];
        this.siftDown(n);
        this.elements[this.size] = null;
    }

    private int compare(E e, E e2) {
        if (null != this.comparator) {
            return this.comparator.compare(e, e2);
        }
        return ((Comparable)e).compareTo(e2);
    }

    private void siftUp(int n) {
        int n2;
        E e;
        E e2 = this.elements[n];
        while (n > 0 && this.compare(e = this.elements[n2 = (n - 1) / 2], e2) > 0) {
            this.elements[n] = e;
            n = n2;
        }
        this.elements[n] = e2;
    }

    private void siftDown(int n) {
        int n2;
        E e = this.elements[n];
        while ((n2 = n * 2 + 1) < this.size) {
            if (n2 + 1 < this.size && this.compare(this.elements[n2 + 1], this.elements[n2]) < 0) {
                ++n2;
            }
            if (this.compare(e, this.elements[n2]) <= 0) break;
            this.elements[n] = this.elements[n2];
            n = n2;
        }
        this.elements[n] = e;
    }

    private void initSize(Collection<? extends E> collection) {
        if (null == collection) {
            throw new NullPointerException();
        }
        if (collection.isEmpty()) {
            this.elements = this.newElementArray(1);
        } else {
            int n = (int)Math.ceil((double)collection.size() * 1.1);
            this.elements = this.newElementArray(n);
        }
    }

    private void growToSize(int n) {
        if (n > this.elements.length) {
            E[] EArray = this.newElementArray(n * 2);
            System.arraycopy(this.elements, 0, EArray, 0, this.elements.length);
            this.elements = EArray;
        }
    }

    private class PriorityIterator
    implements Iterator<E> {
        private int currentIndex = -1;
        private boolean allowRemove = false;

        private PriorityIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < PriorityQueue.this.size - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.allowRemove = true;
            return PriorityQueue.this.elements[++this.currentIndex];
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new IllegalStateException();
            }
            this.allowRemove = false;
            PriorityQueue.this.removeAt(this.currentIndex--);
        }
    }
}

