/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8188218128353913216L;
    transient Object[] elementData;
    int size;
    transient int threshold;
    private static final int DEFAULT_MAX_SIZE = 21;
    private static final int loadFactor = 7500;
    transient int modCount = 0;
    private static final Object NULL_OBJECT = new Object();

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.threshold = this.getThreshold(n);
        this.elementData = this.newElementArray(this.computeElementArraySize());
    }

    private int getThreshold(int n) {
        return n > 3 ? n : 3;
    }

    private int computeElementArraySize() {
        return (int)((long)this.threshold * 10000L / 7500L) * 2;
    }

    private Object[] newElementArray(int n) {
        return new Object[n];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        super.putAllImpl(map);
    }

    private V massageValue(Object object) {
        return (V)(object == NULL_OBJECT ? null : object);
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.elementData.length; ++i) {
            this.elementData[i] = null;
        }
        ++this.modCount;
    }

    @Override
    public boolean containsKey(Object object) {
        int n;
        if (object == null) {
            object = NULL_OBJECT;
        }
        return this.elementData[n = this.findIndex(object, this.elementData)] == object;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            object = NULL_OBJECT;
        }
        for (int i = 1; i < this.elementData.length; i += 2) {
            if (this.elementData[i] != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        int n;
        if (object == null) {
            object = NULL_OBJECT;
        }
        if (this.elementData[n = this.findIndex(object, this.elementData)] == object) {
            Object object2 = this.elementData[n + 1];
            return this.massageValue(object2);
        }
        return null;
    }

    private IdentityHashMapEntry<K, V> getEntry(Object object) {
        int n;
        if (object == null) {
            object = NULL_OBJECT;
        }
        if (this.elementData[n = this.findIndex(object, this.elementData)] == object) {
            return this.getEntry(n);
        }
        return null;
    }

    private IdentityHashMapEntry<K, V> getEntry(int n) {
        Object object = this.elementData[n];
        Object object2 = this.elementData[n + 1];
        if (object == NULL_OBJECT) {
            object = null;
        }
        if (object2 == NULL_OBJECT) {
            object2 = null;
        }
        return new IdentityHashMapEntry<Object, Object>(object, object2);
    }

    private int findIndex(Object object, Object[] objectArray) {
        int n = objectArray.length;
        int n2 = this.getModuloHash(object, n);
        int n3 = (n2 + n - 2) % n;
        while (n2 != n3 && objectArray[n2] != object && objectArray[n2] != null) {
            n2 = (n2 + 2) % n;
        }
        return n2;
    }

    private int getModuloHash(Object object, int n) {
        return (System.identityHashCode(object) & Integer.MAX_VALUE) % (n / 2) * 2;
    }

    @Override
    public V put(K k, V v) {
        int n;
        Object object = k;
        Object object2 = v;
        if (object == null) {
            object = NULL_OBJECT;
        }
        if (object2 == null) {
            object2 = NULL_OBJECT;
        }
        if (this.elementData[n = this.findIndex(object, this.elementData)] != object) {
            ++this.modCount;
            if (++this.size > this.threshold) {
                this.rehash();
                n = this.findIndex(object, this.elementData);
            }
            this.elementData[n] = object;
            this.elementData[n + 1] = null;
        }
        Object object3 = this.elementData[n + 1];
        this.elementData[n + 1] = object2;
        return this.massageValue(object3);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    private void rehash() {
        int n = this.elementData.length << 1;
        if (n == 0) {
            n = 1;
        }
        Object[] objectArray = this.newElementArray(n);
        for (int i = 0; i < this.elementData.length; i += 2) {
            Object object = this.elementData[i];
            if (object == null) continue;
            int n2 = this.findIndex(object, objectArray);
            objectArray[n2] = object;
            objectArray[n2 + 1] = this.elementData[i + 1];
        }
        this.elementData = objectArray;
        this.computeMaxSize();
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)(this.elementData.length / 2) * 7500L / 10000L);
    }

    @Override
    public V remove(Object object) {
        Object object2;
        int n;
        int n2;
        if (object == null) {
            object = NULL_OBJECT;
        }
        if (this.elementData[n2 = (n = this.findIndex(object, this.elementData))] != object) {
            return null;
        }
        Object object3 = this.elementData[n2 + 1];
        int n3 = this.elementData.length;
        while ((object2 = this.elementData[n = (n + 2) % n3]) != null) {
            boolean bl;
            int n4 = this.getModuloHash(object2, n3);
            boolean bl2 = bl = n4 > n2;
            if (n < n2) {
                bl = bl || n4 <= n;
            } else {
                boolean bl3 = bl = bl && n4 <= n;
            }
            if (bl) continue;
            this.elementData[n2] = object2;
            this.elementData[n2 + 1] = this.elementData[n + 1];
            n2 = n;
        }
        --this.size;
        ++this.modCount;
        this.elementData[n2] = null;
        this.elementData[n2 + 1] = null;
        return this.massageValue(object3);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new IdentityHashMapEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    if (IdentityHashMap.this.containsKey(object)) {
                        IdentityHashMap.this.remove(object);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type<K, K, V>(){

                        @Override
                        public K get(MapEntry<K, V> mapEntry) {
                            return mapEntry.key;
                        }
                    }, IdentityHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type<V, K, V>(){

                        @Override
                        public V get(MapEntry<K, V> mapEntry) {
                            return mapEntry.value;
                        }
                    }, IdentityHashMap.this);
                }

                @Override
                public boolean remove(Object object) {
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        if (object != iterator.next()) continue;
                        iterator.remove();
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set<Map.Entry<K, V>> set = this.entrySet();
            return ((Object)set).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (MapEntry mapEntry : this.entrySet()) {
            objectOutputStream.writeObject(mapEntry.key);
            objectOutputStream.writeObject(mapEntry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.threshold = this.getThreshold(21);
        this.elementData = this.newElementArray(this.computeElementArraySize());
        int n2 = n;
        while (--n2 >= 0) {
            Object object = objectInputStream.readObject();
            this.put(object, objectInputStream.readObject());
        }
        this.size = n;
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        if (map.entrySet() != null) {
            super.putAll(map);
        }
    }

    static class IdentityHashMapEntrySet<KT, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final IdentityHashMap<KT, VT> associatedMap;

        public IdentityHashMapEntrySet(IdentityHashMap<KT, VT> identityHashMap) {
            this.associatedMap = identityHashMap;
        }

        IdentityHashMap<KT, VT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.size;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.associatedMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                IdentityHashMapEntry identityHashMapEntry = ((IdentityHashMap)this.associatedMap).getEntry(((Map.Entry)object).getKey());
                return identityHashMapEntry != null && identityHashMapEntry.equals(object);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new IdentityHashMapIterator(new MapEntry.Type<Map.Entry<KT, VT>, KT, VT>(){

                @Override
                public Map.Entry<KT, VT> get(MapEntry<KT, VT> mapEntry) {
                    return mapEntry;
                }
            }, this.associatedMap);
        }
    }

    static class IdentityHashMapIterator<E, KT, VT>
    implements Iterator<E> {
        private int position = 0;
        private int lastPosition = 0;
        final IdentityHashMap<KT, VT> associatedMap;
        int expectedModCount;
        final MapEntry.Type<E, KT, VT> type;
        boolean canRemove = false;

        IdentityHashMapIterator(MapEntry.Type<E, KT, VT> type, IdentityHashMap<KT, VT> identityHashMap) {
            this.associatedMap = identityHashMap;
            this.type = type;
            this.expectedModCount = identityHashMap.modCount;
        }

        @Override
        public boolean hasNext() {
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    this.position += 2;
                    continue;
                }
                return true;
            }
            return false;
        }

        void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public E next() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IdentityHashMapEntry identityHashMapEntry = ((IdentityHashMap)this.associatedMap).getEntry(this.position);
            this.lastPosition = this.position;
            this.position += 2;
            this.canRemove = true;
            return this.type.get(identityHashMapEntry);
        }

        @Override
        public void remove() {
            this.checkConcurrentMod();
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            this.associatedMap.remove(this.associatedMap.elementData[this.lastPosition]);
            this.position = this.lastPosition;
            ++this.expectedModCount;
        }
    }

    static class IdentityHashMapEntry<K, V>
    extends MapEntry<K, V> {
        IdentityHashMapEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key == entry.getKey() && this.value == entry.getValue();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

