/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.harmony.luni.internal.nls.Messages;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1421746759512286392L;
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot;
    transient int lastSlot = -1;
    transient int modCount;
    private static final Enumeration<?> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private static <K, V> Entry<K, V> newEntry(K k, V v, int n) {
        return new Entry<K, V>(k, v);
    }

    public Hashtable() {
        this(11);
    }

    public Hashtable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(n == 0 ? 1 : n);
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public Hashtable(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.firstSlot = n;
        this.elementData = this.newElementArray(n == 0 ? 1 : n);
        this.loadFactor = f;
        this.computeMaxSize();
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 4 / 3 + 11);
        this.putAll(map);
    }

    private Entry<K, V>[] newElementArray(int n) {
        return new Entry[n];
    }

    @Override
    public synchronized void clear() {
        this.elementCount = 0;
        Arrays.fill(this.elementData, null);
        ++this.modCount;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.elementData = (Entry[])this.elementData.clone();
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                if (entry == null) continue;
                hashtable.elementData[n] = (Entry)entry.clone();
            }
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.elementData.length;
        while (--n >= 0) {
            Entry<K, V> entry = this.elementData[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator(new MapEntry.Type<V, K, V>(){

            @Override
            public V get(MapEntry<K, V> mapEntry) {
                return mapEntry.value;
            }
        }, true);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Collections.SynchronizedSet<Map.Entry<K, V>>(new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Hashtable.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Entry entry = Hashtable.this.getEntry(((Map.Entry)object).getKey());
                return object.equals(entry);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new HashIterator(new MapEntry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(MapEntry<K, V> mapEntry) {
                        return mapEntry;
                    }
                });
            }
        }, (Object)this);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set<Map.Entry<K, V>> set = this.entrySet();
            for (Map.Entry entry : map.entrySet()) {
                if (set.contains(entry)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[n2];
        while (entry != null) {
            if (entry.equalsKey(object, n)) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry<K, V> getEntry(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[n2];
        while (entry != null) {
            if (entry.equalsKey(object, n)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized int hashCode() {
        int n = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            int n2 = (k != this ? k.hashCode() : 0) ^ (v != this ? (v != null ? v.hashCode() : 0) : 0);
            n += n2;
        }
        return n;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator(new MapEntry.Type<K, K, V>(){

            @Override
            public K get(MapEntry<K, V> mapEntry) {
                return mapEntry.key;
            }
        }, true);
    }

    @Override
    public Set<K> keySet() {
        return new Collections.SynchronizedSet(new AbstractSet<K>(){

            @Override
            public boolean contains(Object object) {
                return Hashtable.this.containsKey(object);
            }

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (Hashtable.this.containsKey(object)) {
                    Hashtable.this.remove(object);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<K> iterator() {
                if (this.size() == 0) {
                    return EMPTY_ITERATOR;
                }
                return new HashEnumIterator(new MapEntry.Type<K, K, V>(){

                    @Override
                    public K get(MapEntry<K, V> mapEntry) {
                        return mapEntry.key;
                    }
                });
            }
        }, (Object)this);
    }

    @Override
    public synchronized V put(K k, V v) {
        if (k != null && v != null) {
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[n2];
            while (entry != null && !entry.equalsKey(k, n)) {
                entry = entry.next;
            }
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (n2 < this.firstSlot) {
                    this.firstSlot = n2;
                }
                if (n2 > this.lastSlot) {
                    this.lastSlot = n2;
                }
                entry = Hashtable.newEntry(k, v, n);
                entry.next = this.elementData[n2];
                this.elementData[n2] = entry;
                return null;
            }
            Object object = entry.value;
            entry.value = v;
            return (V)object;
        }
        throw new NullPointerException();
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rehash() {
        int n = (this.elementData.length << 1) + 1;
        if (n == 0) {
            n = 1;
        }
        int n2 = n;
        int n3 = -1;
        Entry<K, V>[] entryArray = this.newElementArray(n);
        int n4 = this.lastSlot + 1;
        while (--n4 >= this.firstSlot) {
            Entry<K, V> entry = this.elementData[n4];
            while (entry != null) {
                int n5 = (entry.getKeyHash() & Integer.MAX_VALUE) % n;
                if (n5 < n2) {
                    n2 = n5;
                }
                if (n5 > n3) {
                    n3 = n5;
                }
                Entry entry2 = entry.next;
                entry.next = entryArray[n5];
                entryArray[n5] = entry;
                entry = entry2;
            }
        }
        this.firstSlot = n2;
        this.lastSlot = n3;
        this.elementData = entryArray;
        this.computeMaxSize();
    }

    @Override
    public synchronized V remove(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = null;
        Entry<K, V> entry2 = this.elementData[n2];
        while (entry2 != null && !entry2.equalsKey(object, n)) {
            entry = entry2;
            entry2 = entry2.next;
        }
        if (entry2 != null) {
            ++this.modCount;
            if (entry == null) {
                this.elementData[n2] = entry2.next;
            } else {
                entry.next = entry2.next;
            }
            --this.elementCount;
            Object object2 = entry2.value;
            entry2.value = null;
            return (V)object2;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 28);
        stringBuilder.append('{');
        for (int i = this.lastSlot; i >= this.firstSlot; --i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    stringBuilder.append(entry.key);
                } else {
                    stringBuilder.append("(" + Messages.getString("luni.04") + ")");
                }
                stringBuilder.append('=');
                if (entry.value != this) {
                    stringBuilder.append(entry.value);
                } else {
                    stringBuilder.append("(" + Messages.getString("luni.04") + ")");
                }
                stringBuilder.append(", ");
                entry = entry.next;
            }
        }
        if (this.elementCount > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Collection<V> values() {
        return new Collections.SynchronizedCollection(new AbstractCollection<V>(){

            @Override
            public boolean contains(Object object) {
                return Hashtable.this.contains(object);
            }

            @Override
            public int size() {
                return Hashtable.this.elementCount;
            }

            @Override
            public void clear() {
                Hashtable.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                return new HashIterator(new MapEntry.Type<V, K, V>(){

                    @Override
                    public V get(MapEntry<K, V> mapEntry) {
                        return mapEntry.value;
                    }
                });
            }
        }, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = null;
        Hashtable hashtable2 = this;
        synchronized (hashtable2) {
            try {
                hashtable = (Hashtable)super.clone();
                hashtable.elementData = (Entry[])this.elementData.clone();
                int n = this.elementData.length;
                while (--n >= 0) {
                    Entry<K, V> entry = this.elementData[n];
                    if (entry == null) continue;
                    hashtable.elementData[n] = (Entry)entry.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        hashtable.writeObjectImpl(objectOutputStream);
    }

    private void writeObjectImpl(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        objectOutputStream.writeInt(this.elementCount);
        int n = this.elementData.length;
        while (--n >= 0) {
            Entry<K, V> entry = this.elementData[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = this.newElementArray(n);
        int n2 = this.elementCount = objectInputStream.readInt();
        while (--n2 >= 0) {
            Object object = objectInputStream.readObject();
            int n3 = object.hashCode();
            int n4 = (n3 & Integer.MAX_VALUE) % n;
            if (n4 < this.firstSlot) {
                this.firstSlot = n4;
            }
            if (n4 > this.lastSlot) {
                this.lastSlot = n4;
            }
            Entry<Object, Object> entry = Hashtable.newEntry(object, objectInputStream.readObject(), n3);
            entry.next = this.elementData[n4];
            this.elementData[n4] = entry;
        }
    }

    class HashEnumIterator<E>
    extends HashIterator<E>
    implements Enumeration<E> {
        private boolean isEnumeration;
        int start;
        Entry<K, V> entry;

        HashEnumIterator(MapEntry.Type<E, K, V> type) {
            super(type);
            this.isEnumeration = false;
        }

        HashEnumIterator(MapEntry.Type<E, K, V> type, boolean bl) {
            super(type);
            this.isEnumeration = false;
            this.isEnumeration = bl;
            this.start = Hashtable.this.lastSlot + 1;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.isEnumeration) {
                if (this.entry != null) {
                    return true;
                }
                while (this.start > Hashtable.this.firstSlot) {
                    if (Hashtable.this.elementData[--this.start] == null) continue;
                    this.entry = Hashtable.this.elementData[this.start];
                    return true;
                }
                return false;
            }
            return super.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (this.isEnumeration) {
                return this.hasMoreElements();
            }
            return super.hasNext();
        }

        @Override
        public E next() {
            if (this.isEnumeration) {
                if (this.expectedModCount == Hashtable.this.modCount) {
                    return this.nextElement();
                }
                throw new ConcurrentModificationException();
            }
            return super.next();
        }

        @Override
        public E nextElement() {
            if (this.isEnumeration) {
                if (this.hasMoreElements()) {
                    Object RT = this.type.get(this.entry);
                    this.entry = this.entry.next;
                    return (E)RT;
                }
                throw new NoSuchElementException();
            }
            return super.next();
        }

        @Override
        public void remove() {
            if (this.isEnumeration) {
                throw new UnsupportedOperationException();
            }
            super.remove();
        }
    }

    private class HashIterator<E>
    implements Iterator<E> {
        int position;
        int expectedModCount;
        final MapEntry.Type<E, K, V> type;
        Entry<K, V> lastEntry;
        int lastPosition;
        boolean canRemove = false;

        HashIterator(MapEntry.Type<E, K, V> type) {
            this.type = type;
            this.position = Hashtable.this.lastSlot;
            this.expectedModCount = Hashtable.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.lastEntry != null && this.lastEntry.next != null) {
                return true;
            }
            while (this.position >= Hashtable.this.firstSlot) {
                if (Hashtable.this.elementData[this.position] == null) {
                    --this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.lastEntry != null) {
                    this.lastEntry = this.lastEntry.next;
                }
                if (this.lastEntry == null) {
                    while (this.position >= Hashtable.this.firstSlot && (this.lastEntry = Hashtable.this.elementData[this.position]) == null) {
                        --this.position;
                    }
                    if (this.lastEntry != null) {
                        this.lastPosition = this.position--;
                    }
                }
                if (this.lastEntry != null) {
                    this.canRemove = true;
                    return this.type.get(this.lastEntry);
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.canRemove) {
                    this.canRemove = false;
                    Hashtable hashtable = Hashtable.this;
                    synchronized (hashtable) {
                        boolean bl = false;
                        Entry entry = Hashtable.this.elementData[this.lastPosition];
                        if (entry == this.lastEntry) {
                            Hashtable.this.elementData[this.lastPosition] = entry.next;
                            bl = true;
                        } else {
                            while (entry != null && entry.next != this.lastEntry) {
                                entry = entry.next;
                            }
                            if (entry != null) {
                                entry.next = this.lastEntry.next;
                                bl = true;
                            }
                        }
                        if (bl) {
                            ++Hashtable.this.modCount;
                            --Hashtable.this.elementCount;
                            ++this.expectedModCount;
                            return;
                        }
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> next;
        final int hashcode;

        Entry(K k, V v) {
            super(k, v);
            this.hashcode = k.hashCode();
        }

        @Override
        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object object = this.value;
            this.value = v;
            return (V)object;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object object, int n) {
            return this.hashcode == object.hashCode() && this.key.equals(object);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

