/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2340985798034038923L;
    private static final int DEFAULT_SIZE = 16;
    private transient DequeStatus status;
    private transient int modCount;
    private transient int front;
    private transient int rear;
    private transient E[] elements;

    public ArrayDeque() {
        this(16);
    }

    public ArrayDeque(int n) {
        int n2 = this.countInitSize(n);
        this.elements = new Object[n2];
        this.rear = 0;
        this.front = 0;
        this.status = DequeStatus.Empty;
        this.modCount = 0;
    }

    private int countInitSize(int n) {
        int n2 = Math.max(n, 16);
        if (0 >= (n2 = Integer.highestOneBit(n2 - 1) << 1)) {
            n2 = n;
        }
        return n2;
    }

    public ArrayDeque(Collection<? extends E> collection) {
        this.elements = new Object[this.countInitSize(collection.size())];
        this.rear = 0;
        this.front = 0;
        this.status = DequeStatus.Empty;
        this.modCount = 0;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addLastImpl(iterator.next());
        }
    }

    @Override
    public void addFirst(E e) {
        this.offerFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.addLastImpl(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.checkNull(e);
        this.checkAndExpand();
        this.front = this.circularSmallerPos(this.front);
        this.elements[this.front] = e;
        this.resetStatus(true);
        ++this.modCount;
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public boolean offer(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public boolean add(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public void push(E e) {
        this.offerFirst(e);
    }

    @Override
    public E removeFirst() {
        this.checkEmpty();
        return this.removePollFirstImpl();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E removeLast() {
        this.checkEmpty();
        return this.removeLastImpl();
    }

    @Override
    public E pollFirst() {
        return this.status == DequeStatus.Empty ? null : (E)this.removePollFirstImpl();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.status == DequeStatus.Empty ? null : (E)this.removeLastImpl();
    }

    @Override
    public E getFirst() {
        this.checkEmpty();
        return this.elements[this.front];
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getLast() {
        this.checkEmpty();
        return this.elements[this.circularSmallerPos(this.rear)];
    }

    @Override
    public E peekFirst() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.front];
    }

    @Override
    public E peek() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.front];
    }

    @Override
    public E peekLast() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.circularSmallerPos(this.rear)];
    }

    private void checkNull(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
    }

    private void checkEmpty() {
        if (this.status == DequeStatus.Empty) {
            throw new NoSuchElementException();
        }
    }

    private int circularSmallerPos(int n) {
        return n - 1 < 0 ? this.elements.length - 1 : n - 1;
    }

    private int circularBiggerPos(int n) {
        return n + 1 >= this.elements.length ? 0 : n + 1;
    }

    private void checkAndExpand() {
        if (this.status != DequeStatus.Full) {
            return;
        }
        if (Integer.MAX_VALUE == this.elements.length) {
            throw new IllegalStateException();
        }
        int n = this.elements.length;
        int n2 = n << 1;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.elements, this.front, objectArray, 0, n - this.front);
        System.arraycopy(this.elements, 0, objectArray, n - this.front, this.front);
        this.front = 0;
        this.rear = n;
        this.status = DequeStatus.Normal;
        this.elements = objectArray;
    }

    private void resetStatus(boolean bl) {
        this.status = this.front == this.rear ? (bl ? DequeStatus.Full : DequeStatus.Empty) : DequeStatus.Normal;
    }

    private boolean addLastImpl(E e) {
        this.checkNull(e);
        this.checkAndExpand();
        this.elements[this.rear] = e;
        this.rear = this.circularBiggerPos(this.rear);
        this.resetStatus(true);
        ++this.modCount;
        return true;
    }

    private E removePollFirstImpl() {
        E e = this.elements[this.front];
        this.elements[this.front] = null;
        this.front = this.circularBiggerPos(this.front);
        this.resetStatus(false);
        ++this.modCount;
        return e;
    }

    private E removeLastImpl() {
        int n = this.circularSmallerPos(this.rear);
        E e = this.elements[n];
        this.elements[n] = null;
        this.rear = n;
        this.resetStatus(false);
        ++this.modCount;
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.removeFirstOccurrenceImpl(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrenceImpl(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (null != object) {
            Iterator<E> iterator = this.descendingIterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private boolean removeFirstOccurrenceImpl(Object object) {
        if (null != object) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private void removeInternal(int n, boolean bl) {
        int n2 = n;
        if (bl) {
            while (n2 != this.front) {
                int n3 = this.circularSmallerPos(n2);
                this.elements[n2] = this.elements[n3];
                n2 = n3;
            }
            this.front = this.circularBiggerPos(this.front);
        } else {
            while (n2 != this.rear) {
                int n4 = this.circularBiggerPos(n2);
                this.elements[n2] = this.elements[n4];
                n2 = n4;
            }
            this.rear = this.circularSmallerPos(this.rear);
        }
        this.elements[n2] = null;
        this.resetStatus(false);
    }

    @Override
    public int size() {
        if (this.status == DequeStatus.Full) {
            return this.elements.length;
        }
        return this.front <= this.rear ? this.rear - this.front : this.rear + this.elements.length - this.front;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean contains(Object object) {
        if (null != object) {
            ArrayDequeIterator arrayDequeIterator = new ArrayDequeIterator();
            while (arrayDequeIterator.hasNext()) {
                if (!object.equals(arrayDequeIterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.status != DequeStatus.Empty) {
            int n = this.front;
            do {
                this.elements[n] = null;
            } while ((n = this.circularBiggerPos(n)) != this.rear);
            this.status = DequeStatus.Empty;
        }
        this.rear = 0;
        this.front = 0;
        this.modCount = 0;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            arrayDeque.elements = (Object[])this.elements.clone();
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Object[] toArray() {
        return this.newArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.newArray(TArray);
    }

    private <T> T[] newArray(T[] objectArray) {
        int n = this.size();
        if (n > objectArray.length) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, n);
        }
        if (this.front < this.rear) {
            System.arraycopy(this.elements, this.front, objectArray, 0, n);
        } else if (n != 0) {
            int n2 = this.elements.length;
            System.arraycopy(this.elements, this.front, objectArray, 0, n2 - this.front);
            System.arraycopy(this.elements, 0, objectArray, n2 - this.front, this.rear);
        }
        if (n < objectArray.length) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayDequeIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReverseArrayDequeIterator();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elements = new Object[this.countInitSize(n)];
        this.rear = 0;
        this.front = 0;
        this.status = DequeStatus.Empty;
        this.modCount = 0;
        for (int i = 0; i < n; ++i) {
            this.addLastImpl(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        ArrayDequeIterator arrayDequeIterator = new ArrayDequeIterator();
        while (arrayDequeIterator.hasNext()) {
            objectOutputStream.writeObject(arrayDequeIterator.next());
        }
    }

    private class ReverseArrayDequeIterator<E>
    implements Iterator<E> {
        private int pos;
        private final int expectedModCount;
        private boolean canRemove;

        ReverseArrayDequeIterator() {
            this.expectedModCount = ArrayDeque.this.modCount;
            this.pos = ArrayDeque.this.circularSmallerPos(ArrayDeque.this.rear);
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != ArrayDeque.this.modCount) {
                return false;
            }
            return this.hasNextInternal();
        }

        private boolean hasNextInternal() {
            return ArrayDeque.this.circularBiggerPos(this.pos) != ArrayDeque.this.front || ArrayDeque.this.status == DequeStatus.Full && !this.canRemove;
        }

        @Override
        public E next() {
            if (this.hasNextInternal()) {
                Object object = ArrayDeque.this.elements[this.pos];
                this.canRemove = true;
                this.pos = ArrayDeque.this.circularSmallerPos(this.pos);
                return (E)object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                ArrayDeque.this.removeInternal(ArrayDeque.this.circularBiggerPos(this.pos), false);
                this.canRemove = false;
                return;
            }
            throw new IllegalStateException();
        }
    }

    private class ArrayDequeIterator<E>
    implements Iterator<E> {
        private int pos;
        private final int expectedModCount;
        private boolean canRemove;

        ArrayDequeIterator() {
            this.pos = ArrayDeque.this.front;
            this.expectedModCount = ArrayDeque.this.modCount;
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != ArrayDeque.this.modCount) {
                return false;
            }
            return this.hasNextInternal();
        }

        private boolean hasNextInternal() {
            return this.pos != ArrayDeque.this.rear || ArrayDeque.this.status == DequeStatus.Full && !this.canRemove;
        }

        @Override
        public E next() {
            if (this.hasNextInternal()) {
                Object object = ArrayDeque.this.elements[this.pos];
                if (this.expectedModCount == ArrayDeque.this.modCount && null != object) {
                    this.canRemove = true;
                    this.pos = ArrayDeque.this.circularBiggerPos(this.pos);
                    return (E)object;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                int n = ArrayDeque.this.circularSmallerPos(this.pos);
                if (this.expectedModCount == ArrayDeque.this.modCount && null != ArrayDeque.this.elements[n]) {
                    ArrayDeque.this.removeInternal(n, true);
                    this.canRemove = false;
                    return;
                }
                throw new ConcurrentModificationException();
            }
            throw new IllegalStateException();
        }
    }

    private static enum DequeStatus {
        Empty,
        Normal,
        Full;

    }
}

