/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    Set<K> keySet;
    Collection<V> valuesCollection;

    protected AbstractMap() {
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public boolean containsKey(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next().getKey())) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (iterator.next().getKey() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next().getValue())) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (iterator.next().getValue() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry = iterator.next();
                    K k = entry.getKey();
                    V v = entry.getValue();
                    Object v2 = map.get(k);
                    if ((null == v2 || v2.equals(v)) && (null != v2 || v2 == v)) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += ((Object)iterator.next()).hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        Iterator<Map.Entry<K, V>> setIterator;
                        {
                            this.setIterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.setIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.setIterator.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.setIterator.remove();
                        }
                    };
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                iterator.remove();
                return entry.getValue();
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                iterator.remove();
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 28);
        stringBuilder.append('{');
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            if (k != this) {
                stringBuilder.append(k);
            } else {
                stringBuilder.append("(this Map)");
            }
            stringBuilder.append('=');
            V v = entry.getValue();
            if (v != this) {
                stringBuilder.append(v);
            } else {
                stringBuilder.append("(this Map)");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        Iterator<Map.Entry<K, V>> setIterator;
                        {
                            this.setIterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.setIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.setIterator.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.setIterator.remove();
                        }
                    };
                }
            };
        }
        return this.valuesCollection;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap abstractMap = (AbstractMap)super.clone();
        abstractMap.keySet = null;
        abstractMap.valuesCollection = null;
        return abstractMap;
    }

    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        private K key;
        private V value;

        public SimpleImmutableEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

