/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
        }
        return !collection.isEmpty();
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.size()) {
                return false;
            }
            Iterator<E> iterator = this.iterator();
            Iterator iterator2 = list.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                Object e2 = iterator2.next();
                if (e != null ? e.equals(e2) : e2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public int hashCode() {
        int n = 1;
        for (E e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator();
        if (object != null) {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new SimpleListIterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator(this.size());
        if (object != null) {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new FullListIterator(n);
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator<E> listIterator = this.listIterator(n);
        for (int i = n; i < n2; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (0 <= n && n2 <= this.size()) {
            if (n <= n2) {
                if (this instanceof RandomAccess) {
                    return new SubAbstractListRandomAccess(this, n, n2);
                }
                return new SubAbstractList(this, n, n2);
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    private static class SubAbstractList<E>
    extends AbstractList<E> {
        private final AbstractList<E> fullList;
        private int offset;
        private int size;

        SubAbstractList(AbstractList<E> abstractList, int n, int n2) {
            this.fullList = abstractList;
            this.modCount = this.fullList.modCount;
            this.offset = n;
            this.size = n2 - n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void add(int n, E e) {
            if (this.modCount != this.fullList.modCount) throw new ConcurrentModificationException();
            if (0 > n || n > this.size) throw new IndexOutOfBoundsException();
            this.fullList.add(n + this.offset, e);
            ++this.size;
            this.modCount = this.fullList.modCount;
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= n && n <= this.size) {
                    boolean bl = this.fullList.addAll(n + this.offset, collection);
                    if (bl) {
                        this.size += collection.size();
                        this.modCount = this.fullList.modCount;
                    }
                    return bl;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                boolean bl = this.fullList.addAll(this.offset + this.size, collection);
                if (bl) {
                    this.size += collection.size();
                    this.modCount = this.fullList.modCount;
                }
                return bl;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public E get(int n) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= n && n < this.size) {
                    return this.fullList.get(n + this.offset);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= n && n <= this.size) {
                    return new SubAbstractListIterator<E>(this.fullList.listIterator(n + this.offset), this, this.offset, this.size);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public E remove(int n) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= n && n < this.size) {
                    E e = this.fullList.remove(n + this.offset);
                    --this.size;
                    this.modCount = this.fullList.modCount;
                    return e;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        protected void removeRange(int n, int n2) {
            if (n != n2) {
                if (this.modCount == this.fullList.modCount) {
                    this.fullList.removeRange(n + this.offset, n2 + this.offset);
                    this.size -= n2 - n;
                    this.modCount = this.fullList.modCount;
                } else {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public E set(int n, E e) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= n && n < this.size) {
                    return this.fullList.set(n + this.offset, e);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        void sizeChanged(boolean bl) {
            this.size = bl ? ++this.size : --this.size;
            this.modCount = this.fullList.modCount;
        }

        private static final class SubAbstractListIterator<E>
        implements ListIterator<E> {
            private final SubAbstractList<E> subList;
            private final ListIterator<E> iterator;
            private int start;
            private int end;

            SubAbstractListIterator(ListIterator<E> listIterator, SubAbstractList<E> subAbstractList, int n, int n2) {
                this.iterator = listIterator;
                this.subList = subAbstractList;
                this.start = n;
                this.end = this.start + n2;
            }

            @Override
            public void add(E e) {
                this.iterator.add(e);
                this.subList.sizeChanged(true);
                ++this.end;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.nextIndex() < this.end;
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.previousIndex() >= this.start;
            }

            @Override
            public E next() {
                if (this.iterator.nextIndex() < this.end) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex() - this.start;
            }

            @Override
            public E previous() {
                if (this.iterator.previousIndex() >= this.start) {
                    return this.iterator.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                int n = this.iterator.previousIndex();
                if (n >= this.start) {
                    return n - this.start;
                }
                return -1;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                this.subList.sizeChanged(false);
                --this.end;
            }

            @Override
            public void set(E e) {
                this.iterator.set(e);
            }
        }
    }

    private static final class SubAbstractListRandomAccess<E>
    extends SubAbstractList<E>
    implements RandomAccess {
        SubAbstractListRandomAccess(AbstractList<E> abstractList, int n, int n2) {
            super(abstractList, n, n2);
        }
    }

    private final class FullListIterator
    extends SimpleListIterator
    implements ListIterator<E> {
        FullListIterator(int n) {
            if (0 > n || n > AbstractList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.pos = n - 1;
        }

        @Override
        public void add(E e) {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    AbstractList.this.add(this.pos + 1, e);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                this.lastPosition = -1;
                if (AbstractList.this.modCount != this.expectedModCount) {
                    ++this.expectedModCount;
                }
            } else {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.pos >= 0;
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public E previous() {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    Object e = AbstractList.this.get(this.pos);
                    this.lastPosition = this.pos--;
                    return e;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int previousIndex() {
            return this.pos;
        }

        @Override
        public void set(E e) {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    AbstractList.this.set(this.lastPosition, e);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalStateException();
                }
            } else {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class SimpleListIterator
    implements Iterator<E> {
        int pos = -1;
        int expectedModCount;
        int lastPosition = -1;

        SimpleListIterator() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < AbstractList.this.size();
        }

        @Override
        public E next() {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    Object e = AbstractList.this.get(this.pos + 1);
                    this.lastPosition = ++this.pos;
                    return e;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void remove() {
            if (this.lastPosition == -1) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                AbstractList.this.remove(this.lastPosition);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = AbstractList.this.modCount;
            if (this.pos == this.lastPosition) {
                --this.pos;
            }
            this.lastPosition = -1;
        }
    }
}

