/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.wssapi.token;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.io.InputStream;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class SAMLTokenFactory {
    protected static final SecurityPermission GET_NEWCREDENTIALCONFIG_PERM = new SecurityPermission("wssapi.SAMLTokenFactory.newCredentialConfig");
    protected static final SecurityPermission GET_NEWSAMLTOKEN_PERM = new SecurityPermission("wssapi.SAMLTokenFactory.newSAMLToken");
    protected static final SecurityPermission GET_NEWSUBJECT_PERM = new SecurityPermission("wssapi.SAMLTokenFactory.newSubject");
    public static final String WssSamlV11Token11 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    public static final String WssSamlV20Token11 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    private static Map<String, SAMLTokenFactory> factories = new HashMap<String, SAMLTokenFactory>();
    private static Map<String, String> tokenFactorissMap = new HashMap<String, String>();

    public static SAMLTokenFactory getInstance(String valueType) throws WSSException {
        SAMLTokenFactory instance;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_NEWSAMLTOKEN_PERM);
        }
        if ((instance = factories.get(valueType)) == null) {
            try {
                String factoryImpl = SAMLTokenFactory.getImplClassName(valueType);
                if (factoryImpl != null && !factoryImpl.isEmpty()) {
                    instance = (SAMLTokenFactory)Class.forName(factoryImpl).newInstance();
                    factories.put(valueType, instance);
                }
            }
            catch (Exception e) {
                throw new WSSException(e.getMessage(), e.getCause());
            }
        }
        return instance;
    }

    public abstract RequesterConfig newBearerTokenGenerateConfig();

    public abstract RequesterConfig newSenderVouchesTokenGenerateConfig();

    public abstract RequesterConfig newSymmetricHolderOfKeyTokenGenerateConfig();

    public abstract RequesterConfig newAsymmetricHolderOfKeyTokenGenerateConfig();

    public abstract CredentialConfig newCredentialConfig(Subject var1) throws WSSException;

    public abstract CredentialConfig newCredentialConfig() throws WSSException;

    public abstract ProviderConfig newDefaultProviderConfig(String var1) throws WSSException;

    public abstract SAMLToken newSAMLToken(Subject var1, RequesterConfig var2, ProviderConfig var3) throws WSSException;

    public abstract SAMLToken newSAMLToken(CredentialConfig var1, RequesterConfig var2, ProviderConfig var3) throws WSSException;

    public abstract SAMLToken newSAMLToken(ConsumerConfig var1, XMLStructure var2) throws WSSException;

    public abstract SAMLToken newSAMLToken(ConsumerConfig var1, InputStream var2) throws WSSException;

    public abstract Subject newSubject(SAMLToken var1) throws WSSException;

    public abstract ConsumerConfig newConsumerConfig() throws WSSException;

    private static String getImplClassName(String vType) {
        String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName(vType);
        if (_factoryKey == null) {
            _factoryKey = tokenFactorissMap.get(vType);
        }
        return _factoryKey;
    }

    static {
        tokenFactorissMap.put(WssSamlV11Token11, "com.ibm.ws.wssecurity.wssapi.token.impl.SAML11TokenFactoryImpl");
        tokenFactorissMap.put(WssSamlV20Token11, "com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenFactoryImpl");
    }
}

