/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog;

import com.tivoli.pd.jras.pdjlog.jlog.Formatter;
import com.tivoli.pd.jras.pdjlog.jlog.Gate;
import com.tivoli.pd.jras.pdjlog.jlog.IConstants;
import com.tivoli.pd.jras.pdjlog.jlog.IFormatter;
import com.tivoli.pd.jras.pdjlog.jlog.IHandler;
import com.tivoli.pd.jras.pdjlog.jlog.ILogRecord;
import com.tivoli.pd.jras.pdjlog.jlog.LogObject;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.NestedException;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.b;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.c;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.e;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.f;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Handler
extends Gate
implements IConstants,
IHandler,
Runnable {
    private final String q = "$Id: @(#)19  1.2 src/com/tivoli/pd/jras/pdjlog/jlog/Handler.java, pd.jras, am600, 050110a 04/02/23 17:57:13 @(#) $";
    private static final String r = "(C) Copyright IBM Corp. 1998, 2000.";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    private transient b s;
    private transient boolean t;
    public transient boolean u;
    private transient boolean v;
    private transient boolean w;
    protected Hashtable x;
    private int y;
    protected transient int z;
    private transient int A;
    private int B;
    private int C;
    protected transient Object D;
    protected transient Object E;
    protected transient Object F;
    protected transient Object G;
    protected transient PrintWriter H = null;
    private transient c I;
    private transient c J;
    private String K;
    protected transient Thread L;

    public Handler() {
        this(null, null);
    }

    public Handler(String string) {
        this(string, null);
    }

    public Handler(String string, String string2) {
        super(string, string2);
        this.start();
    }

    public void init() {
        block8: {
            block7: {
                super.init();
                if (this.D == null) {
                    this.D = new Object();
                }
                if (this.E == null) {
                    this.E = new Object();
                }
                if (this.F == null) {
                    this.F = new Object();
                }
                if (this.G == null) {
                    this.G = new Object();
                }
                this.L = null;
                this.z = 0;
                this.A = 0;
                this.u = false;
                this.v = false;
                this.w = false;
                this.setBackupEnabled(false);
                this.setBackupCapacity(50000);
                this.setMaxRetries(5);
                this.setRetryInterval(5000);
                if (this.x != null) break block7;
                this.x = new Hashtable();
                if (!LogObject.j) break block8;
            }
            this.x.clear();
        }
        this.addFormatter(new Formatter());
        this.K = "";
        this.H = null;
        this.J = this.I = new e(10000);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("queueCapacity", new Integer(this.getQueueCapacity()).toString());
        properties.put("isBackupEnabled", new Boolean(this.isBackupEnabled()).toString());
        properties.put("backupCapacity", new Integer(this.getBackupCapacity()).toString());
        properties.put("isCircular", new Boolean(this.isCircular()).toString());
        properties.put("maxRetries", new Integer(this.getMaxRetries()).toString());
        properties.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        if (!this.K.equals("")) {
            properties.put("formatterNames", this.K);
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("queueCapacity");
        if (string != null) {
            this.setQueueCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("isBackupEnabled")) != null) {
            this.setBackupEnabled(new Boolean(string));
        }
        if ((string = properties.getProperty("backupCapacity")) != null) {
            this.setBackupCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("maxRetries")) != null) {
            this.setMaxRetries(new Integer(string));
        }
        if ((string = properties.getProperty("retryInterval")) != null) {
            this.setRetryInterval(new Integer(string));
        }
        if ((string = properties.getProperty("isCircular")) != null) {
            this.setCircular(new Boolean(string));
        }
        if ((string = properties.getProperty("formatterNames")) != null) {
            this.K = string;
        }
    }

    public Thread getThread() {
        return this.L;
    }

    public int getQueueCount() {
        int n2;
        block3: {
            block2: {
                if (!this.isCircular()) break block2;
                n2 = this.I.a() + this.J.a();
                if (!LogObject.j) break block3;
            }
            n2 = this.I.a();
        }
        return n2;
    }

    public int getQueueCapacity() {
        return this.I.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueCapacity(int n2) throws IllegalStateException {
        if (n2 >= 0) {
            Object object = this.E;
            synchronized (object) {
                Object object2 = this.F;
                synchronized (object2) {
                    if (n2 != this.getQueueCapacity()) {
                        if (this.I.a() != 0 || this.J.a() != 0) {
                            throw new IllegalStateException(LogUtil.getLogMessage("ERR_QUEUE_STATE"));
                        }
                        this.a(n2, this.I.e());
                    }
                }
            }
        }
    }

    public boolean isBackupEnabled() {
        return this.t;
    }

    public void setBackupEnabled(boolean bl2) {
        block6: {
            block7: {
                boolean bl3;
                block9: {
                    block8: {
                        bl3 = LogObject.j;
                        if (!bl2) break block7;
                        if (this.s != null) break block8;
                        this.s = new b(this.getBackupCapacity());
                        if (!bl3) break block9;
                    }
                    this.s.i();
                }
                try {
                    this.s.g();
                    this.t = true;
                    break block6;
                }
                catch (IOException iOException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    iOException.printStackTrace();
                    if (!bl3) break block6;
                }
            }
            if (this.s != null) {
                this.s.i();
            }
            this.s = null;
            this.t = false;
        }
    }

    public int getBackupCapacity() {
        return this.y;
    }

    public void setBackupCapacity(int n2) {
        if (n2 >= 0) {
            this.y = n2;
        }
    }

    public int getMaxRetries() {
        return this.B;
    }

    public void setMaxRetries(int n2) {
        if (n2 >= 0) {
            this.B = n2;
        }
    }

    public int getRetryInterval() {
        return this.C;
    }

    public void setRetryInterval(int n2) {
        if (n2 >= 0) {
            this.C = n2;
        }
    }

    public boolean isCircular() {
        return this.I.e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircular(boolean bl2) throws IllegalStateException {
        Object object = this.E;
        synchronized (object) {
            Object object2 = this.F;
            synchronized (object2) {
                if (this.I.e() != bl2) {
                    if (this.I.a() != 0 || this.J.a() != 0) {
                        throw new IllegalStateException(LogUtil.getLogMessage("ERR_QUEUE_STATE"));
                    }
                    this.a(this.getQueueCapacity(), bl2);
                }
            }
        }
    }

    protected void a(int n2, boolean bl2) {
        block3: {
            block2: {
                if (!bl2) break block2;
                this.I = new f(n2);
                this.J = new e(0);
                if (!LogObject.j) break block3;
            }
            this.J = this.I = new e(n2);
        }
    }

    public void addFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.x.put(string, iFormatter);
                if (!LogObject.j) continue;
            }
        }
    }

    public void removeFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.x.remove(string);
                if (!LogObject.j) continue;
            }
        }
    }

    public Enumeration getFormatters() {
        return this.x.elements();
    }

    public abstract void openDevice() throws NestedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.D;
        synchronized (object) {
            if (this.H != null) {
                this.H.flush();
                this.H.close();
            }
            this.H = null;
            this.u = false;
        }
    }

    public void start() {
        if (this.L == null) {
            this.v = false;
            this.w = false;
            String string = this.getClass().getName() + ":" + this.getName();
            this.L = new Thread((Runnable)this, string);
            this.L.setDaemon(true);
            this.L.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean bl2 = LogObject.j;
        while (!this.v) {
            ILogRecord iLogRecord;
            block16: {
                object = this.E;
                synchronized (object) {
                    block17: {
                        iLogRecord = this.J.f();
                        if (iLogRecord != null) break block16;
                        if (!this.w) break block17;
                        this.v = true;
                        if (!bl2) break block16;
                    }
                    try {
                        this.E.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (iLogRecord == null) continue;
            object = this.F;
            synchronized (object) {
                this.F.notifyAll();
            }
            this.a(iLogRecord);
            if (!bl2) continue;
        }
        this.closeDevice();
        if (this.s != null) {
            this.s.i();
        }
        object = this.E;
        synchronized (object) {
            this.E.notify();
            this.L = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.dumpQueue();
        Object object = this.E;
        synchronized (object) {
            this.w = true;
            this.E.notify();
        }
        object = this.E;
        synchronized (object) {
            while (!this.v) {
                try {
                    this.E.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!LogObject.j) continue;
                }
            }
            this.w = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRecord(ILogRecord iLogRecord, boolean bl2) {
        block17: {
            boolean bl3;
            block18: {
                bl3 = LogObject.j;
                if (iLogRecord == null || this.w) break block17;
                if (!bl2) break block18;
                this.a(iLogRecord);
                if (!bl3) break block17;
            }
            boolean bl4 = false;
            while (!bl4) {
                Object object;
                if (this.I.a(iLogRecord)) {
                    bl4 = true;
                    if (this.I.e()) continue;
                    object = this.E;
                    synchronized (object) {
                        this.E.notify();
                        continue;
                    }
                }
                if (!Thread.currentThread().equals(this.L)) {
                    object = this.F;
                    synchronized (object) {
                        Object object2 = this.G;
                        synchronized (object2) {
                            this.G.notify();
                        }
                        try {
                            this.F.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (this.A == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_QUEUE_FULL", this.getName()));
                }
                ++this.A;
                bl4 = true;
                if (!bl3) continue;
            }
        }
    }

    private void a(ILogRecord iLogRecord) {
        block11: {
            boolean bl2 = LogObject.j;
            boolean bl3 = true;
            try {
                block12: {
                    block14: {
                        block13: {
                            if (this.isBackupEnabled() && this.s.b() != 0) {
                                bl3 = this.a();
                            }
                            if (!bl3) break block12;
                            this.b(iLogRecord);
                            this.z = 0;
                            ++this.n;
                            if (this.A == 0) break block11;
                            if (this.A != 1) break block13;
                            LogUtil.errorMsg(LogUtil.getLogMessage("HANDLER_OK_1", this.getName()));
                            if (!bl2) break block14;
                        }
                        LogUtil.errorMsg(LogUtil.getLogMessage("HANDLER_OK_2", this.getName(), new Integer(this.A)));
                    }
                    this.A = 0;
                    if (!bl2) break block11;
                }
                this.c(iLogRecord);
            }
            catch (NestedException nestedException) {
                if (this.z == 0) {
                    LogUtil.errorMsg(nestedException.getMessage());
                    if (nestedException.getNestedException() != null) {
                        nestedException.getNestedException().printStackTrace();
                    }
                }
                ++this.z;
                if (this.isBackupEnabled()) {
                    this.c(iLogRecord);
                    if (!bl2) break block11;
                }
                this.d(iLogRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void b(ILogRecord iLogRecord) throws NestedException {
        Object object = this.D;
        synchronized (object) {
            IFormatter iFormatter;
            if (!this.u) {
                this.openDevice();
            }
            if (this.u && (iFormatter = this.e(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.H.println(string);
                if (this.H.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }

    private void c(ILogRecord iLogRecord) {
        block6: {
            if (this.z == 1) {
                LogUtil.errorMsg(LogUtil.getLogMessage("BACKUP_ATTEMPT", this.getName()));
            }
            if (!this.s.e()) {
                try {
                    this.s.a(iLogRecord);
                    break block6;
                }
                catch (IOException iOException) {
                    if (this.A == 0) {
                        LogUtil.errorMsg(LogUtil.getLogMessage("ERR_WRITE_BACKUP", this.getName()));
                    }
                    iOException.printStackTrace();
                    ++this.A;
                    if (!LogObject.j) break block6;
                }
            }
            if (this.A == 0) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_BACKUP_FULL", this.getName()));
            }
            ++this.A;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(ILogRecord iLogRecord) {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.getMaxRetries();
        if (this.z == 1 && n3 > 0) {
            LogUtil.errorMsg(LogUtil.getLogMessage("RETRY_ATTEMPT", this.getName()));
        }
        while (!bl2 && n2 < n3 && !this.w) {
            block10: {
                try {
                    int n4 = this.getRetryInterval();
                    if (n4 == 0) break block10;
                    Object object = this.G;
                    synchronized (object) {
                        this.G.wait(n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.b(iLogRecord);
                bl2 = true;
                this.z = 0;
            }
            catch (NestedException nestedException) {
                ++n2;
                if (!LogObject.j) continue;
            }
        }
        if (!bl2) {
            ++this.A;
        }
    }

    private boolean a() throws NestedException {
        boolean bl2 = LogObject.j;
        ILogRecord iLogRecord = null;
        boolean bl3 = true;
        boolean bl4 = false;
        while (this.s.b() > 0 && !bl4) {
            try {
                iLogRecord = this.s.f();
            }
            catch (Exception exception) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_READ_BACKUP", this.s.a(), this.getName()));
                exception.printStackTrace();
                bl4 = true;
                this.s.h();
                try {
                    this.s.g();
                }
                catch (IOException iOException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    iOException.printStackTrace();
                    this.setBackupEnabled(false);
                }
            }
            try {
                this.b(iLogRecord);
            }
            catch (NestedException nestedException) {
                bl4 = true;
                ++this.z;
                b b2 = new b(this.getBackupCapacity());
                try {
                    b2.g();
                    b2.a(iLogRecord);
                    while (this.s.b() > 0) {
                        iLogRecord = this.s.f();
                        b2.a(iLogRecord);
                        if (!bl2) continue;
                    }
                    this.s.i();
                    this.s = b2;
                    bl3 = false;
                }
                catch (Exception exception) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    exception.printStackTrace();
                    this.setBackupEnabled(false);
                }
                if (!bl2) continue;
            }
        }
        if (!bl4) {
            this.s.i();
            try {
                this.s.g();
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                iOException.printStackTrace();
                this.setBackupEnabled(false);
            }
        }
        return bl3;
    }

    protected IFormatter e(ILogRecord iLogRecord) {
        boolean bl2 = LogObject.j;
        boolean bl3 = false;
        Class<?> clazz = iLogRecord.getClass();
        IFormatter iFormatter = null;
        while (!bl3 && clazz != null) {
            block4: {
                block3: {
                    String string = clazz.getName();
                    if (!this.x.containsKey(string)) break block3;
                    bl3 = true;
                    iFormatter = (IFormatter)this.x.get(string);
                    if (!bl2) break block4;
                }
                clazz = clazz.getSuperclass();
            }
            if (!bl2) continue;
        }
        return iFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpQueue() {
        block9: {
            boolean bl2 = LogObject.j;
            if (!this.isCircular()) break block9;
            boolean bl3 = false;
            Object object = this.E;
            synchronized (object) {
                Object object2 = this.F;
                synchronized (object2) {
                    while (!bl3) {
                        block11: {
                            ILogRecord iLogRecord;
                            block10: {
                                iLogRecord = this.I.f();
                                if (iLogRecord != null) break block10;
                                bl3 = true;
                                if (!bl2) break block11;
                            }
                            this.J.a(iLogRecord);
                        }
                        if (!bl2) continue;
                    }
                    this.F.notifyAll();
                }
                this.E.notifyAll();
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return string + ", deviceOpen=" + this.u;
    }
}

