/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.TransitedEncoding;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class EncTicketPart {
    private TicketFlags b;
    private EncryptionKey c;
    private Realm d;
    private PrincipalName e;
    private TransitedEncoding f;
    private KerberosTime g;
    private KerberosTime h;
    private KerberosTime i;
    private KerberosTime j;
    private HostAddresses k;
    private AuthorizationData l;

    public EncTicketPart(TicketFlags ticketFlags, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, TransitedEncoding transitedEncoding, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses, AuthorizationData authorizationData) {
        this.b = ticketFlags;
        this.c = encryptionKey;
        this.d = realm;
        this.e = principalName;
        this.f = transitedEncoding;
        this.g = kerberosTime;
        this.h = kerberosTime2;
        this.i = kerberosTime3;
        this.j = kerberosTime4;
        this.k = hostAddresses;
        this.l = authorizationData;
    }

    public EncTicketPart(byte[] byArray) throws Asn1Exception, KrbException, IOException {
        this.b(new DerValue(byArray));
    }

    public EncTicketPart(DerValue derValue) throws Asn1Exception, KrbException, IOException {
        this.b(derValue);
    }

    private void b(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.j = null;
        this.k = null;
        this.l = null;
        if ((derValue.getTag() & 0x1F) != 3 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.b = TicketFlags.parse(derValue2.getData(), (byte)0, false);
        this.c = EncryptionKey.parse(derValue2.getData(), (byte)1, false);
        this.d = Realm.parse(derValue2.getData(), (byte)2, false);
        this.e = PrincipalName.parse(derValue2.getData(), (byte)3, false);
        this.f = TransitedEncoding.parse(derValue2.getData(), (byte)4, false);
        this.g = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.h = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.i = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        if (derValue2.getData().available() > 0) {
            this.j = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        }
        if (derValue2.getData().available() > 0) {
            this.k = HostAddresses.parse(derValue2.getData(), (byte)9, true);
        }
        if (derValue2.getData().available() > 0) {
            this.l = AuthorizationData.parse(derValue2.getData(), (byte)10, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.b.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.c.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.e.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.f.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.g.asn1Encode());
        if (this.h != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.h.asn1Encode());
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.i.asn1Encode());
        if (this.j != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.j.asn1Encode());
        }
        if (this.k != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.k.asn1Encode());
        }
        if (this.l != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.l.asn1Encode());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)3), derOutputStream2);
        return derOutputStream.toByteArray();
    }

    public TicketFlags getTicketFlags() {
        return this.b;
    }

    public EncryptionKey getEncryptionKey() {
        return this.c;
    }

    public Realm getClientRealm() {
        return this.d;
    }

    public PrincipalName getClient() {
        return this.e;
    }

    public TransitedEncoding getTransitedEncoding() {
        return this.f;
    }

    public KerberosTime getAuthTime() {
        return this.g;
    }

    public KerberosTime getStartTime() {
        return this.h;
    }

    public KerberosTime getEndTime() {
        return this.i;
    }

    public KerberosTime getRenewableTillTime() {
        return this.j;
    }

    public HostAddresses getClientAddresses() {
        return this.k;
    }

    public AuthorizationData getAuthzData() {
        return this.l;
    }
}

