/*===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 * 
 * IBM SDK, Java(tm) Technology Edition, v6
 * (C) Copyright IBM Corp. 1999, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *===========================================================================
 */
/*
 * @(#)Skeleton.java	1.20 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.rmi.server;

import java.rmi.Remote;

/**
 * The <code>Skeleton</code> interface is used solely by the RMI
 * implementation.
 *
 * <p> Every version 1.1 (and version 1.1 compatible skeletons generated in
 * 1.2 using <code>rmic -vcompat</code>) skeleton class generated by the rmic
 * stub compiler implements this interface. A skeleton for a remote object is
 * a server-side entity that dispatches calls to the actual remote object
 * implementation.
 *
 * @version 1.20, 11/17/05
 * @author  Ann Wollrath
 * @since   JDK1.1
 * @deprecated no replacement.  Skeletons are no longer required for remote
 * method calls in the Java 2 platform v1.2 and greater.
 */
@Deprecated
public interface Skeleton {
    /**
     * Unmarshals arguments, calls the actual remote object implementation,
     * and marshals the return value or any exception.
     *
     * @param obj remote implementation to dispatch call to
     * @param theCall object representing remote call
     * @param opnum operation number
     * @param hash stub/skeleton interface hash
     * @exception java.lang.Exception if a general exception occurs.
     * @since JDK1.1
     * @deprecated no replacement
     */
    @Deprecated
    void dispatch(Remote obj, RemoteCall theCall, int opnum, long hash)
	throws Exception;

    /**
     * Returns the operations supported by the skeleton.
     * @return operations supported by skeleton
     * @since JDK1.1
     * @deprecated no replacement
     */
    @Deprecated
    Operation[] getOperations();
}
