/*
 * @(#)ProcessImpl.java	1.4 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package java.lang;

import java.io.IOException;
import java.lang.Process;
import java.io.UnsupportedEncodingException;                                    //IBM-zos_ebcdic

/* This class is for the exclusive use of ProcessBuilder.start() to
 * create new processes.
 *
 * @author Martin Buchholz
 * @version 1.4, 05/11/17
 * @since   1.5
 */

final class ProcessImpl
{
    static final String platformEncoding;                                       //IBM-zos_ebcdic
                                                                                //IBM-zos_ebcdic
    /* Determine encoding to use for the building of command arguments          //IBM-zos_ebcdic
     * and environment data                                                     //IBM-zos_ebcdic
     */                                                                         //IBM-zos_ebcdic
    static {                                                                    //IBM-zos_ebcdic
        String encoding = System.getProperty("ibm.system.encoding");            //IBM-zos_ebcdic
        if (encoding == null) encoding = System.getProperty("file.encoding");   //IBM-zos_ebcdic
        platformEncoding = encoding;                                            //IBM-zos_ebcdic
    }                                                                           //IBM-zos_ebcdic
                                                                                //IBM-zos_ebcdic
    private static boolean iSeriesFlag;                                         //IBM-iseries_bringup
                                                                                //IBM-iseries_bringup
    static {                                                                    //IBM-iseries_bringup
    	if ( System.getProperty("os.name").compareTo("OS/400") == 0 ) {     //IBM-iseries_bringup
            iSeriesFlag = true;                                                 //IBM-iseries_bringup
        }                                                                       //IBM-iseries_bringup
    }                                                                           //IBM-iseries_bringup
    private ProcessImpl() {}	// Not instantiable

    private static byte[] toCString(String s) {
	if (s == null)
	    return null;
	byte[] bytes;                                                           //IBM-zos_ebcdic
        try {                                                                   //IBM-zos_ebcdic
            bytes = s.getBytes(platformEncoding);                               //IBM-zos_ebcdic
        } catch (UnsupportedEncodingException e) {                              //IBM-zos_ebcdic
            bytes = s.getBytes();                                               //IBM-zos_ebcdic
        }                                                                       //IBM-zos_ebcdic
	byte[] result = new byte[bytes.length + 1];
	System.arraycopy(bytes, 0,
			 result, 0,
			 bytes.length);
	result[result.length-1] = (byte)0;
	return result;
    }

    // Only for use by ProcessBuilder.start()
    static Process start(String[] cmdarray,
			 java.util.Map<String,String> environment,
			 String dir,
			 boolean redirectErrorStream)
	throws IOException
    {
	assert cmdarray != null && cmdarray.length > 0;

	// Convert arguments to a contiguous block; it's easier to do
	// memory management in Java than in C.
	byte[][] args = new byte[cmdarray.length-1][];
	int size = args.length; // For added NUL bytes
	for (int i = 0; i < args.length; i++) {
            try {                                                               //IBM-zos_ebcdic
                args[i] = cmdarray[i+1].getBytes(platformEncoding);             //IBM-zos_ebcdic
            } catch (UnsupportedEncodingException e) {                          //IBM-zos_ebcdic
                args[i] = cmdarray[i+1].getBytes();                             //IBM-zos_ebcdic
            }                                                                   //IBM-zos_ebcdic
	    size += args[i].length;
	}
	byte[] argBlock = new byte[size];
	int i = 0;
	for (byte[] arg : args) {
	    System.arraycopy(arg, 0, argBlock, i, arg.length);
	    i += arg.length + 1;
	    // No need to write NUL bytes explicitly
	}

	int[] envc = new int[1];
	byte[] envBlock = ProcessEnvironment.toEnvironmentBlock(environment, envc);
	
        if ( iSeriesFlag ) {                                                    //IBM-iseries_bringup
	        return new ISERIESProcess                                       //IBM-iseries_bringup
	            (toCString(cmdarray[0]),                                    //IBM-iseries_bringup
	             argBlock, args.length,                                     //IBM-iseries_bringup
	             envBlock, envc[0],                                         //IBM-iseries_bringup
	             toCString(dir),                                            //IBM-iseries_bringup
	             redirectErrorStream);                                      //IBM-iseries_bringup
        } else {                                                                //IBM-iseries_bringup
	        return new UNIXProcess                                          //IBM-iseries_bringup
            (toCString(cmdarray[0]),                                            //IBM-iseries_bringup
             argBlock, args.length,                                             //IBM-iseries_bringup
             envBlock, envc[0],                                                 //IBM-iseries_bringup
             toCString(dir),                                                    //IBM-iseries_bringup
             redirectErrorStream);                                              //IBM-iseries_bringup
        }                                                                       //IBM-iseries_bringup
    }
}
//IBM-zos_ebcdic
//IBM-iseries_bringup
