/*
 *  2008-08-17: this file was modified by International Business Machines Corporation.
 *  Modifications Copyright 2008 IBM Corporation.
 */

/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package java.beans;

class StringPersistenceDelegate extends PersistenceDelegate {
    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        String value = (String) oldInstance;
        return new Expression(oldInstance, String.class,
                "new", new Object[] { value }); //$NON-NLS-1$
    }

    @Override
    /*
     * It's unnecessary to do anything for initialization, because two mutatable
     * strings are actually equivalent already.
     */
    protected void initialize(Class<?> type, Object oldInstance,
            Object newInstance, Encoder out) {
        // do nothing
    }

    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        if (oldInstance instanceof String && newInstance instanceof String) {
            return newInstance.equals(oldInstance);
        }
        return super.mutatesTo(oldInstance, newInstance);
    }
}
