/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class ThreadControllerWrapper {
    private static ThreadController m_tpool = new ThreadController();

    public static Thread runThread(Runnable runnable, int n) {
        return m_tpool.run(runnable, n);
    }

    public static void waitThread(Thread thread, Runnable runnable) throws InterruptedException {
        m_tpool.waitThread(thread, runnable);
    }

    public static class ThreadController {
        public Thread run(Runnable runnable, int n) {
            SafeThread safeThread = new SafeThread(runnable);
            safeThread.start();
            return safeThread;
        }

        public void waitThread(Thread thread, Runnable runnable) throws InterruptedException {
            thread.join();
        }

        final class SafeThread
        extends Thread {
            private volatile boolean ran = false;

            public SafeThread(Runnable runnable) {
                super(runnable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (Thread.currentThread() != this) {
                    throw new IllegalStateException("The run() method in a SafeThread cannot be called from another thread.");
                }
                SafeThread safeThread = this;
                synchronized (safeThread) {
                    if (this.ran) {
                        throw new IllegalStateException("The run() method in a SafeThread cannot be called more than once.");
                    }
                    this.ran = true;
                }
                super.run();
            }
        }
    }
}

