/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.ElemContext;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.ToHTMLCommon;
import org.apache.xml.serializer.ToHTMLStream;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToXHTMLStream
extends ToHTMLCommon {
    static final String s_xhtmlURI = "http://www.w3.org/1999/xhtml";
    private boolean m_inBlockElem = false;
    private static final ToHTMLStream.Trie m_elementFlags = new ToHTMLStream.Trie(true);
    protected boolean m_inDTD = false;
    private static final CharInfo s_xhtmlcharInfo;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        if (this.m_inEntityRef) {
            return;
        }
        ElemContext elemContext = this.m_elemContext;
        if (elemContext.m_startTagOpen) {
            this.closeStartTag();
            elemContext.m_startTagOpen = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            object = string3 != null && string3.length() > 0 ? string3 : string2;
            this.startDocumentInternal((String)object);
            this.m_needToCallStartDocument = false;
            this.m_docIsEmpty = false;
        }
        if (this.m_needToOutputDocTypeDecl) {
            object = string3;
            if (object == null || ((String)object).length() == 0) {
                object = string2;
            }
            this.outputDocTypeDecl((String)object);
        }
        if (!s_xhtmlURI.equals(string)) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            object = ToXHTMLStream.getElemDesc(string3);
            int n = ((ElemDesc)object).getFlags();
            if (this.m_doIndent) {
                boolean bl;
                boolean bl2 = bl = (n & 8) != 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (null != elemContext.m_elementName && (!this.m_inBlockElem || bl)) {
                    this.m_startNewLine = true;
                    this.indent();
                }
                boolean bl3 = this.m_inBlockElem = !bl;
            }
            if (string != null) {
                this.ensurePrefixIsDeclared(string, string3);
            }
            this.m_isprevtext = false;
            this.m_startNewLine = true;
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
            if ((n & 2) != 0) {
                this.m_elemContext = elemContext.push();
                this.m_elemContext.m_elementName = string3;
                this.m_elemContext.m_elementDesc = object;
                return;
            }
            this.m_elemContext = elemContext = elemContext.push(string, string2, string3);
            elemContext.m_elementDesc = object;
            elemContext.m_isRaw = (n & 0x100) != 0;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void metaCreate(ElemContext elemContext, Writer writer) throws SAXException, IOException {
        if (!this.m_omitMetaTag) {
            if (this.m_doIndent) {
                this.indent();
            }
            String string = this.m_mediatype == null ? "text/html" : this.m_mediatype;
            writer.write("<meta http-equiv=\"Content-Type\" content=\"");
            writer.write(string);
            writer.write("; charset=");
            String string2 = this.getEncoding();
            String string3 = Encodings.getMimeEncoding(string2);
            writer.write(string3);
            writer.write("\" />");
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        boolean bl;
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (string == null && (string = this.m_elemContext.m_elementURI) == null) {
            string = this.getElementURI();
        }
        if (!(bl = s_xhtmlURI.equals(string))) {
            super.endElement(string, string2, string3);
            return;
        }
        try {
            boolean bl2;
            ElemDesc elemDesc;
            int n;
            ElemContext elemContext = this.m_elemContext;
            if (elemContext.m_elementDesc == null) {
                if (string2 == null && (string2 = this.m_elemContext.m_elementLocalName) == null) {
                    string2 = ToXHTMLStream.getLocalName(string3);
                }
                elemContext.m_elementDesc = ToXHTMLStream.getElemDesc(string2);
            }
            boolean bl3 = ((n = (elemDesc = elemContext.m_elementDesc).getFlags()) & 2) == 0 && elemDesc != s_elemNotFound;
            Writer writer = this.m_writer;
            if (!elemContext.m_startTagOpen) {
                bl2 = false;
                if (this.m_doIndent) {
                    boolean bl4 = (n & 8) != 0;
                    boolean bl5 = false;
                    if (this.m_ispreserve) {
                        this.m_ispreserve = false;
                    } else if (this.m_doIndent && (!this.m_inBlockElem || bl4)) {
                        this.m_startNewLine = true;
                        bl5 = true;
                    }
                    if (!elemContext.m_startTagOpen && bl5) {
                        this.indent(elemContext.m_currentElemDepth - 1);
                    }
                    this.m_inBlockElem = !bl4;
                }
                writer.write("</");
                writer.write(string3);
                writer.write(62);
            } else {
                String string4 = string2 == null ? string3 : string2;
                bl2 = this.metaDiscard(string4);
                int n2 = this.m_attributes.getLength();
                if (!bl2) {
                    writer.write(60);
                    writer.write(string3);
                    if (this.m_tracer != null) {
                        super.fireStartElem(string3);
                    }
                    if (n2 > 0) {
                        this.processAttributes(writer, n2);
                    }
                    if (bl3) {
                        if (this.m_elemContext.m_elementDesc != null && (this.m_elemContext.m_elementDesc.getFlags() & 0x400000) != 0 && s_xhtmlURI.equals(this.m_elemContext.m_elementURI)) {
                            writer.write(62);
                            this.metaCreate(this.m_elemContext, writer);
                            if (this.m_doIndent) {
                                if (this.m_ispreserve) {
                                    this.m_ispreserve = false;
                                } else {
                                    this.m_startNewLine = true;
                                    this.indent(elemContext.m_currentElemDepth - 1);
                                }
                                this.m_inBlockElem = false;
                            }
                            writer.write("</");
                        } else {
                            writer.write("></");
                        }
                        writer.write(string3);
                        writer.write(62);
                    } else {
                        writer.write(" />");
                    }
                }
                if (n2 > 0) {
                    this.m_attributes.clear();
                }
            }
            if ((n & 0x200000) != 0) {
                this.m_ispreserve = true;
            }
            this.m_isprevtext = false;
            if (this.m_tracer != null && !bl2) {
                super.fireEndElem(string3);
            }
            this.m_prefixMap.popNamespaces(this.m_elemContext.m_currentElemDepth, null);
            this.m_elemContext = elemContext.m_prev;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public static final ElemDesc getElemDesc(String string) {
        Object object = m_elementFlags.get(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return s_elemNotFound;
    }

    public static final ElemDesc getElemDesc(QName qName) {
        Object object = m_elementFlags.get(ToXHTMLStream.getStringRep(qName));
        if (null != object) {
            return (ElemDesc)object;
        }
        return s_elemNotFound;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushInternal();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n;
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.m_docIsEmpty = false;
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                if ((n = string2.indexOf("?>")) >= 0) {
                    if (n > 0) {
                        writer.write(string2.substring(0, n));
                    }
                    writer.write("? >");
                    if (n + 2 < string2.length()) {
                        writer.write(string2.substring(n + 2));
                    }
                } else {
                    writer.write(string2);
                }
                writer.write("?>");
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_elemContext.m_isRaw) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n, n2);
    }

    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        if ((n3 & 1) != 0 && this.m_optLevel == 0) {
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            } else if (this.m_needToCallStartDocument) {
                this.m_docIsEmpty = false;
                this.startDocumentInternal();
            }
            this.m_ispreserve = true;
            try {
                if (this.m_writerOptimized != null) {
                    if (n2 == 1) {
                        this.m_writerOptimized.write(cArray[n]);
                    } else {
                        this.m_writerOptimized.writeASCII(cArray, n, n2);
                    }
                    return;
                }
                this.m_writer.write(cArray, n, n2);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.characters(cArray, n, n2);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public ToXHTMLStream() {
        EncodingInfo encodingInfo;
        this.m_charInfo = s_xhtmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
        this.m_spaceBeforeClose = true;
        this.m_OutputPropsDefault = new HashMap();
        this.m_OutputPropsDefault.put("method", "xhtml");
        this.m_doIndent = true;
        this.m_OutputPropsDefault.put("indent", "yes");
        this.m_mediatype = "text/html";
        this.m_OutputPropsDefault.put("media-type", "text/html");
        this.m_version = "4.0";
        this.m_OutputPropsDefault.put("version", "4.0");
        this.m_OutputPropsDefault.put("mime-name", "UTF-8");
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.m_OutputPropsDefault.put("encoding", "UTF-8");
        this.m_OutputPropsDefault.put("omit-xml-declaration", "no");
        this.m_standalone = "no";
        this.m_OutputPropsDefault.put("standalone", "no");
        this.m_wasJustReset = true;
    }

    public void setOutputFormat(Properties properties) {
        Object object;
        boolean bl = false;
        if (properties instanceof OutputPropertiesFactory.SerializerProps && ((OutputPropertiesFactory.SerializerProps)(object = (OutputPropertiesFactory.SerializerProps)properties)).hasOnlyStandardDefaults()) {
            bl = true;
        }
        if (!bl) {
            this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
            object = (String)properties.get("escape-uri-attributes");
            if (object != null) {
                if ("yes".equals(object)) {
                    this.m_specialEscapeURLs = true;
                } else if ("no".equals(object)) {
                    this.m_specialEscapeURLs = false;
                }
            }
            this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        }
        super.setOutputFormat(properties);
    }

    private void startDocumentInternal(String string) throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
        if (this.m_needToOutputDocTypeDecl) {
            String string2 = this.getDoctypeSystem();
            String string3 = this.getDoctypePublic();
            if (null != string2) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE ");
                    if (string == null || string.length() == 0) {
                        string = "html";
                    }
                    writer.write(string);
                    if (null != string3) {
                        writer.write(" PUBLIC \"");
                        writer.write(string3);
                        writer.write("\" \"");
                    } else {
                        writer.write(" SYSTEM \"");
                    }
                    writer.write(string2);
                    writer.write("\">");
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public final void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.m_elemContext.m_elementName && (this.m_elemContext.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elemContext.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(cArray, n, n2, true, this.m_lineSepUse);
            }
            catch (IOException iOException) {
                throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n, n2);
        }
    }

    private boolean metaDiscard(String string) {
        String string2;
        ElemDesc elemDesc;
        return !this.m_omitMetaTag && "meta".equals(string) && this.m_elemContext.m_currentElemDepth > 1 && (elemDesc = this.m_elemContext.m_prev.m_elementDesc) != null && elemDesc.is(0x400000) && "Content-Type".equalsIgnoreCase(string2 = this.m_attributes.getValue("http-equiv"));
    }

    protected void closeStartTag() throws SAXException {
        try {
            ElemDesc elemDesc;
            String string;
            NamespaceMappings.MappingRecord mappingRecord;
            boolean bl;
            String string2 = this.m_elemContext.m_elementName;
            this.m_writer.write(60);
            this.m_writer.write(string2);
            if (this.m_tracer != null) {
                super.fireStartElem(string2);
            }
            int n = this.m_attributes.getLength();
            boolean bl2 = bl = this.m_elemContext.m_elementDesc == null;
            if (bl && (mappingRecord = this.m_prefixMap.getMappingFromPrefix("")) != null && s_xhtmlURI.equals(string = mappingRecord.m_uri) && (elemDesc = ToXHTMLStream.getElemDesc(this.m_elemContext.m_elementName)) != s_elemNotFound) {
                this.m_elemContext.m_elementDesc = elemDesc;
                this.m_elemContext.m_elementURI = s_xhtmlURI;
            }
            if (n > 0) {
                this.processAttributes(this.m_writer, n);
                this.m_attributes.clear();
            }
            this.m_writer.write(62);
            if (this.m_elemContext.m_elementDesc != null && (this.m_elemContext.m_elementDesc.getFlags() & 0x400000) != 0 && s_xhtmlURI.equals(this.m_elemContext.m_elementURI)) {
                this.metaCreate(this.m_elemContext, this.m_writer);
            }
            if (this.m_CdataElems != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        super.comment(cArray, n, n2);
    }

    public boolean reset() {
        boolean bl = super.reset();
        if (!bl) {
            return false;
        }
        this.initToXHTMLStream();
        return true;
    }

    private void initToXHTMLStream() {
        this.m_inBlockElem = false;
        this.m_inDTD = false;
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToXHTMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
            this.m_elemContext.m_elementLocalName = this.m_elemContext.m_elementName;
            if (s_xhtmlURI.equals(string2)) {
                this.m_elemContext.m_elementDesc = (ElemDesc)m_elementFlags.get(this.m_elemContext.m_elementLocalName);
            }
        }
        this.startPrefixMapping(string, string2, false);
    }

    String getXMLVersion() {
        return "1.0";
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            String string = this.getXMLVersion();
            if (!this.getOmitXMLDeclaration()) {
                String string2 = Encodings.getMimeEncoding(this.getEncoding());
                String string3 = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    Writer writer = this.m_writer;
                    writer.write("<?xml version=\"");
                    writer.write(string);
                    writer.write("\" encoding=\"");
                    writer.write(string2);
                    writer.write(34);
                    writer.write(string3);
                    writer.write("?>");
                    if (this.m_doIndent && (this.m_standaloneWasSpecified || this.getDoctypePublic() != null || this.getDoctypeSystem() != null)) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    }
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
    }

    public final void endDocument() throws SAXException {
        this.flushInternal();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void flushPending() throws SAXException {
        this.flushInternal();
        this.flushWriter();
    }

    void outputDocTypeDecl(String string) throws SAXException {
        if (this.m_needToOutputDocTypeDecl) {
            String string2 = this.getDoctypeSystem();
            String string3 = this.getDoctypePublic();
            if (null != string2) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE ");
                    writer.write(string);
                    if (null != string3) {
                        writer.write(" PUBLIC \"");
                        writer.write(string3);
                        writer.write(34);
                    }
                    if (null != string2) {
                        if (null == string3) {
                            writer.write(" SYSTEM \"");
                        } else {
                            writer.write(" \"");
                        }
                        writer.write(string2);
                        writer.write(34);
                    }
                    writer.write(62);
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    void processAttribute(Writer writer, WriterOptimized writerOptimized, AttributesImplSerializer.AttributeImpl attributeImpl, ElemDesc elemDesc, int n) throws IOException {
        writer.write(32);
        String string = attributeImpl.m_qName;
        String string2 = attributeImpl.m_value;
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            writer.write(string);
            writer.write("=\"");
            writer.write(string);
            writer.write(34);
        } else {
            writer.write(string);
            writer.write("=\"");
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                switch (n) {
                    case 0: {
                        if ((attributeImpl.m_flags & 1) != 0) {
                            if (writer == writerOptimized) {
                                writerOptimized.writeASCII(string2);
                                break;
                            }
                            writer.write(string2);
                            break;
                        }
                        this.writeHTMLAttrURIOpt(writer, writerOptimized, string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.writeHTMLAttrURI(writer, writerOptimized, string2);
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        if ((attributeImpl.m_flags & 1) != 0) {
                            if (writer == writerOptimized) {
                                writerOptimized.writeASCII(string2);
                                break;
                            }
                            writer.write(string2);
                            break;
                        }
                        this.writeXMLAttrOpt(writer, writerOptimized, string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.writeXMLAttr(writer, writerOptimized, string2);
                    }
                }
            }
            writer.write(34);
        }
    }

    static {
        ToHTMLStream.initTagReference(m_elementFlags);
        s_xhtmlcharInfo = CharInfo.getCharInfo(null, "xhtml");
    }
}

