/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.parser;

import com.ibm.xylem.Binding;
import com.ibm.xylem.IMatchDestructable;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.AndInstruction;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.AssignmentInstruction;
import com.ibm.xylem.instructions.AutomatonInstruction;
import com.ibm.xylem.instructions.BeginInstruction;
import com.ibm.xylem.instructions.BuildLazyStreamInstruction;
import com.ibm.xylem.instructions.BuildMultiStreamInstruction;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.JavaArrayLookupInstruction;
import com.ibm.xylem.instructions.JavaDowncastInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LazyStreamElementInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LetOnceInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.LocalizeMessageInstruction;
import com.ibm.xylem.instructions.LoopInstruction;
import com.ibm.xylem.instructions.Match2Instruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xylem.instructions.NumericalComparisonInstruction;
import com.ibm.xylem.instructions.OrInstruction;
import com.ibm.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xylem.instructions.PrimitiveToStringInstruction;
import com.ibm.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xylem.instructions.ReadJavaConstantInstruction;
import com.ibm.xylem.instructions.ReadJavaFieldInstruction;
import com.ibm.xylem.instructions.ReadSlotInstruction;
import com.ibm.xylem.instructions.SlotInstruction;
import com.ibm.xylem.instructions.SortStreamInstruction;
import com.ibm.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.StreamRepeatInstruction;
import com.ibm.xylem.instructions.SubstreamAfterInstruction;
import com.ibm.xylem.instructions.SubstreamBeforeInstruction;
import com.ibm.xylem.instructions.SubstreamInstruction;
import com.ibm.xylem.instructions.TagInstruction;
import com.ibm.xylem.instructions.TestStreamInstruction;
import com.ibm.xylem.instructions.TryCatchInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.instructions.TupleMatchInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.instructions.UnionInjectInstruction;
import com.ibm.xylem.instructions.UntagInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.parser.IFormHandler;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.parser.ParserException;
import com.ibm.xylem.types.BigIntegerType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.types.PrimitiveNumericalType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CoreFormHandler
implements IFormHandler {
    protected static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$parser$CoreFormHandler == null ? (class$com$ibm$xylem$parser$CoreFormHandler = CoreFormHandler.class$("com.ibm.xylem.parser.CoreFormHandler")) : class$com$ibm$xylem$parser$CoreFormHandler);
    private static BasicForm[] s_basicForms = new BasicForm[]{new BasicForm("cost-center", 2, class$com$ibm$xylem$instructions$CostCenterInstruction == null ? (class$com$ibm$xylem$instructions$CostCenterInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.CostCenterInstruction")) : class$com$ibm$xylem$instructions$CostCenterInstruction), new BasicForm("delay", 1, class$com$ibm$xylem$instructions$DelayInstruction == null ? (class$com$ibm$xylem$instructions$DelayInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.DelayInstruction")) : class$com$ibm$xylem$instructions$DelayInstruction), new BasicForm("force", 1, class$com$ibm$xylem$instructions$ForceInstruction == null ? (class$com$ibm$xylem$instructions$ForceInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.ForceInstruction")) : class$com$ibm$xylem$instructions$ForceInstruction), new BasicForm("pure", 1, class$com$ibm$xylem$instructions$PureInstruction == null ? (class$com$ibm$xylem$instructions$PureInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.PureInstruction")) : class$com$ibm$xylem$instructions$PureInstruction), new BasicForm("length", 1, class$com$ibm$xylem$instructions$LengthInstruction == null ? (class$com$ibm$xylem$instructions$LengthInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.LengthInstruction")) : class$com$ibm$xylem$instructions$LengthInstruction), new BasicForm("once!", 1, class$com$ibm$xylem$instructions$OnceInstruction == null ? (class$com$ibm$xylem$instructions$OnceInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.OnceInstruction")) : class$com$ibm$xylem$instructions$OnceInstruction), new BasicForm("not", 1, class$com$ibm$xylem$instructions$NotInstruction == null ? (class$com$ibm$xylem$instructions$NotInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.NotInstruction")) : class$com$ibm$xylem$instructions$NotInstruction), new BasicForm("negate", 1, class$com$ibm$xylem$instructions$NegateInstruction == null ? (class$com$ibm$xylem$instructions$NegateInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.NegateInstruction")) : class$com$ibm$xylem$instructions$NegateInstruction), new BasicForm("abs", 1, class$com$ibm$xylem$instructions$AbsoluteValueInstruction == null ? (class$com$ibm$xylem$instructions$AbsoluteValueInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.AbsoluteValueInstruction")) : class$com$ibm$xylem$instructions$AbsoluteValueInstruction), new BasicForm("round", 1, class$com$ibm$xylem$instructions$RoundInstruction == null ? (class$com$ibm$xylem$instructions$RoundInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.RoundInstruction")) : class$com$ibm$xylem$instructions$RoundInstruction), new BasicForm("range", 2, class$com$ibm$xylem$instructions$RangeInstruction == null ? (class$com$ibm$xylem$instructions$RangeInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.RangeInstruction")) : class$com$ibm$xylem$instructions$RangeInstruction), new BasicForm("eq?", 2, class$com$ibm$xylem$instructions$PrimitiveEqualityInstruction == null ? (class$com$ibm$xylem$instructions$PrimitiveEqualityInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.PrimitiveEqualityInstruction")) : class$com$ibm$xylem$instructions$PrimitiveEqualityInstruction), new BasicForm("nan?", 1, class$com$ibm$xylem$instructions$NaNInstruction == null ? (class$com$ibm$xylem$instructions$NaNInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.NaNInstruction")) : class$com$ibm$xylem$instructions$NaNInstruction), new BasicForm("equals?", 2, class$com$ibm$xylem$instructions$DeepEqualityInstruction == null ? (class$com$ibm$xylem$instructions$DeepEqualityInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.DeepEqualityInstruction")) : class$com$ibm$xylem$instructions$DeepEqualityInstruction), new BasicForm("hex-escape", 1, class$com$ibm$xylem$instructions$HexEscapeInstruction == null ? (class$com$ibm$xylem$instructions$HexEscapeInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.HexEscapeInstruction")) : class$com$ibm$xylem$instructions$HexEscapeInstruction), new BasicForm("stream-element", 2, class$com$ibm$xylem$instructions$StreamElementInstruction == null ? (class$com$ibm$xylem$instructions$StreamElementInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.StreamElementInstruction")) : class$com$ibm$xylem$instructions$StreamElementInstruction), new BasicForm("non-null-value", 1, class$com$ibm$xylem$instructions$NonNullValueInstruction == null ? (class$com$ibm$xylem$instructions$NonNullValueInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.NonNullValueInstruction")) : class$com$ibm$xylem$instructions$NonNullValueInstruction), new BasicForm("is-null-value", 1, class$com$ibm$xylem$instructions$IsNullValueInstruction == null ? (class$com$ibm$xylem$instructions$IsNullValueInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.IsNullValueInstruction")) : class$com$ibm$xylem$instructions$IsNullValueInstruction), new BasicForm("get-non-null-value", 1, class$com$ibm$xylem$instructions$GetNonNullValueInstruction == null ? (class$com$ibm$xylem$instructions$GetNonNullValueInstruction = CoreFormHandler.class$("com.ibm.xylem.instructions.GetNonNullValueInstruction")) : class$com$ibm$xylem$instructions$GetNonNullValueInstruction)};
    static /* synthetic */ Class class$com$ibm$xylem$parser$CoreFormHandler;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$CostCenterInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$DelayInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$ForceInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$PureInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$LengthInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$OnceInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$NotInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$NegateInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$AbsoluteValueInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$RoundInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$RangeInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$PrimitiveEqualityInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$NaNInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$DeepEqualityInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$HexEscapeInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$StreamElementInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$NonNullValueInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$IsNullValueInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$instructions$GetNonNullValueInstruction;
    static /* synthetic */ Class class$com$ibm$xylem$Instruction;

    public static int getBasicFormSize() {
        return s_basicForms.length;
    }

    public static Class getBasicFormClass(int n) {
        return CoreFormHandler.s_basicForms[n].m_class;
    }

    public static String getBasicFormName(int n) {
        return CoreFormHandler.s_basicForms[n].m_name;
    }

    public Instruction parseForm(String string, Parser parser, ITypeStore iTypeStore) throws ParserException {
        Object object;
        int n;
        s_logger.debug("processing " + string);
        for (n = 0; n < s_basicForms.length; n += 1) {
            object = s_basicForms[n];
            if (!((BasicForm)object).m_name.equals(string)) continue;
            Class[] classArray = new Class[((BasicForm)object).m_parameters];
            Instruction[] instructionArray = new Instruction[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = class$com$ibm$xylem$Instruction == null ? CoreFormHandler.class$("com.ibm.xylem.Instruction") : class$com$ibm$xylem$Instruction;
                instructionArray[i] = parser.parseExpression(iTypeStore);
            }
            parser.parseCloseParen();
            try {
                return (Instruction)((BasicForm)object).m_class.getConstructor(classArray).newInstance(instructionArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ParserException("Internal error", exception);
            }
        }
        if (string.equals("let")) {
            Object object2 = parser.parseName();
            object = parser.parseExpression(iTypeStore);
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LetInstruction(object2, (Instruction)object, instruction);
        }
        if (string.equals("let!")) {
            Object object3 = parser.parseName();
            object = parser.parseExpression(iTypeStore);
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LetOnceInstruction(object3, (Instruction)object, instruction);
        }
        if (string.equals("lazy-stream-element")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Object object4 = parser.parseName();
            Instruction instruction2 = parser.parseExpression(iTypeStore);
            Instruction instruction3 = parser.parseExpression(iTypeStore, false);
            if (instruction3 != null) {
                parser.parseCloseParen();
            }
            return new LazyStreamElementInstruction(instruction, (Instruction)object, object4, instruction2, instruction3);
        }
        if (string.equals("let*")) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            object = new LinkedList();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                ((LinkedList)object).add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = new Instruction[linkedList.size()];
            Binding[] bindingArray = new Binding[((LinkedList)object).size()];
            int n2 = 0;
            while (!((AbstractCollection)object).isEmpty()) {
                instructionArray[n2] = (Instruction)((LinkedList)object).removeLast();
                bindingArray[n2] = new Binding(linkedList.removeLast());
                ++n2;
            }
            return OptimizerUtilities.replaceDeconstructionBindings(instructionArray, bindingArray, instruction);
        }
        if (string.equals("set!")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new AssignmentInstruction(instruction, (Instruction)object);
        }
        if (string.equals("get!")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new ReadSlotInstruction(instruction);
        }
        if (string.equals("char-stream-to-java-string")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new CharStreamToJavaStringInstruction(instruction);
        }
        if (string.equals("try")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TryCatchInstruction(instruction, (Instruction)object);
        }
        if (string.equals("union-inject")) {
            Type type = parser.parseTypeName(iTypeStore);
            int n3 = Integer.parseInt(parser.parseIdentifier());
            int n4 = Integer.parseInt(parser.parseIdentifier());
            Instruction instruction = parser.parseExpression(iTypeStore);
            return new UnionInjectInstruction(type, n3, n4, instruction);
        }
        if (string.equals("stream")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseRemainingExpressions(iTypeStore);
            return new StreamInstruction(type, (Instruction[])object);
        }
        if (string.equals("begin")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new BeginInstruction(instructionArray);
        }
        if (string.equals("tuple")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new TupleInstruction(instructionArray);
        }
        if (string.equals("stream-s")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            object = new TypeVariable();
            StreamType streamType = new StreamType((Type)object);
            for (int i = 0; i < instructionArray.length; ++i) {
                instructionArray[i] = new AssertTypeInstruction(instructionArray[i], streamType);
                instructionArray[i].setSourceFilename(parser.getCurrentURL());
                instructionArray[i].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)object, instructionArray);
        }
        if (string.equals("stream-e")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            object = new TypeVariable();
            for (int i = 0; i < instructionArray.length; ++i) {
                instructionArray[i] = new AssertTypeInstruction(instructionArray[i], (Type)object);
                instructionArray[i].setSourceFilename(parser.getCurrentURL());
                instructionArray[i].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)object, instructionArray);
        }
        if (string.equals("construct")) {
            String string2 = parser.parseIdentifier();
            object = parser.parseRemainingExpressions(iTypeStore);
            return new ConstructorInstantiationInstruction(string2, (Instruction[])object);
        }
        if (string.equals("sort")) {
            List<Instruction> list = Arrays.asList(parser.parseRemainingExpressions(iTypeStore));
            object = list.get(0);
            list = list.subList(1, list.size());
            Instruction[] instructionArray = list.subList(0, list.size() / 2).toArray(new Instruction[0]);
            Instruction[] instructionArray2 = list.subList(list.size() / 2, list.size()).toArray(new Instruction[0]);
            return new SortStreamInstruction((Instruction)object, instructionArray, instructionArray2);
        }
        if (string.equals("call-module-function")) {
            String string3 = parser.parseIdentifier();
            object = parser.parseIdentifier();
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new ModuleFunctionCallInstruction(string3, (String)object, instructionArray);
        }
        if (string.equals("localize-message")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new LocalizeMessageInstruction(instruction, (Instruction)object, instructionArray);
        }
        if (string.equals("apply") || string.equals("apply!")) {
            n = string.equals("apply") ? 1 : 0;
            object = parser.parseExpression(iTypeStore);
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new ApplyInstruction((Instruction)object, instructionArray, n != 0);
        }
        if (string.equals("lookup-java-array")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseRemainingExpressions(iTypeStore);
            return new JavaArrayLookupInstruction(instruction, (Instruction[])object);
        }
        if (string.equals("new-java-object")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseRemainingExpressions(iTypeStore);
            return new NewJavaObjectInstruction((Instruction[])object, type);
        }
        if (string.equals("java-downcast")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new JavaDowncastInstruction((Instruction)object, type);
        }
        if (string.equals("read-java-field")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaFieldInstruction(instruction, (String)object);
        }
        if (string.equals("read-java-constant")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaConstantInstruction(instruction, (String)object);
        }
        if (string.equals("java-method-invoke") || string.equals("static-method-invoke")) {
            n = parser.read();
            object = null;
            if (n == 64) {
                object = parser.parseTypeName(iTypeStore);
            } else {
                parser.unread((char)n);
            }
            Instruction instruction = null;
            if (string.equals("java-method-invoke")) {
                instruction = parser.parseExpression(iTypeStore);
            }
            String string4 = parser.parseIdentifier();
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            if (string.equals("java-method-invoke")) {
                return new JavaMethodInvocationInstruction(string4, instruction, instructionArray, (Type)object);
            }
            return new StaticMethodInvocationInstruction(string4, instructionArray, (Type)object);
        }
        if (string.equals("and")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new AndInstruction(instructionArray);
        }
        if (string.equals("or")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new OrInstruction(instructionArray);
        }
        if (string.equals("assert-type")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new AssertTypeInstruction((Instruction)object, type);
        }
        if (string.equals("primitive-cast")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new JavaDowncastInstruction((Instruction)object, type);
        }
        if (string.equals("java-null")) {
            Type type = parser.parseTypeName(iTypeStore);
            parser.parseCloseParen();
            return LiteralInstruction.nullLiteral(type);
        }
        if (string.equals("stream-repeat")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(instruction, (Instruction)object);
        }
        if (string.equals("stream-repeat-stream")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(instruction, (Instruction)object);
        }
        if (string.equals("slot!")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SlotInstruction(instruction);
        }
        if (string.equals("tag")) {
            String string5 = parser.parseIdentifier();
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TagInstruction(string5, (Instruction)object);
        }
        if (string.equals("untag")) {
            String string6 = parser.parseIdentifier();
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new UntagInstruction(string6, (Instruction)object);
        }
        if (string.equals("foreach") || string.equals("foreach-c")) {
            Object object5 = parser.parseName();
            object = null;
            if (object5.equals("@")) {
                object = (ICollectionType)((Object)parser.parseTypeName(iTypeStore));
                object5 = parser.parseName();
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            Object object6 = null;
            if (string.equals("foreach-c")) {
                object6 = parser.parseName();
            }
            Instruction instruction4 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return object == null ? new ForEachInstruction(instruction, object5, object6, instruction4) : new ForEachInstruction(instruction, object5, object6, instruction4, (ICollectionType)object);
        }
        if (string.equals("parallel-foreach")) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            object = new LinkedList();
            Type type = null;
            char c = parser.read();
            if (c == '@') {
                type = parser.parseTypeName(iTypeStore);
            } else {
                parser.unread(c);
            }
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                ((LinkedList)object).add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = ((LinkedList)object).toArray(new Instruction[0]);
            Object[] objectArray = linkedList.toArray(new Object[0]);
            ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, objectArray, instruction, type);
            return parallelForEachInstruction;
        }
        if (string.equals("big-integer")) {
            String string7 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(BigIntegerType.s_bigIntegerType, new BigInteger(string7));
        }
        if (string.equals("big-decimal")) {
            String string8 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(DecimalType.s_decimalType, new BigDecimal(string8));
        }
        if (string.equals("substream-after")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamAfterInstruction(instruction, (Instruction)object);
        }
        if (string.equals("substream")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction instruction5 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamInstruction(instruction, (Instruction)object, instruction5, true);
        }
        if (string.equals("substream-1")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction instruction6 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamInstruction(instruction, (Instruction)object, instruction6, false);
        }
        if (string.equals("substream-before")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamBeforeInstruction(instruction, (Instruction)object);
        }
        if (string.equals("primitive-to-string")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new PrimitiveToStringInstruction(instruction);
        }
        if (string.equals("process-stream") || string.equals("process-stream-i") || string.equals("test-stream")) {
            n = string.equals("process-stream-i") ? 1 : 0;
            boolean bl = string.equals("test-stream");
            Type type = null;
            Instruction instruction = parser.parseExpression(iTypeStore);
            if (instruction instanceof IdentifierInstruction && ((IdentifierInstruction)instruction).getVariable().equals("@")) {
                type = parser.parseTypeName(iTypeStore);
                instruction = parser.parseExpression(iTypeStore);
            }
            Instruction instruction7 = parser.parseExpression(iTypeStore);
            Object object7 = parser.parseName();
            Object object8 = parser.parseName();
            Instruction instruction8 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            if (bl) {
                if (type == null) {
                    return new TestStreamInstruction(instruction, instruction7, object7, object8, instruction8);
                }
                return new TestStreamInstruction(instruction, instruction7, object7, object8, instruction8, (ICollectionType)((Object)type));
            }
            return new ProcessStreamInstruction(n != 0, instruction, instruction7, object7, object8, instruction8, type);
        }
        if (string.equals("choose")) {
            ChooseInstruction.Case[] caseArray;
            ArrayList<ChooseInstruction.Case> arrayList = new ArrayList<ChooseInstruction.Case>();
            object = null;
            while (parser.parseOpenParenOrEnd()) {
                caseArray = parser.parseIdentifier();
                if (caseArray.equals("otherwise")) {
                    object = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (caseArray.equals("when")) {
                    Instruction instruction = parser.parseExpression(iTypeStore);
                    Instruction instruction9 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    arrayList.add(new ChooseInstruction.Case(instruction, instruction9));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)caseArray, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
            }
            caseArray = new ChooseInstruction.Case[arrayList.size()];
            arrayList.toArray(caseArray);
            return new ChooseInstruction(caseArray, (Instruction)object);
        }
        if (string.equals("match")) {
            MatchInstruction.Match[] matchArray;
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = new ArrayList();
            Instruction instruction10 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction10 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Instruction instruction11;
                    int n5;
                    Object[] objectArray;
                    NaryPrimopInstruction naryPrimopInstruction;
                    Instruction instruction12 = parser.parseExpression(iTypeStore);
                    Instruction instruction13 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    if (instruction12 instanceof LiteralInstruction) {
                        ((ArrayList)object).add(new MatchInstruction.LiteralMatch((LiteralInstruction)instruction12, instruction13));
                        continue;
                    }
                    if (instruction12 instanceof FunctionCallInstruction) {
                        naryPrimopInstruction = (FunctionCallInstruction)instruction12;
                        objectArray = new Object[((FunctionCallInstruction)naryPrimopInstruction).m_parameters.length];
                        for (n5 = 0; n5 < objectArray.length; ++n5) {
                            instruction11 = ((FunctionCallInstruction)naryPrimopInstruction).m_parameters[n5];
                            if (!(instruction11 instanceof IdentifierInstruction)) {
                                throw new ParserException("Constructor match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
                            }
                            objectArray[n5] = ((IdentifierInstruction)instruction11).getVariable();
                        }
                        ((ArrayList)object).add(new MatchInstruction.DeconstructionMatch(iTypeStore.getName(), ((FunctionCallInstruction)naryPrimopInstruction).getFunction(), objectArray, instruction13));
                        continue;
                    }
                    if (instruction12 instanceof TupleInstruction) {
                        if (!((ArrayList)object).isEmpty()) {
                            throw new ParserException("Cannot mix tuple case with other cases in match", parser.getCurrentURL(), parser.getLineNumber());
                        }
                        naryPrimopInstruction = (TupleInstruction)instruction12;
                        objectArray = new Object[((TupleInstruction)naryPrimopInstruction).m_parameters.length];
                        for (n5 = 0; n5 < objectArray.length; ++n5) {
                            instruction11 = ((TupleInstruction)naryPrimopInstruction).m_parameters[n5];
                            if (!(instruction11 instanceof IdentifierInstruction)) {
                                throw new ParserException("Tuple match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber());
                            }
                            objectArray[n5] = ((IdentifierInstruction)instruction11).getVariable();
                        }
                        parser.parseCloseParen();
                        return new TupleMatchInstruction(instruction, objectArray, instruction13);
                    }
                    throw new ParserException("Unexpected condition " + instruction12, parser.getCurrentURL(), parser.getLineNumber());
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new MatchInstruction.Match[((ArrayList)object).size()];
            ((ArrayList)object).toArray(matchArray);
            return new MatchInstruction(instruction, matchArray, instruction10);
        }
        if (string.equals("match2")) {
            Match2Instruction.Match[] matchArray;
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = new ArrayList();
            Instruction instruction14 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction14 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Instruction instruction15 = parser.parseExpression(iTypeStore);
                    if (!(instruction15 instanceof IMatchDestructable)) {
                        throw new ParserException("Invalid pattern in match2", parser.getCurrentURL(), parser.getLineNumber());
                    }
                    Instruction instruction16 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    ((ArrayList)object).add(new Match2Instruction.Match(instruction15, instruction16));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new Match2Instruction.Match[((ArrayList)object).size()];
            ((ArrayList)object).toArray(matchArray);
            return new Match2Instruction(instruction, matchArray, instruction14);
        }
        if (string.equals("type-match")) {
            TypeMatchInstruction.Match[] matchArray;
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = new ArrayList();
            Instruction instruction17 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction17 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Type type = parser.parseTypeName(iTypeStore);
                    Object object9 = parser.parseName();
                    Instruction instruction18 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    ((ArrayList)object).add(new TypeMatchInstruction.Match(type, object9, instruction18));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new TypeMatchInstruction.Match[((ArrayList)object).size()];
            ((ArrayList)object).toArray(matchArray);
            return new TypeMatchInstruction(instruction, matchArray, instruction17);
        }
        if (string.equals("tuple-match")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseOpenParen();
            object = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            Instruction instruction19 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TupleMatchInstruction(instruction, (Object[])object, instruction19);
        }
        if (string.equals("build-lazy-stream")) {
            parser.parseOpenParen();
            Object[] objectArray = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            object = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object[i] = parser.parseExpression(iTypeStore);
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new BuildLazyStreamInstruction((Instruction[])object, objectArray, instruction);
        }
        if (string.equals("build-multi-stream")) {
            parser.parseOpenParen();
            Object[] objectArray = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            object = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object[i] = parser.parseExpression(iTypeStore);
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new BuildMultiStreamInstruction((Instruction[])object, objectArray, instruction);
        }
        if (string.equals("lambda") || string.equals("lambda!")) {
            Binding[] bindingArray;
            n = string.equals("lambda") ? 1 : 0;
            parser.parseOpenParen();
            ArrayList<Binding[]> arrayList = new ArrayList<Binding[]>();
            while ((object = parser.parseName(false)) != null) {
                bindingArray = new Binding(object);
                char c = parser.readStripComments();
                if (c != '@') {
                    parser.unread(c);
                } else {
                    bindingArray.setType(parser.parseTypeName(iTypeStore));
                }
                arrayList.add(bindingArray);
            }
            parser.parseCloseParen();
            bindingArray = new Binding[arrayList.size()];
            arrayList.toArray(bindingArray);
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LambdaInstruction(instruction, bindingArray, n != 0);
        }
        if (string.equals("loop") || string.equals("loop!")) {
            n = string.equals("loop");
            object = parser.parseName(true);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            LinkedList<Instruction> linkedList2 = new LinkedList<Instruction>();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                linkedList2.add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = new Instruction[linkedList.size()];
            Binding[] bindingArray = new Binding[linkedList2.size()];
            int n6 = 0;
            while (!linkedList2.isEmpty()) {
                instructionArray[n6] = (Instruction)linkedList2.removeFirst();
                bindingArray[n6] = new Binding(linkedList.removeFirst());
                ++n6;
            }
            return new LoopInstruction(object, instruction, bindingArray, instructionArray, n != 0);
        }
        if (string.equals("automaton") || string.equals("automaton-i") || string.equals("automaton-c") || string.equals("automaton-ic")) {
            AutomatonInstruction.Match[] matchArray;
            n = string.equals("automaton-i");
            object = parser.parseExpression(iTypeStore);
            ICollectionType iCollectionType = null;
            if (object instanceof IdentifierInstruction && ((IdentifierInstruction)object).getVariable().equals("@")) {
                iCollectionType = (ICollectionType)((Object)parser.parseTypeName(iTypeStore));
                object = parser.parseExpression(iTypeStore);
            }
            Instruction instruction = parser.parseExpression(iTypeStore);
            Type type = parser.parseTypeName(iTypeStore);
            Object object10 = null;
            if (string.equals("automaton-c") || string.equals("automaton-ic")) {
                object10 = parser.parseName();
            }
            ArrayList<AutomatonInstruction.Match> arrayList = new ArrayList<AutomatonInstruction.Match>();
            Instruction instruction20 = null;
            Object object11 = null;
            Object object12 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    object11 = parser.parseName();
                    object12 = parser.parseName();
                    instruction20 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("state")) {
                    int n7 = parser.parseInteger();
                    Instruction instruction21 = parser.parseExpression(iTypeStore);
                    Instruction instruction22 = parser.parseExpression(iTypeStore);
                    Instruction instruction23 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    if (instruction21 instanceof LiteralInstruction) {
                        arrayList.add(new AutomatonInstruction.LiteralMatch(n7, (LiteralInstruction)instruction21, instruction22, instruction23));
                        continue;
                    }
                    if (instruction21 instanceof FunctionCallInstruction) {
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction21;
                        AutomatonInstruction.BindingOrLiteral[] bindingOrLiteralArray = new AutomatonInstruction.BindingOrLiteral[functionCallInstruction.m_parameters.length];
                        for (int i = 0; i < bindingOrLiteralArray.length; ++i) {
                            Instruction instruction24 = functionCallInstruction.m_parameters[i];
                            if (instruction24 instanceof IdentifierInstruction) {
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral(((IdentifierInstruction)instruction24).getVariable());
                                continue;
                            }
                            if (instruction24 instanceof LiteralInstruction) {
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral((LiteralInstruction)instruction24);
                                continue;
                            }
                            if (instruction24 instanceof StreamInstruction) {
                                StreamInstruction streamInstruction = (StreamInstruction)instruction24;
                                int n8 = streamInstruction.getChildInstructionCount();
                                LiteralInstruction[] literalInstructionArray = new LiteralInstruction[n8];
                                for (int j = 0; j < n8; ++j) {
                                    Instruction instruction25 = streamInstruction.getChildInstruction(j);
                                    if (!(instruction25 instanceof LiteralInstruction)) {
                                        throw new ParserException("Illegal non-literal part of stream (" + instruction25 + ") in constructor match");
                                    }
                                    literalInstructionArray[j] = (LiteralInstruction)instruction25;
                                }
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral(literalInstructionArray);
                                continue;
                            }
                            throw new ParserException("Illegal expression (" + instruction24.getClass() + ") in constructor match");
                        }
                        arrayList.add(new AutomatonInstruction.DeconstructionMatch(n7, functionCallInstruction.getFunction(), bindingOrLiteralArray, instruction22, instruction23));
                        continue;
                    }
                    if (instruction21 instanceof IdentifierInstruction) {
                        arrayList.add(new AutomatonInstruction.LiteralWildcardMatch(n7, ((IdentifierInstruction)instruction21).getVariable(), instruction22, instruction23));
                        continue;
                    }
                    throw new ParserException("Unexpected condition " + instruction21);
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new AutomatonInstruction.Match[arrayList.size()];
            arrayList.toArray(matchArray);
            return iCollectionType == null ? new AutomatonInstruction((Instruction)object, instruction, matchArray, instruction20, type, object11, object12, object10, n != 0) : new AutomatonInstruction((Instruction)object, instruction, matchArray, instruction20, type, object11, object12, object10, n != 0, iCollectionType);
        }
        for (n = 0; n < PrimitiveNumericalType.getOperatorSize(); n += 1) {
            object = PrimitiveNumericalType.getOperator(n);
            if (!((String)object).equals(string)) continue;
            Instruction instruction = parser.parseExpression(iTypeStore);
            Instruction instruction26 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return PrimitiveNumericalType.isComparisonOperator(n) ? new NumericalComparisonInstruction(instruction, instruction26, n) : new PrimitiveArithmeticInstruction(instruction, instruction26, n);
        }
        return null;
    }

    public void registerForms(Parser parser) {
        int n;
        parser.registerForm("let", this);
        parser.registerForm("let!", this);
        parser.registerForm("set!", this);
        parser.registerForm("get!", this);
        parser.registerForm("slot!", this);
        parser.registerForm("begin", this);
        parser.registerForm("stream", this);
        parser.registerForm("stream-s", this);
        parser.registerForm("stream-e", this);
        parser.registerForm("assert-type", this);
        parser.registerForm("primitive-cast", this);
        parser.registerForm("stream-element", this);
        parser.registerForm("stream-repeat", this);
        parser.registerForm("foreach", this);
        parser.registerForm("foreach-c", this);
        parser.registerForm("parallel-foreach", this);
        parser.registerForm("automaton", this);
        parser.registerForm("automaton-i", this);
        parser.registerForm("automaton-c", this);
        parser.registerForm("automaton-ic", this);
        parser.registerForm("construct", this);
        parser.registerForm("call-module-function", this);
        parser.registerForm("primitive-to-string", this);
        parser.registerForm("choose", this);
        parser.registerForm("match", this);
        parser.registerForm("match2", this);
        parser.registerForm("substream-after", this);
        parser.registerForm("substream-before", this);
        parser.registerForm("and", this);
        parser.registerForm("or", this);
        parser.registerForm("tuple", this);
        parser.registerForm("tuple-match", this);
        parser.registerForm("process-stream", this);
        parser.registerForm("process-stream-i", this);
        parser.registerForm("type-match", this);
        parser.registerForm("let*", this);
        parser.registerForm("substream", this);
        parser.registerForm("substream-1", this);
        parser.registerForm("build-multi-stream", this);
        parser.registerForm("build-lazy-stream", this);
        parser.registerForm("lazy-stream-element", this);
        parser.registerForm("loop", this);
        parser.registerForm("lambda", this);
        parser.registerForm("apply", this);
        parser.registerForm("test-stream", this);
        parser.registerForm("localize-message", this);
        parser.registerForm("char-stream-to-java-string", this);
        parser.registerForm("big-integer", this);
        parser.registerForm("big-decimal", this);
        parser.registerForm("static-method-invoke", this);
        parser.registerForm("java-method-invoke", this);
        parser.registerForm("new-java-object", this);
        parser.registerForm("java-null", this);
        parser.registerForm("java-downcast", this);
        parser.registerForm("read-java-field", this);
        parser.registerForm("read-java-constant", this);
        parser.registerForm("lookup-java-array", this);
        parser.registerForm("sort", this);
        parser.registerForm("try", this);
        parser.registerForm("tag", this);
        parser.registerForm("untag", this);
        parser.registerForm("union-inject", this);
        for (n = 0; n < PrimitiveNumericalType.getOperatorSize(); ++n) {
            parser.registerForm(PrimitiveNumericalType.getOperator(n), this);
        }
        for (n = 0; n < s_basicForms.length; ++n) {
            parser.registerForm(CoreFormHandler.s_basicForms[n].m_name, this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BasicForm {
        public String m_name;
        public int m_parameters;
        public Class m_class;

        BasicForm(String string, int n, Class clazz) {
            this.m_name = string;
            this.m_parameters = n;
            this.m_class = clazz;
        }
    }
}

