/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.PrimitiveNumericalType;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class NumericalComparisonInstruction
extends BinaryPrimopInstruction {
    protected int m_operator;

    public NumericalComparisonInstruction() {
    }

    public NumericalComparisonInstruction(Instruction instruction, Instruction instruction2, int n) {
        super(instruction, instruction2);
        this.m_operator = n;
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(type, type2, this);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    public Instruction cloneWithoutTypeInformation() {
        return new NumericalComparisonInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_operator);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        String string3 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
        String string4 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types and char");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        String string5 = iNumericalType.generateCodeForOperation(string3, string4, this.m_operator);
        dataFlowCodeGenerationHelper.appendAssignment(string2, BooleanType.s_booleanType, string5, codeGenerationTracker);
        return string2;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
        codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types and char");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        iNumericalType.generateCodeForOperation(instructionListBuilder, this.m_operator);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(PrimitiveNumericalType.getOperator(this.m_operator), n);
        this.m_operand1.toString(prettyPrinter, n + 1);
        this.m_operand2.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Type type = this.m_operand1.evaluateType(function);
        Object object = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object2 = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        Object object3 = iNumericalType.evaluateOperation(object, object2, this.m_operator);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object3);
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new NumericalComparisonInstruction(instruction, instruction2, this.m_operator);
    }

    public int getOperation() {
        return this.m_operator;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return ((NumericalComparisonInstruction)object).m_operator == this.m_operator;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_operator);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_operator = readObjectFileHelper.readInt();
    }
}

