/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v2;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.ConditionalExpr;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FLWORExpr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xtq.ast.nodes.KindTest;
import com.ibm.xtq.ast.nodes.NameTest;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.NodeTest;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xtq.ast.nodes.SequenceTypeOperator;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.nodes.TreatExpr;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.xml.types.AggregateType;
import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.AttributeType;
import com.ibm.xtq.xml.types.ChoiceType;
import com.ibm.xtq.xml.types.CollectionType;
import com.ibm.xtq.xml.types.DocumentType;
import com.ibm.xtq.xml.types.ElementType;
import com.ibm.xtq.xml.types.ExtendedTypes;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.UntypedAtomic;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v2.Translator2Helper;
import com.ibm.xtq.xslt.translator.v2.XSLTC2Helper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v2.Function2TypeChecker;
import javax.xml.namespace.QName;

public class XPath2TypeChecker
extends Function2TypeChecker {
    private static final NodeType NULL_NODE = new NodeType(null, -1);

    public XPath2TypeChecker(XPathCompiler xPathCompiler) {
        super(xPathCompiler);
    }

    public Type visitExpression(Expr expr) throws TypeCheckError {
        switch (expr.getId()) {
            case 0: 
            case 1: {
                break;
            }
            case 40: {
                return this.sequenceExpression(expr);
            }
            case 101: {
                return this.emptySequence(expr);
            }
            case 186: {
                return this.pattern(expr);
            }
            case 187: {
                return this.pathPattern(expr);
            }
            case 83: 
            case 84: {
                return this.slashSlashPattern(expr);
            }
            case 41: {
                break;
            }
            case 188: {
                return this.stepPattern(expr);
            }
            case 5: {
                return this.stringLiteral(expr);
            }
            case 100: {
                return this.variableOrParameterReference(expr);
            }
            case 57: {
                return this.orExpression(expr);
            }
            case 58: {
                return this.andExpression(expr);
            }
            case 53: {
                return this.quantifiedExpression(expr);
            }
            case 42: {
                return this.forExpression(expr);
            }
            case 56: {
                return this.ifExpression(expr);
            }
            case 65: {
                return this.instanceofExpression(expr);
            }
            case 67: {
                return this.castableAsExpression(expr);
            }
            case 59: {
                return this.comparisonExpression(expr);
            }
            case 60: {
                return this.rangeExpression(expr);
            }
            case 61: {
                return this.additiveExpression(expr);
            }
            case 62: {
                return this.multiplicativeExpression(expr);
            }
            case 69: {
                return this.unaryExpression(expr);
            }
            case 63: {
                return this.unionExpression(expr);
            }
            case 64: {
                return this.intersectOrExceptExpression(expr);
            }
            case 82: {
                return this.pathExpression(expr);
            }
            case 85: {
                return this.stepExpression(expr);
            }
            case 68: {
                return this.castAsExpression(expr);
            }
            case 66: {
                return this.treatAsExpression(expr);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 169: 
            case 171: 
            case 172: 
            case 191: {
                break;
            }
            case 97: {
                return this.integerLiteral(expr);
            }
            case 98: {
                return this.decimalLiteral(expr);
            }
            case 99: {
                return this.doubleLiteral(expr);
            }
            case 105: {
                Type type = expr.isRootOnSelfNode() ? TypeConstants.NODE : this.visitFunction((FunctionCall)expr);
                return type;
            }
            case 228: {
                return this.stringLiteral(expr);
            }
            case 102: {
                return this.contextItemExpression(expr);
            }
            default: {
                throw new StaticError(expr);
            }
        }
        return null;
    }

    protected Type binaryOperatorExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = this.getOperatorIndex(operatorExpr);
        PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = this._compiler.getOperatorDeclaration(n);
        return this.standardPolymorphicFunctionCall(polymorphicFunctionDeclaration, operatorExpr, true);
    }

    private int getOperatorIndex(OperatorExpr operatorExpr) {
        switch (operatorExpr.getOperatorType()) {
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 26: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 15;
            }
            case 15: {
                return 17;
            }
            case 16: {
                return 19;
            }
            case 17: {
                return 16;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
        }
        return -1;
    }

    protected Type additiveExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    private Type logicalExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        if (n != 2) {
            throw new StaticError(expr);
        }
        this.visitExpression(operatorExpr.getOperand(0));
        this.visitExpression(operatorExpr.getOperand(1));
        ASTDecorator2.setType(expr, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type andExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type orExpression(Expr expr) throws TypeCheckError {
        return this.logicalExpression(expr);
    }

    protected Type comparisonExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    public Type visitFunction(FunctionCall functionCall) throws TypeCheckError {
        if (functionCall instanceof IdOrKeyFunctionCallPattern) {
            return this.idKeyPattern(functionCall);
        }
        return super.visitFunction(functionCall);
    }

    protected Type idKeyPattern(Expr expr) {
        FunctionCall functionCall = (FunctionCall)expr;
        QName qName = functionCall.getFunctionQName();
        if (qName.getLocalPart().equals("id")) {
            this._compiler.setHasIdCall(true);
            if (functionCall.getOperandCount() == 1 && functionCall.getOperand(0).getId() == 5) {
                return TypeConstants.NODE;
            }
            throw new StaticError(expr);
        }
        if (functionCall.getOperandCount() == 2 && functionCall.getOperand(0).getId() == 5 && functionCall.getOperand(1).getId() == 5) {
            return TypeConstants.NODE;
        }
        throw new StaticError(expr);
    }

    protected Type multiplicativeExpression(Expr expr) throws TypeCheckError {
        return this.binaryOperatorExpression(expr);
    }

    protected Type pattern(Expr expr) throws TypeCheckError {
        if (expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1) {
            return this.unionPattern((OperatorExpr)expr);
        }
        throw new StaticError(expr);
    }

    protected Type unionPattern(OperatorExpr operatorExpr) throws TypeCheckError {
        int n = operatorExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            this.visitExpression(operatorExpr.getOperand(i));
        }
        return null;
    }

    protected Type pathPattern(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int n = pathExpr.getOperandCount();
        if (n == 0 && pathExpr.isAbsolute()) {
            return TypeConstants.DOCUMENT;
        }
        Type type = null;
        for (int i = 0; i < n; ++i) {
            Expr expr2 = pathExpr.getOperand(i);
            type = this.visitExpression(expr2);
        }
        return type;
    }

    protected Type pathExpression(Expr expr) throws TypeCheckError {
        PathExpr pathExpr = (PathExpr)expr;
        int n = pathExpr.getOperandCount();
        int n2 = pathExpr.isAbsolute() ? 1 : 0;
        Type type = null;
        if (n == n2 + 1) {
            Expr expr2 = pathExpr.getOperand(n2);
            type = this.visitExpression(expr2);
        } else {
            Expr expr3 = pathExpr.getOperand(n2);
            Type type2 = this.visitExpression(expr3);
            for (int i = n2 + 1; i < n; ++i) {
                Expr expr4 = pathExpr.getOperand(i);
                type = this.visitExpression(expr4);
            }
        }
        ASTDecorator2.setType(pathExpr, type);
        return type;
    }

    protected Type sequenceExpression(Expr expr) throws TypeCheckError {
        Type type;
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        if (n == 0) {
            type = TypeConstants.EMPTY;
        } else if (n == 1) {
            type = this.visitExpression(operatorExpr.getOperand(0));
        } else {
            AggregateType aggregateType = new AggregateType();
            for (int i = 0; i < n; ++i) {
                Expr expr2 = operatorExpr.getOperand(i);
                aggregateType.addType(this.visitExpression(expr2));
            }
            type = aggregateType;
        }
        ASTDecorator2.setType(operatorExpr, type);
        return type;
    }

    protected Type contextItemExpression(Expr expr) {
        XSequenceType xSequenceType = new XSequenceType(TypeConstants.ITEM, OccurrenceIndicator.ONE);
        ASTDecorator2.setType(expr, xSequenceType);
        return xSequenceType;
    }

    protected Type stepExpression(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        if (stepExpr.isFilterStep()) {
            return this.filterStepExpression(stepExpr);
        }
        return this.axisStepExpression(stepExpr);
    }

    private Type filterStepExpression(StepExpr stepExpr) throws TypeCheckError {
        Expr expr = null;
        try {
            expr = stepExpr.getPrimaryExpr();
        }
        catch (XPath20Exception xPath20Exception) {
            throw new StaticError(stepExpr);
        }
        int n = stepExpr.getPredicateCount();
        Type type = null;
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            if (n > 0) {
                type = new XSequenceType(TypeConstants.NODE, OccurrenceIndicator.ZERO_OR_MORE);
            }
        } else {
            type = this.visitExpression(expr);
            if (n > 0) {
                if (type instanceof ItemType) {
                    type = new XSequenceType((ItemType)type, OccurrenceIndicator.ZERO_OR_MORE);
                } else if (type instanceof CollectionType) {
                    ((CollectionType)type).setCanBeEmpty(true);
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            Expr expr2 = stepExpr.getPredicateAt(i);
            this.predicate(expr2);
        }
        ASTDecorator2.setType(stepExpr, type);
        return type;
    }

    private Type axisStepExpression(StepExpr stepExpr) throws TypeCheckError {
        NodeType nodeType = this.getTypeForStep(stepExpr, this._compiler);
        int n = nodeType.getId();
        stepExpr.setStepNodeType(n);
        if (n == 7) {
            XSLTCHelper.processingInstructionTestRewrite(stepExpr, this._parser);
        }
        if (n == 9) {
            XSLTC2Helper.documentTestRewrite(this._parser, stepExpr, this._parser);
        }
        Type type = nodeType.getType();
        int n2 = stepExpr.getPredicateCount();
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            // empty if block
        }
        for (int i = 0; i < n2; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            this.predicate(expr);
        }
        ASTDecorator2.setType(stepExpr, type);
        return type;
    }

    protected Type stepPattern(Expr expr) throws TypeCheckError {
        StepExpr stepExpr = (StepExpr)expr;
        NodeType nodeType = this.getTypeForStep(stepExpr, this._compiler);
        int n = nodeType.getId();
        stepExpr.setStepNodeType(n);
        int n2 = stepExpr.getPredicateCount();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Expr expr2 = stepExpr.getPredicateAt(i);
                this.predicate(expr2);
            }
        }
        return nodeType.getType();
    }

    protected Type emptySequence(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.EMPTY);
        return TypeConstants.EMPTY;
    }

    protected Type stringLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.STRING);
        return TypeConstants.STRING;
    }

    protected Type integerLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.INTEGER);
        return TypeConstants.INTEGER;
    }

    protected Type decimalLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.DECIMAL);
        return TypeConstants.DECIMAL;
    }

    protected Type doubleLiteral(Expr expr) {
        ASTDecorator2.setType(expr, TypeConstants.DOUBLE);
        return TypeConstants.DOUBLE;
    }

    protected Type unaryExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        if (operatorExpr.getOperatorType() == 26) {
            int n = this.getOperatorIndex(operatorExpr);
            PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = this._compiler.getOperatorDeclaration(n);
            return this.standardPolymorphicFunctionCall(polymorphicFunctionDeclaration, operatorExpr, true);
        }
        Type type = this.visitExpression(operatorExpr.getOperand(0));
        ASTDecorator2.setType(expr, type);
        return type;
    }

    protected Type unionExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        if (n != 2) {
            throw new StaticError(operatorExpr);
        }
        for (int i = 0; i < 2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            Type type = this.visitExpression(expr2);
        }
        ASTDecorator2.setType(expr, TypeConstants.NODE);
        return TypeConstants.NODE;
    }

    protected Type predicate(Expr expr) throws TypeCheckError {
        Type type = this.visitExpression(expr);
        if (type == TypeConstants.INTEGER) {
            Node node;
            Expr expr2 = (Expr)expr.jjtGetParent();
            boolean bl = false;
            if (XSLTCHelper.hasLastCall(expr) || XSLTCHelper.isPattern(expr2) || XSLTCHelper.isFilterStep(expr2)) {
                if (XSLTCHelper.isPattern(expr2) && !XSLTCHelper.hasLastCall(expr)) {
                    ASTDecorator.setNthPositionFilter(expr, ASTDecorator.getCanOptimize(expr));
                } else if (XSLTCHelper.isFilterStep(expr2)) {
                    StepExpr stepExpr = (StepExpr)expr2;
                    Expr expr3 = null;
                    try {
                        expr3 = stepExpr.getPrimaryExpr();
                    }
                    catch (XPath20Exception xPath20Exception) {
                        throw new StaticError(expr);
                    }
                    boolean bl2 = true;
                    if (XSLTCHelper.isKeyCall(expr3)) {
                        bl2 = false;
                    } else if (expr3 instanceof VariableRef) {
                        bl2 = false;
                    } else if (expr3 instanceof PathExpr) {
                        bl2 = false;
                    } else if (expr3.getId() == 63) {
                        bl2 = false;
                    } else if (XSLTCHelper.hasLastCall(expr)) {
                        bl2 = false;
                    } else if (stepExpr.jjtGetParent() instanceof PathExpr && ((PathExpr)stepExpr.jjtGetParent()).getOperandCount() > 1) {
                        bl2 = false;
                    }
                    ASTDecorator.setCanOptimize(expr, bl2);
                    if (bl2) {
                        bl = true;
                    }
                }
                if (bl) {
                    ASTDecorator.setNthPositionFilter(expr, true);
                    return TypeConstants.NODE;
                }
                return TypeConstants.INTEGER;
            }
            if (expr2 != null && expr2.getId() == 85 && (node = expr2.jjtGetParent()) != null && node instanceof PathExpr) {
                PathExpr pathExpr = (PathExpr)node;
                Expr expr4 = null;
                try {
                    if (pathExpr.isAbsolute() && (expr4 = pathExpr.getOperand(1)) instanceof StepExpr && ((StepExpr)expr4).getAxisType() == 13) {
                        ASTDecorator.setNthDescendant(expr, true);
                        return TypeConstants.NODE;
                    }
                }
                catch (XPath20Exception xPath20Exception) {
                    throw new StaticError(expr);
                }
            }
            ASTDecorator.setNthPositionFilter(expr, true);
            return TypeConstants.NODE;
        }
        if (type == TypeConstants.BOOLEAN && XSLTCHelper.hasPositionCall(expr)) {
            ASTDecorator.setNthPositionFilter(expr, true);
        }
        ASTDecorator.setNthPositionFilter(expr, false);
        Translator2Helper.getCompareValue(expr);
        return TypeConstants.BOOLEAN;
    }

    protected Type variableOrParameterReference(Expr expr) throws TypeCheckError {
        String string;
        VariableRef variableRef = (VariableRef)expr;
        Type type = ASTDecorator2.getType(variableRef);
        if (type != null) {
            return type;
        }
        QName qName = variableRef.getVariableName();
        String string2 = qName.getLocalPart();
        String string3 = qName.getNamespaceURI();
        QName qName2 = this._parser.getQName(string3, string = qName.getPrefix(), string2);
        VariableBase variableBase = this.lookupVariable(qName2);
        if (variableBase == null) {
            if (XSLTCHelper.isJAXPVariable(variableRef, this.getCompiler())) {
                type = TypeConstants.UNTYPEDATOMIC;
                ASTDecorator2.setType(variableRef, type);
                return type;
            }
            throw new StaticError(expr);
        }
        ASTDecorator.setVariable(variableRef, variableBase);
        if (variableBase.isLocal()) {
            SimpleNode simpleNode = variableRef;
            do {
                if (!XSLTCHelper.isClosure(simpleNode)) continue;
                ASTDecorator.setClosure(variableRef, simpleNode);
                XSLTCHelper.addVariableToClosure(simpleNode, variableRef);
                break;
            } while (!(simpleNode instanceof TopLevelDecl) && (simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null);
        }
        if ((type = ASTDecorator2.getVariableType(variableBase)) == null) {
            this.visitTree(variableBase);
            type = ASTDecorator2.getVariableType(variableBase);
        }
        ASTDecorator2.setType(variableRef, type);
        return type;
    }

    protected Type castableAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Expr expr2 = sequenceTypeOperator.getLHS();
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        Type type = this.visitExpression(expr2);
        type = type.getAtomizedType();
        boolean bl = false;
        Type type2 = (Type)((Object)this.getCompiler().getTypeFactory().getTypeFromName(typeExpr.getTypeName()));
        if (type2 == null) {
            throw new StaticError(expr);
        }
        if (!(type2 instanceof AnyAtomicType)) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 0 || typeExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(expr);
        }
        if (type2 == TypeConstants.ANYATOMICTYPE) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 2) {
            bl = true;
        }
        int n = type.castableAs((AnyAtomicType)type2, bl);
        if (bl && type.getQuantifier().canBeEmpty()) {
            type2 = new XSequenceType((AnyAtomicType)type2, OccurrenceIndicator.ZERO_OR_ONE);
        }
        ASTDecorator2.setCastableAsResult(expr, n);
        ASTDecorator2.setType(expr, type2);
        return TypeConstants.BOOLEAN;
    }

    protected Type castAsExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Expr expr2 = sequenceTypeOperator.getLHS();
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        Type type = this.visitExpression(expr2);
        type = type.getAtomizedType();
        boolean bl = false;
        Type type2 = (Type)((Object)this.getCompiler().getTypeFactory().getTypeFromName(typeExpr.getTypeName()));
        if (type2 == null) {
            throw new StaticError(expr);
        }
        if (!(type2 instanceof AnyAtomicType)) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 0 || typeExpr.getOccurrenceIndicator() == 1) {
            throw new StaticError(expr);
        }
        if (type2 == TypeConstants.ANYATOMICTYPE) {
            throw new StaticError(expr);
        }
        if (type.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            throw new StaticError(expr);
        }
        if (typeExpr.getOccurrenceIndicator() == 2) {
            bl = true;
        }
        if (type == TypeConstants.EMPTY && typeExpr.getOccurrenceIndicator() == 3) {
            throw new StaticError(expr);
        }
        int n = type.castableAs((AnyAtomicType)type2, bl);
        if (n == 0) {
            throw new StaticError(expr);
        }
        if (bl && type.getQuantifier().canBeEmpty()) {
            type2 = new XSequenceType((AnyAtomicType)type2, OccurrenceIndicator.ZERO_OR_ONE);
        }
        ASTDecorator2.setType(expr, type2);
        return type2;
    }

    protected Type everyExpression(Expr expr) {
        return null;
    }

    protected Type forExpression(Expr expr) throws TypeCheckError {
        Object object;
        Object object2;
        FLWORExpr fLWORExpr = (FLWORExpr)expr;
        int n = fLWORExpr.getClauseCount();
        for (int i = 0; i < n; ++i) {
            object2 = fLWORExpr.getVardecl(i);
            Expr expr2 = ((VariableBase)object2).getExpression();
            object = this.visitExpression(expr2);
            if (object instanceof CollectionType) {
                object = ((CollectionType)object).getPrimeType();
            }
            ASTDecorator2.setVariableType((VariableBase)object2, (Type)object);
            this.addVariable((VarDecl)object2);
        }
        Expr expr3 = fLWORExpr.getResultingExpr();
        object2 = this.visitExpression(expr3);
        ASTDecorator2.setType(expr3, (Type)object2);
        for (int i = 0; i < n; ++i) {
            object = fLWORExpr.getVariableName(i);
            this.removeVariable((QName)object);
        }
        return object2;
    }

    protected Type ifExpression(Expr expr) throws TypeCheckError {
        Type type;
        ConditionalExpr conditionalExpr = (ConditionalExpr)expr;
        Expr expr2 = conditionalExpr.getThenExpr();
        Expr expr3 = conditionalExpr.getElseExpr();
        Type type2 = this.visitExpression(conditionalExpr.getTestExpr());
        Type type3 = this.visitExpression(expr2);
        if (type3.equals(type = this.visitExpression(expr3))) {
            return type3;
        }
        return new ChoiceType(type3, type);
    }

    protected Type instanceofExpression(Expr expr) throws TypeCheckError {
        SequenceTypeOperator sequenceTypeOperator = (SequenceTypeOperator)expr;
        Type type = this.visitExpression(sequenceTypeOperator.getLHS());
        TypeExpr typeExpr = sequenceTypeOperator.getSequenceType();
        XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
        if (xSequenceType == null) {
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_INSTANCE_OF");
            throw new StaticError(errorMsg);
        }
        if (xSequenceType instanceof DocumentType) {
            // empty if block
        }
        if (!(type.getPrimeType() instanceof UntypedAtomic)) {
            int n = type.typeMatches(xSequenceType);
            if (n == 1) {
                ASTDecorator2.setCompileTimeEvaluationValue(expr, Boolean.TRUE);
            } else {
                ASTDecorator2.setSequenceType(sequenceTypeOperator, xSequenceType);
            }
        } else {
            ASTDecorator2.setSequenceType(sequenceTypeOperator, xSequenceType);
        }
        ASTDecorator2.setType(sequenceTypeOperator, TypeConstants.BOOLEAN);
        return TypeConstants.BOOLEAN;
    }

    protected Type intersectOrExceptExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        if (n != 2) {
            throw new StaticError(operatorExpr);
        }
        for (int i = 0; i < 2; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            Type type = this.visitExpression(expr2);
        }
        ASTDecorator2.setType(expr, TypeConstants.NODE);
        return TypeConstants.NODE;
    }

    protected Type quantifiedExpression(Expr expr) throws TypeCheckError {
        Object object;
        Object object2;
        QuantifiedExpr quantifiedExpr = (QuantifiedExpr)expr;
        int n = quantifiedExpr.getClauseCount();
        for (int i = 0; i < n; ++i) {
            object2 = quantifiedExpr.getVardecl(i);
            Expr expr2 = ((VariableBase)object2).getExpression();
            object = this.visitExpression(expr2);
            if (object instanceof CollectionType) {
                object = ((CollectionType)object).getPrimeType();
            }
            ASTDecorator2.setVariableType((VariableBase)object2, (Type)object);
            this.addVariable((VarDecl)object2);
        }
        Expr expr3 = quantifiedExpr.getResultingExpr();
        object2 = this.visitExpression(expr3);
        ASTDecorator2.setType(expr3, (Type)object2);
        for (int i = 0; i < n; ++i) {
            object = quantifiedExpr.getVariableName(i);
            this.removeVariable((QName)object);
        }
        return TypeConstants.BOOLEAN;
    }

    protected Type rangeExpression(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            this.visitExpression(expr2);
        }
        AnyAtomicType anyAtomicType = TypeConstants.INTEGER;
        ASTDecorator2.setType(expr, anyAtomicType);
        return anyAtomicType;
    }

    protected Type someExpression(Expr expr) {
        return null;
    }

    protected Type treatAsExpression(Expr expr) throws TypeCheckError {
        TreatExpr treatExpr = (TreatExpr)expr;
        Type type = this.visitExpression(treatExpr.getExpr());
        TypeExpr typeExpr = treatExpr.getSequenceType();
        XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
        if (xSequenceType == null) {
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_TREAT_AS_2");
            throw new StaticError(errorMsg);
        }
        int n = type.typeMatches(xSequenceType);
        if (n == 0) {
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_TREAT_AS");
            throw new StaticError(errorMsg);
        }
        Type type2 = n == 1 ? type : xSequenceType;
        ASTDecorator2.setTreatAsResult(treatExpr, n);
        return type2;
    }

    public NodeType getTypeForStep(StepExpr stepExpr, XPathCompiler xPathCompiler) {
        NodeTest nodeTest = null;
        short s = 0;
        try {
            nodeTest = stepExpr.getNodeTest();
            s = stepExpr.getAxisType();
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
        XSLTParser xSLTParser = xPathCompiler.getParser();
        if (nodeTest.isNameTest()) {
            NameTest nameTest = (NameTest)nodeTest;
            QName qName = nameTest.getQName();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (qName != null) {
                string2 = qName.getLocalPart();
                string3 = qName.getPrefix();
                string = s == 4 && string3.equals("") ? "" : qName.getNamespaceURI();
            } else {
                short s2 = nameTest.getNameTestType();
                if (s2 == 0) {
                    if (s == 12) {
                        return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
                    }
                    if (s == 4) {
                        return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
                    }
                    return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
                }
                if (s2 == 1) {
                    string3 = nameTest.getNCName();
                    string = this._staticContext.lookupNamespace(string3);
                    string2 = "*";
                    if (stepExpr.getId() == 188 && stepExpr.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(stepExpr, -0.25);
                    }
                } else if (s2 == 2) {
                    string2 = nameTest.getNCName();
                    if (stepExpr.getId() == 188 && stepExpr.getPredicateCount() == 0) {
                        ASTDecorator.setPatternPriority(stepExpr, -0.25);
                    }
                }
                qName = string3 != null ? new QName(string, string2, string3) : new QName(string2);
            }
            if (s == 12) {
                if (qName != null) {
                    QName qName2 = new QName("", string2, "xmlns");
                    return new NodeType(null, xPathCompiler.registerNamespaceDecl(qName2));
                }
                return NULL_NODE;
            }
            QName qName3 = xSLTParser.getQName(string, string3, string2);
            if (s == 4) {
                int n = xPathCompiler.registerAttribute(qName3);
                AttributeType attributeType = new AttributeType(qName, TypeConstants.UNTYPEDATOMIC);
                return new NodeType(new XSequenceType(attributeType, OccurrenceIndicator.ZERO_OR_MORE), n);
            }
            int n = xPathCompiler.registerElement(qName3);
            ElementType elementType = new ElementType(qName, TypeConstants.UNTYPEDANY);
            return new NodeType(new XSequenceType(elementType, OccurrenceIndicator.ZERO_OR_MORE), n);
        }
        KindTest kindTest = (KindTest)nodeTest;
        short s3 = kindTest.getKindTestType();
        switch (s3) {
            case 0: {
                return new NodeType(ExtendedTypes.PI_ZERO_OR_MORE, 7);
            }
            case 1: {
                return new NodeType(ExtendedTypes.COMMENT_ZERO_OR_MORE, 8);
            }
            case 2: {
                return new NodeType(ExtendedTypes.NODE_ZERO_OR_MORE, -1);
            }
            case 3: {
                return new NodeType(ExtendedTypes.TEXT_ZERO_OR_MORE, 3);
            }
            case 4: {
                return new NodeType(ExtendedTypes.DOCUMENT_ZERO_OR_MORE, 9);
            }
            case 7: {
                this.testInScopeElementDeclarations(kindTest.getTypeName());
            }
            case 5: {
                return new NodeType(ExtendedTypes.ELEMENT_ZERO_OR_MORE, 1);
            }
            case 8: {
                this.testInScopeAttributeDeclarations(kindTest.getTypeName());
            }
            case 6: {
                return new NodeType(ExtendedTypes.ATTRIBUTE_ZERO_OR_MORE, 2);
            }
        }
        return NULL_NODE;
    }

    protected Type slashSlashPattern(Expr expr) throws TypeCheckError {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        int n = operatorExpr.getOperandCount();
        Type type = null;
        for (int i = 0; i < n; ++i) {
            Expr expr2 = operatorExpr.getOperand(i);
            type = this.visitExpression(expr2);
        }
        return type;
    }

    private boolean testInScopeElementDeclarations(QName qName) {
        if (this._staticContext.getInScopeElementDeclaration(qName) == null) {
            throw new StaticError("NOT_DEFINED_IN_STATIC_CONTEXT", qName.toString());
        }
        return true;
    }

    private boolean testInScopeAttributeDeclarations(QName qName) {
        if (this._staticContext.getInScopeAttributeDeclaration(qName) == null) {
            throw new StaticError("NOT_DEFINED_IN_STATIC_CONTEXT", qName.toString());
        }
        return true;
    }

    static class NodeType {
        private Type _type;
        private int _id;

        public NodeType(Type type, int n) {
            this._type = type;
            this._id = n;
        }

        public Type getType() {
            return this._type;
        }

        public int getId() {
            return this._id;
        }
    }
}

