/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v2;

import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xtq.ast.nodes.CallTemplate;
import com.ibm.xtq.ast.nodes.Choose;
import com.ibm.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xtq.ast.nodes.Copy;
import com.ibm.xtq.ast.nodes.CopyOf;
import com.ibm.xtq.ast.nodes.DirCommentConstructor;
import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.ForEach;
import com.ibm.xtq.ast.nodes.ForEachGroup;
import com.ibm.xtq.ast.nodes.If;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.Otherwise;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.nodes.ValueOf;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.nodes.When;
import com.ibm.xtq.ast.nodes.WithParam;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.xml.types.AttributeType;
import com.ibm.xtq.xml.types.CommentType;
import com.ibm.xtq.xml.types.DocumentType;
import com.ibm.xtq.xml.types.ElementType;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.ProcessingInstructionType;
import com.ibm.xtq.xml.types.TextType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.ToHTMLStream;
import org.apache.xml.serializer.ToXHTMLStream;

public class Translator2Helper
implements Constants {
    public static ElemDesc getElemDesc(DirElemConstructor dirElemConstructor) {
        ElemDesc elemDesc = null;
        int n = dirElemConstructor.getXTQProgram().getOutputMethod();
        switch (n) {
            case 2: {
                elemDesc = ToHTMLStream.getElemDesc(dirElemConstructor.getQName());
                break;
            }
            case 4: {
                elemDesc = ToXHTMLStream.getElemDesc(dirElemConstructor.getQName());
            }
        }
        return elemDesc;
    }

    private static boolean isSimpleRTF(Expr expr) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (Translator2Helper.isTextElement(expr2, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAdaptiveRTF(Expr expr) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (Translator2Helper.isTextElement(expr2, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTextElement(Expr expr, boolean bl) {
        if (expr instanceof ValueOf || expr instanceof Number || expr instanceof Text) {
            return true;
        }
        if (expr instanceof If) {
            return bl ? Translator2Helper.isAdaptiveRTF(expr) : Translator2Helper.isSimpleRTF(expr);
        }
        if (expr instanceof Choose) {
            int n = expr.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                Expr expr2 = (Expr)expr.jjtGetChild(i);
                if (expr2 instanceof Text || (expr2 instanceof When || expr2 instanceof Otherwise) && (bl && Translator2Helper.isAdaptiveRTF(expr2) || !bl && Translator2Helper.isSimpleRTF(expr2))) continue;
                return false;
            }
            return true;
        }
        return bl && (expr instanceof CallTemplate || expr instanceof ApplyTemplates);
    }

    public static boolean canLoadAsArrayOffsetLength(Text text) {
        return text.getText().length() <= 21845;
    }

    public static Template getCalleeTemplate(CallTemplate callTemplate) {
        XTQProgram xTQProgram = callTemplate.getXTQProgram();
        xTQProgram = xTQProgram.getTopLevelXTQProgram();
        List list = xTQProgram.getAllValidTemplates();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Template template = (Template)list.get(i);
            if (template.getQName() != callTemplate.getQName()) continue;
            return template;
        }
        return null;
    }

    protected static boolean buildParameterList(CallTemplate callTemplate, Object[] objectArray) {
        Object object;
        Expr expr;
        boolean bl;
        boolean bl2 = callTemplate.jjtGetNumChildren();
        int n = objectArray.length;
        block0: for (bl = false; bl < bl2; bl += 1) {
            Node node = callTemplate.jjtGetChild(bl ? 1 : 0);
            if (!(node instanceof WithParam) || ((WithParam)(expr = (WithParam)node)).isTunnel()) continue;
            object = ((WithParam)expr).getQName();
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof Param && ((Param)object2).getQName() == object) {
                    objectArray[i] = expr;
                    continue block0;
                }
                if (!(object2 instanceof WithParam) || ((WithParam)object2).getQName() != object) continue;
                objectArray[i] = expr;
                continue block0;
            }
        }
        bl = false;
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof Param)) continue;
            expr = (Param)objectArray[i];
            object = ((VariableBase)expr).getExpression();
            if (expr.jjtGetNumChildren() <= 0 && (object == null || !XSLTCHelper.hasVariableReferences((Expr)object))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean canProduceAttributeNodes(Expr expr, boolean bl) {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (expr2 instanceof Text) {
                Text text = (Text)expr2;
                if (text.isIgnore()) continue;
                return false;
            }
            if (expr2 instanceof DirElemConstructor || expr2 instanceof ValueOf || expr2 instanceof CompElemConstructor || expr2 instanceof DirCommentConstructor || expr2 instanceof Number || expr2 instanceof DirPIConstructor) {
                return false;
            }
            if (expr2 instanceof CompAttrConstructor) {
                if (bl) continue;
                return true;
            }
            if (expr2 instanceof CallTemplate || expr2 instanceof ApplyTemplates || expr2 instanceof Copy || expr2 instanceof CopyOf) {
                return true;
            }
            if ((expr2 instanceof If || expr2 instanceof ForEach || expr2 instanceof ForEachGroup) && Translator2Helper.canProduceAttributeNodes(expr2, false)) {
                return true;
            }
            if (!(expr2 instanceof Choose)) continue;
            int n2 = expr2.jjtGetNumChildren();
            for (int j = 0; j < n2; ++j) {
                Expr expr3 = (Expr)expr2.jjtGetChild(j);
                if (!(expr3 instanceof When) && !(expr3 instanceof Otherwise) || !Translator2Helper.canProduceAttributeNodes(expr3, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected static int getMinPrecedence(Expr expr, int n) {
        XTQProgram xTQProgram = expr.getXTQProgram();
        XTQProgram xTQProgram2 = expr.getXTQProgram().getTopLevelXTQProgram();
        int n2 = n;
        int n3 = xTQProgram2.jjtGetNumChildren();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Expr expr2 = (Expr)xTQProgram2.jjtGetChild(i);
            if (!(expr2 instanceof Template)) continue;
            XTQProgram xTQProgram3 = expr2.getXTQProgram();
            while (xTQProgram3 != null && xTQProgram3 != xTQProgram) {
                if (xTQProgram3._importedFrom != null) {
                    xTQProgram3 = xTQProgram3._importedFrom;
                    continue;
                }
                if (xTQProgram3._includedFrom != null) {
                    xTQProgram3 = xTQProgram3._includedFrom;
                    continue;
                }
                xTQProgram3 = null;
            }
            if (xTQProgram3 != xTQProgram || (n4 = expr2.getXTQProgram().getImportPrecedence()) >= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    public static boolean hasBadChars(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= ' ' && '~' >= c && c != '<' && c != '>' && c != '&' && c != '\"') continue;
            return true;
        }
        return false;
    }

    public static Type getRealType(Expr expr) {
        Type type = ASTDecorator2.getExpressionCastType(expr);
        if (type != null) {
            return type;
        }
        return ASTDecorator2.getType(expr);
    }

    protected static boolean isNodeValueTest(Expr expr) {
        if (!ASTDecorator.getCanOptimize(expr)) {
            return false;
        }
        return XSLTCHelper.getStepForPredicate(expr) != null && Translator2Helper.getCompareValue(expr) != null;
    }

    public static Expr getCompareValue(Expr expr) {
        Expr expr2 = ASTDecorator.getCompareValue(expr);
        if (expr2 != null) {
            return expr2;
        }
        if (expr == null) {
            return null;
        }
        if (expr.getId() == 59) {
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            if (operatorExpr.getOperatorType() != 13 && operatorExpr.getOperatorType() != 14) {
                return null;
            }
            Expr expr3 = operatorExpr.getOperand(0);
            Expr expr4 = operatorExpr.getOperand(1);
            Type type = Translator2Helper.getRealType(expr3);
            Type type2 = Translator2Helper.getRealType(expr4);
            if (type == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(expr3)) {
                expr2 = expr3;
            } else if (expr3 instanceof VariableRef) {
                expr2 = expr3;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
            if (type2 == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(expr4)) {
                expr2 = expr4;
            } else if (expr4 instanceof VariableRef) {
                expr2 = expr4;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
        }
        return null;
    }

    public static void composeSignatureFromClass(StringBuffer stringBuffer, String string) {
        if (string.length() == 1) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('L');
            stringBuffer.append(string.replace('.', '/'));
            stringBuffer.append(';');
        }
    }

    public static String composeSignatureFromClass(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Translator2Helper.composeSignatureFromClass(stringBuffer, string);
        return stringBuffer.toString();
    }

    public static String composeCastLibMethodFromQName(QName qName) {
        String string = qName.getLocalPart();
        char c = string.charAt(0);
        return "to" + Character.toUpperCase(c) + string.substring(1);
    }

    public static String composeTypeMethodFromQName(QName qName) {
        String string = qName.getLocalPart();
        return string.toUpperCase();
    }

    static final String getOperatorClass(FunctionDeclaration functionDeclaration) {
        XSequenceType xSequenceType = functionDeclaration.getArgumentType(0);
        return xSequenceType.getBaseType().getRuntimeType();
    }

    static final String getOperatorMethod(OperatorExpr operatorExpr) {
        switch (operatorExpr.getOperatorType()) {
            case 4: {
                return "add";
            }
            case 5: {
                return "subtract";
            }
            case 30: {
                return "multiply";
            }
            case 31: {
                return "divide";
            }
            case 32: {
                return "idiv";
            }
            case 33: {
                return "mod";
            }
            case 7: {
                return "equals";
            }
            case 8: {
                return "notEquals";
            }
            case 11: {
                return "greaterThan";
            }
            case 9: {
                return "lessThan";
            }
            case 12: {
                return "greaterOrEquals";
            }
            case 10: {
                return "lessOrEquals";
            }
            case 26: {
                return "negate";
            }
            case 25: {
                return "nop()";
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return "g_compareF";
            }
        }
        return null;
    }

    public static final boolean isOperatorOnAtomicTypes(OperatorExpr operatorExpr) {
        switch (operatorExpr.getOperatorType()) {
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 30: {
                return true;
            }
            case 31: {
                return true;
            }
            case 32: {
                return true;
            }
            case 33: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 11: {
                return true;
            }
            case 9: {
                return true;
            }
            case 12: {
                return true;
            }
            case 10: {
                return true;
            }
            case 26: {
                return true;
            }
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isGeneralComparisonsOperator(OperatorExpr operatorExpr) {
        switch (operatorExpr.getOperatorType()) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static final int getXDMNodeType(ItemType itemType) {
        if (itemType instanceof ElementType) {
            return 1;
        }
        if (itemType instanceof AttributeType) {
            return 2;
        }
        if (itemType instanceof TextType) {
            return 3;
        }
        if (itemType instanceof CommentType) {
            return 8;
        }
        if (itemType instanceof ProcessingInstructionType) {
            return 7;
        }
        if (itemType instanceof DocumentType) {
            return 9;
        }
        return -1;
    }
}

