/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v1;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.runtime.extensions.XSLTObjectType;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.TranslatorHelper;
import com.ibm.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v1.XPathTranslator;
import com.ibm.xtq.xslt.typechecker.v1.types.NumberType;
import com.ibm.xtq.xslt.typechecker.v1.types.ReferenceType;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import com.ibm.xtq.xslt.xylem.instructions.AbsoluteCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CountInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListFilterInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ForwardPositionCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetDocumentRootInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetLastInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeValueCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NthCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.PositionInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SingleNodeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StepCursorInstruction;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.instructions.AndInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.IntType;

public class XPathPathTranslator {
    protected Module m_module;
    protected XPathTranslator m_xpathTranslator;
    protected XPathCompiler m_compiler;
    private boolean m_disableNVCursor = false;

    public XPathPathTranslator(Module module, XPathTranslator xPathTranslator, XPathCompiler xPathCompiler) {
        this.m_compiler = xPathCompiler;
        this.m_xpathTranslator = xPathTranslator;
        this.m_module = module;
    }

    public Module getModule() {
        return this.m_module;
    }

    protected Instruction pathExpression(Expr expr, String string, Instruction instruction) {
        PathExpr pathExpr = (PathExpr)expr;
        if (pathExpr.isAbsolute()) {
            return this.absolutePathExpression(pathExpr, string, instruction);
        }
        return this.relativePathExpression(pathExpr, 0, string, instruction);
    }

    public Instruction rootStepExpression(Expr expr) {
        return new GetDocumentRootInstruction();
    }

    private Instruction absolutePathExpression(PathExpr pathExpr, String string, Instruction instruction) {
        int n = pathExpr.getOperandCount();
        if (n > 1) {
            Instruction instruction2 = this.relativePathExpression(pathExpr, 1, string, this.makeNullCursorInstruction());
            return new AbsoluteCursorInstruction(new IdentifierInstruction("__context__"), instruction2);
        }
        return new GetDocumentRootInstruction();
    }

    private Instruction relativePathExpression(PathExpr pathExpr, int n, String string, Instruction instruction) {
        int n2 = pathExpr.getOperandCount();
        if (n2 == n + 1) {
            return this.m_xpathTranslator.visitRawExpression(pathExpr.getOperand(n), string, instruction);
        }
        Instruction instruction2 = this.translatePathElements(pathExpr, n, n2 - 1, string, instruction);
        return instruction2;
    }

    private Instruction translatePathElements(PathExpr pathExpr, int n, int n2, String string, Instruction instruction) {
        if (n2 == n) {
            Instruction instruction2 = this.m_xpathTranslator.visitRawExpression(pathExpr.getOperand(n), string, instruction);
            if (instruction2 == null) {
                throw new RuntimeException();
            }
            return instruction2;
        }
        Instruction instruction3 = this.translatePathElements(pathExpr, n, n2 - 1, string, instruction);
        Instruction instruction4 = this.m_xpathTranslator.visitRawExpression(pathExpr.getOperand(n2), string, this.makeNullCursorInstruction());
        if (instruction4 instanceof GetTypedAxisCursorInstruction) {
            instruction4 = GetTypedAxisCursorForStepInstruction.makeIntoTypedAxisCursorForStepInstruction((GetTypedAxisCursorInstruction)instruction4);
        } else if (instruction4 instanceof GetAxisCursorInstruction) {
            instruction4 = GetAxisCursorForStepInstruction.makeIntoAxisCursorForStepInstruction((GetAxisCursorInstruction)instruction4);
        }
        return new StepCursorInstruction(new CoerceInstruction(instruction3, CursorType.s_cursorType), new CoerceInstruction(instruction4, CursorType.s_cursorType));
    }

    public Instruction makeNullCursorInstruction() {
        return new FunctionCallInstruction("empty-cursor", new Instruction[]{new IdentifierInstruction("__root__")});
    }

    protected Instruction stepExpression(Expr expr, String string, Instruction instruction) {
        Expr expr2;
        if (expr instanceof IdOrKeyFunctionCallPattern && ((IdOrKeyFunctionCallPattern)(expr2 = (IdOrKeyFunctionCallPattern)expr)).isIdFunc()) {
            return new IDInstruction(this.m_xpathTranslator.visitRawExpression(((FunctionCall)expr2).getOperand(0), string, new IdentifierInstruction("__context__")));
        }
        expr2 = (StepExpr)expr;
        try {
            if (((StepExpr)expr2).isFilterStep()) {
                return this.filterStepExpression((StepExpr)expr2, string);
            }
            return this.axisStepExpression((StepExpr)expr2, string, instruction);
        }
        catch (XPath20Exception xPath20Exception) {
            throw new WrappedRuntimeException(xPath20Exception);
        }
    }

    private Instruction filterStepExpression(StepExpr stepExpr, String string) throws XPath20Exception {
        int n = stepExpr.getPredicateCount();
        if (n > 0) {
            return this.translatePredicatesForFilterStep(stepExpr, n, string);
        }
        return this.translatePrimaryExpression(stepExpr, string);
    }

    private Instruction translatePrimaryExpression(StepExpr stepExpr, String string) throws XPath20Exception {
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            return this.contextItemExpression(stepExpr);
        }
        Expr expr = stepExpr.getPrimaryExpr();
        return this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__"));
    }

    private Instruction translatePredicatesForFilterStep(StepExpr stepExpr, int n, String string) throws XPath20Exception {
        if (n == 0) {
            return this.translatePrimaryExpression(stepExpr, string);
        }
        Expr expr = stepExpr.getPredicateAt(n - 1);
        XSLTLinkerSettings xSLTLinkerSettings = this.m_xpathTranslator.getLinkerSettings();
        if (ASTDecorator.isNthPositionFilter(expr)) {
            Instruction instruction = this.translatePredicatesForFilterStep(stepExpr, n - 1, string);
            return new NthCursorInstruction(instruction, new CoerceInstruction(this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), IntType.s_intType));
        }
        if (xSLTLinkerSettings.isTestInputSpecialization() && ASTDecorator1.getType(expr) instanceof NumberType) {
            Instruction instruction = this.translatePredicatesForFilterStep(stepExpr, n - 1, string);
            return new LetInstruction("__context__", instruction, new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), new NthCursorInstruction(new IdentifierInstruction("__context__"), new CoerceInstruction(this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), IntType.s_intType)))));
        }
        return new CurrentNodeListCursorInstruction(new ForwardPositionCursorInstruction(new CoerceInstruction(this.translatePredicatesForFilterStep(stepExpr, n - 1, string), CursorType.s_cursorType)), this.translatePredicateFilter(expr, string), new IdentifierInstruction("__current__"));
    }

    private Instruction axisStepExpression(StepExpr stepExpr, String string, Instruction instruction) throws XPath20Exception {
        int n = stepExpr.getPredicateCount();
        if (n > 0) {
            return this.translatePredicatesForAxisStep(stepExpr, n, string, instruction);
        }
        return this.translateNodeTestForAxisStep(stepExpr, instruction);
    }

    public Instruction translateNodeTestForAxisStep(StepExpr stepExpr, Instruction instruction) throws XPath20Exception {
        int n = stepExpr.getStepNodeType();
        if (XSLTCHelper.isAbbreviatedDot(stepExpr)) {
            return new IdentifierInstruction("__context__");
        }
        if (stepExpr.getAxisType() == 4 && !XSLTCHelper.isWildcardNodeTest(stepExpr) && !XSLTCHelper.hasParentPattern(stepExpr)) {
            return new GetTypedAxisCursorInstruction(2, n, instruction);
        }
        int n2 = stepExpr.getAxisType();
        n2 = XSLTCHelper.xpathAxis2DTMAxis(n2);
        switch (n) {
            case 2: {
                n2 = 2;
            }
            case -1: {
                return new GetAxisCursorInstruction(n2, instruction);
            }
        }
        return new GetTypedAxisCursorInstruction(n2, n, instruction);
    }

    protected Instruction contextItemExpression(Expr expr) {
        if (ASTDecorator1.getType(expr) == Type.Node) {
            return new IdentifierInstruction("__context__");
        }
        return new SingleNodeInstruction();
    }

    protected void dump(Instruction instruction) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        instruction.toString(prettyPrinter, 2);
        String string = prettyPrinter.toString();
        System.out.println("============");
        System.out.println(string);
        System.out.println("============");
    }

    public Instruction translatePredicatesForAxisStep(StepExpr stepExpr, int n, String string, Instruction instruction) throws XPath20Exception {
        EqualityInstruction equalityInstruction;
        CoerceInstruction coerceInstruction;
        Instruction instruction2;
        Instruction instruction3;
        Instruction instruction4;
        if (n == 0) {
            return this.translateNodeTestForAxisStep(stepExpr, instruction);
        }
        Expr expr = stepExpr.getPredicateAt(n - 1);
        Object[] objectArray = this.predicate(expr, string);
        if (!this.m_disableNVCursor && objectArray.length == 2 && TranslatorHelper.isNodeValueTest(expr)) {
            int n2;
            Instruction instruction5;
            StepExpr stepExpr2 = XSLTCHelper.getStepForPredicate(expr);
            if (XSLTCHelper.isAbbreviatedDot(stepExpr2)) {
                instruction5 = this.translateNodeTestForAxisStep(stepExpr, instruction);
                n2 = 0;
            } else {
                Instruction instruction6 = this.translatePredicatesForAxisStep(stepExpr, n - 1, string, instruction);
                Instruction instruction7 = this.m_xpathTranslator.visitRawExpression(stepExpr2, string, this.makeNullCursorInstruction());
                if (instruction6 == null) {
                    throw new RuntimeException();
                }
                if (instruction7 instanceof GetTypedAxisCursorInstruction) {
                    instruction7 = GetTypedAxisCursorForStepInstruction.makeIntoTypedAxisCursorForStepInstruction((GetTypedAxisCursorInstruction)instruction7);
                }
                instruction5 = new StepCursorInstruction(new CoerceInstruction(instruction6, CursorType.s_cursorType), new CoerceInstruction(instruction7, CursorType.s_cursorType));
                n2 = 1;
            }
            return new GetNodeValueCursorInstruction(instruction5, n2, TranslatorUtilities.coerceToString((Instruction)objectArray[0]), (Boolean)objectArray[1]);
        }
        if (ASTDecorator.isNthDescendant(expr)) {
            throw new StaticError("ERR_UNSUPPORTED_EXP", "//*[n]");
        }
        if (ASTDecorator.isNthPositionFilter(expr)) {
            if (stepExpr.isPatternStepRewrittenToPredicate()) {
                Instruction instruction8 = this.translatePredicatesForAxisStep(stepExpr, n - 1, string, instruction);
                Instruction instruction9 = this.generateContextPositionForPredicateRewritePatterns(stepExpr, n, string, instruction.cloneWithoutTypeInformation());
                EqualityInstruction equalityInstruction2 = new EqualityInstruction(new IdentifierInstruction("__contextposition__"), new CoerceInstruction((Instruction)objectArray[0], IntType.s_intType), false);
                CoerceInstruction coerceInstruction2 = new CoerceInstruction(new IdentifierInstruction("__context__"), BooleanType.s_booleanType);
                AndInstruction andInstruction = new AndInstruction(coerceInstruction2, equalityInstruction2);
                LetInstruction letInstruction = new LetInstruction("__context__", instruction8, new LetInstruction("__contextposition__", instruction9, new LetInstruction("__contextlast__", new GetLastInstruction(), andInstruction)));
                return letInstruction;
            }
            Instruction instruction10 = this.translatePredicatesForAxisStep(stepExpr, n - 1, string, instruction);
            return new LetInstruction("__context__", instruction10, new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), new NthCursorInstruction(new IdentifierInstruction("__context__"), new CoerceInstruction((Instruction)objectArray[0], IntType.s_intType)))));
        }
        Instruction instruction11 = this.translatePredicatesForAxisStep(stepExpr, n - 1, string, instruction.cloneWithoutTypeInformation());
        CoerceInstruction coerceInstruction3 = new CoerceInstruction(instruction11, CursorType.s_cursorType);
        if (stepExpr.isPatternStepRewrittenToPredicate()) {
            instruction4 = this.generateContextPositionForPredicateRewritePatterns(stepExpr, n, string, instruction);
            instruction3 = new LetInstruction("__contextposition__", instruction4, this.translatePredicateFilter(expr, string));
        } else {
            instruction3 = this.translatePredicateFilter(expr, string);
        }
        if (instruction3 instanceof CurrentNodeListFilterInstruction && (instruction2 = ((CurrentNodeListFilterInstruction)(instruction4 = (CurrentNodeListFilterInstruction)instruction3)).getBody()) instanceof CoerceInstruction && (coerceInstruction = (CoerceInstruction)instruction2).getOperand() instanceof EqualityInstruction && !(equalityInstruction = (EqualityInstruction)coerceInstruction.getOperand()).isTestingInequality()) {
            Instruction instruction12 = equalityInstruction.getOperand1();
            Instruction instruction13 = equalityInstruction.getOperand2();
            if (instruction12 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction12).getVariable().equals("__contextposition__") && (instruction13 instanceof LiteralInstruction || instruction13 instanceof IdentifierInstruction && !((IdentifierInstruction)instruction13).getVariable().equals("__contextlast__"))) {
                return new LetInstruction("__context__", coerceInstruction3, new LetInstruction("__contextlast__", new GetLastInstruction(), new NthCursorInstruction(new IdentifierInstruction("__context__"), new CoerceInstruction(instruction13, IntType.s_intType))));
            }
            if (instruction13 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction13).getVariable().equals("__contextposition__") && (instruction12 instanceof LiteralInstruction || instruction12 instanceof IdentifierInstruction && !((IdentifierInstruction)instruction12).getVariable().equals("__contextlast__"))) {
                return new LetInstruction("__context__", coerceInstruction3, new LetInstruction("__contextlast__", new GetLastInstruction(), new NthCursorInstruction(new IdentifierInstruction("__context__"), new CoerceInstruction(instruction12, IntType.s_intType))));
            }
        }
        return new CurrentNodeListCursorInstruction(coerceInstruction3, instruction3, new IdentifierInstruction("__current__"));
    }

    private Instruction generateContextPositionForPredicateRewritePatterns(StepExpr stepExpr, int n, String string, Instruction instruction) throws XPath20Exception {
        short s = stepExpr.getAxisType();
        Assert._assert(s != 4, "Attribute axis should not occur here!");
        stepExpr.setAxisType((short)9);
        Instruction instruction2 = this.translatePredicatesForAxisStep(stepExpr, n - 1, string, instruction);
        stepExpr.setAxisType(s);
        CountInstruction countInstruction = new CountInstruction(instruction2);
        LiteralInstruction literalInstruction = new LiteralInstruction(IntType.s_intType, new Integer(1));
        PrimitiveArithmeticInstruction primitiveArithmeticInstruction = new PrimitiveArithmeticInstruction(countInstruction, literalInstruction, 0);
        return primitiveArithmeticInstruction;
    }

    protected Object[] predicate(Expr expr, String string) {
        if (ASTDecorator.isNthPositionFilter(expr) || ASTDecorator.isNthDescendant(expr)) {
            return new Object[]{this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__"))};
        }
        if (TranslatorHelper.isNodeValueTest(expr) && ((Expr)expr.jjtGetParent()).getId() == 85 && !((StepExpr)expr.jjtGetParent()).isFilterStep()) {
            Expr expr2 = ASTDecorator.getCompareValue(expr);
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            return new Object[]{this.m_xpathTranslator.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")), new Boolean(operatorExpr.getOperatorType() == 13)};
        }
        return new Object[]{this.translatePredicateFilter(expr, string)};
    }

    private Instruction translatePredicateFilter(Expr expr, String string) {
        Type type = ASTDecorator1.getType(expr);
        if (type instanceof ReferenceType) {
            return new CurrentNodeListFilterInstruction(new LetInstruction("p", this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), new TypeMatchInstruction(new IdentifierInstruction("p"), new TypeMatchInstruction.Match[]{new TypeMatchInstruction.Match(IntType.s_intType, "p", new PrimitiveEqualityInstruction(new IdentifierInstruction("p"), new IdentifierInstruction("__contextposition__"))), new TypeMatchInstruction.Match(DoubleType.s_doubleType, "p", new PrimitiveEqualityInstruction(new CoerceInstruction(new IdentifierInstruction("p"), IntType.s_intType), new IdentifierInstruction("__contextposition__"))), new TypeMatchInstruction.Match(XSLTObjectType.s_xsltObjectType, "p", new ChooseInstruction(new JavaMethodInvocationInstruction("isNumber", new IdentifierInstruction("p"), new Instruction[0], (com.ibm.xylem.Type)BooleanType.s_booleanType), (Instruction)new PrimitiveEqualityInstruction(new CoerceInstruction(new IdentifierInstruction("p"), IntType.s_intType), new IdentifierInstruction("__contextposition__")), new CoerceInstruction(new IdentifierInstruction("p"), BooleanType.s_booleanType)))}, new CoerceInstruction(new IdentifierInstruction("p"), BooleanType.s_booleanType))));
        }
        if (type instanceof NumberType) {
            return new CurrentNodeListFilterInstruction(new PrimitiveEqualityInstruction(new CoerceInstruction(this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), IntType.s_intType), new IdentifierInstruction("__contextposition__")));
        }
        return new CurrentNodeListFilterInstruction(new CoerceInstruction(this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), BooleanType.s_booleanType));
    }

    public void setDisableNVCursor(boolean bl) {
        this.m_disableNVCursor = bl;
    }
}

