/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.BeginInstruction;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xylem.instructions.OnceInstruction;
import com.ibm.xylem.instructions.StreamElementInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.JavaObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamespaceHelper {
    private static final Type s_javaObjectType = new JavaObjectType("java.lang.Object");
    private static final Type s_hashtableType = new JavaObjectType("java.util.Hashtable");
    private static final String s_getStaticNamespaceTablesFunction = "get-static-namespace-tables";
    private static final String s_namespace_id_key = "com.ibm.xtq.xslt.translator.namespacehelper.namespaceid";
    public static final String s_getNSPrefixCounterFunction = "get-ns-prefix-counter";
    private List m_namespaceNodes = new ArrayList();
    static /* synthetic */ Class class$com$ibm$xtq$xslt$runtime$Counter;

    public Instruction getNamespaceId(Expr expr) {
        int n;
        Expr expr2 = this.lastNamespaceNode(expr);
        Integer n2 = (Integer)expr2.getProperty(s_namespace_id_key);
        if (n2 == null) {
            n = this.m_namespaceNodes.size();
            expr2.addProperty(s_namespace_id_key, new Integer(n));
            this.m_namespaceNodes.add(expr2);
        } else {
            n = n2;
        }
        return LiteralInstruction.integerLiteral(n);
    }

    public Function generateGetStaticNamespaceTablesFunction() {
        Object object;
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction[] instructionArray = new Instruction[this.m_namespaceNodes.size()];
        ArrayList<StreamInstruction> arrayList = new ArrayList<StreamInstruction>();
        for (int i = 0; i < this.m_namespaceNodes.size(); ++i) {
            object = (Expr)this.m_namespaceNodes.get(i);
            Instruction instruction = letChainBuilder.bind(new OnceInstruction(new NewJavaObjectInstruction(new Instruction[0], s_hashtableType)));
            this.fillInHashtable(instruction, (Expr)object, arrayList, letChainBuilder);
            instructionArray[i] = instruction;
        }
        arrayList.add(new StreamInstruction(s_hashtableType, instructionArray));
        Instruction instruction = letChainBuilder.packageUp(new BeginInstruction(arrayList));
        object = new Function(s_getStaticNamespaceTablesFunction, new Binding[0], instruction);
        ((Function)object).setMemoizeResult(true);
        return object;
    }

    public final Instruction callGetStaticNamespaceTablesFunction() {
        return new FunctionCallInstruction(s_getStaticNamespaceTablesFunction, new Instruction[0]);
    }

    public final Instruction getNamespaceTable(Expr expr) {
        Instruction instruction = this.callGetStaticNamespaceTablesFunction();
        Instruction instruction2 = this.getNamespaceId(expr);
        StreamElementInstruction streamElementInstruction = new StreamElementInstruction(instruction, instruction2);
        return streamElementInstruction;
    }

    private Expr lastNamespaceNode(Expr expr) {
        Node node;
        HashMap hashMap;
        Expr expr2 = expr;
        while (expr2 != null && ((hashMap = expr2.getPrefixMapping()) == null || hashMap.size() <= 0) && (node = expr2.jjtGetParent()) instanceof Expr) {
            expr2 = (Expr)node;
        }
        return expr2;
    }

    private void fillInHashtable(Instruction instruction, Expr expr, List list, LetChainBuilder letChainBuilder) {
        HashMap hashMap;
        Node node = expr.jjtGetParent();
        if (node != null && node instanceof Expr) {
            this.fillInHashtable(instruction, (Expr)node, list, letChainBuilder);
        }
        if ((hashMap = expr.getPrefixMapping()) != null) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Instruction instruction2 = letChainBuilder.bind(StreamInstruction.charStreamLiteral((String)entry.getKey()));
                Instruction instruction3 = letChainBuilder.bind(StreamInstruction.charStreamLiteral((String)entry.getValue()));
                Instruction[] instructionArray = new Instruction[]{letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction2)), letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction3))};
                list.add(new JavaMethodInvocationInstruction("put", instruction.cloneWithoutTypeInformation(), instructionArray, s_javaObjectType));
            }
        }
    }

    public Function generateGetNSPrefixCountFunction(int n) {
        NewJavaObjectInstruction newJavaObjectInstruction = new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.integerLiteral(n)}, (Type)new JavaObjectType((class$com$ibm$xtq$xslt$runtime$Counter == null ? (class$com$ibm$xtq$xslt$runtime$Counter = NamespaceHelper.class$("com.ibm.xtq.xslt.runtime.Counter")) : class$com$ibm$xtq$xslt$runtime$Counter).getName()));
        Function function = new Function(s_getNSPrefixCounterFunction, new Binding[0], newJavaObjectInstruction);
        function.setMemoizeResult(true);
        return function;
    }

    public Instruction callGetNSPrefixCountFunction() {
        return new FunctionCallInstruction(s_getNSPrefixCounterFunction, new Instruction[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

