/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.xslt.runtime.JavaMethodResolver;
import com.ibm.xtq.xslt.runtime.extensions.XSLTObjectType;
import com.ibm.xtq.xslt.translator.MethodTypeConstants;
import com.ibm.xtq.xslt.translator.ObjectFactory;
import com.ibm.xtq.xslt.typechecker.v1.types.MethodType;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.IntType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class FunctionOperatorHelper
implements Constants,
MethodTypeConstants {
    private final HashMap m_primfuncTable = new HashMap();
    private final HashMap m_primopTable = new HashMap();
    private final HashMap m_extensionNamespaceTable = new HashMap();
    private static final HashMap objectTypeHash = new HashMap();
    private static final String[][] xsltObjectTypes;
    private static final String DEFAULT_OBJECT_TYPE = "external";
    public static final String OBJECT_TYPE_FUNCTION = "object-type$exslt-common$";

    public FunctionOperatorHelper() {
        this.initPrimopTable();
        this.initExtensionNamespaceTable();
    }

    public static boolean isStandardFunctionNamespace(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isExtensionNamespace(String string) {
        return string != null && string.length() > 0;
    }

    public boolean isPredefinedExtensionNamespace(String string) {
        return this.m_extensionNamespaceTable.containsKey(string);
    }

    public boolean isFunctionAvailable(ASTBuildingContext aSTBuildingContext, FunctionCall functionCall) {
        Expr expr = functionCall.getOperand(0);
        if (expr.getId() == 5) {
            String string;
            Literal literal = (Literal)expr;
            String string2 = null;
            string2 = literal.getStringLiteral();
            int n = string2.indexOf(58);
            String string3 = n > 0 ? string2.substring(n + 1) : string2;
            String string4 = n > 0 ? string2.substring(0, n) : "";
            String string5 = string = n > 0 ? aSTBuildingContext.getStaticContext().lookupNamespace(string4) : "";
            if (FunctionOperatorHelper.isStandardFunctionNamespace(string)) {
                return this.lookupPrimfunc(string, string3) != null;
            }
            if (this.isPredefinedExtensionNamespace(string)) {
                return this.lookupPrimfunc(string, string3) != null;
            }
            return this.hasExternalMethods(string, string3);
        }
        return false;
    }

    public String[] getClassAndMethod(String string, String string2) {
        String string3 = this.getClassNameFromUri(string);
        String string4 = null;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string4 = string2.substring(n + 1);
            string3 = string3 != null && string3.length() > 0 ? string3 + "." + string2.substring(0, n) : string2.substring(0, n);
        } else {
            string4 = string2;
        }
        return new String[]{string3, string4};
    }

    public String getClassNameFromUri(String string) {
        String string2 = this.getClassName(string);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith("http://www.ibm.com/xmlns/prod/xltxe-j/java")) {
            int n = "http://www.ibm.com/xmlns/prod/xltxe-j/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith("http://xml.apache.org/xalan/xsltc/java")) {
            int n = "http://xml.apache.org/xalan/xsltc/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith("http://xml.apache.org/xalan/java")) {
            int n = "http://xml.apache.org/xalan/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith("http://xml.apache.org/xslt/java")) {
            int n = "http://xml.apache.org/xslt/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public List lookupPrimfunc(String string, String string2) {
        if (FunctionOperatorHelper.isStandardFunctionNamespace(string)) {
            return (List)this.m_primfuncTable.get(string2);
        }
        return (List)this.m_primfuncTable.get(string + ":" + string2);
    }

    public Iterator getFunctionItr() {
        return this.m_primfuncTable.keySet().iterator();
    }

    public List lookupPrimop(String string) {
        return (List)this.m_primopTable.get(string);
    }

    public MethodType resolveOperator(String string, MethodType methodType) {
        MethodType methodType2 = null;
        List list = this.lookupPrimop(string);
        if (list != null) {
            methodType2 = this.findType(list, methodType);
        }
        return methodType2;
    }

    public MethodType resolveFunction(String string, String string2, MethodType methodType) {
        MethodType methodType2 = null;
        List list = this.lookupPrimfunc(string, string2);
        if (list != null) {
            methodType2 = this.findType(list, methodType);
        }
        return methodType2;
    }

    private MethodType findType(List list, MethodType methodType) {
        MethodType methodType2 = null;
        int n = list.size();
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            MethodType methodType3 = (MethodType)list.get(i);
            if (methodType3.argsCount() != methodType.argsCount()) continue;
            if (methodType2 == null) {
                methodType2 = methodType3;
                n2 = methodType.distanceTo(methodType3);
                continue;
            }
            int n3 = methodType.distanceTo(methodType3);
            if (n3 >= n2) continue;
            n2 = n3;
            methodType2 = methodType3;
        }
        return methodType2;
    }

    public boolean isExtensionFunction(FunctionDecl functionDecl) {
        QName qName = functionDecl.getQName();
        String string = qName.getNamespaceURI();
        if (FunctionOperatorHelper.isExtensionNamespace(string)) {
            String string2 = qName.getLocalPart();
            if (this.lookupPrimfunc(string, string2) != null) {
                Assert.assertNotImplemented();
            }
            String[] stringArray = this.getClassAndMethod(string, string2);
            int n = functionDecl.getArity();
            boolean bl = JavaMethodResolver.hasMethods(stringArray[0], stringArray[1], n);
            return bl;
        }
        return false;
    }

    public Method lookupPredefinedExtension(String string, String string2, int n) throws ClassNotFoundException {
        String string3;
        int n2;
        Object object;
        String string4 = this.getClassName(string);
        if (string4 == null) {
            return null;
        }
        Class clazz = ObjectFactory.findProviderClass(string4, ObjectFactory.findClassLoader(), true);
        if (clazz == null) {
            return null;
        }
        if (string2.indexOf(45) > 0) {
            object = new StringBuffer("");
            for (n2 = 0; n2 < string2.length(); ++n2) {
                if (n2 > 0 && string2.charAt(n2 - 1) == '-') {
                    ((StringBuffer)object).append(Character.toUpperCase(string2.charAt(n2)));
                    continue;
                }
                if (string2.charAt(n2) == '-') continue;
                ((StringBuffer)object).append(string2.charAt(n2));
            }
            string3 = ((StringBuffer)object).toString();
        } else {
            string3 = string2;
        }
        object = JavaMethodResolver.findMethods(clazz, string3);
        for (n2 = 0; n2 < object.size(); ++n2) {
            Method method = (Method)object.get(n2);
            if (method.getParameterTypes().length != n) continue;
            return method;
        }
        return null;
    }

    public static boolean isNodesetExtensionCall(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string2.equals("nodeset") && (string.equals("http://www.ibm.com/xmlns/prod/xltxe-j") || string.equals("http://xml.apache.org/xalan/xsltc") || string.equals("http://xml.apache.org/xalan") || string.equals("http://xml.apache.org/xslt")) || string2.equals("node-set") && string.equals("http://exslt.org/common") || (string2.equals("nodeSet") || string2.equals("node-set")) && string.equals("urn:schemas-microsoft-com:xslt") || string2.equals("nodeSet") && string.equals("http://icl.com/saxon");
        }
        return false;
    }

    public static boolean isObjectTypeExtensionCall(String string, String string2) {
        return string != null && string.length() > 0 && string.equals("http://exslt.org/common") && string2.equals("object-type");
    }

    public static boolean isNodeIsInSequenceCall(String string, String string2) {
        return string != null && string.length() > 0 && string.equals("http://xtqhp") && string2.equals("nodeIsInSequence");
    }

    public static void generateFunctions(Module module) {
        Function function = FunctionOperatorHelper.generateObjectTypeFunction();
        module.addFunction(function);
    }

    private static Function generateObjectTypeFunction() {
        Instruction instruction;
        String string = "object";
        String string2 = "x";
        Set set = objectTypeHash.entrySet();
        TypeMatchInstruction.Match[] matchArray = new TypeMatchInstruction.Match[set.size() + 1];
        Iterator iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            Map.Entry entry = iterator.next();
            matchArray[i] = new TypeMatchInstruction.Match((Type)entry.getKey(), string2, StreamInstruction.charStreamLiteral((String)entry.getValue()));
        }
        ChooseInstruction.Case[] caseArray = new ChooseInstruction.Case[xsltObjectTypes.length];
        for (int i = 0; i < xsltObjectTypes.length; ++i) {
            instruction = new JavaMethodInvocationInstruction(xsltObjectTypes[i][0], new IdentifierInstruction(string2), new Instruction[0], (Type)BooleanType.s_booleanType);
            caseArray[i] = new ChooseInstruction.Case(instruction, StreamInstruction.charStreamLiteral(xsltObjectTypes[i][1]));
        }
        ChooseInstruction chooseInstruction = new ChooseInstruction(caseArray, StreamInstruction.charStreamLiteral(DEFAULT_OBJECT_TYPE));
        matchArray[matchArray.length - 1] = new TypeMatchInstruction.Match(XSLTObjectType.s_xsltObjectType, string2, chooseInstruction);
        instruction = StreamInstruction.charStreamLiteral(DEFAULT_OBJECT_TYPE);
        TypeMatchInstruction typeMatchInstruction = new TypeMatchInstruction(new IdentifierInstruction(string), matchArray, instruction);
        Binding[] bindingArray = new Binding[]{new Binding(string)};
        Function function = new Function(OBJECT_TYPE_FUNCTION, bindingArray, typeMatchInstruction);
        return function;
    }

    private String getClassName(String string) {
        return (String)this.m_extensionNamespaceTable.get(string);
    }

    private boolean hasExternalMethods(String string, String string2) {
        String string3 = this.getClassNameFromUri(string);
        int n = string2.lastIndexOf(46);
        Class clazz = null;
        String string4 = string2;
        if (n > 0) {
            string3 = string3 != null && string3.length() > 0 ? string3 + "." + string2.substring(0, n) : string2.substring(0, n);
            string4 = string2.substring(n + 1);
        } else if (string3 != null || string3.length() > 0) {
            try {
                clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        } else {
            return false;
        }
        if (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        boolean bl = string4.equals("new") ? JavaMethodResolver.hasConstructors(clazz) : JavaMethodResolver.hasMethods(clazz, string4);
        return bl;
    }

    private void addPrimfunc(String string, MethodType methodType) {
        ArrayList<MethodType> arrayList = (ArrayList<MethodType>)this.m_primfuncTable.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<MethodType>();
            this.m_primfuncTable.put(string, arrayList);
        }
        arrayList.add(methodType);
    }

    private void addPrimop(String string, MethodType methodType) {
        ArrayList<MethodType> arrayList = (ArrayList<MethodType>)this.m_primopTable.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<MethodType>();
            this.m_primopTable.put(string, arrayList);
        }
        arrayList.add(methodType);
    }

    private void initPrimopTable() {
        this.addPrimop("+", MethodTypeConstants.R_RR);
        this.addPrimop("-", MethodTypeConstants.R_RR);
        this.addPrimop("*", MethodTypeConstants.R_RR);
        this.addPrimop("div", MethodTypeConstants.R_RR);
        this.addPrimop("mod", MethodTypeConstants.R_RR);
        this.addPrimop("+", MethodTypeConstants.I_II);
        this.addPrimop("-", MethodTypeConstants.I_II);
        this.addPrimop("*", MethodTypeConstants.I_II);
        this.addPrimop("<", MethodTypeConstants.B_RR);
        this.addPrimop("<=", MethodTypeConstants.B_RR);
        this.addPrimop(">", MethodTypeConstants.B_RR);
        this.addPrimop(">=", MethodTypeConstants.B_RR);
        this.addPrimop("<", MethodTypeConstants.B_II);
        this.addPrimop("<=", MethodTypeConstants.B_II);
        this.addPrimop(">", MethodTypeConstants.B_II);
        this.addPrimop(">=", MethodTypeConstants.B_II);
        this.addPrimop("<", MethodTypeConstants.B_BB);
        this.addPrimop("<=", MethodTypeConstants.B_BB);
        this.addPrimop(">", MethodTypeConstants.B_BB);
        this.addPrimop(">=", MethodTypeConstants.B_BB);
        this.addPrimop("or", MethodTypeConstants.B_BB);
        this.addPrimop("and", MethodTypeConstants.B_BB);
        this.addPrimop("u-", MethodTypeConstants.R_R);
        this.addPrimop("u-", MethodTypeConstants.I_I);
        this.addPrimfunc("last", MethodTypeConstants.I_V);
        this.addPrimfunc("position", MethodTypeConstants.I_V);
        this.addPrimfunc("count", MethodTypeConstants.I_N);
        this.addPrimfunc("id", MethodTypeConstants.N_S);
        this.addPrimfunc("id", MethodTypeConstants.N_N);
        this.addPrimfunc("local-name", MethodTypeConstants.S_V);
        this.addPrimfunc("local-name", MethodTypeConstants.S_A);
        this.addPrimfunc("namespace-uri", MethodTypeConstants.S_V);
        this.addPrimfunc("namespace-uri", MethodTypeConstants.S_A);
        this.addPrimfunc("name", MethodTypeConstants.S_V);
        this.addPrimfunc("name", MethodTypeConstants.S_A);
        this.addPrimfunc("string", MethodTypeConstants.S_O);
        this.addPrimfunc("string", MethodTypeConstants.S_V);
        this.addPrimfunc("concat", MethodTypeConstants.S_SS);
        this.addPrimfunc("starts-with", MethodTypeConstants.B_SS);
        this.addPrimfunc("contains", MethodTypeConstants.B_SS);
        this.addPrimfunc("substring-after", MethodTypeConstants.S_SS);
        this.addPrimfunc("substring-before", MethodTypeConstants.S_SS);
        this.addPrimfunc("substring", MethodTypeConstants.S_SR);
        this.addPrimfunc("substring", MethodTypeConstants.S_SRR);
        this.addPrimfunc("string-length", MethodTypeConstants.I_V);
        this.addPrimfunc("string-length", MethodTypeConstants.I_S);
        this.addPrimfunc("normalize-space", MethodTypeConstants.S_V);
        this.addPrimfunc("normalize-space", MethodTypeConstants.S_S);
        this.addPrimfunc("translate", MethodTypeConstants.S_SSS);
        this.addPrimfunc("boolean", MethodTypeConstants.B_O);
        this.addPrimfunc("not", MethodTypeConstants.B_B);
        this.addPrimfunc("true", MethodTypeConstants.B_V);
        this.addPrimfunc("false", MethodTypeConstants.B_V);
        this.addPrimfunc("lang", MethodTypeConstants.B_S);
        this.addPrimfunc("number", MethodTypeConstants.R_O);
        this.addPrimfunc("number", MethodTypeConstants.R_V);
        this.addPrimfunc("sum", MethodTypeConstants.R_N);
        this.addPrimfunc("floor", MethodTypeConstants.R_R);
        this.addPrimfunc("ceiling", MethodTypeConstants.R_R);
        this.addPrimfunc("round", MethodTypeConstants.R_R);
        this.addPrimfunc("current", MethodTypeConstants.A_V);
        this.addPrimfunc("document", MethodTypeConstants.N_O);
        this.addPrimfunc("document", MethodTypeConstants.N_ON);
        this.addPrimfunc("generate-id", MethodTypeConstants.S_V);
        this.addPrimfunc("generate-id", MethodTypeConstants.S_A);
        this.addPrimfunc("format-number", MethodTypeConstants.S_RS);
        this.addPrimfunc("format-number", MethodTypeConstants.S_RSS);
        this.addPrimfunc("unparsed-entity-uri", MethodTypeConstants.S_S);
        this.addPrimfunc("key", MethodTypeConstants.N_SS);
        this.addPrimfunc("key", MethodTypeConstants.N_SN);
        this.addPrimfunc("function-available", MethodTypeConstants.B_S);
        this.addPrimfunc("element-available", MethodTypeConstants.B_S);
        this.addPrimfunc("system-property", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/common:node-set", MethodTypeConstants.N_O);
        this.addPrimfunc("http://exslt.org/common:object-type", MethodTypeConstants.S_O);
        this.addPrimfunc("http://exslt.org/dates-and-times:date", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:date", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:date-time", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-abbreviation", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-abbreviation", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-month", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-month", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-week", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-week", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-year", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-in-year", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-name", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-name", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-of-week-in-month", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:day-of-week-in-month", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:format-date", MethodTypeConstants.S_SS);
        this.addPrimfunc("http://exslt.org/dates-and-times:hour-in-day", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:hour-in-day", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:leap-year", MethodTypeConstants.B_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:leap-year", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:minute-in-hour", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:minute-in-hour", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-abbreviation", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-abbreviation", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-in-year", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-in-year", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-name", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:month-name", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:second-in-minute", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:second-in-minute", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:time", MethodTypeConstants.S_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:time", MethodTypeConstants.S_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:week-in-year", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:week-in-year", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/dates-and-times:year", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/dates-and-times:year", MethodTypeConstants.R_S);
        this.addPrimfunc("http://exslt.org/math:abs", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:acos", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:asin", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:atan", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:atan2", MethodTypeConstants.R_RR);
        this.addPrimfunc("http://exslt.org/math:constant", MethodTypeConstants.R_SR);
        this.addPrimfunc("http://exslt.org/math:cos", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:exp", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:highest", MethodTypeConstants.N_N);
        this.addPrimfunc("http://exslt.org/math:log", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:lowest", MethodTypeConstants.N_N);
        this.addPrimfunc("http://exslt.org/math:max", MethodTypeConstants.R_N);
        this.addPrimfunc("http://exslt.org/math:min", MethodTypeConstants.R_N);
        this.addPrimfunc("http://exslt.org/math:power", MethodTypeConstants.R_RR);
        this.addPrimfunc("http://exslt.org/math:random", MethodTypeConstants.R_V);
        this.addPrimfunc("http://exslt.org/math:sin", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:sqrt", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/math:tan", MethodTypeConstants.R_R);
        this.addPrimfunc("http://exslt.org/sets:difference", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://exslt.org/sets:distinct", MethodTypeConstants.N_N);
        this.addPrimfunc("http://exslt.org/sets:has-same-node", MethodTypeConstants.B_NN);
        this.addPrimfunc("http://exslt.org/sets:intersection", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://exslt.org/sets:leading", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://exslt.org/sets:trailing", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://exslt.org/strings:align", MethodTypeConstants.S_SS);
        this.addPrimfunc("http://exslt.org/strings:align", MethodTypeConstants.S_SSS);
        this.addPrimfunc("http://exslt.org/strings:concat", MethodTypeConstants.S_N);
        this.addPrimfunc("http://exslt.org/strings:padding", MethodTypeConstants.S_R);
        this.addPrimfunc("http://exslt.org/strings:padding", MethodTypeConstants.S_RS);
        this.addPrimfunc("http://exslt.org/strings:split", MethodTypeConstants.N_S);
        this.addPrimfunc("http://exslt.org/strings:split", MethodTypeConstants.N_SS);
        this.addPrimfunc("http://exslt.org/strings:tokenize", MethodTypeConstants.N_S);
        this.addPrimfunc("http://exslt.org/strings:tokenize", MethodTypeConstants.N_SS);
        this.addPrimfunc("http://www.ibm.com/xmlns/prod/xltxe-j:nodeset", MethodTypeConstants.N_O);
        this.addPrimfunc("http://xml.apache.org/xalan:nodeset", MethodTypeConstants.N_O);
        this.addPrimfunc("http://xml.apache.org/xslt:nodeset", MethodTypeConstants.N_O);
        this.addPrimfunc("http://xml.apache.org/xalan/xsltc:nodeset", MethodTypeConstants.N_O);
        this.addPrimfunc("urn:schemas-microsoft-com:xslt:nodeSet", MethodTypeConstants.N_O);
        this.addPrimfunc("urn:schemas-microsoft-com:xslt:node-set", MethodTypeConstants.N_O);
        this.addPrimfunc("http://icl.com/saxon:nodeSet", MethodTypeConstants.N_O);
        this.addPrimfunc("http://xml.apache.org/xalan:difference", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://xml.apache.org/xalan:distinct", MethodTypeConstants.N_N);
        this.addPrimfunc("http://xml.apache.org/xalan:hasSameNodes", MethodTypeConstants.B_NN);
        this.addPrimfunc("http://xml.apache.org/xalan:intersection", MethodTypeConstants.N_NN);
        this.addPrimfunc("http://xml.apache.org/xalan:tokenize", MethodTypeConstants.N_S);
        this.addPrimfunc("http://xml.apache.org/xalan:tokenize", MethodTypeConstants.N_SS);
        this.addPrimfunc("http://xtqhp:nodeIsInSequence", MethodTypeConstants.B_AN);
    }

    private void initExtensionNamespaceTable() {
        this.m_extensionNamespaceTable.put("http://www.ibm.com/xmlns/prod/xltxe-j", "com.ibm.xtq.xslt.runtime.extensions.Extensions");
        this.m_extensionNamespaceTable.put("http://xml.apache.org/xalan", "com.ibm.xtq.xslt.runtime.extensions.Extensions");
        this.m_extensionNamespaceTable.put("http://xml.apache.org/xslt", "com.ibm.xtq.xslt.runtime.extensions.Extensions");
        this.m_extensionNamespaceTable.put("http://xml.apache.org/xalan/xsltc", "com.ibm.xtq.xslt.runtime.extensions.Extensions");
        this.m_extensionNamespaceTable.put("http://exslt.org/common", null);
        this.m_extensionNamespaceTable.put("http://exslt.org/math", "com.ibm.xtq.xslt.runtime.extensions.ExsltMath");
        this.m_extensionNamespaceTable.put("http://exslt.org/sets", "com.ibm.xtq.xslt.runtime.extensions.ExsltSets");
        this.m_extensionNamespaceTable.put("http://exslt.org/dates-and-times", "com.ibm.xtq.xslt.runtime.extensions.ExsltDatetime");
        this.m_extensionNamespaceTable.put("http://exslt.org/strings", "com.ibm.xtq.xslt.runtime.extensions.ExsltStrings");
        this.m_extensionNamespaceTable.put("urn:schemas-microsoft-com:xslt", null);
        this.m_extensionNamespaceTable.put("http://icl.com/saxon", null);
        this.m_extensionNamespaceTable.put("http://xtqhp", null);
    }

    static {
        objectTypeHash.put(CharType.s_charType.getStreamType(), "string");
        objectTypeHash.put(DoubleType.s_doubleType, "number");
        objectTypeHash.put(IntType.s_intType, "number");
        objectTypeHash.put(BooleanType.s_booleanType, "boolean");
        objectTypeHash.put(CursorType.s_cursorType, "node-set");
        objectTypeHash.put(SAXEventsLibrary.getSAXEventStream(), "RTF");
        xsltObjectTypes = new String[][]{{"isNumber", "number"}, {"isBoolean", "boolean"}, {"isString", "string"}, {"isNodeset", "node-set"}, {"isRTF", "RTF"}};
    }
}

