/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.common.utils.ObjectVector;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCurrentNodeListFilter;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;

public class XDMCurrentNodelistCursor
extends XDMCursorProxyCursor {
    private boolean _docOrder;
    private final XDMCurrentNodeListFilter _filter;
    private ObjectVector _nodes = new ObjectVector();
    private int _currentIndex;
    private final XDMCursor _contextNode;
    private XDMCursor m_source;
    protected int m_position = 0;

    public XDMCurrentNodelistCursor(XDMCursor xDMCursor, XDMCurrentNodeListFilter xDMCurrentNodeListFilter, XDMCursor xDMCursor2) {
        super(xDMCursor);
        this.m_source = xDMCursor;
        this._filter = xDMCurrentNodeListFilter;
        switch (xDMCursor.getAxis()) {
            case 0: 
            case 1: 
            case 11: 
            case 12: {
                this._docOrder = false;
                break;
            }
            default: {
                this._docOrder = true;
            }
        }
        this._contextNode = xDMCursor2.singleNode();
        this.init();
    }

    public XDMCurrentNodelistCursor(XDMCursor xDMCursor, boolean bl, XDMCurrentNodeListFilter xDMCurrentNodeListFilter, XDMCursor xDMCursor2) {
        super(xDMCursor);
        this.m_source = xDMCursor;
        this._filter = xDMCurrentNodeListFilter;
        this._docOrder = bl;
        this._contextNode = xDMCursor2.singleNode();
        this.init();
    }

    public void init() {
        this._nodes.removeAllElements();
        if (!this.m_currentCursor.isEmpty()) {
            do {
                this._nodes.addElement(this.m_currentCursor.singleNode());
            } while (this.m_currentCursor.nextNode());
            this.m_source = this.m_currentCursor;
            this._currentIndex = 0;
            if (!this.nextNode()) {
                this._currentIndex = -1;
            }
        }
    }

    public boolean nextNode() {
        int n = this._nodes.size();
        XDMCursor xDMCursor = this._contextNode;
        int n2 = this._currentIndex;
        while (n2 < n) {
            XDMCursor xDMCursor2;
            int n3;
            int n4 = n3 = this._docOrder ? n2 + 1 : n - n2;
            if (!this._filter.test(xDMCursor2 = (XDMCursor)this._nodes.elementAt(n2++), n3, n, xDMCursor, this)) continue;
            this._currentIndex = n2;
            this.m_currentCursor = xDMCursor2;
            ++this.m_position;
            return true;
        }
        return false;
    }

    public XDMCursor singleNode() {
        return this.m_currentCursor;
    }

    public void resetIteration() {
        if (this.m_position == 0) {
            return;
        }
        this._currentIndex = 0;
        this.m_position = 0;
        if (!this.nextNode()) {
            this._currentIndex = -1;
        }
    }

    public boolean setDocOrdered() {
        if (this.m_source == null || this.m_source.isDocOrdered()) {
            return true;
        }
        boolean bl = this.m_source.setDocOrdered();
        if (!bl) {
            this.m_source.resetIteration();
            bl = this.m_source.setDocOrdered();
        }
        if (bl) {
            this.m_currentCursor = this.m_source;
            this.init();
        } else {
            this.m_source = this.m_currentCursor;
        }
        return bl;
    }

    public int getLength() {
        if (this._currentIndex < 0) {
            return 0;
        }
        return this.computePositionOfLast();
    }

    public int getCurrentPos() {
        return this.m_position;
    }

    public boolean setCurrentPos(int n) {
        if (n == this.m_position) {
            return true;
        }
        if (n < this.m_position) {
            this.resetIteration();
        }
        if (!this.isEmpty()) {
            while (this.nextNode()) {
                if (n != this.m_position) continue;
                return true;
            }
        }
        return false;
    }

    private int computePositionOfLast() {
        int n = this._nodes.size();
        XDMCursor xDMCursor = this._contextNode;
        int n2 = this.m_position;
        int n3 = this._currentIndex;
        while (n3 < n) {
            XDMCursor xDMCursor2;
            int n4;
            int n5 = n4 = this._docOrder ? n3 + 1 : n - n3;
            if (!this._filter.test(xDMCursor2 = (XDMCursor)this._nodes.elementAt(n3++), n4, n, xDMCursor, this)) continue;
            ++n2;
        }
        return n2;
    }

    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        this.m_currentCursor = this.m_source.newContext(xDMCursor);
        this.init();
        return this;
    }

    public int getAxis() {
        return this.m_source.getAxis();
    }

    public XDMCursor getTypedAxisCursor(int n, int n2) {
        XDMCursor xDMCursor = this.m_source.getTypedAxisCursor(n, n2);
        return xDMCursor.newContext(this.m_currentCursor);
    }

    public XDMCursor getAxisCursor(int n) {
        XDMCursor xDMCursor = this.m_source.getAxisCursor(n);
        return xDMCursor.newContext(this.m_currentCursor);
    }

    public boolean isEmpty() {
        if (this.m_source == null) {
            return true;
        }
        return this._nodes.size() == 0 || this._currentIndex < 0;
    }

    public Object clone() {
        try {
            XDMCurrentNodelistCursor xDMCurrentNodelistCursor = (XDMCurrentNodelistCursor)super.clone();
            xDMCurrentNodelistCursor._nodes = (ObjectVector)this._nodes.clone();
            return xDMCurrentNodelistCursor;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XDMCursor cloneWithReset() {
        XDMCursor xDMCursor = (XDMCursor)this.clone();
        xDMCursor.resetIteration();
        return xDMCursor;
    }

    public XDMCursor cloneXDMCursor() {
        return (XDMCursor)this.clone();
    }
}

