/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm;

import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;

public class XDMException
extends RuntimeException {
    private static final long serialVersionUID = -8048373510055981960L;
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Self-causation is not permitted."));
        }
        if (this.containedException != null && throwable != null) {
            throw new IllegalStateException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Cannot overwrite cause."));
        }
        this.containedException = throwable;
        return this;
    }

    public XDMException(String string) {
        super(string);
        this.containedException = null;
        this.locator = null;
    }

    public XDMException(Throwable throwable) {
        super(throwable.getMessage());
        this.containedException = throwable;
        this.locator = null;
    }

    public XDMException(String string, Throwable throwable) {
        super(string == null || string.length() == 0 ? throwable.getMessage() : string);
        this.containedException = throwable;
        this.locator = null;
    }

    public XDMException(String string, SourceLocator sourceLocator) {
        super(string);
        this.containedException = null;
        this.locator = sourceLocator;
    }

    public XDMException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.containedException = throwable;
        this.locator = sourceLocator;
    }

    public String getMessageAndLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.getMessage();
        if (null != string) {
            stringBuffer.append(string);
        }
        if (null != this.locator) {
            stringBuffer.append(": ").append(this.getLocationAsString());
        }
        return stringBuffer.toString();
    }

    public String getLocationAsString() {
        if (null != this.locator) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.locator.getSystemId();
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            if (null != string) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string);
            }
            if (0 != n) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n);
            }
            if (0 != n2) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        Object object;
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            object = this.getLocationAsString();
            if (null != object) {
                printWriter.println((String)object);
            }
            super.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this.getException();
        for (int i = 0; i < 10 && null != object; ++i) {
            Object object2;
            printWriter.println("---------");
            try {
                if (object instanceof XDMException && null != (object2 = ((XDMException)object).getLocationAsString())) {
                    printWriter.println((String)object2);
                }
                ((Throwable)object).printStackTrace(printWriter);
            }
            catch (Throwable throwable) {
                printWriter.println("Could not print stack trace...");
            }
            try {
                object2 = object.getClass().getMethod("getException", new Class[0]);
                if (null != object2) {
                    Object object3 = object;
                    if (object3 != (object = (Throwable)((Method)object2).invoke(object, new Object[0]))) continue;
                    break;
                }
                object = null;
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = null;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = null;
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = null;
            }
        }
    }
}

