/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref;

import com.ibm.xtq.xml.res.XMLMessages;

final class ChunkedIntArray {
    final int slotsize = 4;
    static final int lowbits = 10;
    static final int chunkalloc = 1024;
    static final int lowmask = 1023;
    ChunksVector chunks = new ChunksVector();
    final int[] fastArray = new int[1024];
    int lastUsed = 0;

    ChunkedIntArray(int n) {
        if (this.slotsize < n) {
            throw new ArrayIndexOutOfBoundsException(XMLMessages.createXMLMessage("ERR_SYSTEM", new Object[]{"ChunkedIntArray(" + Integer.toString(n) + ") not currently supported"}));
        }
        if (this.slotsize > n) {
            System.out.println("*****WARNING: ChunkedIntArray(" + n + ") wasting " + (this.slotsize - n) + " words per slot");
        }
        this.chunks.addElement(this.fastArray);
    }

    int appendSlot(int n, int n2, int n3, int n4) {
        int n5 = (this.lastUsed + 1) * 4;
        int n6 = n5 >> 10;
        int n7 = n5 & 0x3FF;
        if (n6 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n6);
        nArray[n7] = n;
        nArray[n7 + 1] = n2;
        nArray[n7 + 2] = n3;
        nArray[n7 + 3] = n4;
        return ++this.lastUsed;
    }

    int readEntry(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Offset bigger than slot"));
        }
        int n3 = (n *= 4) >> 10;
        int n4 = n & 0x3FF;
        int[] nArray = this.chunks.elementAt(n3);
        return nArray[n4 + n2];
    }

    int specialFind(int n, int n2) {
        int n3 = n;
        while (n3 > 0) {
            int n4 = (n3 *= 4) >> 10;
            int n5 = n3 & 0x3FF;
            int[] nArray = this.chunks.elementAt(n4);
            n3 = nArray[n5 + 1];
            if (n3 != n2) continue;
        }
        if (n3 <= 0) {
            return n2;
        }
        return -1;
    }

    int slotsUsed() {
        return this.lastUsed;
    }

    void discardLast() {
        --this.lastUsed;
    }

    void writeEntry(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Offset bigger than slot"));
        }
        int n4 = (n *= 4) >> 10;
        int n5 = n & 0x3FF;
        int[] nArray = this.chunks.elementAt(n4);
        nArray[n5 + n2] = n3;
    }

    void writeSlot(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n *= 4) >> 10;
        int n7 = n & 0x3FF;
        if (n6 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n6);
        nArray[n7] = n2;
        nArray[n7 + 1] = n3;
        nArray[n7 + 2] = n4;
        nArray[n7 + 3] = n5;
    }

    void readSlot(int n, int[] nArray) {
        int n2 = (n *= 4) >> 10;
        int n3 = n & 0x3FF;
        if (n2 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray2 = this.chunks.elementAt(n2);
        System.arraycopy(nArray2, n3, nArray, 0, 4);
    }

    class ChunksVector {
        final int BLOCKSIZE = 64;
        int[][] m_map = new int[64][];
        int m_mapSize = 64;
        int pos = 0;

        ChunksVector() {
        }

        final int size() {
            return this.pos;
        }

        void addElement(int[] nArray) {
            if (this.pos >= this.m_mapSize) {
                int n = this.m_mapSize;
                while (this.pos >= this.m_mapSize) {
                    this.m_mapSize += 64;
                }
                int[][] nArrayArray = new int[this.m_mapSize][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, n);
                this.m_map = nArrayArray;
            }
            this.m_map[this.pos] = nArray;
            ++this.pos;
        }

        final int[] elementAt(int n) {
            return this.m_map[n];
        }
    }
}

