/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.scontext.MergedCharacterMapsManager;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public final class ResultDocument
extends Expr {
    private Expr _formatExpr;
    private Expr _hrefExpr;
    private Expr _methodExpr;
    private String _useCharacterMapsExpanded;
    private Expr _undeclarePrefixesExpr;
    private Expr _standaloneExpr;
    private Expr _outputVersionExpr;
    private Expr _omitXmlDeclarationExpr;
    private Expr _normalizationFormExpr;
    private Expr _mediaTypeExpr;
    private Expr _indentExpr;
    private Expr _includeContentTypeExpr;
    private Expr _docTypeSystemExpr;
    private Expr _escapeUriAttributesExpr;
    private Expr _encodingExpr;
    private Expr _docTypePublicExpr;
    private Expr _cdataSectionNamesExpr;
    private Expr _byteOrderMarkExpr;
    private String _formatString = "";
    private String _useCharacterMapsString = "";
    protected int _validation = 0;
    protected QName _typeName = null;

    public ResultDocument() {
        super(210);
    }

    public ResultDocument(int n) {
        super(n);
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public String toString() {
        String string;
        String string2 = "ResultDocument: href: ";
        if (this._hrefExpr != null && this._hrefExpr.getId() == 228) {
            string = ((Text)this._hrefExpr).getText().toString();
            string2 = string2 + "href: ";
            string2 = string2 + string;
        }
        if (this._formatExpr != null && this._formatExpr.getId() == 228) {
            string = ((Text)this._formatExpr).getText().toString();
            string2 = string2 + "format: ";
            string2 = string2 + string;
        }
        return string2;
    }

    public Expr getHrefExpr() {
        return this._hrefExpr;
    }

    public Expr getFormatExpr() {
        return this._formatExpr;
    }

    public Expr getMethodExpr() {
        return this._methodExpr;
    }

    public String getOutputDefinitionName() {
        return this._formatString;
    }

    public void parseContents(XSLTParser xSLTParser) {
        Object object;
        String string = XPathTreeConstants.jjtNodeName[this.getId()];
        this._byteOrderMarkExpr = this.getExprForAttr(xSLTParser, string, "byte-order-mark");
        this._cdataSectionNamesExpr = this.getExprForAttr(xSLTParser, string, "cdata-section-elements");
        this._docTypePublicExpr = this.getExprForAttr(xSLTParser, string, "doctype-public");
        this._docTypeSystemExpr = this.getExprForAttr(xSLTParser, string, "doctype-system");
        this._encodingExpr = this.getExprForAttr(xSLTParser, string, "encoding");
        this._escapeUriAttributesExpr = this.getExprForAttr(xSLTParser, string, "escape-uri-attributes");
        this._formatExpr = this.getExprForAttr(xSLTParser, string, "format");
        this._formatString = this.getAttribute("format");
        this._hrefExpr = this.getExprForAttr(xSLTParser, string, "href");
        this._includeContentTypeExpr = this.getExprForAttr(xSLTParser, string, "include-content-type");
        this._indentExpr = this.getExprForAttr(xSLTParser, string, "indent");
        this._mediaTypeExpr = this.getExprForAttr(xSLTParser, string, "media-type");
        this._methodExpr = this.getExprForAttr(xSLTParser, string, "method");
        this._normalizationFormExpr = this.getExprForAttr(xSLTParser, string, "normalization-form");
        this._omitXmlDeclarationExpr = this.getExprForAttr(xSLTParser, string, "omit-xml-declaration");
        this._outputVersionExpr = this.getExprForAttr(xSLTParser, string, "output-version");
        this._standaloneExpr = this.getExprForAttr(xSLTParser, string, "standalone");
        this._undeclarePrefixesExpr = this.getExprForAttr(xSLTParser, string, "undeclare-prefixes");
        if (this.hasAttribute("use-character-maps")) {
            this._useCharacterMapsString = this.getAttribute("use-character-maps");
            xSLTParser.checkAttributeValue(this, string, "use-character-maps", this._useCharacterMapsString, 3);
        }
        this._useCharacterMapsExpanded = this.expandQNames(xSLTParser);
        boolean bl = this.hasAttribute("validation");
        if (bl) {
            object = this.getAttribute("validation");
            xSLTParser.checkAttributeValue(this, string, "validation", (String)object, 3);
            this.setValidation((String)object);
        }
        if (this.hasAttribute("type")) {
            if (bl) {
                object = new ASTMsg("NODE_HAS_TYPE_AND_VALIDATION", (Object)string, (Expr)this);
                xSLTParser.reportError(3, (ASTBaseMsg)object);
            }
            object = this.getAttribute("type");
            xSLTParser.checkAttributeValue(this, string, "type", (String)object, 3);
            this.setTypeName(xSLTParser.getQNameIgnoreDefaultNs((String)object));
        }
        this.parseChildren(xSLTParser);
    }

    private Expr getExprForAttr(XSLTParser xSLTParser, String string, String string2) {
        Expr expr;
        if (this.hasAttribute(string2)) {
            String string3 = this.getAttribute(string2);
            expr = ResultDocument.parseAVTAttrContent(xSLTParser, string3, this);
            if (expr.getId() == 228) {
                xSLTParser.checkAttributeValue(this, string, string2, string3, 3);
            }
        } else {
            String string4 = "";
            expr = ResultDocument.parseAVTAttrContent(xSLTParser, string4, this);
        }
        return expr;
    }

    private String expandQNames(XSLTParser xSLTParser) {
        String string;
        if (this._useCharacterMapsString == null || this._useCharacterMapsString.length() == 0) {
            string = "";
        } else {
            MergedCharacterMapsManager mergedCharacterMapsManager = xSLTParser.getStaticContext().getCharacterMapsManager();
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = Util.whitespaceTokenize(this._useCharacterMapsString);
            boolean bl = true;
            while (stringTokenizer.hasMoreElements()) {
                Object object;
                String string2 = stringTokenizer.nextToken();
                if (!XMLChar.isValidQName(string2)) {
                    object = new ASTMsg("USE_CHARACTER_MAPS_NOT_LEXICAL_QNAME", string2, "xsl:result-document", this);
                    xSLTParser.reportError(3, (ASTBaseMsg)object);
                    continue;
                }
                object = this.getExpandedQName(xSLTParser, string2);
                if (object == null) {
                    ASTMsg aSTMsg = new ASTMsg("USE_CHARACTER_MAPS_NO_URI", string2, "xsl:result-document", this);
                    xSLTParser.reportError(3, aSTMsg);
                    continue;
                }
                if (!bl) {
                    stringBuffer.append(' ');
                }
                bl = false;
                stringBuffer.append((String)object);
                mergedCharacterMapsManager.characterMapIsReferenced((String)object, this);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public Expr getByteOrderMarkExpr() {
        return this._byteOrderMarkExpr;
    }

    public Expr getCdataSectionNamesExpr() {
        return this._cdataSectionNamesExpr;
    }

    public Expr getDocTypePublicExpr() {
        return this._docTypePublicExpr;
    }

    public Expr getEncodingExpr() {
        return this._encodingExpr;
    }

    public Expr getEscapeUriAttributesExpr() {
        return this._escapeUriAttributesExpr;
    }

    public Expr getDocTypeSystemExpr() {
        return this._docTypeSystemExpr;
    }

    public Expr getIncludeContentTypeExpr() {
        return this._includeContentTypeExpr;
    }

    public Expr getIndentExpr() {
        return this._indentExpr;
    }

    public Expr getMediaTypeExpr() {
        return this._mediaTypeExpr;
    }

    public Expr getNormalizationFormExpr() {
        return this._normalizationFormExpr;
    }

    public Expr getOmitXmlDeclarationExpr() {
        return this._omitXmlDeclarationExpr;
    }

    public Expr getOutputVersionExpr() {
        return this._outputVersionExpr;
    }

    public Expr getStandaloneExpr() {
        return this._standaloneExpr;
    }

    public Expr getUndeclarePrefixesExpr() {
        return this._undeclarePrefixesExpr;
    }

    public String getUseCharacterMapsExpanded() {
        return this._useCharacterMapsExpanded;
    }

    public void setValidation(String string) {
        if (string.equals("strict")) {
            this._validation = 4;
        } else if (string.equals("lax")) {
            this._validation = 3;
        } else if (string.equals("preserve")) {
            this._validation = 2;
        } else if (string.equals("strip")) {
            this._validation = 1;
        }
    }

    public int getValidation() {
        return this._validation != 0 ? this._validation : this.getXTQProgram().getDefaultValidation();
    }

    public void setTypeName(QName qName) {
        this._typeName = qName;
        this._validation = 5;
    }

    public QName getTypeName() {
        return this._typeName;
    }
}

