/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.util.Settings;

public class SettingLoaderFactory {
    private static final SettingLoader fileSettingLoader = new FileSettingLoader();
    private static final SettingLoader systemPropertyLoader = new SystemPropertySettingLoader();
    private static final SettingLoader fileOrSystemPropertyLoader = new CompoundSettingLoader(systemPropertyLoader, fileSettingLoader);

    public static SettingLoader getFileOrSystemPropertySettingLoader() {
        return fileOrSystemPropertyLoader;
    }

    public static SettingLoader getSystemPropertySettingLoader() {
        return systemPropertyLoader;
    }

    public static SettingLoader getAlternativeKeyLoader(SettingLoader defaultLoader, String ... alternativeKey) {
        return new CompoundSettingLoader(defaultLoader, new ConstantKeyLoader(defaultLoader, alternativeKey));
    }

    private static class ConstantKeyLoader
    implements SettingLoader {
        private String[] keys;
        private SettingLoader wrappedLoader;

        public ConstantKeyLoader(SettingLoader wrappedLoader, String[] keys) {
            this.wrappedLoader = wrappedLoader;
            this.keys = keys;
        }

        public String getSetting(String key) {
            for (String keyVal : this.keys) {
                if (this.wrappedLoader.getSetting(keyVal) == null) continue;
                return this.wrappedLoader.getSetting(keyVal);
            }
            return null;
        }
    }

    private static class CompoundSettingLoader
    implements SettingLoader {
        private SettingLoader[] loaders;

        public CompoundSettingLoader(SettingLoader ... loaders) {
            this.loaders = loaders;
        }

        public String getSetting(String key) {
            for (SettingLoader loader : this.loaders) {
                if (loader.getSetting(key) == null) continue;
                return loader.getSetting(key);
            }
            return null;
        }
    }

    private static class SystemPropertySettingLoader
    implements SettingLoader {
        private SystemPropertySettingLoader() {
        }

        public String getSetting(String key) {
            return System.getProperty(key);
        }
    }

    private static class FileSettingLoader
    implements SettingLoader {
        private FileSettingLoader() {
        }

        public String getSetting(String key) {
            return Settings.getString(key);
        }
    }

    public static interface SettingLoader {
        public String getSetting(String var1);
    }
}

