/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Debug {
    private static final String LOGGER_NAME = "ikeyman";
    private static final String DEBUG_FILE_NAME = "debugTrace.log";
    private static final int DEBUG_LIMIT = 0x100000;
    private static final int DEBUG_COUNT = 5;
    private static Logger logger = Logger.getLogger("ikeyman");
    private static int stackTraceDepth = -1;

    private static String getMethodName(StackTraceElement element) {
        return element.getMethodName() + " (line " + element.getLineNumber() + ")";
    }

    private static StackTraceElement getStackTraceElement(StackTraceElement[] elements) {
        if (stackTraceDepth < 0) {
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                if (!element.getClassName().equals("com.ibm.gsk.ikeyman.util.Debug")) continue;
                stackTraceDepth = i + 1;
                break;
            }
        }
        return elements[stackTraceDepth];
    }

    public static void entering() {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.entering(element.getClassName(), Debug.getMethodName(element));
    }

    public static void entering(Object ... params) {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.entering(element.getClassName(), Debug.getMethodName(element), params);
    }

    public static void exiting() {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.exiting(element.getClassName(), Debug.getMethodName(element));
    }

    public static void exiting(Object result) {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.exiting(element.getClassName(), Debug.getMethodName(element), result);
    }

    public static void throwing(Throwable thrown) {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.throwing(element.getClassName(), Debug.getMethodName(element), thrown);
    }

    public static void log(String message, Object ... params) {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.logp(Level.INFO, element.getClassName(), Debug.getMethodName(element), message, params);
    }

    public static void finest(String message, Object ... params) {
        StackTraceElement element = Debug.getStackTraceElement(Thread.currentThread().getStackTrace());
        logger.logp(Level.FINEST, element.getClassName(), Debug.getMethodName(element), message, params);
    }

    static {
        if (KeymanSettings.Setting.LoggingModeEnabled.getBoolean().booleanValue() || KeymanSettings.Setting.DebugModeEnabled.getBoolean().booleanValue()) {
            FileHandler fileHandler;
            try {
                fileHandler = new FileHandler(DEBUG_FILE_NAME, 0x100000, 5);
                fileHandler.setFormatter(new KeymanFormatter());
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.addHandler(fileHandler);
            logger.setLevel(Level.ALL);
            logger.setUseParentHandlers(false);
        } else {
            logger.setLevel(Level.OFF);
        }
    }

    private static class KeymanFormatter
    extends Formatter {
        private String indentation = "";
        private static final String INDENT = "  ";

        private KeymanFormatter() {
        }

        public String format(LogRecord record) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter returnString = new PrintWriter(stringWriter);
            if (record.getMessage().contains("ENTRY")) {
                returnString.append(this.indentation).append(">>");
                this.indentation = this.indentation + INDENT;
            } else if (record.getMessage().contains("RETURN")) {
                if (this.indentation.length() > 0) {
                    this.indentation = this.indentation.substring(0, this.indentation.length() - INDENT.length());
                }
                returnString.append(this.indentation).append("<<");
            } else {
                returnString.append(this.indentation);
            }
            returnString.append(record.getSourceClassName()).append(":").append(record.getSourceMethodName());
            returnString.append(" ").append(MessageFormat.format(record.getMessage(), record.getParameters()));
            if (record.getThrown() != null) {
                returnString.append("\n").append(this.indentation);
                record.getThrown().printStackTrace(returnString);
            }
            returnString.append("\n").close();
            return stringWriter.toString();
        }
    }

    private static class StringHandler
    extends Handler {
        private StringBuffer str = new StringBuffer();
        private Formatter formatter = new KeymanFormatter();

        private StringHandler() {
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(LogRecord record) {
            this.str.append(this.formatter.format(record));
        }

        public String toString() {
            return this.str.toString();
        }
    }
}

