/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorFactory {
    private static final Comparator<String> ignoreCaseStringComparator = new IgnoreCaseStringComparator();
    private static final Comparator<String> collatedStringComparator = new CollatedStringComparator();

    public static Comparator<String> newIgnoreCaseStringComparator() {
        return ignoreCaseStringComparator;
    }

    public static Comparator<String> newCollatedStringComparator() {
        return collatedStringComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollatedStringComparator
    implements Comparator<String>,
    Serializable {
        private static Collator collator = Collator.getInstance(KeymanSettings.LOCALE);

        private CollatedStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return collator.compare(s1, s2);
        }

        static {
            collator.setStrength(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreCaseStringComparator
    implements Comparator<String>,
    Serializable {
        private IgnoreCaseStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.equalsIgnoreCase(s2)) {
                return 0;
            }
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }
}

