/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayItemFactory {
    public static List<ExtensionItem> getExtensionItems(X509Certificate cert) throws KeyManagerException {
        return ExtensionItemImpl.extractExtensions(cert);
    }

    public static AlgorithmItem getAlgorithmItem(Key key) throws KeyManagerException {
        return new AlgorithmItemImpl(key);
    }

    public static AlgorithmItem getAlgorithmItem(String oid, byte[] params) {
        return new AlgorithmItemImpl(oid, params);
    }

    public static AlgorithmItem getAlgorithmItem(AlgorithmId alg) throws KeyManagerException {
        return new AlgorithmItemImpl(alg);
    }

    public static AlgorithmItem getAlgorithmItem(Key key, int keySize) throws KeyManagerException {
        return new AlgorithmItemImpl(key, keySize);
    }

    public static AlgorithmItem getUnsupportedAlgorithmItem(Key key) throws KeyManagerException {
        return new UnsupportedAlgorithmItemImpl(key);
    }

    public static Collection<TreeDisplayItem> getAttributeItems(PKCSAttribute[] attr) {
        ArrayList<TreeDisplayItem> attributes = new ArrayList<TreeDisplayItem>();
        for (PKCSAttribute attribute : attr) {
            attributes.add(new AttributeItem(attribute));
        }
        return attributes;
    }

    public static DNItem getDNItem(X500Principal principal) throws KeyManagerException {
        return new DNItemImpl(principal);
    }

    public static DNItem getDNItem(String dn) throws KeyManagerException {
        return new DNItemImpl(dn);
    }

    public static DNItem getDNItem(X500Name name) throws KeyManagerException {
        return new DNItemImpl(name);
    }

    public static DNItem getDNItem(String cn, String ou, String o, String l, String s, String pc, String c) throws KeyManagerException {
        return new DNItemImpl(cn, ou, o, l, s, pc, c);
    }

    public static DisplayItem getFinterprintItem(Certificate cert) throws KeyManagerException {
        return new FingerprintItem(cert);
    }

    public static DisplayItem getFinterprintItem(CertificationRequestInfo certReq) throws KeyManagerException {
        return new FingerprintItem(certReq);
    }

    public static SanItem getSanItem(Collection<List<?>> sanCollection) {
        return new SanItemImpl(sanCollection);
    }

    public static SanItem getSanItem(List<String> emailAddresses, List<String> dnsNames, List<String> ipAddresses) {
        return new SanItemImpl(emailAddresses, dnsNames, ipAddresses);
    }

    public static ValidityItem getValidityItem(Date notBefore, Date notAfter) {
        return new ValidityItemImpl(notBefore, notAfter);
    }

    public static TreeDisplayItem getCertificateRequestVersion(BigInteger version) {
        return new CertificateRequestVersion(version);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertificateRequestVersion
    implements TreeDisplayItem {
        private BigInteger version;

        public CertificateRequestVersion(BigInteger version) {
            this.version = version;
        }

        @Override
        public String toString() {
            return this.version.toString();
        }

        public KeymanTree.KeymanTreeNode getTreeNode() {
            KeymanTree.KeymanTreeNode node = KeymanTree.newNode(Messages.getString("Label.Version"), this.toString());
            return node;
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(this.getTreeNode());
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidityItemImpl
    implements ValidityItem {
        private Date notBefore;
        private Date notAfter;

        public ValidityItemImpl(Date notBefore, Date notAfter) {
            this.notBefore = notBefore;
            this.notAfter = notAfter;
        }

        public Date getNotAfter() {
            return this.notAfter;
        }

        public Date getNotBefore() {
            return this.notBefore;
        }

        public boolean checkValidity() {
            return this.checkValidity(0);
        }

        @Override
        public boolean checkValidity(int days) {
            Calendar cal = Calendar.getInstance();
            cal.add(6, days);
            Date futureTime = cal.getTime();
            return futureTime.after(this.notBefore) && futureTime.before(this.notAfter);
        }

        @Override
        public boolean isExpired() {
            return Calendar.getInstance().getTime().after(this.notAfter);
        }

        @Override
        public String toString() {
            if (KeymanSettings.isCLI()) {
                DateFormat df = DateFormat.getDateTimeInstance(0, 0);
                return MessageFormat.format(Messages.getString("Label.FromTo"), df.format(this.notBefore), df.format(this.notAfter));
            }
            DateFormat df = DateFormat.getDateInstance(1);
            return MessageFormat.format(Messages.getString("Label.ValidFromTo"), df.format(this.notBefore), df.format(this.notAfter));
        }

        public KeymanTree.KeymanTreeNode getTreeNode() {
            KeymanTree.KeymanTreeNode node = KeymanTree.newNode(Messages.getString("Label.Validity"));
            DateFormat df = DateFormat.getDateTimeInstance(0, 0);
            node.addChild(KeymanTree.newNode(Messages.getString("Label.NotBefore"), df.format(this.notBefore)));
            node.addChild(KeymanTree.newNode(Messages.getString("Label.NotAfter"), df.format(this.notAfter)));
            return node;
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(this.getTreeNode());
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SanItemImpl
    implements SanItem {
        private List<String> emailAddresses = new ArrayList<String>();
        private List<String> ipAddresses = new ArrayList<String>();
        private List<String> dnsNames = new ArrayList<String>();

        public SanItemImpl(Collection<List<?>> sanCollection) {
            if (sanCollection != null) {
                for (List<?> sanItem : sanCollection) {
                    Integer itemType = (Integer)sanItem.get(0);
                    switch (itemType) {
                        case 1: {
                            this.emailAddresses.add((String)sanItem.get(1));
                            break;
                        }
                        case 7: {
                            this.ipAddresses.add((String)sanItem.get(1));
                            break;
                        }
                        case 2: {
                            this.dnsNames.add((String)sanItem.get(1));
                        }
                    }
                }
            }
        }

        public SanItemImpl(List<String> emailAddresses, List<String> dnsNames, List<String> ipAddresses) {
            this.emailAddresses = emailAddresses;
            this.dnsNames = dnsNames;
            this.ipAddresses = ipAddresses;
        }

        @Override
        public String getDnsName() {
            return this.dnsNames.size() == 0 ? "" : this.dnsNames.toString();
        }

        @Override
        public String getEmailAddress() {
            return this.emailAddresses.size() == 0 ? "" : this.emailAddresses.toString();
        }

        @Override
        public String getIpAddress() {
            return this.ipAddresses.size() == 0 ? "" : this.ipAddresses.toString();
        }

        @Override
        public CertAttrSet<?> toExtension(boolean critical) throws KeyManagerException {
            try {
                GeneralNames generalNames = this.toGeneralNames();
                if (generalNames.size() == 0) {
                    return null;
                }
                DerOutputStream stream = new DerOutputStream();
                generalNames.encode(stream);
                return new SubjectAlternativeNameExtension(Boolean.valueOf(critical), (Object)stream.toByteArray());
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SAN, (Throwable)e, e.getMessage());
            }
            catch (GeneralNamesException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.SAN_ENCODING_ERROR, (Throwable)e);
            }
        }

        @Override
        public boolean isEmpty() {
            return !(this.emailAddresses != null && this.emailAddresses.size() != 0 || this.dnsNames != null && this.dnsNames.size() != 0 || this.ipAddresses != null && this.ipAddresses.size() != 0);
        }

        private GeneralNames toGeneralNames() throws IOException {
            GeneralNames generalNames = new GeneralNames();
            if (this.emailAddresses != null) {
                for (String emailAddress : this.emailAddresses) {
                    if (emailAddress.trim().equals("")) continue;
                    generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new RFC822Name(emailAddress)));
                }
            }
            if (this.dnsNames != null) {
                for (String dnsName : this.dnsNames) {
                    if (dnsName.trim().equals("")) continue;
                    generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new DNSName(dnsName)));
                }
            }
            if (this.ipAddresses != null) {
                for (String ipAddress : this.ipAddresses) {
                    if (ipAddress.trim().equals("")) continue;
                    generalNames.addElement((Object)new GeneralName((GeneralNameInterface)new IPAddressName(ipAddress)));
                }
            }
            return generalNames;
        }
    }

    private static class FingerprintItem
    implements DisplayItem {
        private String fingerprint;

        public FingerprintItem(CertificationRequestInfo info) throws KeyManagerException {
            try {
                this.fingerprint = FingerprintItem.getMD5(info.encode());
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
            }
        }

        public FingerprintItem(Certificate cert) throws KeyManagerException {
            try {
                this.fingerprint = FingerprintItem.getSHA1(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
            }
        }

        private static String getSHA1(byte[] data) {
            return FingerprintItem.getDigest(data, "SHA-1");
        }

        public static String getMD5(byte[] data) {
            return FingerprintItem.getDigest(data, "MD5");
        }

        public static String getDigest(byte[] data, String digestMethod) {
            String fingerPrint = null;
            try {
                MessageDigest md = MessageDigest.getInstance(digestMethod);
                byte[] fingerPrintData = md.digest(data);
                fingerPrint = FingerprintItem.formatBinaryDataWithColon(fingerPrintData);
            }
            catch (NoSuchAlgorithmException e1) {
                fingerPrint = Messages.getString("Message.DigestNotSupported");
            }
            catch (Exception e2) {
                fingerPrint = Messages.getString("Message.NotComputed");
            }
            return fingerPrint;
        }

        public static String formatBinaryDataWithColon(byte[] data) {
            String output = Messages.getString("Message.NotComputed");
            if (data == null || data.length > 24) {
                return output;
            }
            StringBuffer strbuf = new StringBuffer(48);
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    strbuf.append(':');
                }
                byte b = data[i];
                strbuf.append("0123456789ABCDEF".charAt(b >> 4 & 0xF));
                strbuf.append("0123456789ABCDEF".charAt(b & 0xF));
            }
            output = strbuf.toString();
            return output;
        }

        public String toString() {
            return this.fingerprint;
        }
    }

    private static class ExtensionOIDItem {
        private String oid;
        private String name;
        private static final Map<String, String> OidNameMap = new HashMap<String, String>();

        public ExtensionOIDItem(ObjectIdentifier oid) {
            this(oid.toString());
        }

        public ExtensionOIDItem(String oid) {
            this.oid = oid;
            this.name = ExtensionOIDItem.mapOIDToName(oid);
            if (this.name.trim().equals("")) {
                this.name = oid;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getOid() {
            return this.oid;
        }

        private static String mapOIDToName(String oid) {
            if (OidNameMap.containsKey(oid)) {
                return Messages.getString(OidNameMap.get(oid));
            }
            return oid;
        }

        static {
            OidNameMap.put("2.5.29.9", "Label.SubjectDirectoryAttributes");
            OidNameMap.put("2.5.29.14", "Label.SubjectKeyIdentifier");
            OidNameMap.put("2.5.29.15", "Label.KeyUsage");
            OidNameMap.put("2.5.29.16", "Label.PrivateKeyUsagePeriod");
            OidNameMap.put("2.5.29.17", "Label.SAN");
            OidNameMap.put("2.5.29.18", "Label.IssuerAlternativeNames");
            OidNameMap.put("2.5.29.19", "Label.BasicConstraints");
            OidNameMap.put("2.5.29.30", "Label.NameConstraints");
            OidNameMap.put("2.5.29.31", "Label.CRLDistributionPoints");
            OidNameMap.put("2.5.29.32", "Label.CertificatePolicies");
            OidNameMap.put("2.5.29.33", "Label.PolicyMappings");
            OidNameMap.put("2.5.29.35", "Label.AuthorityKeyIdentifier");
            OidNameMap.put("2.5.29.36", "Label.PolicyConstraints");
            OidNameMap.put("2.5.29.37", "Label.ExtendedKeyUsageField");
            OidNameMap.put("1.3.6.1.5.5.7.1.1", "Label.AuthorityInfoAccess");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DNItemImpl
    implements DNItem {
        private Vector<DNItemComponent> components = new Vector();
        private X500Name name;

        private DNItemImpl(X500Name name) {
            this.initialiseClass(name);
        }

        public DNItemImpl(String dn) throws KeyManagerException {
            try {
                dn = dn.replaceFirst("[z|Z][i|I][p|P]\\s*=", "postalcode=");
                this.initialiseClass(new X500Name(dn));
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DN, (Throwable)e);
            }
        }

        private DNItemImpl(String cn, String ou, String o, String l, String s, String pc, String c) throws KeyManagerException {
            StringBuffer sb = new StringBuffer();
            DNItemImpl.append(sb, "cn", cn);
            if (ou != null && !ou.trim().equals("")) {
                Strings strings = StringSplitterImpl.getStringSplitter().getStrings(ou, ',', '\\');
                LinkedList<String> list = new LinkedList<String>();
                while (strings.hasNext()) {
                    list.add(strings.next());
                }
                ListIterator i = list.listIterator(list.size());
                while (i.hasPrevious()) {
                    DNItemImpl.append(sb, "ou", (String)i.previous());
                }
            }
            DNItemImpl.append(sb, "o", o);
            DNItemImpl.append(sb, "l", l);
            DNItemImpl.append(sb, "st", s);
            DNItemImpl.append(sb, "POSTALCODE", pc);
            DNItemImpl.append(sb, "c", c);
            try {
                this.initialiseClass(new X500Name(sb.toString()));
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DN, (Throwable)e);
            }
        }

        private DNItemImpl(X500Principal issuerX500Principal) throws KeyManagerException {
            X500Name issuer = null;
            try {
                issuer = new X500Name(issuerX500Principal.getName());
                this.initialiseClass(issuer);
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DN, (Throwable)e, issuerX500Principal.getName());
            }
        }

        private static void append(StringBuffer sb, String tag, String value) {
            if (value != null && !value.trim().equals("")) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(tag + "=\"" + value + "\"");
            }
        }

        private void initialiseClass(X500Name name) {
            this.name = name;
            for (int i = 0; i < name.size(); ++i) {
                RDN relativeDN = name.getRDN(i);
                for (int j = 0; j < relativeDN.size(); ++j) {
                    String value;
                    AVA ava = relativeDN.getAVA(j);
                    ObjectIdentifier oid = ava.getOID();
                    try {
                        value = ava.getValue();
                    }
                    catch (NullPointerException e) {
                        value = "";
                    }
                    this.components.add(new DNItemComponent(oid, value));
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.components.size() == 0;
        }

        @Override
        public X500Name getX500Name() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name.toString();
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            for (DNItemComponent component : this.components) {
                nodes.add(component.getTreeNode());
            }
            return nodes;
        }

        public boolean equals(Object o) {
            if (o instanceof DNItemImpl) {
                return ((DNItemImpl)o).name.equals(this.name);
            }
            return false;
        }

        public static final class StringSplitterImpl {
            private static final StringSplitter x = new StringSplitter(){

                public Strings getStrings(String s, char delimiter, char escape) throws NullPointerException {
                    if (s == null) {
                        throw new NullPointerException();
                    }
                    char[] buffer = new char[s.length()];
                    final LinkedList<String> strings = new LinkedList<String>();
                    boolean lastCharEscape = false;
                    int counter = 0;
                    for (int i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        if (lastCharEscape) {
                            if (c != delimiter && c != escape) {
                                buffer[counter++] = 92;
                            }
                            buffer[counter++] = c;
                            lastCharEscape = false;
                            continue;
                        }
                        if (c == delimiter) {
                            strings.add(new String(buffer, 0, counter));
                            counter = 0;
                            continue;
                        }
                        if (c == escape) {
                            lastCharEscape = true;
                            continue;
                        }
                        buffer[counter++] = c;
                        lastCharEscape = false;
                    }
                    if (counter > 0) {
                        strings.add(new String(buffer, 0, counter));
                    }
                    return new Strings(){
                        private final Iterator<String> i;
                        private int position;
                        {
                            this.i = strings.iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public String next() throws NoSuchElementException {
                            if (this.hasNext()) {
                                ++this.position;
                                return this.i.next();
                            }
                            throw new NoSuchElementException();
                        }

                        public int getPosition() {
                            return this.position;
                        }
                    };
                }
            };

            private StringSplitterImpl() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public static StringSplitter getStringSplitter() {
                return x;
            }
        }

        public static interface StringSplitter {
            public Strings getStrings(String var1, char var2, char var3) throws NullPointerException;
        }

        public static interface Strings {
            public boolean hasNext();

            public String next() throws NoSuchElementException;
        }

        private static class DNItemComponent {
            private DNOIDItem oid;
            private String value;

            public DNItemComponent(ObjectIdentifier oid, String value) {
                this.oid = new DNOIDItem(oid);
                this.value = value;
            }

            public KeymanTree.KeymanTreeNode getTreeNode() {
                KeymanTree.KeymanTreeNode node = KeymanTree.newNode(this.oid.getName());
                node.addChild(KeymanTree.newNode(Messages.getString("Label.Type"), this.oid.getOID()));
                if (!this.value.equals("")) {
                    node.addChild(KeymanTree.newNode(Messages.getString("Label.Value"), this.value));
                }
                return node;
            }

            public String toString(boolean includeAttributeTag) {
                String returnString = "";
                if (includeAttributeTag) {
                    returnString = returnString + (String)DNOIDItem.OidAttributeMap.get(this.oid.oid);
                }
                return returnString + this.value;
            }

            public static class DNOIDItem {
                private ObjectIdentifier oid;
                private String name;
                private static final Map<ObjectIdentifier, String> OidNameMap = new HashMap<ObjectIdentifier, String>();
                private static final Map<ObjectIdentifier, String> OidAttributeMap = new HashMap<ObjectIdentifier, String>();

                public DNOIDItem(ObjectIdentifier oid) {
                    this.oid = oid;
                    this.name = DNOIDItem.mapOIDToName(oid);
                }

                public String getName() {
                    return this.name;
                }

                public boolean equals(Object o) {
                    if (o instanceof ObjectIdentifier) {
                        return this.oid.equals(o);
                    }
                    return super.equals(o);
                }

                public String getOID() {
                    return this.oid.toString();
                }

                private static String mapOIDToName(ObjectIdentifier oid) {
                    if (OidNameMap.containsKey(oid)) {
                        return Messages.getString(OidNameMap.get(oid));
                    }
                    return oid.toString();
                }

                static {
                    OidNameMap.put(X500Name.commonName_oid, "Label.CN");
                    OidNameMap.put(X500Name.countryName_oid, "Label.Country");
                    OidNameMap.put(X500Name.localityName_oid, "Label.Locality");
                    OidNameMap.put(X500Name.stateName_oid, "Label.State");
                    OidNameMap.put(X500Name.streetAddress_oid, "Label.Street");
                    OidNameMap.put(X500Name.orgName_oid, "Label.Org");
                    OidNameMap.put(X500Name.orgUnitName_oid, "Label.OU");
                    OidNameMap.put(X500Name.title_oid, "Label.Title");
                    OidNameMap.put(X500Name.postalCode_oid, "Label.Zip");
                    OidNameMap.put(X500Name.emailAddress_oid, "Label.Email");
                    OidAttributeMap.put(X500Name.commonName_oid, "cn=");
                    OidAttributeMap.put(X500Name.countryName_oid, "c=");
                    OidAttributeMap.put(X500Name.dnQualifier_oid, "dnq=");
                    OidAttributeMap.put(X500Name.domainComponent_oid, "dc=");
                    OidAttributeMap.put(X500Name.emailAddress_oid, "email=");
                    OidAttributeMap.put(X500Name.generationQualifier_oid, "generation=");
                    OidAttributeMap.put(X500Name.givenName_oid, "givenname=");
                    OidAttributeMap.put(X500Name.initials_oid, "initials=");
                    OidAttributeMap.put(X500Name.ipAddress_oid, "ip=");
                    OidAttributeMap.put(X500Name.localityName_oid, "l=");
                    OidAttributeMap.put(X500Name.serialNumber_oid, "serialnumber=");
                    OidAttributeMap.put(X500Name.stateName_oid, "s=");
                    OidAttributeMap.put(X500Name.streetAddress_oid, "street=");
                    OidAttributeMap.put(X500Name.surName_oid, "surname=");
                    OidAttributeMap.put(X500Name.orgName_oid, "o=");
                    OidAttributeMap.put(X500Name.orgUnitName_oid, "ou=");
                    OidAttributeMap.put(X500Name.postalCode_oid, "postalcode=");
                    OidAttributeMap.put(X500Name.title_oid, "t=");
                    OidAttributeMap.put(X500Name.userid_oid, "uid=");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeItem
    implements TreeDisplayItem {
        private ExtensionOIDItem oid;
        private Object value;

        public AttributeItem(PKCSAttribute attr) {
            this.oid = new ExtensionOIDItem(attr.getAttributeId());
            this.value = attr.toString();
        }

        public KeymanTree.KeymanTreeNode getTreeNode() {
            KeymanTree.KeymanTreeNode node = KeymanTree.newNode(this.oid.getOid());
            node.addChild(KeymanTree.newNode(Messages.getString("Label.Type"), this.oid.getOid()));
            node.addChild(KeymanTree.newNode(Messages.getString("Label.Value"), this.value.toString()));
            return node;
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(this.getTreeNode());
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnsupportedAlgorithmItemImpl
    implements AlgorithmItem {
        private String algorithmName;
        private String parameters = new ByteArray(null).toString();

        public UnsupportedAlgorithmItemImpl(Key key) throws KeyManagerException {
            this.algorithmName = key.getAlgorithm();
        }

        @Override
        public String getOID() {
            return this.algorithmName;
        }

        @Override
        public String toString() {
            return this.getOID();
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(KeymanTree.newNode(Messages.getString("Label.Algorithm"), this.algorithmName));
            nodes.add(KeymanTree.newNode(Messages.getString("Label.Parameters"), this.parameters));
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlgorithmItemImpl
    implements AlgorithmItem {
        private String oid;
        private ByteArray parameters;

        public AlgorithmItemImpl(AlgorithmId alg) throws KeyManagerException {
            this.initialiseClass(alg);
        }

        public AlgorithmItemImpl(String oid, byte[] params) {
            this.oid = oid;
            this.parameters = new ByteArray(params);
        }

        public AlgorithmItemImpl(Key key) throws KeyManagerException {
            AlgorithmId algId = null;
            try {
                algId = AlgorithmId.get((String)key.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e1, key.getAlgorithm());
            }
            this.initialiseClass(algId);
        }

        public AlgorithmItemImpl(Key key, int keySize) throws KeyManagerException {
            AlgorithmId algId = null;
            try {
                algId = AlgorithmId.get((String)key.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    algId = AlgorithmId.get((String)(key.getAlgorithm() + keySize));
                }
                catch (NoSuchAlgorithmException e1) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e1, key.getAlgorithm());
                }
            }
            this.initialiseClass(algId);
        }

        @Override
        public String getOID() {
            return this.oid;
        }

        private void initialiseClass(AlgorithmId alg) throws KeyManagerException {
            this.oid = alg.getOID().toString();
            try {
                this.parameters = new ByteArray(alg.getParameters());
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALGORITHM_PARAMETERS, (Throwable)e);
            }
        }

        @Override
        public String toString() {
            String readable = null;
            try {
                readable = AlgorithmId.get((String)this.oid).getName();
            }
            catch (NoSuchAlgorithmException e) {
                readable = this.oid;
            }
            if (readable.equals(this.oid)) {
                return this.oid;
            }
            return readable + " (" + this.oid + ")";
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(KeymanTree.newNode(Messages.getString("Label.Algorithm"), this.oid));
            nodes.add(KeymanTree.newNode(Messages.getString("Label.Parameters"), this.parameters.toString()));
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionItemImpl
    implements ExtensionItem {
        private ExtensionOIDItem oid;
        private boolean critical;
        private String value;
        private Extension extension;

        public ExtensionItemImpl(Extension ext) {
            this.oid = new ExtensionOIDItem(ext.getExtensionId());
            this.critical = ext.isCritical();
            this.value = ext.toString();
            this.extension = ext;
        }

        public static List<ExtensionItem> extractExtensions(X509Certificate cert) throws KeyManagerException {
            ArrayList<ExtensionItem> extensions = new ArrayList<ExtensionItem>();
            try {
                DerValue der = new DerValue(cert.getEncoded()).getData().getDerValue();
                X509CertInfo info = new X509CertInfo(der);
                CertificateExtensions certExtensions = (CertificateExtensions)info.get("extensions");
                if (certExtensions != null) {
                    Collection extensionCollection = certExtensions.getAllExtensions();
                    for (Extension ext : extensionCollection) {
                        extensions.add(new ExtensionItemImpl(ext));
                    }
                }
                return extensions;
            }
            catch (CertificateEncodingException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.DER_ENCODING_ERROR, (Throwable)e);
            }
            catch (CertificateParsingException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)e);
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ERROR, (Throwable)e);
            }
        }

        @Override
        public Extension getExtension() {
            return this.extension;
        }

        public KeymanTree.KeymanTreeNode getTreeNode() {
            KeymanTree.KeymanTreeNode node = KeymanTree.newNode(this.oid.getName());
            node.addChild(KeymanTree.newNode(Messages.getString("Label.ExtensionIdentifier"), this.oid.getOid()));
            node.addChild(KeymanTree.newNode(Messages.getString("Label.CriticalFlag"), "" + this.critical));
            node.addChild(KeymanTree.newNode(Messages.getString("Label.Value"), this.value));
            return node;
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(this.getTreeNode());
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringTreeNodeDisplayItem
    implements TreeDisplayItem {
        private String keyString;

        public StringTreeNodeDisplayItem(String keyString) {
            this.keyString = keyString;
        }

        @Override
        public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
            ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
            nodes.add(KeymanTree.newNode(this.keyString, this.toString()));
            return nodes;
        }
    }

    public static interface ValidityItem
    extends TreeDisplayItem {
        public boolean isExpired();

        public boolean checkValidity(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SanItem
    extends DisplayItem {
        public String getDnsName();

        public String getEmailAddress();

        public String getIpAddress();

        public boolean isEmpty();

        public CertAttrSet<?> toExtension(boolean var1) throws KeyManagerException;
    }

    public static interface DNItem
    extends TreeDisplayItem {
        public boolean isEmpty();

        public X500Name getX500Name();
    }

    public static interface AlgorithmItem
    extends TreeDisplayItem {
        public String getOID();
    }

    public static interface ExtensionItem
    extends TreeDisplayItem {
        public Extension getExtension();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TreeDisplayItem
    extends DisplayItem {
        public List<KeymanTree.KeymanTreeNode> getTreeNodes();
    }

    public static interface DisplayItem {
        public String toString();
    }
}

